/* CoreImage - CIImageAccumulator.h

   Copyright (c) 2004 Apple, Inc.
   All rights reserved. */

#import <CoreImage/CoreImageDefines.h>
#import <CoreImage/CIImage.h>

NS_ASSUME_NONNULL_BEGIN

NS_CLASS_AVAILABLE(10_4, 9_0)
@interface CIImageAccumulator : NSObject
{
    __strong void *_state;
}

/* Create a new accumulator object. 
   For pixel format options see CIImage.h.
   The specified color space is used to render the image. 
   If no color space is specified, no color matching is done. */
+ (instancetype)imageAccumulatorWithExtent:(CGRect)extent
                                    format:(CIFormat)format;

+ (instancetype)imageAccumulatorWithExtent:(CGRect)extent
                                    format:(CIFormat)format
                                colorSpace:(CGColorSpaceRef)colorSpace
NS_AVAILABLE(10_7, 9_0);

- (instancetype)initWithExtent:(CGRect)extent format:(CIFormat)format;

- (instancetype)initWithExtent:(CGRect)extent
                        format:(CIFormat)format
                    colorSpace:(CGColorSpaceRef)colorSpace
NS_AVAILABLE(10_7, 9_0);

/* Return the extent of the accumulator. */
@property (readonly) CGRect extent;

/* Return the pixel format of the accumulator. */
@property (readonly) CIFormat format;

/* Return an image representing the current contents of the accumulator.
 * Rendering the image after subsequently calling setImage: has
 * undefined behavior. */
- (CIImage *)image;

/* Set the image 'im' as the current contents of the accumulator. */
- (void)setImage:(CIImage *)image;

/* Set the image 'im' as the accumulator's contents. The caller guarantees
 * that the new contents only differ from the old within the specified
 * region. */
- (void)setImage:(CIImage *)image dirtyRect:(CGRect)dirtyRect;

/* Reset the accumulator, discarding any pending updates and current content. */
- (void)clear;

@end

NS_ASSUME_NONNULL_END
