'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/struct/graph.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "struct::graph" n 2.4 struct "Tcl Data Structures"
.BS
.SH NAME
struct::graph \- Create and manipulate directed graph objects
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBstruct::graph  ?2.4?\fR
.sp
package require \fBstruct::list  ?1.5?\fR
.sp
package require \fBstruct::set  ?2.2.3?\fR
.sp
\fB::struct::graph\fR ?\fIgraphName\fR? ?\fB=\fR|\fB:=\fR|\fBas\fR|\fBdeserialize\fR \fIsource\fR?
.sp
\fBgraphName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIgraphName\fR \fB=\fR \fIsourcegraph\fR
.sp
\fIgraphName\fR \fB-->\fR \fIdestgraph\fR
.sp
\fIgraphName\fR \fBappend\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBdeserialize\fR \fIserialization\fR
.sp
\fIgraphName\fR \fBdestroy\fR
.sp
\fIgraphName\fR \fBarc append\fR \fIarc\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBarc attr\fR \fIkey\fR
.sp
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-arcs\fR \fIlist\fR
.sp
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-glob\fR \fIglobpattern\fR
.sp
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-regexp\fR \fIrepattern\fR
.sp
\fIgraphName\fR \fBarc delete\fR \fIarc\fR ?\fIarc\fR ...?
.sp
\fIgraphName\fR \fBarc exists\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc flip\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc get\fR \fIarc\fR \fIkey\fR
.sp
\fIgraphName\fR \fBarc getall\fR \fIarc\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBarc getunweighted\fR
.sp
\fIgraphName\fR \fBarc getweight\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc keys\fR \fIarc\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBarc keyexists\fR \fIarc\fR \fIkey\fR
.sp
\fIgraphName\fR \fBarc insert\fR \fIstart\fR \fIend\fR ?\fIchild\fR?
.sp
\fIgraphName\fR \fBarc lappend\fR \fIarc\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBarc rename\fR \fIarc\fR \fInewname\fR
.sp
\fIgraphName\fR \fBarc set\fR \fIarc\fR \fIkey\fR ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBarc setunweighted\fR ?\fIweight\fR?
.sp
\fIgraphName\fR \fBarc setweight\fR \fIarc\fR \fIweight\fR
.sp
\fIgraphName\fR \fBarc unsetweight\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc hasweight\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc source\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc target\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc nodes\fR \fIarc\fR
.sp
\fIgraphName\fR \fBarc move-source\fR \fIarc\fR \fInewsource\fR
.sp
\fIgraphName\fR \fBarc move-target\fR \fIarc\fR \fInewtarget\fR
.sp
\fIgraphName\fR \fBarc move\fR \fIarc\fR \fInewsource\fR \fInewtarget\fR
.sp
\fIgraphName\fR \fBarc unset\fR \fIarc\fR \fIkey\fR
.sp
\fIgraphName\fR \fBarc weights\fR
.sp
\fIgraphName\fR \fBarcs\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-filter \fIcmdprefix\fR? ?-in|-out|-adj|-inner|-embedding \fInode node...\fR?
.sp
\fIgraphName\fR \fBlappend\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBnode append\fR \fInode\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBnode attr\fR \fIkey\fR
.sp
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-nodes\fR \fIlist\fR
.sp
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-glob\fR \fIglobpattern\fR
.sp
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-regexp\fR \fIrepattern\fR
.sp
\fIgraphName\fR \fBnode degree\fR ?-in|-out? \fInode\fR
.sp
\fIgraphName\fR \fBnode delete\fR \fInode\fR ?\fInode\fR...?
.sp
\fIgraphName\fR \fBnode exists\fR \fInode\fR
.sp
\fIgraphName\fR \fBnode get\fR \fInode\fR \fIkey\fR
.sp
\fIgraphName\fR \fBnode getall\fR \fInode\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBnode keys\fR \fInode\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBnode keyexists\fR \fInode\fR \fIkey\fR
.sp
\fIgraphName\fR \fBnode insert\fR ?\fInode\fR...?
.sp
\fIgraphName\fR \fBnode lappend\fR \fInode\fR \fIkey\fR \fIvalue\fR
.sp
\fIgraphName\fR \fBnode opposite\fR \fInode\fR \fIarc\fR
.sp
\fIgraphName\fR \fBnode rename\fR \fInode\fR \fInewname\fR
.sp
\fIgraphName\fR \fBnode set\fR \fInode\fR \fIkey\fR ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBnode unset\fR \fInode\fR \fIkey\fR
.sp
\fIgraphName\fR \fBnodes\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-filter \fIcmdprefix\fR? ?-in|-out|-adj|-inner|-embedding \fInode\fR \fInode\fR...?
.sp
\fIgraphName\fR \fBget\fR \fIkey\fR
.sp
\fIgraphName\fR \fBgetall\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBkeys\fR ?\fIpattern\fR?
.sp
\fIgraphName\fR \fBkeyexists\fR \fIkey\fR
.sp
\fIgraphName\fR \fBserialize\fR ?\fInode\fR...?
.sp
\fIgraphName\fR \fBset\fR \fIkey\fR ?\fIvalue\fR?
.sp
\fIgraphName\fR \fBswap\fR \fInode1\fR \fInode2\fR
.sp
\fIgraphName\fR \fBunset\fR \fIkey\fR
.sp
\fIgraphName\fR \fBwalk\fR \fInode\fR ?-order \fIorder\fR? ?-type \fItype\fR? ?-dir \fIdirection\fR? -command \fIcmd\fR
.sp
.BE
.SH DESCRIPTION
.PP
A directed graph is a structure containing two collections of
elements, called \fInodes\fR and \fIarcs\fR respectively, together
with a relation ("connectivity") that places a general structure upon
the nodes and arcs.
.PP
Each arc is connected to two nodes, one of which is called the
\fIsource\fR and the other the \fItarget\fR. This imposes a
direction upon the arc, which is said to go from the source to the
target. It is allowed that source and target of an arc are the same
node. Such an arc is called a \fIloop\fR.
Whenever a node is either the source or target of an arc both are said
to be \fIadjacent\fR. This extends into a relation between nodes,
i.e. if two nodes are connected through at least one arc they are said
to be \fIadjacent\fR too.
.PP
Each node can be the source and target for any number of arcs. The
former are called the \fIoutgoing arcs\fR of the node, the latter
the \fIincoming arcs\fR of the node. The number of arcs in either
set is called the \fIin-degree\fR resp. the \fIout-degree\fR of the
node.
.PP
In addition to maintaining the node and arc relationships, this graph
implementation allows any number of named \fIattributes\fR to be
associated with the graph itself, and each node or arc.
.PP
\fINote:\fR The major version of the package \fBstruct\fR has
been changed to version 2.0, due to backward incompatible changes in
the API of this module. Please read the section
\fBChanges for 2.0\fR for a full list of all changes,
incompatible and otherwise.
.PP
\fINote:\fR A C-implementation of the command can be had from the
location \fIhttp://www.purl.org/NET/schlenker/tcl/cgraph\fR. See also
\fIhttp://wiki.tcl.tk/cgraph\fR.  This implementation uses a bit less
memory than the tcl version provided here directly, and is faster. Its
support is limited to versions of the package before 2.0.
.PP
As of version 2.2 of this package a critcl based C implementation is
available from here as well. This implementation however requires Tcl
8.4 to run.
.PP
The main command of the package is:
.TP
\fB::struct::graph\fR ?\fIgraphName\fR? ?\fB=\fR|\fB:=\fR|\fBas\fR|\fBdeserialize\fR \fIsource\fR?
The command creates a new graph object with an associated global Tcl
command whose name is \fIgraphName\fR.  This command may be used to
invoke various operations on the graph.  It has the following general
form:
.RS
.TP
\fBgraphName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.RE
.sp
If \fIgraphName\fR is not specified a unique name will be generated by
the package itself. If a \fIsource\fR is specified the new graph will
be initialized to it. For the operators \fB=\fR, \fB:=\fR, and
\fBas\fR the \fIsource\fR argument is interpreted as the name of
another graph object, and the assignment operator \fB=\fR will be
executed. For the operator \fBdeserialize\fR the \fIsource\fR is a
serialized graph object and \fBdeserialize\fR will be executed.
.sp
In other words
.sp
.nf

    ::struct::graph mygraph = b

.fi
.sp
is equivalent to
.sp
.nf

    ::struct::graph mygraph
    mygraph = b

.fi
.sp
and
.sp
.nf

    ::struct::graph mygraph deserialize $b

.fi
.sp
is equivalent to
.sp
.nf

    ::struct::graph mygraph
    mygraph deserialize $b

.fi
.PP
.PP
The following commands are possible for graph objects:
.TP
\fIgraphName\fR \fB=\fR \fIsourcegraph\fR
This is the \fIassignment\fR operator for graph objects. It copies
the graph contained in the graph object \fIsourcegraph\fR over the
graph data in \fIgraphName\fR. The old contents of \fIgraphName\fR are
deleted by this operation.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fIgraphName\fR \fBdeserialize\fR [\fIsourcegraph\fR \fBserialize\fR]

.fi
.sp
The operation assumes that the \fIsourcegraph\fR provides the method
\fBserialize\fR and that this method returns a valid graph
serialization.
.TP
\fIgraphName\fR \fB-->\fR \fIdestgraph\fR
This is the \fIreverse assignment\fR operator for graph objects. It
copies the graph contained in the graph object \fIgraphName\fR over
the graph data in the object \fIdestgraph\fR.
The old contents of \fIdestgraph\fR are deleted by this operation.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fIdestgraph\fR \fBdeserialize\fR [\fIgraphName\fR \fBserialize\fR]

.fi
.sp
The operation assumes that the \fIdestgraph\fR provides the method
\fBdeserialize\fR and that this method takes a graph serialization.
.TP
\fIgraphName\fR \fBappend\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR to one of the keyed values associated with the graph.
Returns the new value given to the attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBdeserialize\fR \fIserialization\fR
This is the complement to \fBserialize\fR. It replaces the graph
data in \fIgraphName\fR with the graph described by the
\fIserialization\fR value. The old contents of \fIgraphName\fR are
deleted by this operation.
.TP
\fIgraphName\fR \fBdestroy\fR
Destroys the graph, including its storage space and associated command.
.TP
\fIgraphName\fR \fBarc append\fR \fIarc\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR to one of the keyed values associated with an
\fIarc\fR. Returns the new value given to the attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBarc attr\fR \fIkey\fR
.TP
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-arcs\fR \fIlist\fR
.TP
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-glob\fR \fIglobpattern\fR
.TP
\fIgraphName\fR \fBarc attr\fR \fIkey\fR \fB-regexp\fR \fIrepattern\fR
This method retrieves the value of the attribute named \fIkey\fR, for
all arcs in the graph (matching the restriction specified via one of
the possible options) and having the specified attribute.
.sp
The result is a dictionary mapping from arc names to the value of
attribute \fIkey\fR at that arc.
Arcs not having the attribute \fIkey\fR, or not passing a
specified restriction, are not listed in the result.
.sp
The possible restrictions are:
.RS
.TP
\fB-arcs\fR
The value is a list of arcs. Only the arcs mentioned in this list
are searched for the attribute.
.TP
\fB-glob\fR
The value is a glob pattern. Only the arcs in the graph whose names
match this pattern are searched for the attribute.
.TP
\fB-regexp\fR
The value is a regular expression. Only the arcs in the graph whose
names match this pattern are searched for the attribute.
.RE
.sp
.TP
\fIgraphName\fR \fBarc delete\fR \fIarc\fR ?\fIarc\fR ...?
Remove the specified arcs from the graph.
.TP
\fIgraphName\fR \fBarc exists\fR \fIarc\fR
Return true if the specified \fIarc\fR exists in the graph.
.TP
\fIgraphName\fR \fBarc flip\fR \fIarc\fR
Reverses the direction of the named \fIarc\fR, i.e. the source and
target nodes of the arc are exchanged with each other.
.TP
\fIgraphName\fR \fBarc get\fR \fIarc\fR \fIkey\fR
Returns the value associated with the key \fIkey\fR for the \fIarc\fR.
.TP
\fIgraphName\fR \fBarc getall\fR \fIarc\fR ?\fIpattern\fR?
Returns a dictionary (suitable for use with [\fBarray set\fR])
for the \fIarc\fR.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned dictionary. The pattern
is a \fBglob\fR pattern.
.TP
\fIgraphName\fR \fBarc getunweighted\fR
Returns a list containing the names of all arcs in the graph which
have no weight associated with them.
.TP
\fIgraphName\fR \fBarc getweight\fR \fIarc\fR
Returns the weight associated with the \fIarc\fR. Throws an error if
the arc has no weight associated with it.
.TP
\fIgraphName\fR \fBarc keys\fR \fIarc\fR ?\fIpattern\fR?
Returns a list of keys for the \fIarc\fR.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned list. The pattern is a
\fBglob\fR pattern.
.TP
\fIgraphName\fR \fBarc keyexists\fR \fIarc\fR \fIkey\fR
Return true if the specified \fIkey\fR exists for the \fIarc\fR.
.TP
\fIgraphName\fR \fBarc insert\fR \fIstart\fR \fIend\fR ?\fIchild\fR?
Insert an arc named \fIchild\fR into the graph beginning at the node
\fIstart\fR and ending at the node \fIend\fR. If the name of the new
arc is not specified the system will generate a unique name of the
form \fIarc\fR\fIx\fR.
.TP
\fIgraphName\fR \fBarc lappend\fR \fIarc\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR (as a list) to one of the keyed values
associated with an \fIarc\fR. Returns the new value given to the
attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBarc rename\fR \fIarc\fR \fInewname\fR
Renames the arc \fIarc\fR to \fInewname\fR. An error is thrown if
either the arc does not exist, or a arc with name \fInewname\fR does
exist. The result of the command is the new name of the arc.
.TP
\fIgraphName\fR \fBarc set\fR \fIarc\fR \fIkey\fR ?\fIvalue\fR?
Set or get one of the keyed values associated with an arc.
An arc may have any number of keyed values associated with it.
If \fIvalue\fR is not specified, this command returns the current value assigned to the key;
if \fIvalue\fR is specified, this command assigns that value to the key, and returns
that value.
.TP
\fIgraphName\fR \fBarc setunweighted\fR ?\fIweight\fR?
Sets the weight of all arcs without a weight to \fIweight\fR. Returns
the empty string as its result. If not present \fIweight\fR defaults
to \fB0\fR.
.TP
\fIgraphName\fR \fBarc setweight\fR \fIarc\fR \fIweight\fR
Sets the weight of the \fIarc\fR to \fIweight\fR. Returns \fIweight\fR.
.TP
\fIgraphName\fR \fBarc unsetweight\fR \fIarc\fR
Removes the weight of the \fIarc\fR, if present. Does nothing
otherwise. Returns the empty string.
.TP
\fIgraphName\fR \fBarc hasweight\fR \fIarc\fR
Determines if the \fIarc\fR has a weight associated with it.  The
result is a boolean value, \fBTrue\fR if a weight is defined, and
\fBFalse\fR otherwise.
.TP
\fIgraphName\fR \fBarc source\fR \fIarc\fR
Return the node the given \fIarc\fR begins at.
.TP
\fIgraphName\fR \fBarc target\fR \fIarc\fR
Return the node the given \fIarc\fR ends at.
.TP
\fIgraphName\fR \fBarc nodes\fR \fIarc\fR
Return the nodes the given \fIarc\fR begins and ends at,
as a two-element list.
.TP
\fIgraphName\fR \fBarc move-source\fR \fIarc\fR \fInewsource\fR
Changes the source node of the arc to \fInewsource\fR. It can be said
that the arc rotates around its target node.
.TP
\fIgraphName\fR \fBarc move-target\fR \fIarc\fR \fInewtarget\fR
Changes the target node of the arc to \fInewtarget\fR. It can be said
that the arc rotates around its source node.
.TP
\fIgraphName\fR \fBarc move\fR \fIarc\fR \fInewsource\fR \fInewtarget\fR
Changes both source and target nodes of the arc to \fInewsource\fR,
and \fInewtarget\fR resp.
.TP
\fIgraphName\fR \fBarc unset\fR \fIarc\fR \fIkey\fR
Remove a keyed value from the arc \fIarc\fR. The method will do
nothing if the \fIkey\fR does not exist.
.TP
\fIgraphName\fR \fBarc weights\fR
Returns a dictionary whose keys are the names of all arcs which have a
weight associated with them, and the values are these weights.
.TP
\fIgraphName\fR \fBarcs\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-filter \fIcmdprefix\fR? ?-in|-out|-adj|-inner|-embedding \fInode node...\fR?
Returns a list of arcs in the graph. If no restriction is specified a
list containing all arcs is returned. Restrictions can limit the list
of returned arcs based on the nodes that are connected by the arc, on
the keyed values associated with the arc, or both. A general filter
command can be used as well. The restrictions that involve connected
nodes take a variable number of nodes as argument, specified after the
name of the restriction itself.
.sp
The restrictions imposed by either \fB-in\fR, \fB-out\fR,
\fB-adj\fR, \fB-inner\fR, or \fB-embedded\fR are applied
first. Specifying more than one of them is illegal.
.sp
After that the restrictions set via \fB-key\fR (and
\fB-value\fR) are applied. Specifying more than one \fB-key\fR
(and \fB-value\fR) is illegal. Specifying \fB-value\fR alone,
without \fB-key\fR is illegal as well.
.sp
Any restriction set through \fB-filter\fR is applied
last. Specifying more than one \fB-filter\fR is illegal.
.sp
Coming back to the restrictions based on a set of nodes, the command
recognizes the following switches:
.RS
.TP
\fB-in\fR
Return a list of all arcs whose target is one of the nodes in the set
of nodes. I.e. it computes the union of all incoming arcs of the nodes
in the set.
.TP
\fB-out\fR
Return a list of all arcs whose source is one of the nodes in the set
of nodes. I.e. it computes the union of all outgoing arcs of the nodes
in the set.
.TP
\fB-adj\fR
Return a list of all arcs adjacent to at least one of the nodes in the
set. This is the union of the nodes returned by \fB-in\fR and
\fB-out\fR.
.TP
\fB-inner\fR
Return a list of all arcs which are adjacent to two of the nodes in
the set. This is the set of arcs in the subgraph spawned by the
specified nodes.
.TP
\fB-embedding\fR
Return a list of all arcs adjacent to exactly one of the nodes in the
set. This is the set of arcs connecting the subgraph spawned by the
specified nodes to the rest of the graph.
.TP
\fB-key\fR \fIkey\fR
Limit the list of arcs that are returned to those arcs that have an
associated key \fIkey\fR.
.TP
\fB-value\fR \fIvalue\fR
This restriction can only be used in combination with
\fB-key\fR. It limits the list of arcs that are returned to those
arcs whose associated key \fIkey\fR has the value \fIvalue\fR.
.TP
\fB-filter\fR \fIcmdrefix\fR
Limit the list of arcs that are returned to those arcs that pass the
test. The command in \fIcmdprefix\fR is called with two arguments, the
name of the graph object, and the name of the arc in question. It is
executed in the context of the caller and has to return a boolean
value. Arcs for which the command returns \fBfalse\fR are removed
from the result list before it is returned to the caller.
.RE
.TP
\fIgraphName\fR \fBlappend\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR (as a list) to one of the keyed values
associated with the graph. Returns the new value given to the
attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBnode append\fR \fInode\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR to one of the keyed values associated with an
\fInode\fR. Returns the new value given to the attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBnode attr\fR \fIkey\fR
.TP
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-nodes\fR \fIlist\fR
.TP
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-glob\fR \fIglobpattern\fR
.TP
\fIgraphName\fR \fBnode attr\fR \fIkey\fR \fB-regexp\fR \fIrepattern\fR
This method retrieves the value of the attribute named \fIkey\fR, for
all nodes in the graph (matching the restriction specified via one of
the possible options) and having the specified attribute.
.sp
The result is a dictionary mapping from node names to the value of
attribute \fIkey\fR at that node.
Nodes not having the attribute \fIkey\fR, or not passing a
specified restriction, are not listed in the result.
.sp
The possible restrictions are:
.RS
.TP
\fB-nodes\fR
The value is a list of nodes. Only the nodes mentioned in this list
are searched for the attribute.
.TP
\fB-glob\fR
The value is a glob pattern. Only the nodes in the graph whose names
match this pattern are searched for the attribute.
.TP
\fB-regexp\fR
The value is a regular expression. Only the nodes in the graph whose
names match this pattern are searched for the attribute.
.RE
.sp
.TP
\fIgraphName\fR \fBnode degree\fR ?-in|-out? \fInode\fR
Return the number of arcs adjacent to the specified \fInode\fR. If one
of the restrictions \fB-in\fR or \fB-out\fR is given only the
incoming resp. outgoing arcs are counted.
.TP
\fIgraphName\fR \fBnode delete\fR \fInode\fR ?\fInode\fR...?
Remove the specified nodes from the graph.  All of the nodes' arcs
will be removed as well to prevent unconnected arcs.
.TP
\fIgraphName\fR \fBnode exists\fR \fInode\fR
Return true if the specified \fInode\fR exists in the graph.
.TP
\fIgraphName\fR \fBnode get\fR \fInode\fR \fIkey\fR
Return the value associated with the key \fIkey\fR for the \fInode\fR.
.TP
\fIgraphName\fR \fBnode getall\fR \fInode\fR ?\fIpattern\fR?
Returns a dictionary (suitable for use with [\fBarray set\fR])
for the \fInode\fR.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned dictionary. The pattern
is a \fBglob\fR pattern.
.TP
\fIgraphName\fR \fBnode keys\fR \fInode\fR ?\fIpattern\fR?
Returns a list of keys for the \fInode\fR.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned list. The pattern is a
\fBglob\fR pattern.
.TP
\fIgraphName\fR \fBnode keyexists\fR \fInode\fR \fIkey\fR
Return true if the specified \fIkey\fR exists for the \fInode\fR.
.TP
\fIgraphName\fR \fBnode insert\fR ?\fInode\fR...?
Insert one or more nodes into the graph. The new nodes have no arcs
connected to them. If no node is specified one node will be inserted,
and the system will generate a unique name of the form
\fInode\fR\fIx\fR for it.
.TP
\fIgraphName\fR \fBnode lappend\fR \fInode\fR \fIkey\fR \fIvalue\fR
Appends a \fIvalue\fR (as a list) to one of the keyed values
associated with an \fInode\fR. Returns the new value given to the
attribute \fIkey\fR.
.TP
\fIgraphName\fR \fBnode opposite\fR \fInode\fR \fIarc\fR
Return the node at the other end of the specified \fIarc\fR, which has
to be adjacent to the given \fInode\fR.
.TP
\fIgraphName\fR \fBnode rename\fR \fInode\fR \fInewname\fR
Renames the node \fInode\fR to \fInewname\fR. An error is thrown if
either the node does not exist, or a node with name \fInewname\fR does
exist. The result of the command is the new name of the node.
.TP
\fIgraphName\fR \fBnode set\fR \fInode\fR \fIkey\fR ?\fIvalue\fR?
Set or get one of the keyed values associated with a node. A node may have any
number of keyed values associated with it.  If \fIvalue\fR is not
specified, this command returns the current value assigned to the key;
if \fIvalue\fR is specified, this command assigns that value to the
key.
.TP
\fIgraphName\fR \fBnode unset\fR \fInode\fR \fIkey\fR
Remove a keyed value from the node \fInode\fR. The method will do
nothing if the \fIkey\fR does not exist.
.TP
\fIgraphName\fR \fBnodes\fR ?-key \fIkey\fR? ?-value \fIvalue\fR? ?-filter \fIcmdprefix\fR? ?-in|-out|-adj|-inner|-embedding \fInode\fR \fInode\fR...?
Return a list of nodes in the graph. Restrictions can limit the list
of returned nodes based on neighboring nodes, or based on the keyed
values associated with the node. The restrictions that involve
neighboring nodes have a list of nodes as argument, specified after
the name of the restriction itself.
.sp
The possible restrictions are the same as for method
\fBarcs\fR. The exact meanings change slightly, as they operate on
nodes instead of arcs. The command recognizes:
.RS
.TP
\fB-in\fR
Return a list of all nodes with at least one outgoing arc ending in a
node found in the specified set of nodes. Alternatively specified as
the set of source nodes for the \fB-in\fR arcs of the node set. The
\fIincoming neighbours\fR.
.TP
\fB-out\fR
Return a list of all nodes with at least one incoming arc starting in
a node found in the specified set of nodes. Alternatively specified as
the set of target nodes for the \fB-out\fR arcs of the node
set. The \fIoutgoing neighbours\fR.
.TP
\fB-adj\fR
This is the union of the nodes returned by \fB-in\fR and
\fB-out\fR. The \fIneighbours\fR.
.TP
\fB-inner\fR
The set of neighbours (see \fB-adj\fR above) which are also in the
set of nodes. I.e. the intersection between the set of nodes and the
neighbours per \fB-adj\fR.
.TP
\fB-embedding\fR
The set of neighbours (see \fB-adj\fR above) which are not in the
set of nodes. I.e. the difference between the neighbours as per
\fB-adj\fR, and the set of nodes.
.TP
\fB-key\fR \fIkey\fR
Limit the list of nodes that are returned to those nodes that have an
associated key \fIkey\fR.
.TP
\fB-value\fR \fIvalue\fR
This restriction can only be used in combination with
\fB-key\fR. It limits the list of nodes that are returned to those
nodes whose associated key \fIkey\fR has the value \fIvalue\fR.
.TP
\fB-filter\fR \fIcmdrefix\fR
Limit the list of nodes that are returned to those nodes that pass the
test. The command in \fIcmdprefix\fR is called with two arguments, the
name of the graph object, and the name of the node in question. It is
executed in the context of the caller and has to return a boolean
value. Nodes for which the command returns \fBfalse\fR are removed
from the result list before it is returned to the caller.
.RE
.TP
\fIgraphName\fR \fBget\fR \fIkey\fR
Return the value associated with the key \fIkey\fR for the graph.
.TP
\fIgraphName\fR \fBgetall\fR ?\fIpattern\fR?
Returns a dictionary (suitable for use with [\fBarray set\fR])
for the whole graph.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned dictionary. The pattern
is a \fBglob\fR pattern.
.TP
\fIgraphName\fR \fBkeys\fR ?\fIpattern\fR?
Returns a list of keys for the whole graph.
If the \fIpattern\fR is specified only the attributes whose names
match the pattern will be part of the returned list. The pattern is a
\fBglob\fR pattern.
.TP
\fIgraphName\fR \fBkeyexists\fR \fIkey\fR
Return true if the specified \fIkey\fR exists for the whole graph.
.TP
\fIgraphName\fR \fBserialize\fR ?\fInode\fR...?
This method serializes the sub-graph spanned up by the \fInode\fRs. In
other words it returns a tcl value completely describing that
graph. If no nodes are specified the whole graph will be serialized.
This allows, for example, the transfer of graph objects (or parts
thereof) over arbitrary channels, persistence, etc.
This method is also the basis for both the copy constructor and
the assignment operator.
.sp
The result of this method has to be semantically identical over all
implementations of the graph interface. This is what will enable us to
copy graph data between different implementations of the same
interface.
.sp
The result is a list containing a multiple of three items, plus one!
In other words, '[llength $serial] % 3 == 1'. Valid values
include 1, 4, 7, ...
.sp
The last element of the list is a dictionary containing the attributes
associated with the whole graph.
Regarding the other elements; each triple consists of
.RS
.IP [1]
The name of the node to be described,
.IP [2]
A dictionary containing the attributes associated with the node,
.IP [3]
And a list describing all the arcs starting at that node.
.RE
.sp
The elements of the arc list are lists containing three or four
elements each, i.e.
.RS
.IP [1]
The name of the arc described by the element,
.IP [2]
A reference to the destination node of the arc. This reference is an
integer number given the index of that node in the main serialization
list. As that it is greater than or equal to zero, less than the
length of the serialization, and a multiple of three.
\fINote:\fR For internal consistency no arc name may be used twice,
whether in the same node, or at some other node. This is a global
consistency requirement for the serialization.
.IP [3]
And a dictionary containing the attributes associated with the arc.
.IP [4]
The weight associated with the arc. This value is optional. Its
non-presence means that the arc in question has no weight associated
with it.
.sp
\fINote:\fR This information is new, compared to the
serialization of \fBgraph\fR 2.3 and earlier. By making it an
optional element the new format is maximally compatible with the
old. This means that any graph not using weights will generate a
serialization which is still understood by the older graph package. A
serialization will not be understood any longer by the older packages
if, and only if the graph it was generated from actually has arcs with
weights.
.RE
.sp
For all attribute dictionaries they keys are the names of the
attributes, and the values are the values for each name.
.sp
\fINote:\fR The order of the nodes in the serialization has no
relevance, nor has the order of the arcs per node.
.nf

    # A possible serialization for the graph structure
    #
    #        d -----> %2
    #       /         ^ \\\\
    #      /         /   \\\\
    #     /         b     \\\\
    #    /         /       \\\\
    #  %1 <- a - %0         e
    #    ^         \\\\      /
    #     \\\\        c     /
    #      \\\\        \\\\  /
    #       \\\\        v v
    #        f ------ %3
    # is
    #
    # %3 {} {{f 6 {}}} %0 {} {{a 6 {}} {b 9 {}} {c 0 {}}} %1 {} {{d 9 {}}} %2 {} {{e 0 {}}} {}
    #
    # This assumes that the graph has neither attribute data nor weighted arcs.

.fi
.sp
.TP
\fIgraphName\fR \fBset\fR \fIkey\fR ?\fIvalue\fR?
Set or get one of the keyed values associated with a graph. A graph
may have any number of keyed values associated with it. If \fIvalue\fR
is not specified, this command returns the current value assigned to
the key; if \fIvalue\fR is specified, this command assigns that value
to the key.
.TP
\fIgraphName\fR \fBswap\fR \fInode1\fR \fInode2\fR
Swap the position of \fInode1\fR and \fInode2\fR in the graph.
.TP
\fIgraphName\fR \fBunset\fR \fIkey\fR
Remove a keyed value from the graph. The method will do nothing if the
\fIkey\fR does not exist.
.TP
\fIgraphName\fR \fBwalk\fR \fInode\fR ?-order \fIorder\fR? ?-type \fItype\fR? ?-dir \fIdirection\fR? -command \fIcmd\fR
Perform a breadth-first or depth-first walk of the graph starting at
the node \fInode\fR going in either the direction of outgoing or
opposite to the incoming arcs.
.sp
The type of walk, breadth-first or depth-first, is determined by the
value of \fItype\fR; \fBbfs\fR indicates breadth-first,
\fBdfs\fR indicates depth-first.  Depth-first is the default.
.sp
The order of the walk, pre-order, post-order or both-order is
determined by the value of \fIorder\fR; \fBpre\fR indicates
pre-order, \fBpost\fR indicates post-order, \fBboth\fR indicates
both-order. Pre-order is the default. Pre-order walking means that a
node is visited before any of its neighbors (as defined by the
\fIdirection\fR, see below). Post-order walking means that a parent is
visited after any of its neighbors. Both-order walking means that a
node is visited before \fIand\fR after any of its neighbors. The
combination of a breadth-first walk with post- or both-order is illegal.
.sp
The direction of the walk is determined by the value of \fIdir\fR;
\fBbackward\fR indicates the direction opposite to the incoming
arcs, \fBforward\fR indicates the direction of the outgoing arcs.
.sp
As the walk progresses, the command \fIcmd\fR will be evaluated at
each node, with the mode of the call (\fBenter\fR or
\fBleave\fR) and values \fIgraphName\fR and the name of the current
node appended. For a pre-order walk, all nodes are \fBenter\fRed, for a
post-order all nodes are left. In a both-order walk the first visit of
a node \fBenter\fRs it, the second visit \fBleave\fRs it.
.PP
.SH "CHANGES FOR 2.0"
The following noteworthy changes have occurred:
.IP [1]
The API for accessing attributes and their values has been
simplified.
.sp
All functionality regarding the default attribute "data" has been
removed. This default attribute does not exist anymore. All accesses
to attributes have to specify the name of the attribute in
question. This backward \fIincompatible\fR change allowed us to
simplify the signature of all methods handling attributes.
.sp
Especially the flag \fB-key\fR is not required anymore, even more,
its use is now forbidden. Please read the documentation for the arc
and node methods \fBset\fR, \fBget\fR, \fBgetall\fR,
\fBunset\fR, \fBappend\fR, \fBlappend\fR, \fBkeyexists\fR
and \fBkeys\fR for a description of the new API's.
.IP [2]
The methods \fBkeys\fR and \fBgetall\fR now take an optional
pattern argument and will return only attribute data for keys matching
this pattern.
.IP [3]
Arcs and nodes can now be renamed. See the documentation for the
methods \fBarc rename\fR and \fBnode rename\fR.
.IP [4]
The structure has been extended with API's for the serialization and
deserialization of graph objects, and a number of operations based on
them (graph assignment, copy construction).
.sp
Please read the documentation for the methods \fBserialize\fR,
\fBdeserialize\fR, \fB=\fR, and \fB-->\fR, and the
documentation on the construction of graph objects.
.sp
Beyond the copying of whole graph objects these new API's also enable
the transfer of graph objects over arbitrary channels and for easy
persistence.
.IP [5]
A new method, \fBattr\fR, was added to both \fBarc\fR and
\fBnode\fR allowing the query and retrieval of attribute data
without regard to arc and node relationships.
.IP [6]
Both methods \fBarcs\fR and \fBnodes\fR have been extended with
the ability to select arcs and nodes based on an arbitrary filtering
criterium.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstruct :: graph\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
adjacent, arc, cgraph, degree, edge, graph, loop, neighbour, node, serialization, subgraph, vertex
.SH CATEGORY
Data structures
.SH COPYRIGHT
.nf
Copyright (c) 2002-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi