'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/pt/pt_parser_api.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pt_parser_api" i 1 pt "Parser Tools"
.BS
.SH NAME
pt_parser_api \- Parser API
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
\fBclassName\fR ?\fIobjectName\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBparse\fR \fIchan\fR
.sp
\fIobjectName\fR \fBparset\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR. This document is the
entrypoint to the whole system the current package is a part of.
.PP
This document describes the API shared by the grammar interpreter
provided by the package \fBpt::peg::interp\fR and the parsers
generated by the \fBpt\fR application for the result formats
\fBcritcl\fR, \fBsnit\fR, and \fBoo\fR regarding access
to the actual parsing functionality.
.PP
Its intended audience are people who wish to create a parser for some
language of theirs and then use that parser within a Tcl-based package
or application.
.PP
It resides in the User Layer of Parser Tools.
.PP
IMAGE: arch_user_pkg
.PP
.SH "CLASS API"
.TP
\fBclassName\fR ?\fIobjectName\fR?
The class command constructs parser instances, i.e. objects. The
result of the command is the fully-qualified name of the instance
command.
.sp
If no \fIobjectName\fR is specified the class will generate and use an
automatic name. If the \fIobjectName\fR was specified, but is not
fully qualified the command will be created in the curent namespace.
.PP
.SH "INSTANCE API"
All parser instances provide at least the methods shown below:
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the parser instance, releasing all claimed memory
and other resources, and deleting the instance command.
.sp
The result of the command is the empty string.
.TP
\fIobjectName\fR \fBparse\fR \fIchan\fR
This method runs the parser using the contents of \fIchan\fR as input
(starting at the current location in the channel), until parsing is
not possible anymore, either because parsing has completed, or run
into a syntax error.
.sp
Note here that the Parser Tools are based on Tcl 8.5+. In other words,
the channel argument is not restricted to files, sockets, etc. We have
the full power of \fIreflected channels\fR available.
.sp
It should also be noted that the parser pulls the characters from the
input stream as it needs them. If a parser created by this package has
to be operated in a push aka event-driven manner it will be necessary
to go to Tcl 8.6+ and use the \fBcoroutine::auto\fR to wrap it
into a coroutine where \fBread\fR is properly changed for
push-operation.
.sp
Upon successful completion the command returns an abstract syntax tree
as its result.
This AST is in the form specified in section
\fBAST serialization format\fR.
As a plain nested Tcl-list it can then be processed with any Tcl
commands the user likes, doing transformations, semantic checks, etc.
To help in this the package \fBpt::ast\fR provides a set of
convenience commands for validation of the tree's basic structure,
printing it for debugging, and walking it either from the bottom up,
or top down.
.sp
When encountering a syntax error the command will throw an error instead.
This error will be a 4-element Tcl-list, containing, in the order
listed below:
.RS
.IP [1]
The string \fBpt::rde\fR identifying it as parser runtime error.
.IP [2]
The location of the parse error, as character offset from the
beginning of the parsed input.
.IP [3]
The location of parse error, now as a 2-element list containing
line-number and column in the line.
.IP [4]
A set of atomic parsing expressions indicating encoding the characters
and/or nonterminal symbols the parser expected to see at the location
of the parse error, but did not get.
For the specification of atomic parsing expressions please see the
section \fBPE serialization format\fR.
.RE
.TP
\fIobjectName\fR \fBparset\fR \fItext\fR
This method runs the parser using the string in \fItext\fR as input.
In all other ways it behaves like the method \fBparse\fR, shown
above.
.PP
.SH USAGE
A generated parser is used like this
.nf

    package require the-parser-package ;# Generated by result-formats 'critcl', 'snit' or 'oo' of 'pt'.
    set parser [the-parser-class]

    set ast [$parser parse $channel]
    ... process the abstract syntax tree ...

.fi
When using a grammar interpreter for parsing some differences creep in
.nf

    package require the-grammar-package ;# Generated by result-format 'container' of 'pt'.
    set grammar [the-grammar-class]

    package require pt::peg::interp
    set parser [pt::peg::interp]

    $parser use $grammar

    set ast [$parser parse $channel]
    $parser destroy

    ... process the abstract syntax tree ...

.fi
.SH "AST SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Abstract Syntax Trees (ASTs) as immutable values for transport,
comparison, etc.
.PP
Each node in an AST represents a nonterminal symbol of a grammar, and
the range of tokens/characters in the input covered by it. ASTs do not
contain terminal symbols, i.e. tokens/characters. These can be
recovered from the input given a symbol's location.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a tree may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR.
.TP
Regular serialization
.RS
.IP [1]
The serialization of any AST is the serialization of its root node.
.IP [2]
The serialization of any node is a Tcl list containing at least three
elements.
.RS
.IP [1]
The first element is the name of the nonterminal symbol stored in the
node.
.IP [2]
The second and third element are the locations of the first and last
token in the token stream the node represents (covers).
.RS
.IP [1]
Locations are provided as non-negative integer offsets from the
beginning of the token stream, with the first token found in the
stream located at offset 0 (zero).
.IP [2]
The end location has to be equal to or larger than the start location.
.RE
.IP [3]
All elements after the first three represent the children of the node,
which are themselves nodes. This means that the serializations of
nodes without children, i.e. leaf nodes, have exactly three elements.
The children are stored in the list with the leftmost child first, and
the rightmost child last.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of an abstract syntax tree has the format
as specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this tree.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list. I.e. it does not contain superfluous whitespace.
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression grammar below
.PP
.nf

PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'	;
    Sign       <- '-' / '+'					;
    Number     <- Sign? Digit+					;
    Expression <- '(' Expression ')' / (Factor (MulOp Factor)*)	;
    MulOp      <- '*' / '/'					;
    Factor     <- Term (AddOp Term)*				;
    AddOp      <- '+'/'-'					;
    Term       <- Number					;
END;

.fi
.PP
and the input string
.nf
 120+5
.fi
then a parser should deliver the abstract syntax tree below (except for whitespace)
.PP
.nf

set ast {Expression 0 4
    {Factor 0 4
        {Term 0 2
            {Number 0 2
                {Digit 0 0}
                {Digit 1 1}
                {Digit 2 2}
            }
        }
        {AddOp 3 3}
        {Term 4 4
            {Number 4 4
                {Digit 4 4}
            }
        }
    }
}

.fi
.PP
Or, more graphical
.PP
IMAGE: expr_ast
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression. It matches
the empty string.
.IP [2]
The string \fBdot\fR is an atomic parsing expression. It matches
any character.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression. It matches
any Unicode alphabet or digit character. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression. It matches
any Unicode alphabet character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [5]
The string \fBascii\fR is an atomic parsing expression. It matches
any Unicode character below U0080. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression. It matches
any Unicode control character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression. It matches
any Unicode digit character. Note that this includes characters
outside of the [0..9] range. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression. It matches
any Unicode printing character, except for space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [9]
The string \fBlower\fR is an atomic parsing expression. It matches
any Unicode lower-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [10]
The string \fBprint\fR is an atomic parsing expression. It matches
any Unicode printing character, including space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression. It matches
any Unicode punctuation character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [12]
The string \fBspace\fR is an atomic parsing expression. It matches
any Unicode space character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [13]
The string \fBupper\fR is an atomic parsing expression. It matches
any Unicode upper-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression. It
matches any Unicode word character. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e.g.
underscore). This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression. It matches
any hexadecimal digit character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression. It matches
any decimal digit character. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression. It matches the terminal string \fBx\fR.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression. It matches the nonterminal \fBA\fR.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list / \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list x \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIsequence\fR.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well.
This is the \fIkleene closure\fR, describing zero or more
repetitions.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well.
This is the \fIand lookahead predicate\fR.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well.
This is the \fInot lookahead predicate\fR.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well.
This is the \fIoptional input\fR.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list. I.e. it does not contain superfluous whitespace.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical).
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.nf

    Expression <- '(' Expression ')'
                / Factor (MulOp Factor)*

.fi
.PP
then its canonical serialization (except for whitespace) is
.PP
.nf

    {/ {x {t (} {n Expression} {t )}} {x {n Factor} {* {x {n MulOp} {n Factor}}}}}

.fi
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpt\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi