'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/transfer/dsource.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "transfer::data::source" n 0.2 transfer "Data transfer facilities"
.BS
.SH NAME
transfer::data::source \- Data source
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBsnit  ?1.0?\fR
.sp
package require \fBtransfer::copy  ?0.2?\fR
.sp
package require \fBtransfer::data::source  ?0.2?\fR
.sp
\fBtransfer::data::source\fR \fIobjectName\fR ?\fIoptions\fR...?
.sp
\fIobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBtype\fR
.sp
\fIobjectName\fR \fBdata\fR
.sp
\fIobjectName\fR \fBsize\fR
.sp
\fIobjectName\fR \fBvalid\fR \fImsgvar\fR
.sp
\fIobjectName\fR \fBtransmit\fR \fIchannel\fR \fIblocksize\fR \fIdone\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides objects mainly describing the origin of some
data to transfer. They are also able to initiate transfers of the
described information to a channel using the foundation package
\fBtransfer::copy\fR.
.SH API
.SS "PACKAGE COMMANDS"
.TP
\fBtransfer::data::source\fR \fIobjectName\fR ?\fIoptions\fR...?
This command creates a new data source object with an associated Tcl
command whose name is \fIobjectName\fR.
This \fIobject\fR command is explained in full detail in the sections
\fBObject command\fR and \fBObject methods\fR. The set of
supported \fIoptions\fR is explained in section \fBOptions\fR.
.sp
The object command will be created under the current namespace if the
\fIobjectName\fR is not fully qualified, and in the specified
namespace otherwise.
The fully qualified name of the object command is returned as the
result of the command.
.PP
.SS "OBJECT COMMAND"
All objects created by the \fB::transfer::data::source\fR command have
the following general form:
.TP
\fIobjectName\fR \fBmethod\fR ?\fIarg arg ...\fR?
The method \fBmethod\fR and its \fIarg\fR'uments determine the
exact behavior of the command.
See section \fBObject methods\fR for the detailed
specifications.
.PP
.SS "OBJECT METHODS"
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object. Doing so while a transfer initiated
by the object is active is safe as all data required for the transfer
itself was copied, and the completion of the transfer will not try to
access the initiating object anymore. i.e. the transfer is completely
separate from the source object itself.
.TP
\fIobjectName\fR \fBtype\fR
This method returns a string describing the type of the data the
object is refering to. The possible values and their meanings are:
.RS
.TP
\fBundefined\fR
No data was specified at all, or it was specified incompletely. The
object does not know the type.
.TP
\fBstring\fR
The data to transfer is contained in a string.
.TP
\fBchannel\fR
The data to transfer is contained in a channel.
.RE
.TP
\fIobjectName\fR \fBdata\fR
This method returns a value depending on the type of the data the
object refers to, through which the data can be accessed.
The method throws an error if the type is \fBundefined\fR. For type
\fBstring\fR the returned result is the data itself, whereas for
type \fBchannel\fR the returned result is the handle of the channel
containing the data.
.TP
\fIobjectName\fR \fBsize\fR
This method returns a value depending on the type of the data the
object refers to, the size of the data.
The method throws an error if the type is \fBundefined\fR. Return of
a negative value signals that the object is unable to determine an
absolute size upfront (like for data in a channel).
.TP
\fIobjectName\fR \fBvalid\fR \fImsgvar\fR
This method checks the configuration of the object for validity. It
returns a boolean flag as result, whose value is \fBTrue\fR if the
object is valid, and \fBFalse\fR otherwise. In the latter case the
variable whose name is stored in \fImsgvar\fR is set to an error
message describing the problem found with the configuration. Otherwise
this variable is not touched.
.TP
\fIobjectName\fR \fBtransmit\fR \fIchannel\fR \fIblocksize\fR \fIdone\fR
This method initiates a transfer of the referenced data to the
specified \fIchannel\fR.
When the transfer completes the command prefix \fIdone\fR is invoked,
per the rules for the option \fB-command\fR of command
\fBtransfer::copy::do\fR in the package \fBtransfer::copy\fR.
The \fIblocksize\fR specifies the size of the chunks to transfer in
one go. See the option \fB-blocksize\fR of command
\fBtransfer::copy::do\fR in the package \fBtransfer::copy\fR.
.PP
.SS OPTIONS
All data sources support the options listed below. It should be noted
that the first four options are semi-exclusive, each specifying a
different type of data source and associated content. If these options
are specified more than once then the last option specified is used to
actually configure the object.
.TP
\fB-string\fR \fItext\fR
This option specifies that the source of the data is an immediate
string, and its associated argument contains the string in question.
.TP
\fB-channel\fR \fIhandle\fR
This option specifies that the source of the data is a channel, and
its associated argument is the handle of the channel containing the
data.
.TP
\fB-file\fR \fIpath\fR
This option specifies that the source of the data is a file, and its
associated argument is the path of the file containing the data.
.TP
\fB-variable\fR \fIvarname\fR
This option specifies that the source of the data is a string stored
in a variable, and its associated argument contains the name of the
variable in question. The variable is assumed to be global or
namespaced, anchored at the global namespace.
.TP
\fB-size\fR \fIint\fR
This option specifies the size of the data transfer. It is optional
and defaults to -1. This value, and any other value less than zero
signals to transfer all the data from the source.
.TP
\fB-progress\fR \fIcommand\fR
This option, if specified, defines a command to be invoked for each
chunk of bytes transmitted, allowing the user to monitor the progress
of the transmission of the data. The callback is always invoked with
one additional argument, the number of bytes transmitted so far.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItransfer\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
channel, copy, data source, transfer
.SH CATEGORY
Transfer module
.SH COPYRIGHT
.nf
Copyright (c) 2006-2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi