'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/yaml/huddle.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 KATO Kanryu <kanryu6@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "huddle" n 0.1.4 yaml "HUDDLE"
.BS
.SH NAME
huddle \- Create and manipulate huddle object
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBhuddle  ?0.1.4?\fR
.sp
\fBhuddle create\fR \fIkey\fR \fIvalue\fR ?\fIkey value ...\fR?
.sp
\fBhuddle list\fR ?\fIvalue value ...\fR?
.sp
\fBhuddle get\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
.sp
\fBhuddle gets\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
.sp
\fBhuddle set\fR \fIobjectVar\fR \fIkey\fR ?\fIkey ...\fR? \fIvalue\fR
.sp
\fBhuddle remove\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
.sp
\fBhuddle combine\fR \fIobject1\fR \fIobject2\fR ?\fIobject3 ...\fR?
.sp
\fBhuddle equal\fR \fIobject1\fR \fIobject2\fR
.sp
\fBhuddle append\fR \fIobjectVar\fR \fIkey\fR \fIvalue\fR ?\fIkey value ...\fR?
.sp
\fBhuddle append\fR \fIobjectVar\fR \fIvalue\fR ?\fIvalue ...\fR?
.sp
\fBhuddle keys\fR \fIobject\fR
.sp
\fBhuddle llength\fR \fIobject\fR
.sp
\fBhuddle type\fR \fIobject\fR ?\fIkey key...\fR?
.sp
\fBhuddle strip\fR \fIobject\fR
.sp
\fBhuddle jsondump\fR \fIobject\fR ?\fIoffset\fR? ?\fInewline\fR? ?\fIbegin_offset\fR?
.sp
\fBhuddle compile\fR \fIspec\fR \fIdata\fR
.sp
\fBhuddle isHuddle\fR \fIobject\fR
.sp
\fBhuddle checkHuddle\fR \fIobject\fR
.sp
\fBhuddle to_node\fR \fIobject\fR ?\fItag\fR?
.sp
\fBhuddle wrap\fR \fItag\fR \fIsrc\fR
.sp
\fBhuddle call\fR \fItag\fR \fIcommand\fR \fIargs\fR
.sp
\fBhuddle addType\fR \fIcallback\fR
.sp
\fBcallback\fR \fIcommand\fR ?\fIargs\fR?
.sp
\fBsetting\fR
.sp
\fBget_sub\fR \fIsrc\fR \fIkey\fR
.sp
\fBstrip\fR \fIsrc\fR
.sp
\fBset\fR \fIsrc\fR \fIkey\fR \fIvalue\fR
.sp
\fBremove\fR \fIsrc\fR \fIkey\fR \fIvalue\fR
.sp
.BE
.SH DESCRIPTION
.PP
Huddle provides a generic Tcl-based serialization/intermediary format.
Currently, each node is wrapped in a tag with simple type information.
.PP
When converting huddle-notation to other serialization formats like
JSON or YAML this type information is used to select the proper notation.
And when going from JSON/YAML/... to huddle their notation can be used
to select the proper huddle type.
.PP
In that manner huddle can serve as a common intermediary format.
.nf

huddle-format: >
  {HUDDLE {huddle-node}}
huddle-node: >
  {tag content}
each content of tag means:
  s: (content is a) string
  L: list, each sub node is a huddle-node
  D: dict, each sub node is a huddle-node
confirmed:
  - JSON
  - YAML(generally, but cannot discribe YAML-tags)
limitation:
  - cannot discribe aliases from a node to other node.

.fi
.PP
The \fBhuddle\fR package returns
data as a Tcl \fBdict\fR.  Either the \fBdict\fR package or Tcl 8.5 is
required for use.
.SH COMMANDS
.TP
\fBhuddle create\fR \fIkey\fR \fIvalue\fR ?\fIkey value ...\fR?
Create a huddle object as a dict. It can contain other huddle objects.
.TP
\fBhuddle list\fR ?\fIvalue value ...\fR?
Create a huddle object as a list. It can contain other huddle objects.
.TP
\fBhuddle get\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
Almost the same as \fBdict get\fR.
Get a sub-object from the huddle object.
\fIkey\fR can be used to huddle-list's index.
.TP
\fBhuddle gets\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
Get a sub-object from the huddle object, stripped.
.TP
\fBhuddle set\fR \fIobjectVar\fR \fIkey\fR ?\fIkey ...\fR? \fIvalue\fR
Almost the same as \fBdict set\fR.
Set a sub-object from the huddle object.
\fIkey\fR can be used to huddle-list's index.
.TP
\fBhuddle remove\fR \fIobject\fR \fIkey\fR ?\fIkey ...\fR?
Almost the same as \fBdict remove\fR.
Remove a sub-object from the huddle object.
\fIkey\fR can be used to huddle-list's index.
.TP
\fBhuddle combine\fR \fIobject1\fR \fIobject2\fR ?\fIobject3 ...\fR?
Merging huddle objects given.
.nf

% set aa [huddle create a b c d]
HUDDLE {D {a {s b} c {s d}}}
% set bb [huddle create a k l m]
HUDDLE {D {a {s k} l {s m}}}
% huddle combine $aa $bb
HUDDLE {D {a {s k} c {s d} l {s m}}}

.fi
.TP
\fBhuddle equal\fR \fIobject1\fR \fIobject2\fR
Comparing two huddle objects recursively.
When to equal, returns 1, otherwise 0.
.nf

% set aa [huddle create a b c d]
HUDDLE {D {a {s b} c {s d}}}
% set bb [huddle create c d a b]
HUDDLE {D {c {s d} a {s b}}}
% huddle equal $aa $bb
1

.fi
.TP
\fBhuddle append\fR \fIobjectVar\fR \fIkey\fR \fIvalue\fR ?\fIkey value ...\fR?
.TP
\fBhuddle append\fR \fIobjectVar\fR \fIvalue\fR ?\fIvalue ...\fR?
Appending child elements. When for dicts, giving key/value. When for lists, giving values.
.nf

% set aa [huddle create a b c d]
HUDDLE {D {a {s b} c {s d}}}
% huddle append aa a k l m
HUDDLE {D {a {s k} c {s d} l {s m}}}
% set bb [huddle list i j k l]
HUDDLE {L {{s i} {s j} {s k} {s l}}}
% huddle append bb g h i
HUDDLE {L {{s i} {s j} {s k} {s l} {s g} {s h} {s i}}}

.fi
.TP
\fBhuddle keys\fR \fIobject\fR
The same as \fBdict keys\fR.
.TP
\fBhuddle llength\fR \fIobject\fR
The same as \fBllength\fR.
.TP
\fBhuddle type\fR \fIobject\fR ?\fIkey key...\fR?
Return the element type of specified by keys.
if ?key? is not given, returns the type of root node.
.sp
.RS
.TP
\fB\fBstring\fR\fR
the node is a tcl's string.
.TP
\fB\fBdict\fR\fR
the node is a dict.
.TP
\fB\fBlist\fR\fR
the node is a list.
.RE
.nf

% huddle type {HUDDLE {s str}}
string
% huddle type {HUDDLE {L {{s a} {s b} {s c}}}}
list
% huddle type {HUDDLE {D {aa {s b} cc {s d}}}} cc
string

.fi
.TP
\fBhuddle strip\fR \fIobject\fR
Stripped all tags. Converted to normal Tcl's list/dict.
.TP
\fBhuddle jsondump\fR \fIobject\fR ?\fIoffset\fR? ?\fInewline\fR? ?\fIbegin_offset\fR?
dump a json-stream from the huddle-object.
.sp
.RS
.TP
\fB\fBoffset\fR ""\fR
begin offset as spaces "  ".
.RE
.nf
# normal output has some indents. some strings are escaped.
% huddle jsondump {HUDDLE {L {{L {{s i} {s baa} {s \\\\k} {L {{s 1.0} {s true} {s /g} {s h}}} {L {{s g}}}}} {s t}}}}
[
  [
    "i",
    "baa",
    "\\\\k",
    [
      1.0,
      true,
      "\\/g",
      "h"
    ],
    ["g"]
  ],
  "t"
]
# stripped output
% huddle jsondump {HUDDLE {D {dd {D {bb {D {a {s baa} c {s {d
a}}}} cc {D {g {s h}}}}} ee {D {i {s j} k {s 1} j {s { m\\a}}}}}}} "" ""
{"dd": {"bb": {"a": "baa","c": "d\\na"},"cc": {"g": "h"}},"ee": {"i": "j","k": 1,"j": " m\\\\a"}}

.fi
.TP
\fBhuddle compile\fR \fIspec\fR \fIdata\fR
construct a huddle object from plain old tcl values.
\fIspec\fR is defined as follows:
.RS
.TP
\fBstring\fR
data is simply a string
.TP
\fBlist\fR
data is a tcl list of strings
.TP
\fBdict\fR
data is a tcl dict of strings
.TP
list list
data is a tcl list of lists
.TP
list dict
data is a tcl list of dicts
.TP
dict xx list
data is a tcl dict where the value of key xx is a tcl list
.TP
dict * list
data is a tcl dict of lists
\fIdata\fR is plain old tcl values
.RE
.nf
% huddle compile {dict * list} {a {1 2 3} b {4 5}}
HUDDLE {D {a {L {{s 1} {s 2} {s 3}}} b {L {{s 4} {s 5}}}}}
% huddle compile {dict * {list {dict d list}}} {a {{c 1} {d {2 2 2} e 3}} b {{f 4 g 5}}}
HUDDLE {D {a {L {{D {c {s 1}}} {D {d {L {{s 2} {s 2} {s 2}}} e {s 3}}}}} b {L {{D {f {s 4} g {s 5}}}}}}}

.fi
.TP
\fBhuddle isHuddle\fR \fIobject\fR
if \fIobject\fR is a huddle, returns 1. the other, returns 0.
.TP
\fBhuddle checkHuddle\fR \fIobject\fR
if \fIobject\fR is not a huddle, rises an error.
.TP
\fBhuddle to_node\fR \fIobject\fR ?\fItag\fR?
for type-callbacks.
.sp
if \fIobject\fR is a huddle, returns root-node. the other, returns \fB[list s $object]\fR.
.nf

% huddle to_node str
s str
% huddle to_node str !!str
!!str str
% huddle to_node {HUDDLE {s str}}
s str
% huddle to_node {HUDDLE {l {a b c}}}
l {a b c}

.fi
.TP
\fBhuddle wrap\fR \fItag\fR \fIsrc\fR
for type-callbacks.
.sp
Create a huddle object from \fIsrc\fR with specified \fItag\fR.
.nf

% huddle wrap "" str
HUDDLE str
% huddle wrap s str
HUDDLE {s str}

.fi
.TP
\fBhuddle call\fR \fItag\fR \fIcommand\fR \fIargs\fR
for type-callbacks.
.sp
devolving \fIcommand\fR to default \fItag\fR-callback
.TP
\fBhuddle addType\fR \fIcallback\fR
add a user-specified-type/tag to the huddle library.
To see "Additional Type".
.sp
.RS
.TP
\fBcallback\fR
callback function name for additional type.
.RE
.PP
.SH "TYPE CALLBACK"
.PP
The definition of callback for user-type.
.TP
\fBcallback\fR \fIcommand\fR ?\fIargs\fR?
.RS
.TP
\fBcommand\fR
huddle subcomand which is needed to reply by the callback.
.TP
\fBargs\fR
arguments of subcommand. The number of list of arguments is different for each subcommand.
.RE
.PP
.PP
The callback procedure shuould reply the following subcommands.
.TP
\fBsetting\fR
only returns a fixed dict of the type infomation for setting the user-tag.
.RS
.TP
\fBtype\fR typename
typename of the type
.TP
\fBmethod\fR {method1 method2 method3 ...}
method list as huddle subcommand. Then, you can call \fB[huddle method1 ...]\fR
.TP
\fBtag\fR {tag1 child/parent tag2 child/parent ...}
tag list for huddle-node as a dict. if the type has child-nodes, use "parent", otherwise use "child".
.RE
.TP
\fBget_sub\fR \fIsrc\fR \fIkey\fR
returns a sub node specified by \fIkey\fR.
.RS
.TP
\fBsrc\fR
a node content in huddle object.
.RE
.TP
\fBstrip\fR \fIsrc\fR
returns stripped node contents. if the type has child nodes, every node must be stripped.
.TP
\fBset\fR \fIsrc\fR \fIkey\fR \fIvalue\fR
sets a sub-node from the tagged-content, and returns self.
.TP
\fBremove\fR \fIsrc\fR \fIkey\fR \fIvalue\fR
removes a sub-node from the tagged-content, and returns self.
.PP
.PP
\fBstrip\fR must be defined at all types.
\fBget_sub\fR must be defined at container types.
\fBset/remove\fR shuould be defined, if you call them.
.nf

# callback sample for my-dict
proc my_dict_setting {command args} {
    switch -- $command {
        setting { ; # type definition
            return {
                type dict
                method {create keys}
                tag {d child D parent}
                constructor create
                str s
            }
            # type:   the type-name
            # method: add methods to huddle's subcommand.
            #          "get_sub/strip/set/remove/equal/append" called by huddle module.
            #          "strip" must be defined at all types.
            #          "get_sub" must be defined at container types.
            #          "set/remove/equal/append" shuould be defined, if you call them.
            # tag:    tag definition("child/parent" word is maybe obsoleted)
        }
        get_sub { ; # get a sub-node specified by "key" from the tagged-content
            foreach {src key} $args break
            return [dict get $src $key]
        }
        strip { ; # strip from the tagged-content
            foreach {src nop} $args break
            foreach {key val} $src {
                lappend result $key [huddle strip $val]
            }
            return $result
        }
        set { ; # set a sub-node from the tagged-content
            foreach {src key value} $args break
            dict set src $key $value
            return $src
        }
        remove { ; # remove a sub-node from the tagged-content
            foreach {src key value} $args break
            return [dict remove $src $key]
        }
        equal { ; # check equal for each node
            foreach {src1 src2} $args break
            if {[llength $src1] != [llength $src2]} {return 0}
            foreach {key1 val1} $src1 {
                if {![dict exists $src2 $key1]} {return 0}
                if {![huddle _equal_subs $val1 [dict get $src2 $key1]]} {return 0}
            }
            return 1
        }
        append { ; # append nodes
            foreach {str src list} $args break
            if {[llength $list] % 2} {error {wrong # args: should be "huddle append objvar ?key value ...?"}}
            set resultL $src
            foreach {key value} $list {
                if {$str ne ""} {
                    lappend resultL $key [huddle to_node $value $str]
                } else {
                    lappend resultL $key $value
                }
            }
            return [eval dict create $resultL]
        }
        create { ; # $args: all arguments after "huddle create"
            if {[llength $args] % 2} {error {wrong # args: should be "huddle create ?key value ...?"}}
            set resultL {}
            foreach {key value} $args {
                lappend resultL $key [huddle to_node $value]
            }
            return [huddle wrap D $resultL]
        }
        keys {
            foreach {src nop} $args break
            return [dict keys [lindex [lindex $src 1] 1]]
        }
        default {
            error "$command is not callback for dict"
        }
    }
}

.fi
.nf

# inheritance sample from default dict-callback
proc ::yaml::_huddle_mapping {command args} {
    switch -- $command {
        setting { ; # type definition
            return {
                type dict
                method {mapping}
                tag {!!map parent}
                constructor mapping
                str !!str
            }
        }
        mapping { ; # $args: all arguments after "huddle mapping"
            if {[llength $args] % 2} {error {wrong # args: should be "huddle mapping ?key value ...?"}}
            set resultL {}
            foreach {key value} $args {
                lappend resultL $key [huddle to_node $value !!str]
            }
            return [huddle wrap !!map $resultL]
        }
        default { ; # devolving to default dict-callback
            return [huddle call D $command $args]
        }
    }
}

.fi
.SH "HOW TO ADD TYPE"
.PP
You can add huddle-node types e.g. ::struct::tree.
To do so, first, define a callback-procedure for additional tagged-type.
The proc get argments as \fIcommand\fR and ?\fIargs\fR?. It has some switch-sections.
.PP
And, addType subcommand will called.
.nf

huddle addType my_dict_setting

.fi
.SH "WORKING SAMPLE"
.nf

# create as a dict
% set bb [huddle create a b c d]
HUDDLE {D {a {s b} c {s d}}}

# create as a list
% set cc [huddle list e f g h]
HUDDLE {L {{s e} {s f} {s g} {s h}}}
% set bbcc [huddle create bb $bb cc $cc]
HUDDLE {D {bb {D {a {s b} c {s d}}} cc {L {{s e} {s f} {s g} {s h}}}}}
% set folding [huddle list $bbcc p [huddle list q r] s]
HUDDLE {L {{D {bb {D {a {s b} c {s d}}} cc {L {{s e} {s f} {s g} {s h}}}}} {s p} {L {{s q} {s r}}} {s s}}}

# normal Tcl's notation
% huddle strip $folding
{bb {a b c d} cc {e f g h}} p {q r} s

# get a sub node
% huddle get $folding 0 bb
HUDDLE {D {a {s b} c {s d}}}
% huddle gets $folding 0 bb
a b c d

# overwrite a node
% huddle set folding 0 bb c kkk
HUDDLE {L {{D {bb {D {a {s b} c {s kkk}}} cc {L {{s e} {s f} {s g} {s h}}}}} {s p} {L {{s q} {s r}}} {s s}}}

# remove a node
% huddle remove $folding 2 1
HUDDLE {L {{D {bb {D {a {s b} c {s kkk}}} cc {L {{s e} {s f} {s g} {s h}}}}} {s p} {L {{s q}}} {s s}}}
% huddle strip $folding
{bb {a b c kkk} cc {e f g h}} p {q r} s

# dump as a JSON stream
% huddle jsondump $folding
[
  {
    "bb": {
      "a": "b",
      "c": "kkk"
    },
    "cc": [
      "e",
      "f",
      "g",
      "h"
    ]
  },
  "p",
  [
    "q",
    "r"
  ],
  "s"
]

.fi
.SH LIMITATIONS
.PP
now printing.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIhuddle\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
yaml
.SH KEYWORDS
data exchange, exchange format, huddle, json, parsing, text processing, yaml
.SH COPYRIGHT
.nf
Copyright (c) 2008 KATO Kanryu <kanryu6@users.sourceforge.net>

.fi