'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/nntp/nntp.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "nntp" n 1.5.1 nntp "Tcl NNTP Client Library"
.BS
.SH NAME
nntp \- Tcl client for the NNTP protocol
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBnntp  ?0.2.1?\fR
.sp
\fB::nntp::nntp\fR ?\fIhost\fR? ?\fIport\fR? ?\fInntpName\fR?
.sp
\fInntpName\fR \fBmethod\fR ?\fIarg arg ...\fR?
.sp
\fInntpName\fR \fBarticle\fR ?\fImsgid\fR?
.sp
\fInntpName\fR \fBauthinfo\fR ?\fIuser\fR? ?\fIpass\fR?
.sp
\fInntpName\fR \fBbody\fR ?\fImsgid\fR?
.sp
\fInntpName\fR \fBconfigure\fR
.sp
\fInntpName\fR \fBconfigure\fR \fIoption\fR
.sp
\fInntpName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR ...
.sp
\fInntpName\fR \fBcget\fR \fIoption\fR
.sp
\fInntpName\fR \fBdate\fR
.sp
\fInntpName\fR \fBgroup\fR ?\fIgroup\fR?
.sp
\fInntpName\fR \fBhead\fR ?\fImsgid\fR?
.sp
\fInntpName\fR \fBhelp\fR
.sp
\fInntpName\fR \fBlast\fR
.sp
\fInntpName\fR \fBlist\fR
.sp
\fInntpName\fR \fBlistgroup\fR ?\fIgroup\fR?
.sp
\fInntpName\fR \fBmode_reader\fR
.sp
\fInntpName\fR \fBnewgroups\fR \fIsince\fR
.sp
\fInntpName\fR \fBnewnews\fR
.sp
\fInntpName\fR \fBnewnews\fR \fIsince\fR
.sp
\fInntpName\fR \fBnewnews\fR \fIgroup\fR ?\fIsince\fR?
.sp
\fInntpName\fR \fBnext\fR
.sp
\fInntpName\fR \fBpost\fR \fIarticle\fR
.sp
\fInntpName\fR \fBslave\fR
.sp
\fInntpName\fR \fBstat\fR ?\fImsgid\fR?
.sp
\fInntpName\fR \fBquit\fR
.sp
\fInntpName\fR \fBxgtitle\fR ?\fIgroup_pattern\fR?
.sp
\fInntpName\fR \fBxhdr\fR \fIfield\fR ?\fIrange\fR?
.sp
\fInntpName\fR \fBxover\fR ?\fIrange\fR?
.sp
\fInntpName\fR \fBxpat\fR \fIfield\fR \fIrange\fR ?\fIpattern_list\fR?
.sp
.BE
.SH DESCRIPTION
The package \fBnntp\fR provides a simple Tcl-only client library
for the NNTP protocol.  It works by opening the standard NNTP socket
on the server, and then providing a Tcl API to access the NNTP
protocol commands.  All server errors are returned as Tcl errors
(thrown) which must be caught with the Tcl \fBcatch\fR command.
.SH COMMANDS
.TP
\fB::nntp::nntp\fR ?\fIhost\fR? ?\fIport\fR? ?\fInntpName\fR?
The command opens a socket connection to the specified NNTP server and
creates a new nntp object with an associated global Tcl command whose
name is \fInntpName\fR. This command may be used to access the various
NNTP protocol commands for the new connection. The default \fIport\fR
number is "119" and the default \fIhost\fR is "news". These defaults
can be overridden with the environment variables \fBNNTPPORT\fR and
\fBNNTPHOST\fR respectively.
.sp
Some of the commands supported by this package are not part of the
nntp rfc 977 (\fIhttp://www.rfc-editor.org/rfc/rfc977.txt\fR) and will
not be available (or implemented) on all nntp servers.
.sp
The access command \fInntpName\fR has the following general form:
.RS
.TP
\fInntpName\fR \fBmethod\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.RE
.TP
\fInntpName\fR \fBarticle\fR ?\fImsgid\fR?
Query the server for article \fImsgid\fR from the current group.  The article
is returned as a valid tcl list which contains the headers, followed by
a blank line, and then followed by the body of the article. Each element
in the list is one line of the article.
.TP
\fInntpName\fR \fBauthinfo\fR ?\fIuser\fR? ?\fIpass\fR?
Send authentication information (username and password) to the server.
.TP
\fInntpName\fR \fBbody\fR ?\fImsgid\fR?
Query the server for the body of the article \fImsgid\fR from the current
group.  The body of the article is returned as a valid tcl list. Each element
in the list is one line of the body of the article.
.TP
\fInntpName\fR \fBconfigure\fR
.TP
\fInntpName\fR \fBconfigure\fR \fIoption\fR
.TP
\fInntpName\fR \fBconfigure\fR \fIoption\fR \fIvalue\fR ...
.TP
\fInntpName\fR \fBcget\fR \fIoption\fR
Query and configure options of the nntp connection object. Currently
only one option is supported, \fB-binary\fR. When set articles are
retrieved as binary data instead of text. The only methods affected by
this are \fBarticle\fR and \fBbody\fR.
.sp
One application of this option would be the download of articles
containing yEnc encoded images. Although encoded the data is still
mostly binary and retrieving it as text will corrupt the information.
.sp
See package \fByencode\fR for both encoder and decoder of such data.
.TP
\fInntpName\fR \fBdate\fR
Query the server for the servers current date.  The date is returned in the
format \fIYYYYMMDDHHMMSS\fR.
.TP
\fInntpName\fR \fBgroup\fR ?\fIgroup\fR?
Optionally set the current group, and retrieve information about the
currently selected group.  Returns the estimated number of articles in
the group followed by the number of the first article in the group, followed
by the last article in the group, followed by the name of the group.
.TP
\fInntpName\fR \fBhead\fR ?\fImsgid\fR?
Query the server for the headers of the article \fImsgid\fR from the current
group.  The headers of the article are returned as a valid tcl list. Each element
in the list is one line of the headers of the article.
.TP
\fInntpName\fR \fBhelp\fR
Retrieves a list of the commands that are supported by the news server that
is currently attached to.
.TP
\fInntpName\fR \fBlast\fR
Sets the current article pointer to point to the previous message (if there is
one) and returns the msgid of that message.
.TP
\fInntpName\fR \fBlist\fR
Returns a tcl list of valid newsgroups and associated information.  Each
newsgroup is returned as an element in the tcl list with the following format:
.nf

      group last first p

.fi
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').
.sp
The <first> and <last> fields will always be numeric.  They may have
leading zeros.  If the <last> field evaluates to less than the
<first> field, there are no articles currently on file in the
newsgroup.
.TP
\fInntpName\fR \fBlistgroup\fR ?\fIgroup\fR?
Query the server for a list of all the messages (message numbers) in the
group specified by the argument \fIgroup\fR or by the current group if
the \fIgroup\fR argument was not passed.
.TP
\fInntpName\fR \fBmode_reader\fR
Query the server for its nntp 'MODE READER' response string.
.TP
\fInntpName\fR \fBnewgroups\fR \fIsince\fR
Query the server for a list of all the new newsgroups created since the time
specified by the argument \fIsince\fR.  The argument \fIsince\fR can be any
time string that is understood by \fBclock scan\fR. The tcl list of newsgroups
is returned in a similar form to the list of groups returned by the
\fBnntpName list\fR command.  Each element of the list has the form:
.nf

      group last first p

.fi
where <group> is the name of the newsgroup, <last> is the number of
the last known article currently in that newsgroup, <first> is the
number of the first article currently in the newsgroup, and <p> is
either 'y' or 'n' indicating whether posting to this newsgroup is
allowed ('y') or prohibited ('n').
.TP
\fInntpName\fR \fBnewnews\fR
Query the server for a list of new articles posted to the current group in the
last day.
.TP
\fInntpName\fR \fBnewnews\fR \fIsince\fR
Query the server for a list of new articles posted to the current group since
the time specified by the argument \fIsince\fR.  The argument \fIsince\fR can
be any time string that is understood by \fBclock scan\fR.
.TP
\fInntpName\fR \fBnewnews\fR \fIgroup\fR ?\fIsince\fR?
Query the server for a list of new articles posted to the group specified by
the argument \fIgroup\fR since the time specified by the argument \fIsince\fR
(or in the past day if no \fIsince\fR argument is passed.  The argument
\fIsince\fR can be any time string that is understood by \fBclock scan\fR.
.TP
\fInntpName\fR \fBnext\fR
Sets the current article pointer to point to the next message (if there is
one) and returns the msgid of that message.
.TP
\fInntpName\fR \fBpost\fR \fIarticle\fR
Posts an article of the form specified in
RFC 1036 (\fIhttp://www.rfc-editor.org/rfc/rfc1036.txt\fR, successor
to RFC 850) to the current news group.
.TP
\fInntpName\fR \fBslave\fR
Identifies a connection as being made from a slave nntp server. This might
be used to indicate that the connection is serving multiple people and should
be given priority.  Actual use is entirely implementation dependent and may
vary from server to server.
.TP
\fInntpName\fR \fBstat\fR ?\fImsgid\fR?
The stat command is similar to the article command except that no
text is returned.  When selecting by message number within a group,
the stat command serves to set the current article pointer without
sending text. The returned acknowledgment response will contain the
message-id, which may be of some value.  Using the stat command to
select by message-id is valid but of questionable value, since a
selection by message-id does NOT alter the "current article pointer"
.TP
\fInntpName\fR \fBquit\fR
Gracefully close the connection after sending a NNTP QUIT command down
the socket.
.TP
\fInntpName\fR \fBxgtitle\fR ?\fIgroup_pattern\fR?
Returns a tcl list where each element is of the form:
.nf

newsgroup description

.fi
If a \fIgroup_pattern\fR is specified then only newsgroups that match
the pattern will have their name and description returned.
.TP
\fInntpName\fR \fBxhdr\fR \fIfield\fR ?\fIrange\fR?
Returns the specified header field value for the current message or for a
list of messages from the current group.  \fIfield\fR is the title of a
field in the header such as from, subject, date, etc.  If \fIrange\fR is
not specified or is "" then the current message is queried.  The command
returns a list of elements where each element has the form of:
.nf

    msgid value

.fi
Where msgid is the number of the message and value is the value set for the
queried field.  The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fB""\fR
The current message is queried.
.TP
\fImsgid1\fR-\fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.TP
\fImsgid1\fR \fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.RE
.TP
\fInntpName\fR \fBxover\fR ?\fIrange\fR?
Returns header information for the current message or for a range of messages
from the current group.  The information is returned in a tcl list
where each element is of the form:
.nf

    msgid subject from date idstring bodysize headersize xref

.fi
If \fIrange\fR is not specified or is "" then the current message is queried.
The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fB""\fR
The current message is queried.
.TP
\fImsgid1\fR-\fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.TP
\fImsgid1\fR \fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.RE
.TP
\fInntpName\fR \fBxpat\fR \fIfield\fR \fIrange\fR ?\fIpattern_list\fR?
Returns the specified header field value for a specified message or for a
list of messages from the current group where the messages match the
pattern(s) given in the pattern_list.  \fIfield\fR is the title of a
field in the header such as from, subject, date, etc.  The information is
returned in a tcl list where each element is of the form:
.nf

    msgid value

.fi
Where msgid is the number of the message and value is the value set for the
queried field.  The \fIrange\fR argument can be in any of the following forms:
.RS
.TP
\fImsgid\fR
The message specified by \fImsgid\fR is queried.
.TP
\fImsgid1\fR-\fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.TP
\fImsgid1\fR \fImsgid2\fR
All messages between \fImsgid1\fR and \fImsgid2\fR
(including \fImsgid1\fR and \fImsgid2\fR) are queried.
.RE
.PP
.SH EXAMPLE
A bigger example for posting a single article.
.PP
.nf

    package require nntp
    set n [nntp::nntp NNTP_SERVER]
    $n post "From: USER@DOMAIN.EXT (USER_FULL)
    Path: COMPUTERNAME!USERNAME
    Newsgroups: alt.test
    Subject: Tcl test post -ignore
    Message-ID: <[pid][clock seconds]
    @COMPUTERNAME>
    Date: [clock format [clock seconds] -format "%a, %d %
    b %y %H:%M:%S GMT" -gmt true]

    Test message body"

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fInntp\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
news, nntp, nntpclient, rfc 1036, rfc 977
.SH CATEGORY
Networking