'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/pt/pt.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pt" n 1 pt "Parser Tools"
.BS
.SH NAME
pt \- Parser Tools Application
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
\fBpt\fR \fBgenerate\fR \fIresultformat\fR ?\fIoptions...\fR? \fIresultfile\fR \fIinputformat\fR \fIinputfile\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR. This document is the
entrypoint to the whole system the current package is a part of.
.PP
This document describes \fBpt\fR, the main application of the module,
a \fIparser generator\fR. Its intended audience are people who wish
to create a parser for some language of theirs. Should you wish to
modify the application instead, please see the section about the
application's \fBInternals\fR for the basic references.
.PP
It resides in the User Application Layer of Parser Tools.
.PP
IMAGE: arch_user_app
.PP
.SH "COMMAND LINE"
.TP
\fBpt\fR \fBgenerate\fR \fIresultformat\fR ?\fIoptions...\fR? \fIresultfile\fR \fIinputformat\fR \fIinputfile\fR
This sub-command of the application reads the parsing expression
grammar stored in the \fIinputfile\fR in the format \fIinputformat\fR,
converts it to the \fIresultformat\fR under the direction of the
(format-specific) set of options specified by the user and stores the
result in the \fIresultfile\fR.
.sp
The \fIinputfile\fR has to exist, while the \fIresultfile\fR may be
created, overwriting any pre-existing content of the file. Any missing
directory in the path to the \fIresultfile\fR will be created as well.
.sp
The exact form of the result for, and the set of options supported by
the known result-formats, are explained in the upcoming sections of
this document, with the list below providing an index mapping between
format name and its associated section. In alphabetical order:
.sp
.RS
.TP
\fBc\fR
A \fIresultformat\fR. See section \fBC Parser\fR.
.TP
\fBcontainer\fR
A \fIresultformat\fR. See section \fBGrammar Container\fR.
.TP
\fBcritcl\fR
A \fIresultformat\fR. See section \fBC Parser Embedded In Tcl\fR.
.TP
\fBjson\fR
A \fIinput\fR- and \fIresultformat\fR. See section \fBJSON Grammar Exchange\fR.
.TP
\fBoo\fR
A \fIresultformat\fR. See section \fBTclOO Parser\fR.
.TP
\fBpeg\fR
A \fIinput\fR- and \fIresultformat\fR. See section \fBPEG Specification Language\fR.
.TP
\fBsnit\fR
A \fIresultformat\fR. See section \fBSnit Parser\fR.
.RE
.PP
Of the seven possible results four are parsers outright (\fBc\fR,
\fBcritcl\fR, \fBoo\fR, and \fBsnit\fR), one (\fBcontainer\fR)
provides code which can be used in conjunction with a generic parser
(also known as a grammar interpreter), and the last two (\fBjson\fR
and \fBpeg\fR) are doing double-duty as input formats, allowing the
transformation of grammars for exchange, reformatting, and the like.
.PP
The created parsers fall into three categories:
.PP
IMAGE: gen_options
.PP
.TP
\fBSpecialized parsers implemented in C\fR
The fastest parsers are created when using the result formats
\fBc\fR and \fBcritcl\fR. The first returns the raw C code for the
parser, while the latter wraps it into a Tcl package using
\fICriTcl\fR.
.sp
This makes the latter much easier to use than the former. On the other
hand, the former can be adapted to the users' requirements through a
multitude of options, allowing for things like usage of the parser
outside of a Tcl environment, something the \fBcritcl\fR format
doesn't support. As such the \fBc\fR format is meant for more
advanced users, or users with special needs.
.sp
A disadvantage of all the parsers in this section is the need to run
them through a C compiler to make them actually executable. This is
not something everyone has the necessary tools for. The parsers in the
next section are for people under such restrictions.
.TP
\fBSpecialized parsers implemented in Tcl\fR
As the parsers in this section are implemented in Tcl they are quite a
bit slower than anything from the previous section. On the other hand
this allows them to be used in pure-Tcl environments, or in
environments which allow only a limited set of binary packages. In the
latter case it will be advantageous to lobby for the inclusion of the
C-based runtime support (notes below) into the environment to reduce
the impact of Tcl's on the speed of these parsers.
.sp
The relevant formats are \fBsnit\fR and \fBoo\fR. Both place their
result into a Tcl package containing a \fBsnit::type\fR, or TclOO
\fBclass\fR respectively.
.sp
Of the supporting runtime, which is the package \fBpt::rde\fR, the
user has to know nothing but that it does exist and that the parsers
are dependent on it. Knowledge of the API exported by the runtime for
the parsers' consumption is \fInot\fR required by the parsers' users.
.TP
\fBInterpreted parsing implemented in Tcl\fR
The last category, grammar interpretation. This means that an
interpreter for parsing expression grammars takes the description of
the grammar to parse input for, and uses it guide the parsing process.
This is the slowest of the available options, as the interpreter has
to continually run through the configured grammar, whereas the
specialized parsers of the previous sections have the relevant
knowledge about the grammar baked into them.
.sp
The only places where using interpretation make sense is where the
grammar for some input may be changed interactively by the user, as
the interpretation allows for quick turnaround after each change,
whereas the previous methods require the generation of a whole new
parser, which is not as fast.
On the other hand, wherever the grammar to use is fixed, the previous
methods are much more advantageous as the time to generate the parser
is minuscule compared to the time the parser code is in use.
.sp
The relevant result format is \fBcontainer\fR.
It (quickly) generates grammar descriptions (instead of a full parser)
which match the API expected by ParserTools' grammar interpreter.
The latter is provided by the package \fBpt::peg::interp\fR.
.PP
All the parsers generated by \fBcritcl\fR, \fBsnit\fR, and
\fBoo\fR, and the grammar interpreter share a common API for access
to the actual parsing functionality, making them all
plug-compatible.
It is described in the \fIParser API\fR specification document.
.SH "PEG SPECIFICATION LANGUAGE"
\fBpeg\fR, a language for the specification of parsing expression
grammars is meant to be human readable, and writable as well, yet
strict enough to allow its processing by machine. Like any computer
language. It was defined to make writing the specification of a
grammar easy, something the other formats found in the Parser Tools do
not lend themselves too.
.PP
For either an introduction to or the formal specification of the
language, please go and read the \fIPEG Language Tutorial\fR.
.PP
When used as a result-format this format supports the following
options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-template\fR string
The value of this option is a string into which to put the generated
text and the values of the other options. The various locations for
user-data are expected to be specified with the placeholders listed
below. The default value is "\fB@code@\fR".
.RS
.TP
\fB@user@\fR
To be replaced with the value of the option \fB-user\fR.
.TP
\fB@format@\fR
To be replaced with the the constant \fBPEG\fR.
.TP
\fB@file@\fR
To be replaced with the value of the option \fB-file\fR.
.TP
\fB@name@\fR
To be replaced with the value of the option \fB-name\fR.
.TP
\fB@code@\fR
To be replaced with the generated text.
.RE
.PP
.SH "JSON GRAMMAR EXCHANGE"
The \fBjson\fR format for parsing expression grammars was written as
a data exchange format not bound to Tcl. It was defined to allow the
exchange of grammars with PackRat/PEG based parser generators for
other languages.
.PP
For the formal specification of the JSON grammar exchange format,
please go and read \fIThe JSON Grammar Exchange Format\fR.
.PP
When used as a result-format this format supports the following
options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-indented\fR boolean
If this option is set the system will break the generated JSON across
lines and indent it according to its inner structure, with each key of
a dictionary on a separate line.
.sp
If the option is not set (the default), the whole JSON object will be
written on a single line, with minimum spacing between all elements.
.TP
\fB-aligned\fR boolean
If this option is set the system will ensure that the values for the
keys in a dictionary are vertically aligned with each other, for a
nice table effect.
To make this work this also implies that \fB-indented\fR is set.
.sp
If the option is not set (the default), the output is formatted as per
the value of \fBindented\fR, without trying to align the values for
dictionary keys.
.PP
.SH "C PARSER EMBEDDED IN TCL"
The \fBcritcl\fR format is executable code, a parser for the
grammar. It is a Tcl package with the actual parser implementation
written in C and embedded in Tcl via the \fBcritcl\fR package.
.PP
This result-format supports the following options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-class\fR string
The value of this option is the name of the class to generate, without
leading colons.
The default value is \fBCLASS\fR.
.sp
For a simple value \fBX\fR without colons, like CLASS, the parser
command will be \fBX\fR::\fBX\fR. Whereas for a namespaced value
\fBX::Y\fR the parser command will be \fBX::Y\fR.
.TP
\fB-package\fR string
The value of this option is the name of the package to generate.
The default value is \fBPACKAGE\fR.
.PP
.SH "C PARSER"
The \fBc\fR format is executable code, a parser for the grammar. The
parser implementation is written in C and can be tweaked to the users'
needs through a multitude of options.
.PP
The \fBcritcl\fR format, for example, is implemented as a canned
configuration of these options on top of the generator for \fBc\fR.
.PP
This result-format supports the following options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-template\fR string
The value of this option is a string into which to put
the generated text and the other configuration settings. The various
locations for user-data are expected to be specified with the
placeholders listed below. The default value is "\fB@code@\fR".
.RS
.TP
\fB@user@\fR
To be replaced with the value of the option \fB-user\fR.
.TP
\fB@format@\fR
To be replaced with the the constant \fBC/PARAM\fR.
.TP
\fB@file@\fR
To be replaced with the value of the option \fB-file\fR.
.TP
\fB@name@\fR
To be replaced with the value of the option \fB-name\fR.
.TP
\fB@code@\fR
To be replaced with the generated Tcl code.
.RE
The following options are special, in that they will
occur within the generated code, and are replaced there as well.
.RS
.TP
\fB@statedecl@\fR
To be replaced with the value of the option \fBstate-decl\fR.
.TP
\fB@stateref@\fR
To be replaced with the value of the option \fBstate-ref\fR.
.TP
\fB@strings@\fR
To be replaced with the value of the option \fBstring-varname\fR.
.TP
\fB@self@\fR
To be replaced with the value of the option \fBself-command\fR.
.TP
\fB@def@\fR
To be replaced with the value of the option \fBfun-qualifier\fR.
.TP
\fB@ns@\fR
To be replaced with the value of the option \fBnamespace\fR.
.TP
\fB@main@\fR
To be replaced with the value of the option \fBmain\fR.
.TP
\fB@prelude@\fR
To be replaced with the value of the option \fBprelude\fR.
.RE
.TP
\fB-state-decl\fR string
A C string representing the argument declaration to use in the
generated parsing functions to refer to the parsing state. In essence
type and argument name.
The default value is the string \fBRDE_PARAM p\fR.
.TP
\fB-state-ref\fR string
A C string representing the argument named used in the generated
parsing functions to refer to the parsing state.
The default value is the string \fBp\fR.
.TP
\fB-self-command\fR string
A C string representing the reference needed to call the generated
parser function (methods ...) from another parser fonction, per the
chosen framework (template).
The default value is the empty string.
.TP
\fB-fun-qualifier\fR string
A C string containing the attributes to give to the generated
functions (methods ...), per the chosen framework (template).
The default value is \fBstatic\fR.
.TP
\fB-namespace\fR string
The name of the C namespace the parser functions (methods, ...) shall
reside in, or a general prefix to add to the function names.
The default value is the empty string.
.TP
\fB-main\fR string
The name of the main function (method, ...) to be called by the chosen
framework (template) to start parsing input.
The default value is \fB__main\fR.
.TP
\fB-string-varname\fR string
The name of the variable used for the table of strings used by the
generated parser, i.e. error messages, symbol names, etc.
The default value is \fBp_string\fR.
.TP
\fB-prelude\fR string
A snippet of code to be inserted at the head of each generated parsing
function.
The default value is the empty string.
.TP
\fB-indent\fR integer
The number of characters to indent each line of the generated code by.
The default value is \fB0\fR.
.PP
.SH "SNIT PARSER"
The \fBsnit\fR format is executable code, a parser for the
grammar. It is a Tcl package holding a \fBsnit::type\fR, i.e. a class,
whose instances are parsers for the input grammar.
.PP
This result-format supports the following options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-class\fR string
The value of this option is the name of the class to generate, without
leading colons. Note, it serves double-duty as the name of the package
to generate too.
The default value is \fBCLASS\fR.
.PP
.SH "TCLOO PARSER"
The \fBoo\fR format is executable code, a parser for the grammar. It
is a Tcl package holding a \fBTclOO\fR class, whose instances are
parsers for the input grammar.
.PP
This result-format supports the following options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-class\fR string
The value of this option is the name of the class to generate, without
leading colons. Note, it serves double-duty as the name of the package
to generate too.
The default value is \fBCLASS\fR.
.PP
.SH "GRAMMAR CONTAINER"
The \fBcontainer\fR format is another form of describing parsing
expression grammars. While data in this format is executable it does
not constitute a parser for the grammar. It always has to be used in
conjunction with the package \fBpt::peg::interp\fR, a grammar
interpreter.
.PP
The format represents grammars by a \fBsnit::type\fR, i.e. class,
whose instances are API-compatible to the instances of the
\fBpt::peg::container\fR package, and which are preloaded with the
grammar in question.
.PP
This result-format supports the following options:
.TP
\fB-file\fR string
The value of this option is the name of the file or other entity from
which the grammar came, for which the command is run. The default
value is \fBunknown\fR.
.TP
\fB-name\fR string
The value of this option is the name of the grammar we are processing.
The default value is \fBa_pe_grammar\fR.
.TP
\fB-user\fR string
The value of this option is the name of the user for which the command
is run. The default value is \fBunknown\fR.
.TP
\fB-mode\fR \fBbulk\fR|\fBincremental\fR
The value of this option controls which methods of
\fBpt::peg::container\fR instances are used to specify the
grammar, i.e. preload it into the container. There are two legal
values, as listed below. The default is \fBbulk\fR.
.RS
.TP
\fBbulk\fR
In this mode the methods \fBstart\fR, \fBadd\fR, \fBmodes\fR,
and \fBrules\fR are used to specify the grammar in a bulk manner,
i.e. as a set of nonterminal symbols, and two dictionaries mapping
from the symbols to their semantic modes and parsing expressions.
.sp
This mode is the default.
.TP
\fBincremental\fR
In this mode the methods \fBstart\fR, \fBadd\fR, \fBmode\fR,
and \fBrule\fR are used to specify the grammar piecemal, with each
nonterminal having its own block of defining commands.
.RE
.TP
\fB-template\fR string
The value of this option is a string into which to put the generated
code and the other configuration settings. The various locations for
user-data are expected to be specified with the placeholders listed
below. The default value is "\fB@code@\fR".
.RS
.TP
\fB@user@\fR
To be replaced with the value of the option \fB-user\fR.
.TP
\fB@format@\fR
To be replaced with the the constant \fBCONTAINER\fR.
.TP
\fB@file@\fR
To be replaced with the value of the option \fB-file\fR.
.TP
\fB@name@\fR
To be replaced with the value of the option \fB-name\fR.
.TP
\fB@mode@\fR
To be replaced with the value of the option \fB-mode\fR.
.TP
\fB@code@\fR
To be replaced with the generated code.
.RE
.PP
.SH EXAMPLE
In this section we are working a complete example, starting with a PEG
grammar and ending with running the parser generated from it over some
input, following the outline shown in the figure below:
.PP
IMAGE: flow
.PP
Our grammar, assumed to the stored in the file "\fIcalculator.peg\fR"
is
.nf

PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'	;
    Sign       <- '-' / '+'					;
    Number     <- Sign? Digit+					;
    Expression <- '(' Expression ')' / (Factor (MulOp Factor)*)	;
    MulOp      <- '*' / '/'					;
    Factor     <- Term (AddOp Term)*				;
    AddOp      <- '+'/'-'					;
    Term       <- Number					;
END;

.fi
From this we create a snit-based parser
via
.nf

pt generate  snit calculator.tcl  -class calculator  -name  calculator  peg calculator.peg

.fi
which leaves us with the parser package and class written to the file
"\fIcalculator.tcl\fR".
Assuming that this package is then properly installed in a place where
Tcl can find it we can now use this class via a script like
.nf

    package require calculator

    lassign $argv input
    set channel [open $input r]

    set parser [calculator]
    set ast [$parser parse $channel]
    $parser destroy
    close $channel

    ... now process the returned abstract syntax tree ...

.fi
where the abstract syntax tree stored in the variable will look like
.PP
.nf

set ast {Expression 0 4
    {Factor 0 4
        {Term 0 2
            {Number 0 2
                {Digit 0 0}
                {Digit 1 1}
                {Digit 2 2}
            }
        }
        {AddOp 3 3}
        {Term 4 4
            {Number 4 4
                {Digit 4 4}
            }
        }
    }
}

.fi
.PP
assuming that the input file and channel contained the text
.nf
 120+5
.fi
A more graphical representation of the tree would be
.PP
IMAGE: expr_ast
.PP
Regardless, at this point it is the user's responsibility to work with
the tree to reach whatever goal she desires. I.e. analyze it,
transform it, etc. The package \fBpt::ast\fR should be of help
here, providing commands to walk such ASTs structures in various ways.
.PP
One important thing to note is that the parsers used here return a
data structure representing the structure of the input per the grammar
underlying the parser. There are \fIno\fR callbacks during the
parsing process, i.e. no \fIparsing actions\fR, as most other
parsers will have.
.PP
Going back to the last snippet of code, the execution of the parser
for some input, note how the parser instance follows the specified
\fIParser API\fR.
.SH INTERNALS
This section is intended for users of the application which wish to
modify or extend it. Users only interested in the generation of
parsers can ignore it.
.PP
The main functionality of the application is encapsulated in the
package \fBpt::pgen\fR. Please read it for more information.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpt\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi