'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/pt/pt_peg_container.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pt::peg::container" n 1 pt "Parser Tools"
.BS
.SH NAME
pt::peg::container \- PEG Storage
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBsnit \fR
.sp
package require \fBpt::peg::container  ?1?\fR
.sp
\fB::pt::peg\fR \fIobjectName\fR ?\fB=\fR|\fB:=\fR|\fB<--\fR|\fBas\fR|\fBdeserialize\fR \fIsrc\fR?
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBclear\fR
.sp
\fIobjectName\fR \fBimporter\fR
.sp
\fIobjectName\fR \fBimporter\fR \fIobject\fR
.sp
\fIobjectName\fR \fBexporter\fR
.sp
\fIobjectName\fR \fBexporter\fR \fIobject\fR
.sp
\fIobjectName\fR \fB=\fR \fIsource\fR
.sp
\fIobjectName\fR \fB-->\fR \fIdestination\fR
.sp
\fIobjectName\fR \fBserialize\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBdeserialize =\fR \fIdata\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBdeserialize +=\fR \fIdata\fR ?\fIformat\fR?
.sp
\fIobjectName\fR \fBstart\fR
.sp
\fIobjectName\fR \fBstart\fR \fIpe\fR
.sp
\fIobjectName\fR \fBnonterminals\fR
.sp
\fIobjectName\fR \fBmodes\fR
.sp
\fIobjectName\fR \fBmodes\fR \fIdict\fR
.sp
\fIobjectName\fR \fBrules\fR
.sp
\fIobjectName\fR \fBrules\fR \fIdict\fR
.sp
\fIobjectName\fR \fBadd\fR ?\fInt\fR...?
.sp
\fIobjectName\fR \fBremove\fR ?\fInt\fR...?
.sp
\fIobjectName\fR \fBexists\fR \fInt\fR
.sp
\fIobjectName\fR \fBrename\fR \fIntold\fR \fIntnew\fR
.sp
\fIobjectName\fR \fBmode\fR \fInt\fR
.sp
\fIobjectName\fR \fBmode\fR \fInt\fR \fImode\fR
.sp
\fIobjectName\fR \fBrule\fR \fInt\fR
.sp
\fIobjectName\fR \fBrule\fR \fInt\fR \fIpe\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR. This document is the
entrypoint to the whole system the current package is a part of.
.PP
This package provides a container class for parsing expression
grammars, with each instance storing a single grammar and allowing the
user to manipulate and query its definition.
.PP
It resides in the Storage section of the Core Layer of Parser Tools,
and is one of the three pillars the management of parsing expression
grammars resides on.
.PP
IMAGE: arch_core_container
.PP
The other two pillars are, as shown above
.IP [1]
\fIPEG Import\fR, and
.IP [2]
\fIPEG Export\fR
.PP
.PP
Packages related to this are:
.TP
\fBpt::rde\fR
This package provides an implementation of PARAM, a virtual machine
for the parsing of a channel, geared towards the needs of handling
PEGs.
.TP
\fBpt::peg::interp\fR
This package implements an interpreter for PEGs on top of the virtual
machine provided by \fBpt::peg::rde\fR
.PP
.SS "CLASS API"
The package exports the API described here.
.TP
\fB::pt::peg\fR \fIobjectName\fR ?\fB=\fR|\fB:=\fR|\fB<--\fR|\fBas\fR|\fBdeserialize\fR \fIsrc\fR?
The command creates a new container object for a parsing expression
grammar and returns the fully qualified name of the object command as
its result. The API of this object command is described in the section
\fBObject API\fR. It may be used to invoke various operations on
the object.
.sp
The new container will be empty if no \fIsrc\fR is specified. Otherwise
it will contain a copy of the grammar contained in the \fIsrc\fR.
All operators except \fBdeserialize\fR interpret \fIsrc\fR as a
container object command. The \fBdeserialize\fR operator interprets
\fIsrc\fR as the serialization of a parsing expression grammar
instead, as specified in section \fBPEG serialization format\fR.
.sp
An empty grammar has no nonterminal symbols, and the start expression
is the empty expression, i.e. epsilon. It is \fIvalid\fR, but not
\fIuseful\fR.
.PP
.SS "OBJECT API"
.PP
All objects created by this package provide the following methods for
the manipulation and querying of their contents:
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object, releasing all claimed memory, and
deleting the associated object command.
.TP
\fIobjectName\fR \fBclear\fR
This method resets the object to contain the empty grammar. It does
\fInot\fR destroy the object itself.
.TP
\fIobjectName\fR \fBimporter\fR
This method returns the import manager object currently attached to
the container, if any.
.TP
\fIobjectName\fR \fBimporter\fR \fIobject\fR
This method attaches the \fIobject\fR as import manager to the
container, and returns it as the result of the command.
Note that the \fIobject\fR is \fInot\fR put into ownership of the
container. I.e., destruction of the container will \fInot\fR destroy
the \fIobject\fR.
.sp
It is expected that \fIobject\fR provides a method named
\fBimport text\fR which takes a text and a format name, and
returns the canonical serialization of the table of contents contained in
the text, assuming the given format.
.TP
\fIobjectName\fR \fBexporter\fR
This method returns the export manager object currently attached to
the container, if any.
.TP
\fIobjectName\fR \fBexporter\fR \fIobject\fR
This method attaches the \fIobject\fR as export manager to the
container, and returns it as the result of the command.
Note that the \fIobject\fR is \fInot\fR put into ownership of the
container. I.e., destruction of the container will \fInot\fR destroy
the \fIobject\fR.
.sp
It is expected that \fIobject\fR provides a method named
\fBexport object\fR which takes the container and a format name,
and returns a text encoding table of contents stored in the container, in
the given format. It is further expected that the \fIobject\fR will
use the container's method \fBserialize\fR to obtain the
serialization of the table of contents from which to generate the text.
.TP
\fIobjectName\fR \fB=\fR \fIsource\fR
This method assigns the contents of the PEG object \fIsource\fR to
ourselves, overwriting the existing definition. This is the assignment
operator for grammars.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fIobjectName\fR \fBdeserialize =\fR [\fIsource\fR \fBserialize\fR]

.fi
.TP
\fIobjectName\fR \fB-->\fR \fIdestination\fR
This method assigns our contents to the PEG object \fIdestination\fR,
overwriting the existing definition. This is the reverse assignment
operator for grammars.
.sp
This operation is in effect equivalent to
.sp
.nf

    \fIdestination\fR \fBdeserialize =\fR [\fIobjectName\fR \fBserialize\fR]

.fi
.TP
\fIobjectName\fR \fBserialize\fR ?\fIformat\fR?
This method returns our grammar in some textual form usable for
transfer, persistent storage, etc. If no \fIformat\fR is not specified
the returned result is the canonical serialization of the grammar, as
specified in the section \fBPEG serialization format\fR.
.sp
Otherwise the object will use the attached export manager to convert
the data to the specified format. In that case the method will fail
with an error if the container has no export manager attached to it.
.TP
\fIobjectName\fR \fBdeserialize =\fR \fIdata\fR ?\fIformat\fR?
This is the complementary method to \fBserialize\fR.
It replaces the current definition with the grammar contained in the
\fIdata\fR. If no \fIformat\fR was specified it is assumed to be the
regular serialization of a grammar, as specified in the section
\fBPEG serialization format\fR
.sp
Otherwise the object will use the attached import manager to convert
the data from the specified format to a serialization it can handle.
In that case the method will fail with an error if the container has
no import manager attached to it.
.sp
The result of the method is the empty string.
.TP
\fIobjectName\fR \fBdeserialize +=\fR \fIdata\fR ?\fIformat\fR?
This method behaves like \fBdeserialize =\fR in its essentials,
except that it merges the grammar in the \fIdata\fR to its
contents instead of replacing it.
The method will fail with an error and leave the grammar unchanged if
merging is not possible, i.e. would produce an invalid grammar.
.sp
The result of the method is the empty string.
.TP
\fIobjectName\fR \fBstart\fR
This method returns the current start expression of the grammar.
.TP
\fIobjectName\fR \fBstart\fR \fIpe\fR
This method defines the \fIstart expression\fR of the grammar. It
replaces the current start expression with the parsing expression
\fIpe\fR, and returns the new start expression.
.sp
The method will fail with an error and leave the grammar unchanged if
\fIpe\fR does not contain a valid parsing expression as specified in
the section \fBPE serialization format\fR.
.TP
\fIobjectName\fR \fBnonterminals\fR
This method returns the set of all nonterminal symbols known to the
grammar.
.TP
\fIobjectName\fR \fBmodes\fR
This method returns a dictionary mapping the set of all nonterminal
symbols known to the grammar to their semantic modes.
.TP
\fIobjectName\fR \fBmodes\fR \fIdict\fR
This method takes a dictionary mapping a set of nonterminal symbols
known to the grammar to their semantic modes, and returns the new full
mapping of nonterminal symbols to semantic modes.
.sp
The method will fail with an error if any of the nonterminal symbols
in the dictionary is not known to the grammar, or the empty string,
i.e. an invalid nonterminal symbol, or if any the chosen \fImode\fRs
is not one of the legal values.
.TP
\fIobjectName\fR \fBrules\fR
This method returns a dictionary mapping the set of all nonterminal
symbols known to the grammar to their parsing expressions (right-hand
sides).
.TP
\fIobjectName\fR \fBrules\fR \fIdict\fR
This method takes a dictionary mapping a set of nonterminal symbols
known to the grammar to their parsing expressions (right-hand sides),
and returns the new full mapping of nonterminal symbols to parsing
expressions.
.sp
The method will fail with an error any of the nonterminal symbols in
the dictionary is not known to the grammar, or the empty string,
i.e. an invalid nonterminal symbol, or any of the chosen parsing
expressions is not a valid parsing expression as specified in the
section \fBPE serialization format\fR.
.TP
\fIobjectName\fR \fBadd\fR ?\fInt\fR...?
This method adds the nonterminal symbols \fInt\fR, etc. to the
grammar, and defines default semantic mode and expression for it
(\fBvalue\fR and \fBepsilon\fR respectively).
The method returns the empty string as its result.
.sp
The method will fail with an error and leaves the grammar unchanged if
any of the nonterminal symbols are either already defined in our
grammar, or are the empty string (an invalid nonterminal symbol).
.sp
The method does nothing if no symbol was specified as argument.
.TP
\fIobjectName\fR \fBremove\fR ?\fInt\fR...?
This method removes the named nonterminal symbols \fInt\fR, etc. from
the set of nonterminal symbols known to our grammar.
The method returns the empty string as its result.
.sp
The method will fail with an error and leave the grammar unchanged if
any of the nonterminal symbols is not known to the grammar, or is the
empty string, i.e. an invalid nonterminal symbol.
.TP
\fIobjectName\fR \fBexists\fR \fInt\fR
This method tests whether the nonterminal symbol \fInt\fR is known
to our grammar or not.
The result is a boolean value. It will be set to \fBtrue\fR if
\fInt\fR is known, and \fBfalse\fR otherwise.
.sp
The method will fail with an error if \fInt\fR is the empty string,
i.e. an invalid nonterminal symbol.
.TP
\fIobjectName\fR \fBrename\fR \fIntold\fR \fIntnew\fR
This method renames the nonterminal symbol \fIntold\fR to \fIntnew\fR.
The method returns the empty string as its result.
.sp
The method will fail with an error and leave the grammar unchanged if
either \fIntold\fR is not known to the grammar, or \fIntnew\fR is
already known, or any of them is the empty string, i.e. an invalid
nonterminal symbol.
.TP
\fIobjectName\fR \fBmode\fR \fInt\fR
This method returns the current semantic mode for the nonterminal
symbol \fInt\fR.
.sp
The method will fail with an error if \fInt\fR is not known to the
grammar, or the empty string, i.e. an invalid nonterminal symbol.
.TP
\fIobjectName\fR \fBmode\fR \fInt\fR \fImode\fR
This mode sets the semantic mode for the nonterminal symbol \fInt\fR,
and returns the new mode.
The method will fail with an error if \fInt\fR is not known to the
grammar, or the empty string, i.e. an invalid nonterminal symbol, or
the chosen \fImode\fR is not one of the legal values.
.sp
The following modes are legal:
.RS
.TP
\fBvalue\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal itself,
which has the ASTs of the symbol's right hand side as its children.
.TP
\fBleaf\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal, without any
children. Any ASTs generated by the symbol's right hand side are
discarded.
.TP
\fBvoid\fR
The nonterminal has no semantic value. Any ASTs generated by the
symbol's right hand side are discarded (as well).
.RE
.TP
\fIobjectName\fR \fBrule\fR \fInt\fR
This method returns the current parsing expression (right-hand side)
for the nonterminal symbol \fInt\fR.
.sp
The method will fail with an error if \fInt\fR is not known to the
grammar, or the empty string, i.e. an invalid nonterminal symbol.
.TP
\fIobjectName\fR \fBrule\fR \fInt\fR \fIpe\fR
This method set the parsing expression (right-hand side) of the
nonterminal \fInt\fR to \fIpe\fR, and returns the new parsing
expression.
.sp
The method will fail with an error if \fInt\fR is not known to the
grammar, or the empty string, i.e. an invalid nonterminal symbol, or
\fIpe\fR does not contain a valid parsing expression as specified in
the section \fBPE serialization format\fR.
.PP
.PP
.SH "PEG SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expression Grammars as immutable values for transport,
comparison, etc.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a PEG may have more than one regular serialization only exactly
one of them will be \fIcanonical\fR.
.TP
regular serialization
.RS
.IP [1]
The serialization of any PEG is a nested Tcl dictionary.
.IP [2]
This dictionary holds a single key, \fBpt::grammar::peg\fR, and its
value. This value holds the contents of the grammar.
.IP [3]
The contents of the grammar are a Tcl dictionary holding the set of
nonterminal symbols and the starting expression. The relevant keys and
their values are
.RS
.TP
\fBrules\fR
The value is a Tcl dictionary whose keys are the names of the
nonterminal symbols known to the grammar.
.RS
.IP [1]
Each nonterminal symbol may occur only once.
.IP [2]
The empty string is not a legal nonterminal symbol.
.IP [3]
The value for each symbol is a Tcl dictionary itself. The relevant
keys and their values in this dictionary are
.RS
.TP
\fBis\fR
The value is the serialization of the parsing expression describing
the symbols sentennial structure, as specified in the section
\fBPE serialization format\fR.
.TP
\fBmode\fR
The value can be one of three values specifying how a parser should
handle the semantic value produced by the symbol.
.RS
.TP
\fBvalue\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal itself,
which has the ASTs of the symbol's right hand side as its children.
.TP
\fBleaf\fR
The semantic value of the nonterminal symbol is an abstract syntax
tree consisting of a single node node for the nonterminal, without any
children. Any ASTs generated by the symbol's right hand side are
discarded.
.TP
\fBvoid\fR
The nonterminal has no semantic value. Any ASTs generated by the
symbol's right hand side are discarded (as well).
.RE
.RE
.RE
.TP
\fBstart\fR
The value is the serialization of the start parsing expression of the
grammar, as specified in the section \fBPE serialization format\fR.
.RE
.IP [4]
The terminal symbols of the grammar are specified implicitly as the
set of all terminal symbols used in the start expression and on the
RHS of the grammar rules.
.RE
.TP
canonical serialization
The canonical serialization of a grammar has the format as specified
in the previous item, and then additionally satisfies the constraints
below, which make it unique among all the possible serializations of
this grammar.
.RS
.IP [1]
The keys found in all the nested Tcl dictionaries are sorted in
ascending dictionary order, as generated by Tcl's builtin command
\fBlsort -increasing -dict\fR.
.IP [2]
The string representation of the value is the canonical representation
of a Tcl dictionary. I.e. it does not contain superfluous whitespace.
.RE
.PP
.SS EXAMPLE
Assuming the following PEG for simple mathematical expressions
.PP
.nf

PEG calculator (Expression)
    Digit      <- '0'/'1'/'2'/'3'/'4'/'5'/'6'/'7'/'8'/'9'	;
    Sign       <- '-' / '+'					;
    Number     <- Sign? Digit+					;
    Expression <- '(' Expression ')' / (Factor (MulOp Factor)*)	;
    MulOp      <- '*' / '/'					;
    Factor     <- Term (AddOp Term)*				;
    AddOp      <- '+'/'-'					;
    Term       <- Number					;
END;

.fi
.PP
then its canonical serialization (except for whitespace) is
.PP
.nf

pt::grammar::peg {
    rules {
	AddOp      {is {/ {t -} {t +}}                                                                mode value}
	Digit      {is {/ {t 0} {t 1} {t 2} {t 3} {t 4} {t 5} {t 6} {t 7} {t 8} {t 9}}                mode value}
	Expression {is {/ {x {t (} {n Expression} {t )}} {x {n Factor} {* {x {n MulOp} {n Factor}}}}} mode value}
	Factor     {is {x {n Term} {* {x {n AddOp} {n Term}}}}                                        mode value}
	MulOp      {is {/ {t *} {t /}}                                                                mode value}
	Number     {is {x {? {n Sign}} {+ {n Digit}}}                                                 mode value}
	Sign       {is {/ {t -} {t +}}                                                                mode value}
	Term       {is  {n Number}                                                                    mode value}
    }
    start {n Expression}
}

.fi
.PP
.SH "PE SERIALIZATION FORMAT"
Here we specify the format used by the Parser Tools to serialize
Parsing Expressions as immutable values for transport, comparison,
etc.
.PP
We distinguish between \fIregular\fR and \fIcanonical\fR
serializations.
While a parsing expression may have more than one regular
serialization only exactly one of them will be \fIcanonical\fR.
.TP
Regular serialization
.RS
.TP
\fBAtomic Parsing Expressions\fR
.RS
.IP [1]
The string \fBepsilon\fR is an atomic parsing expression. It matches
the empty string.
.IP [2]
The string \fBdot\fR is an atomic parsing expression. It matches
any character.
.IP [3]
The string \fBalnum\fR is an atomic parsing expression. It matches
any Unicode alphabet or digit character. This is a custom extension of
PEs based on Tcl's builtin command \fBstring is\fR.
.IP [4]
The string \fBalpha\fR is an atomic parsing expression. It matches
any Unicode alphabet character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [5]
The string \fBascii\fR is an atomic parsing expression. It matches
any Unicode character below U0080. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [6]
The string \fBcontrol\fR is an atomic parsing expression. It matches
any Unicode control character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [7]
The string \fBdigit\fR is an atomic parsing expression. It matches
any Unicode digit character. Note that this includes characters
outside of the [0..9] range. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [8]
The string \fBgraph\fR is an atomic parsing expression. It matches
any Unicode printing character, except for space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [9]
The string \fBlower\fR is an atomic parsing expression. It matches
any Unicode lower-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [10]
The string \fBprint\fR is an atomic parsing expression. It matches
any Unicode printing character, including space. This is a custom
extension of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [11]
The string \fBpunct\fR is an atomic parsing expression. It matches
any Unicode punctuation character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [12]
The string \fBspace\fR is an atomic parsing expression. It matches
any Unicode space character. This is a custom extension of PEs based
on Tcl's builtin command \fBstring is\fR.
.IP [13]
The string \fBupper\fR is an atomic parsing expression. It matches
any Unicode upper-case alphabet character. This is a custom extension
of PEs based on Tcl's builtin command \fBstring is\fR.
.IP [14]
The string \fBwordchar\fR is an atomic parsing expression. It
matches any Unicode word character. This is any alphanumeric character
(see alnum), and any connector punctuation characters (e.g.
underscore). This is a custom extension of PEs based on Tcl's builtin
command \fBstring is\fR.
.IP [15]
The string \fBxdigit\fR is an atomic parsing expression. It matches
any hexadecimal digit character. This is a custom extension of PEs
based on Tcl's builtin command \fBstring is\fR.
.IP [16]
The string \fBddigit\fR is an atomic parsing expression. It matches
any decimal digit character. This is a custom extension of PEs based
on Tcl's builtin command \fBregexp\fR.
.IP [17]
The expression
[list t \fBx\fR]
is an atomic parsing expression. It matches the terminal string \fBx\fR.
.IP [18]
The expression
[list n \fBA\fR]
is an atomic parsing expression. It matches the nonterminal \fBA\fR.
.RE
.TP
\fBCombined Parsing Expressions\fR
.RS
.IP [1]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list / \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIordered choice\fR, aka \fIprioritized choice\fR.
.IP [2]
For parsing expressions \fBe1\fR, \fBe2\fR, ... the result of
[list x \fBe1\fR \fBe2\fR ... ]
is a parsing expression as well.
This is the \fIsequence\fR.
.IP [3]
For a parsing expression \fBe\fR the result of
[list * \fBe\fR]
is a parsing expression as well.
This is the \fIkleene closure\fR, describing zero or more
repetitions.
.IP [4]
For a parsing expression \fBe\fR the result of
[list + \fBe\fR]
is a parsing expression as well.
This is the \fIpositive kleene closure\fR, describing one or more
repetitions.
.IP [5]
For a parsing expression \fBe\fR the result of
[list & \fBe\fR]
is a parsing expression as well.
This is the \fIand lookahead predicate\fR.
.IP [6]
For a parsing expression \fBe\fR the result of
[list ! \fBe\fR]
is a parsing expression as well.
This is the \fInot lookahead predicate\fR.
.IP [7]
For a parsing expression \fBe\fR the result of
[list ? \fBe\fR]
is a parsing expression as well.
This is the \fIoptional input\fR.
.RE
.RE
.TP
Canonical serialization
The canonical serialization of a parsing expression has the format as
specified in the previous item, and then additionally satisfies the
constraints below, which make it unique among all the possible
serializations of this parsing expression.
.RS
.IP [1]
The string representation of the value is the canonical representation
of a pure Tcl list. I.e. it does not contain superfluous whitespace.
.IP [2]
Terminals are \fInot\fR encoded as ranges (where start and end of the
range are identical).
.RE
.PP
.PP
.SS EXAMPLE
Assuming the parsing expression shown on the right-hand side of the
rule
.PP
.nf

    Expression <- '(' Expression ')'
                / Factor (MulOp Factor)*

.fi
.PP
then its canonical serialization (except for whitespace) is
.PP
.nf

    {/ {x {t (} {n Expression} {t )}} {x {n Factor} {* {x {n MulOp} {n Factor}}}}}

.fi
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpt\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi