'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/sha1/sha256.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008, Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "sha256" n 1.0.3 sha1 "SHA-x Message-Digest Algorithm"
.BS
.SH NAME
sha256 \- SHA256 Message-Digest Algorithm
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBsha256  ?1.0.3?\fR
.sp
\fB::sha2::sha256\fR ?\fI-hex|-bin\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
.sp
\fB::sha2::sha224\fR ?\fI-hex|-bin\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
.sp
\fB::sha2::hmac\fR \fIkey\fR \fIstring\fR
.sp
\fB::sha2::hmac\fR ?\fI-hex|-bin\fR? \fI-key key\fR [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
.sp
\fB::sha2::SHA256Init\fR
.sp
\fB::sha2::SHA224Init\fR
.sp
\fB::sha2::SHA256Update\fR \fItoken\fR \fIdata\fR
.sp
\fB::sha2::SHA256Final\fR \fItoken\fR
.sp
\fB::sha2::SHA224Final\fR \fItoken\fR
.sp
\fB::sha2::HMACInit\fR \fIkey\fR
.sp
\fB::sha2::HMACUpdate\fR \fItoken\fR \fIdata\fR
.sp
\fB::sha2::HMACFinal\fR \fItoken\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides an implementation in Tcl of the SHA256 and
SHA224 message-digest algorithms as specified by FIPS PUB 180-1
(1). These algorithms take a message and generates a 256-bit (224-bit)
digest from the input. The SHA2 algorithms are related to the SHA1
algorithm.
.PP
This package also includes support for creating keyed message-digests
using the HMAC algorithm from RFC 2104 (3) with SHA256 as the
message-digest.
.SH COMMANDS
.TP
\fB::sha2::sha256\fR ?\fI-hex|-bin\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
The command takes a message and returns the SHA256 digest of this
message as a hexadecimal string. You may request the result as binary
data by giving \fI-bin\fR.
.sp
The data to be hashed can be specified either as a string argument to
the \fBsha256\fR command, or as a filename or a pre-opened channel. If the
\fI-filename\fR argument is given then the file is opened, the data read
and hashed and the file is closed. If the \fI-channel\fR argument is
given then data is read from the channel until the end of file. The
channel is not closed. \fINOTE\fR use of the channel or filename
options results in the internal use of \fBvwait\fR. To avoid nested
event loops in Tk or tclhttpd applications you should use the
incremental programming API (see below).
.sp
Only one of \fI-file\fR, \fI-channel\fR or \fIstring\fR should be given.
.TP
\fB::sha2::sha224\fR ?\fI-hex|-bin\fR? [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
Like \fB::sha2::sha256\fR, except that the SHA224 digest is returned.
.TP
\fB::sha2::hmac\fR \fIkey\fR \fIstring\fR
.TP
\fB::sha2::hmac\fR ?\fI-hex|-bin\fR? \fI-key key\fR [ \fI-channel channel\fR | \fI-file filename\fR | \fIstring\fR ]
Calculate an Hashed Message Authentication digest (HMAC) using the
SHA256 digest algorithm. HMACs are described in RFC 2104 (3) and
provide an SHA256 digest that includes a key. All options other than
\fI-key\fR are as for the \fB::sha2::sha256\fR command.
.PP
.SH "PROGRAMMING INTERFACE"
For the programmer, the SHA256 hash can be viewed as a bucket into
which one pours data. When you have finished, you extract a value that
is derived from the data that was poured into the bucket. The
programming interface to the SHA256 hash operates on a token
(equivalent to the bucket). You call \fBSHA256Init\fR to obtain a
token and then call \fBSHA256Update\fR as many times as required to
add data to the hash. To release any resources and obtain the hash
value, you then call \fBSHA256Final\fR. An equivalent set of
functions gives you a keyed digest (HMAC).
.PP
If you have \fBcritcl\fR and have built the \fBtcllibc\fR
package then the implementation of the hashing function will be
performed by compiled code. Failing that there is a pure-tcl
equivalent. The programming interface remains the same in all cases.
.TP
\fB::sha2::SHA256Init\fR
.TP
\fB::sha2::SHA224Init\fR
Begins a new SHA256/SHA224 hash. Returns a token ID that must be used
for the remaining functions.
.TP
\fB::sha2::SHA256Update\fR \fItoken\fR \fIdata\fR
Add data to the hash identified by token. Calling
\fISHA256Update $token "abcd"\fR is equivalent to calling
\fISHA256Update $token "ab"\fR followed by
\fISHA256Update $token "cb"\fR. See \fBEXAMPLES\fR.
Note that this command is used for both SHA256 and SHA224. Only the
initialization and finalization commands of both hashes differ.
.TP
\fB::sha2::SHA256Final\fR \fItoken\fR
.TP
\fB::sha2::SHA224Final\fR \fItoken\fR
Returns the hash value and releases any resources held by this
token. Once this command completes the token will be invalid. The
result is a binary string of 32/28 bytes representing the 256/224 bit
SHA256 / SHA224 digest value.
.TP
\fB::sha2::HMACInit\fR \fIkey\fR
This is equivalent to the \fB::sha2::SHA256Init\fR command except
that it requires the key that will be included in the HMAC.
.TP
\fB::sha2::HMACUpdate\fR \fItoken\fR \fIdata\fR
.TP
\fB::sha2::HMACFinal\fR \fItoken\fR
These commands are identical to the SHA256 equivalent commands.
.PP
.SH EXAMPLES
.nf

% sha2::sha256 "Tcl does SHA256"
0b91043ee484abd83c3e4b08d6034d71b937026379f0f59bda6e625e6e214789

.fi
.nf

% sha2::hmac Sekret "Tcl does SHA256"
4f9352c64d655e8a36abe73e6163a9d7a54039877c1c92ec90b07d48d4e854e0

.fi
.nf

% set tok [sha2::SHA256Init]
::sha2::1
% sha2::SHA256Update $tok "Tcl "
% sha2::SHA256Update $tok "does "
% sha2::SHA256Update $tok "SHA256"
% sha2::Hex [sha2::SHA256Final $tok]
0b91043ee484abd83c3e4b08d6034d71b937026379f0f59bda6e625e6e214789

.fi
.SH REFERENCES
.IP [1]
"Secure Hash Standard", National Institute of Standards
and Technology, U.S. Department Of Commerce, April 1995.
(\fIhttp://www.itl.nist.gov/fipspubs/fip180-1.htm\fR)
.IP [2]
Rivest, R., "The MD4 Message Digest Algorithm", RFC 1320, MIT,
April 1992. (\fIhttp://www.rfc-editor.org/rfc/rfc1320.txt\fR)
.IP [3]
Krawczyk, H., Bellare, M. and Canetti, R. "HMAC: Keyed-Hashing for
Message Authentication", RFC 2104, February 1997.
(\fIhttp://www.rfc-editor.org/rfc/rfc2104.txt\fR)
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIsha1\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
md4, md5, ripemd128, ripemd160, sha1
.SH KEYWORDS
FIPS 180-1, hashing, message-digest, rfc 2104, security, sha256
.SH CATEGORY
Hashes, checksums, and encryption
.SH COPYRIGHT
.nf
Copyright (c) 2008, Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi