'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/simulation/simulation_random.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "simulation::random" n 0.1 simulation "Tcl Simulation Tools"
.BS
.SH NAME
simulation::random \- Pseudo-random number generators
.SH SYNOPSIS
package require \fBTcl  ?8.4?\fR
.sp
package require \fBsimulation::random  0.1\fR
.sp
\fB::simulation::random::prng_Bernoulli\fR \fIp\fR
.sp
\fB::simulation::random::prng_Discrete\fR \fIn\fR
.sp
\fB::simulation::random::prng_Poisson\fR \fIlambda\fR
.sp
\fB::simulation::random::prng_Uniform\fR \fImin\fR \fImax\fR
.sp
\fB::simulation::random::prng_Exponential\fR \fImin\fR \fImean\fR
.sp
\fB::simulation::random::prng_Normal\fR \fImean\fR \fIstdev\fR
.sp
\fB::simulation::random::prng_Pareto\fR \fImin\fR \fIsteep\fR
.sp
\fB::simulation::random::prng_Gumbel\fR \fImin\fR \fIf\fR
.sp
\fB::simulation::random::prng_chiSquared\fR \fIdf\fR
.sp
\fB::simulation::random::prng_Disk\fR \fIrad\fR
.sp
\fB::simulation::random::prng_Sphere\fR \fIrad\fR
.sp
\fB::simulation::random::prng_Ball\fR \fIrad\fR
.sp
\fB::simulation::random::prng_Rectangle\fR \fIlength\fR \fIwidth\fR
.sp
\fB::simulation::random::prng_Block\fR \fIlength\fR \fIwidth\fR \fIdepth\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package consists of commands to generate pseudo-random number
generators. These new commands deliver
.IP \(bu
numbers that are distributed normally, uniformly, according to a
Pareto or Gumbel distribution and so on
.IP \(bu
coordinates of points uniformly spread inside a sphere or a rectangle
.PP
For example:
.nf

    set p [::simulation::random::prng_Normal -1.0 10.0]

.fi
produces a new command (whose name is stored in the variable "p") that
generates normally distributed numbers with a mean of -1.0 and a
standard deviation of 10.0.
.SH PROCEDURES
The package defines the following public procedures for \fIdiscrete\fR
distributions:
.TP
\fB::simulation::random::prng_Bernoulli\fR \fIp\fR
Create a command (PRNG) that generates numbers with a Bernoulli
distribution: the value is either 1 or 0, with a chance p to be 1
.RS
.TP
float \fIp\fR
Chance the outcome is 1
.RE
.sp
.TP
\fB::simulation::random::prng_Discrete\fR \fIn\fR
Create a command (PRNG) that generates numbers 0 to n-1 with equal
probability.
.RS
.TP
int \fIn\fR
Number of different values (ranging from 0 to n-1)
.RE
.sp
.TP
\fB::simulation::random::prng_Poisson\fR \fIlambda\fR
Create a command (PRNG) that generates numbers according to the Poisson
distribution.
.RS
.TP
float \fIlambda\fR
Mean number per time interval
.RE
.PP
The package defines the following public procedures for \fIcontinuous\fR distributions:
.TP
\fB::simulation::random::prng_Uniform\fR \fImin\fR \fImax\fR
Create a command (PRNG) that generates uniformly distributed numbers
between "min" and "max".
.RS
.TP
float \fImin\fR
Minimum number that will be generated
.TP
float \fImax\fR
Maximum number that will be generated
.RE
.sp
.TP
\fB::simulation::random::prng_Exponential\fR \fImin\fR \fImean\fR
Create a command (PRNG) that generates exponentially distributed numbers
with a given minimum value and a given mean value.
.RS
.TP
float \fImin\fR
Minimum number that will be generated
.TP
float \fImean\fR
Mean value for the numbers
.RE
.sp
.TP
\fB::simulation::random::prng_Normal\fR \fImean\fR \fIstdev\fR
Create a command (PRNG) that generates normally distributed numbers
with a given mean value and a given standard deviation.
.RS
.TP
float \fImean\fR
Mean value for the numbers
.TP
float \fIstdev\fR
Standard deviation
.RE
.sp
.TP
\fB::simulation::random::prng_Pareto\fR \fImin\fR \fIsteep\fR
Create a command (PRNG) that generates numbers distributed according to
Pareto with a given minimum value and a given distribution steepness.
.RS
.TP
float \fImin\fR
Minimum number that will be generated
.TP
float \fIsteep\fR
Steepness of the distribution
.RE
.sp
.TP
\fB::simulation::random::prng_Gumbel\fR \fImin\fR \fIf\fR
Create a command (PRNG) that generates numbers distributed according to
Gumbel with a given minimum value and a given scale factor. The
probability density function is:
.nf

     P(v) = exp( -exp(f*(v-min)))

.fi
.RS
.TP
float \fImin\fR
Minimum number that will be generated
.TP
float \fIf\fR
Scale factor for the values
.RE
.sp
.TP
\fB::simulation::random::prng_chiSquared\fR \fIdf\fR
Create a command (PRNG) that generates numbers distributed according to
the chi-squared distribution with df degrees of freedom. The mean is 0
and the standard deviation is 1.
.RS
.TP
float \fIdf\fR
Degrees of freedom
.RE
.PP
The package defines the following public procedures for random point sets:
.TP
\fB::simulation::random::prng_Disk\fR \fIrad\fR
Create a command (PRNG) that generates (x,y)-coordinates for points
uniformly spread over a disk of given radius.
.RS
.TP
float \fIrad\fR
Radius of the disk
.RE
.sp
.TP
\fB::simulation::random::prng_Sphere\fR \fIrad\fR
Create a command (PRNG) that generates (x,y,z)-coordinates for points
uniformly spread over the surface of a sphere of given radius.
.RS
.TP
float \fIrad\fR
Radius of the disk
.RE
.sp
.TP
\fB::simulation::random::prng_Ball\fR \fIrad\fR
Create a command (PRNG) that generates (x,y,z)-coordinates for points
uniformly spread within a ball of given radius.
.RS
.TP
float \fIrad\fR
Radius of the ball
.RE
.sp
.TP
\fB::simulation::random::prng_Rectangle\fR \fIlength\fR \fIwidth\fR
Create a command (PRNG) that generates (x,y)-coordinates for points
uniformly spread over a rectangle.
.RS
.TP
float \fIlength\fR
Length of the rectangle (x-direction)
.TP
float \fIwidth\fR
Width of the rectangle (y-direction)
.RE
.sp
.TP
\fB::simulation::random::prng_Block\fR \fIlength\fR \fIwidth\fR \fIdepth\fR
Create a command (PRNG) that generates (x,y)-coordinates for points
uniformly spread over a block
.RS
.TP
float \fIlength\fR
Length of the block (x-direction)
.TP
float \fIwidth\fR
Width of the block (y-direction)
.TP
float \fIdepth\fR
Depth of the block (z-direction)
.RE
.PP
.SH KEYWORDS
math, random numbers, simulation, statistical distribution
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>

.fi