'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/tepam/tepam_argument_dialogbox.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009/2010, Andreas Drollinger
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tepam::argument_dialogbox" n 0.1.0 tepam "Tcls Enhanced Procedure and Argument Manager"
.BS
.SH NAME
tepam::argument_dialogbox \- TEPAM argument_dialogbox, reference manual
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBTk  8.3\fR
.sp
package require \fBtepam  ?0.1?\fR
.sp
\fBtepam::argument_dialogbox\fR \fIitem_name item_attributes ?item_name item_attributes? ?...?\fR
.sp
\fBtepam::argument_dialogbox\fR {\fIitem_name item_attributes ?item_name item_attributes? ?...?\fR}
.sp
.BE
.SH DESCRIPTION
.SH "ARGUMENT DIALOGBOX CALL"
TEPAM's \fBargument_dialogbox\fR is a flexible and easily usable entry form generator. Each entry element of a form is defined via a \fIdata entry item\fR that can be provided to \fBargument_dialogbox\fR in two formats:
.TP
\fBtepam::argument_dialogbox\fR \fIitem_name item_attributes ?item_name item_attributes? ?...?\fR
Using this first format, each \fIdata entry item\fR is defined via a named argument. The item name defines thereby the entry element type that has to be used in the form. The item data, called \fIitem attributes\fR, defines the variable which is attributed to the data entry element as well as eventual formatting and context information.
.sp
The \fBargument_dialogbox\fR returns \fBok\fR if the entered data have been acknowledged (via the \fIOK\fR button) and validated by a data checker. If the entered data have been rejected (via the \fICancel\fR button) the \fBargument_dialogbox\fR returns \fBcancel\fR.
.sp
A small example is the simplest way to illustrate how the \fBargument_dialogbox\fR can be employed:
.nf
set DialogResult [\fBtepam::argument_dialogbox\fR \\
   \fB-title\fR "Itinerary selection" \\
   \fB-file\fR {\fI-label "Itinerary report" -variable report_file\fR} \\
   \fB-frame\fR {\fI-label "Itinerary start"\fR} \\
      \fB-comment\fR {\fI-text "Specify your itinerary start location"\fR} \\
      \fB-entry\fR {\fI-label "City" -variable start_city -type string\fR} \\
      \fB-entry\fR {\fI-label "Street" -variable start_street -type string -optional 1\fR} \\
      \fB-entry\fR {\fI-label "Street number" -variable start_street_nbr -type integer -optional 1\fR} \\
   \fB-frame\fR {\fI-label "Itinerary destination"\fR} \\
      \fB-comment\fR {\fI-text "Specify your itinerary destination"\fR} \\
      \fB-entry\fR {\fI-label "City" -variable dest_city -type string\fR} \\
      \fB-entry\fR {\fI-label "Street" -variable dest_street -type string -optional 1\fR} \\
      \fB-entry\fR {\fI-label "Street number" -variable dest_street_nbr -type integer -optional 1\fR} \\
   \fB-frame\fR {} \\
   \fB-checkbutton\fR {\fI-label "Don't use highways" -variable no_highway\fR}]
.fi
This example opens a dialog box that has the title \fIItinerary selection\fR. A first entry element in this box allows selecting a report file. It follows two frames to define respectively an itinerary start and end location. Each of these locations, that is described with a comment, has three entry elements to specify respectively the city, street and the street number. Bellow the second frame there is a checkbutton that allows specifying if eventual highways should be ignored.
.TP
\fBtepam::argument_dialogbox\fR {\fIitem_name item_attributes ?item_name item_attributes? ?...?\fR}
Sometimes it is simpler to provide all the data entry item definitions in form of a single list to \fBargument_dialogbox\fR, and not as individual arguments. The second format that is supported by \fBargument_dialogbox\fR corresponds exactly to the first one, except that all item definitions are packed into a single list that is provided to \fBargument_dialogbox\fR. The previous example can therefore also be written in the following way:
.nf
set DialogResult [\fBtepam::argument_dialogbox {\fR
   \fB-title\fR "Itinerary selection"
   \fB-file\fR {\fI-label "Itinerary report" -variable report_file\fR}
   ...
   \fB-checkbutton\fR {\fI-label "Don't use highways" -variable no_highway\fR} \fB}\fR]
.fi
.PP
The commands \fBargument_dialogbox\fR as well as \fBprocedure\fR are exported from the namespace \fBtepam\fR. To use these commands without the \fBtepam::\fR namespace prefix, it is sufficient to import them into the main namespace:
.nf
\fBnamespace import tepam::*\fR

set DialogResult [\fBargument_dialogbox\fR \\
   -title "Itinerary selection"
   ...
.fi
The following subsections explain the different items that are accepted by the \fBargument_dialogbox\fR, classified into three groups. The first data entry item definition format will be used in the remaining document, knowing that this format can always be transformed into the second format by putting all arguments into a single list that is then provided to \fBargument_dialogbox\fR.
.SS "CONTEXT DEFINITION ITEMS"
The first item group allows specifying some context aspects of an argument dialog box. These items are taking a simple character string as item data:
.nf
tepam::argument_dialogbox \\
   \fB-<argument_name>\fR \fIstring\fR \\
   ...
.fi
The following items are classified into this group:
.TP
-title \fIstring\fR
The dialog box window's title which is by default \fIDialog\fR can be changed with the \fI-title\fR item:
.nf
tepam::argument_dialogbox \\
   \fB-title\fR "System configuration" \\
   ...
.fi
.TP
-window \fIstring\fR
The argument dialog box uses by default \fI.dialog\fR as dialog top level window. This path can be changed with the \fI-window\fR item:
.nf
tepam::argument_dialogbox \\
   \fB-window\fR .dialog \\
   ...
.fi
.TP
-parent \fIstring\fR
By defining a parent window, the argument dialog box will be displayed beside this one. Without explicit parent window definition, the top-level window will be considered as parent window.
.nf
tepam::argument_dialogbox \\
   \fB-parent\fR .my_appl \\
   ...
.fi
.TP
-context \fIstring\fR
The dialog box's state, e.g. the entered data as well as the window size and position, is saved and restored the next time the argument dialog box is called if a context is defined. The assignment of a context allows saving the dialog box' state in its context to distinguish between different usages of the argument dialog box.
.nf
tepam::argument_dialogbox \\
   \fB-context\fR destination_definitions \\
   ...
.fi
.PP
.SS "FORMATTING ITEMS"
Especially for big, complex forms it becomes important that the different data entry widgets are graphically well organized and commented to provide an immediate and clear overview to the user. A couple of items allow structuring and commenting the dialog boxes.
.PP
The items of this classification group require as item data an attribute definition list. The attribute definition list contains itself attribute name and data pairs:
.nf
tepam::argument_dialogbox \\
   ...
   \fB-<argument_name>\fR { \fI
      ?-<attribute_name> <attribute_data>?
      ?-<attribute_name> <attribute_data>?
      ?...?\fR
   }
   ...
.fi
The following items are classified into this group:
.TP
-frame \fIlist\fR
The \fI-frame\fR item allows packing all following entry widgets into a labeled frame, until a next frame item is defined or until the last entry widgets. It recognizes the following attributes inside the item data list:
.RS
.TP
-label \fIstring\fR
An optional frame label can be specified with the \fI-label\fR statement.
.RE
Example:
.nf
tepam::argument_dialogbox \\
   ...
   \fB-frame\fR {\fI-label "Destination address"\fR}
   ...
.fi
To close an open frame without opening a new one, an empty list has to be provided to the -frame statement.
.nf
tepam::argument_dialogbox \\
   ...
   \fB-frame\fR {}
   ...
.fi
.TP
-sep [const {{}}]
Entry widgets can be separated with the \fI-sep\fR statement which doesn't require additional definitions. The related definition list has to exist, but its content is ignored.
.nf
tepam::argument_dialogbox \\
   ...
   \fB-sep\fR {}
   ...
.fi
.TP
-comment \fIstring\fR
Comments and descriptions can be added with the \fI-text\fR attribute of the \fI-comment\fR item. Please note that each entry widget itself can also contain a \fI-text\fR attribute for comments and descriptions. But the \fI-comment\fR item allows for example adding a description between two frames.
.nf
tepam::argument_dialogbox \\
   ...
   \fB-comment\fR {\fI-text "Specify bellow the destination address"\fR}
   ...
.fi
.PP
.SS "DATA ENTRY WIDGET ITEMS"
Data entry widgets are created with the widget items. These items require as the formatting items an attribute definition list as item data:
.nf
tepam::argument_dialogbox \\
   ...
   \fB-<argument_name>\fR { \fI
      ?-<attribute_name> <attribute_data>?
      ?-<attribute_name> <attribute_data>?
      ?...?\fR
   }
   ...
.fi
The attribute list can contain various attributes to describe and comment an entry widget and to constrain its entered data. All entry widgets are accepting a common set of attributes that are described in the section \fBEntry Widget Item Attributes\fR.
.PP
TEPAM defines a rich set of entry widgets. If necessary, this set can be extended with additional application specific entry widgets (see \fBAPPLICATION SPECIFIC ENTRY WIDGETS\fR):
.TP
-entry \fIlist\fR
The \fI-entry\fR item generates the simplest but most universal data entry widget. It allows entering any kind of data.
.nf
tepam::argument_dialogbox \\
   \fB-entry\fR {-label Name -variable Entry}
.fi
.TP
-checkbox \fIlist\fR
A group of check boxes is created with the \fI-checkbox\fR item. The number of check boxes and their option values are specified with a list assigned to the \fI-choices\fR attribute or via a variable declared with the \fI-choicevariable\fR attribute:
.nf
tepam::argument_dialogbox \\
   \fB-checkbox\fR {-label "Font sytle" -variable FontStyle \\
               -choices {bold italic underline} -default italic}
.fi
If the check boxes' texts should differ from the option values, they can be defined with the \fI-choicelabels\fR attribute:
.nf
tepam::argument_dialogbox \\
   \fB-checkbox\fR {-label "Font sytle" -variable FontStyle \\
              -choices {bold italic underline} \\
              -choicelabels {Bold Italic Underline} \\
              -default italic}
.fi
In contrast to a radio box group, a check box group allows selecting simultaneously several choice options. The selection is stored for this reason inside the defined variable in form of a list, even if only one choice option has been selected.
.TP
-radiobox \fIlist\fR
A group of radio boxes is created with the \fI-radiobox\fR item. The number of radio boxes and their option values are specified with a list assigned to the \fI-choices\fR attribute or via a variable declared with the \fI-choicevariable\fR attribute.
.sp
In contrast to a check box group, a radio box group allows selecting simultaneously only one choice option. The selected option value is stored directly, and not in form of a list, inside the defined variable.
.nf
tepam::argument_dialogbox \\
   \fB-radiobox\fR {-label "Text adjustment" -variable Adjustment \\
              -choices {left center right} -default left}
.fi
If the radio boxes' texts should differ from the option values, they can be defined with the \fI-choicelabels\fR attribute:
.nf
tepam::argument_dialogbox \\
   \fB-radiobox\fR {-label "Text adjustment" -variable Adjustment \\
              -choices {left center right} \\
              -choicelabels {Left Center Right} -default left}
.fi
.TP
-checkbutton \fIlist\fR
The \fI-checkbutton\fR entry widget allows activating or deactivating a single choice option. The result written into the variable will either be \fB0\fR when the check button was not activated or \fB1\fR if it was activated. An eventually provided default value has also to be either \fB0\fR or \fB1\fR.
.nf
tepam::argument_dialogbox \\
   \fB-checkbutton\fR {-label Capitalize -variable Capitalize -default 1}
.fi
.PP
Several types of list and combo boxes are available to handle selection lists.
.TP
-combobox \fIlist\fR
The combobox is a combination of a normal entry widget together with a drop-down list box. The combobox allows selecting from this drop-down list box a single element. The list of the available elements can be provided either as a list to the \fI-choices\fR attribute, or via a variable that is specified with the \fI-choicevariable\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-combobox\fR {-label "Text size" -variable Size -choices {8 9 10 12 15 18} -default 12}
.fi
And here is an example of using a variable to define the selection list:
.nf
set TextSizes {8 9 10 12 15 18}
tepam::argument_dialogbox \\
   \fB-combobox\fR {-label "Text size" -variable Size -choicevariable TextSizes -default 12}
.fi
.TP
-listbox \fIlist\fR
In contrast to the combo box, the list box is always displayed by the \fIlistbox\fR entry widget. Only one element is selectable unless the \fI-multiple_selection\fR attribute is set. The list box height can be selected with the \fI-height\fR attribute. If the height is not explicitly defined, the list box height is automatically adapted to the argument dialog box' size.
The first example uses a variable to define the available choices:
.nf
set set AvailableSizes
for {set k 0} {$k<16} {incr k} {lappend AvailableSizes [expr 1<<$k]}

tepam::argument_dialogbox \\
   \fB-listbox\fR {-label "Distance" -variable Distance \\
             -choicevariable AvailableSizes -default 6 -height 5}
.fi
Here is a multi element selection example. Please note that also the default selection can contain multiple elements:
.nf
tepam::argument_dialogbox \\
   \fB-listbox\fR {-label "Text styles" -variable Styles \\
             -choices {bold italic underline overstrike} \\
             -choicelabels {Bold Italic Underline Overstrike} \\
             -default {bold underline} -multiple_selection 1 \\
             -height 3}
.fi
.TP
-disjointlistbox \fIlist\fR
A disjoint list box has to be used instead of a normal list box if the selection order is important. The disjoint list box entry widget is in fact displaying two list boxes, one for the selected elements and one for the unselected elements.
.sp
Disjoint listboxes allow always selecting multiple elements. With the exception of the \fI-multiple_selection\fR attribute, disjointed list boxes are accepting the same attributes as the normal listbox, e.g. \fI-height, -choices, -choicevariable, -default\fR.
.nf
tepam::argument_dialogbox \\
   \fB-disjointlistbox\fR {-label "Preferred scripting languages" -variable Languages \\
             -comment "Please select your preferred languanges in the order" \\
             -choices {JavaScript Lisp Lua Octave PHP Perl Python Ruby Scheme Tcl} \\
             -default {Tcl Perl Python}}
.fi
.PP
The file and directory selectors are building a next group of entry widgets. A paragraph of section \fBEntry Widget Item Attributes\fR explains the dedicated attributes of these widgets to specify the targeted file types, active directory etc.
.TP
-file \fIlist\fR
The item \fI-file\fR creates a group composed by an entry widget together with a button that allows opening a file browser. The data type \fIfile\fR is automatically selected for this entry if no data type has been explicitly defined with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-file\fR {-label "Image file" -variable ImageF \\
          -filetypes {{"GIF" {*.gif}} {"JPG" {*.jpg}}} \\
          -initialfile "picture.gif"}
.fi
.TP
-existingfile \fIlist\fR
The item \fI-existingfile\fR creates a group composed by an entry widget together with a button that allows opening a browser to select an existing file. The data type \fIexistingfile\fR is automatically selected for this entry if no data type has been explicitly defined with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-existingfile\fR {-label "Image file" -variable ImageF \\
                  -filetypes {{"GIF" {*.gif}} {"JPG" {*.jpg}}} \\
                  -initialfile "picture.gif"}
.fi
.TP
-directory \fIlist\fR
The item \fI-directory\fR creates a group composed by an entry widget together with a button that allows opening a directory browser. The data type \fIdirectory\fR is automatically selected for this entry if no data type has been explicitly defined with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-directory\fR {-label "Report directory" -variable ReportDir}
.fi
.TP
-existingdirectory \fIlist\fR
The item \fI-existingdirectory\fR creates a group composed by an entry widget together with a button that allows opening a browser to select an existing directory. The data type \fIexistingdirectory\fR is automatically selected for this entry if no data type has been explicitly defined with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-existingdirectory\fR {-label "Report directory" -variable ReportDir}
.fi
.PP
Finally, there is a last group of some other special entry widgets.
.TP
-color \fIlist\fR
The color selector is composed by an entry widget together with a button that allows opening a color browser. The data type \fIcolor\fR is automatically selected for this entry widget type if no data type has been explicitly defined with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-color\fR {-label "Background color" -variable Color -default red}
.fi
.TP
-font \fIlist\fR
The font selector is composed by an entry widget together with a button that allows opening a font browser. The data type \fIfont\fR is automatically selected for this entry widget type if no data type has been explicitly defined with the \fI-type\fR attribute. The entry widget displays an example text using the selected font.
.sp
The font browser allows selecting by default the font families provided by the \fBfont families\fR command as well as a reasonable set of different font sizes between 6 points and 40 points. Different sets of font families and font sizes can be specified respectively via the \fI-font_families\fR or \fI-font_sizes\fR attributes.
.sp
If no default font is provided via the \fI-default\fR attribute, the font of the label widget to display the selected font will be used as default selected font. If the font family of this label widget is not part of the available families the first available family is used as default. If the font size of this label widget is not part of the available sizes the next close available size is selected as default.
.nf
tepam::argument_dialogbox \\
   \fB-font\fR {-label "Font" -variable Font \\
          -font_sizes {8 10 12 16} \\
          -default {Arial 20 italic}}
.fi
.PP
.SS "ENTRY WIDGET ITEM ATTRIBUTES"
All the entry widget items are accepting the following attributes:
.TP
-text \fIstring\fR
Eventual descriptions and comments specified with the \fI-text\fR attribute are displayed above the entry widget.
.nf
tepam::argument_dialogbox \\
   -entry {\fB-text "Please enter your name bellow"\fR -variable Name}
.fi
.TP
-label \fIstring\fR
The label attribute creates left to the entry widget a label using the provided string as label text:
.nf
tepam::argument_dialogbox \\
   -entry {\fB-label Name\fR -variable Name}
.fi
.TP
-variable \fIstring\fR
All entry widgets require a specified variable. After accepting the entered information with the OK button, the entry widget's data are stored inside the defined variables.
.nf
tepam::argument_dialogbox \\
   -existingdirectory {-label "Report directory" \fB-variable ReportDir\fR}
.fi
.TP
-default \fIstring\fR
Eventual default data for the entry widgets can be provided via the \fI-default\fR attribute. The default value is overridden when an argument dialog box with a defined context is called another time. The data acknowledged in a previous call will be used in this case as default data.
.nf
tepam::argument_dialogbox \\
   -checkbox {-label "Font sytle" -variable FontStyle \\
               -choices {bold italic underline} \fB-default italic\fR}
.fi
.TP
-optional \fB0\fR|\fB1\fR
Data can be specified as optional or mandatory with the \fI-optional\fR attribute that requires either \fB0\fR (mandatory) or \fB1\fR (optional) as attribute data.
.sp
In case an entry is optional and no data has been entered, e.g. the entry contains an empty character string, the entry will be considered as undefined and the assigned variable will not be defined.
.nf
tepam::argument_dialogbox \\
   -entry {-label "City" -variable start_city -type string} \\
   -entry {-label "Street" -variable start_street -type string \fB-optional 0\fR} \\
   -entry {-label "Street number" -variable start_street_nbr -type integer \fB-optional 1\fR} \\
.fi
.TP
-type \fIstring\fR
If the data type is defined with the \fI-type\fR attribute the argument dialog box will automatically perform a data type check after acknowledging the entered data and before the dialog box is closed. If a type incompatible data is found an error message box appears and the user can correct the data.
.sp
The argument dialog box accepts all types that have been specified by the TEPAM package and that are also used by \fBtepam::procedure\fR (see the \fItepam::procedure reference manual\fR).
.sp
Some entry widgets like the file and directory widgets, as well as the color and font widgets are specifying automatically a default data type if no type has been specified explicitly with the \fI-type\fR attribute.
.nf
tepam::argument_dialogbox \\
   \fB-entry\fR {-label "Street number" -variable start_street_nbr \fB-type integer\fR} \\
.fi
.TP
-range \fIstring\fR
Data can be constrained with the \fI-range\fR attribute. The valid range is defined with a list containing the minimum valid value and a maximum valid value.
.sp
The \fI-range\fR attribute has to be used only for numerical arguments, like integers and doubles.
.nf
tepam::argument_dialogbox \\
   -entry {-label Month -variable Month -type integer \fB-range {1 12}\fR}
.fi
.TP
-validatecommand \fIstring\fR
More complex argument data validations than type checks can be performed via specific validation commands that are declared via the \fI-validatecommand\fR attribute.
The provided validation command can be a complete script in which the pattern \fI%P\fR is replaced by the argument data that has to be validated.
.nf
tepam::argument_dialogbox \\
   -entry {-label "Your comment" -variable YourCom \\
           \fB-validatecommand\fR "IllegalWordDetector %P"} ]
.fi
.PP
Some other attributes are supported by the list and combo boxes as well as by the radio and check buttons.
.TP
-choices \fIstring\fR
Choice lists can directly be defined with the \fI-choices\fR attribute. This way to define choice lists is especially adapted for smaller, fixed selection lists.
.nf
tepam::argument_dialogbox \\
   -listbox {-label "Text styles" -variable Styles \\
             \fB-choices {bold italic underline}\fR -default underline
.fi
.TP
-choicelabels \fIstring\fR \fI(only check and radio buttons)\fR
If the check and radio boxes' texts should differ from the option values, they can be defined with the \fI-choicelabels\fR attribute:
.nf
tepam::argument_dialogbox \\
   -checkbox {-label "Font sytle" -variable FontStyle \\
              -choices {bold italic underline} \\
              \fB-choicelabels {Bold Italic Underline}\fR
.fi
.TP
-choicevariable \fIstring\fR
Another way to define the choice lists is using the \fI-choicevariable\fR attribute. This way to define choice lists is especially adapted for huge and eventually variable lists.
.nf
set TextSizes {8 9 10 12 15 18}
tepam::argument_dialogbox \\
   -combobox {-label "Text size" -variable Size \fB-choicevariable TextSizes\fR}
.fi
.TP
-multiple_selection \fB0\fR|\fB1\fR
The list box item (\fB-listbox\fR) allows by default selecting only one list element. By setting the \fI-multiple_selection\fR attribute to \fB1\fR, multiple elements can be selected.
.nf
tepam::argument_dialogbox \\
   -listbox {-label "Text styles" -variable Styles \\
             -choices {bold italic underline} -default underline \\
             \fB-multiple_selection 1\fR -height 3}
.fi
.PP
Some additional attributes are supported by the file and directory selection widgets.
.TP
-filetypes \fIstring\fR
The file type attribute is used by the \fB-file\fR and \fB-existingfile\fR items to define the file endings that are searched by the file browser.
.nf
tepam::argument_dialogbox \\
   -file {-label "Image file" -variable ImageF \\
          \fB-filetypes {{"GIF" {*.gif}} {"JPG" {*.jpg}}}\fR}
.fi
.TP
-initialfile \fIstring\fR
The initial file used by the file browsers of the \fB-file\fR and \fB-existingfile\fR widgets are by default the file defined with the \fI-default\fR attribute, unless a file is specified with the \fI-initialfile\fR attribute.
.nf
tepam::argument_dialogbox \\
   -file {-variable ImageF \fB-initialfile "picture.gif"\fR}
.fi
.TP
-activedir \fIstring\fR
The \fI-activedir\fR attribute will override the default active search directory used by the file browsers of all file and directory entry widgets. The default active search directory is defined by the directory of a specified initial file (\fI-initialfile\fR) if defined, and otherwise by the directory of the default file/directory, specified with the \fI-default\fR attribute.
.nf
tepam::argument_dialogbox \\
   -file "-variable ImageF \fB-activedir $pwd\fR"
.fi
.PP
Finally, there is a last attribute supported by some widgets:
.TP
-height \fIstring\fR
All widgets containing a selection list (\fB-listbox\fR, \fB-disjointlistbox\fR, \fB-font\fR) are accepting the \fI-height\fR attribute that defines the number of displayed rows of the selection lists.
.nf
tepam::argument_dialogbox \\
   -listbox {-label "Text size" -variable Size \\
             -choices {8 9 10 12 15 18} -default 12 \fB-height 3\fR}
.fi
If the no height has been explicitly specified the height of the widget will be adapted to the argument dialog box' size.
.PP
.SH "APPLICATION SPECIFIC ENTRY WIDGETS"
An application specific entry widget can be made available to the argument dialog box by adding a dedicated procedure to the \fBtepam\fR namespace. This procedure has three arguments; the first one is the widget path, the second one a subcommand and the third argument has various purposes:
.nf
\fIproc\fR tepam::ad_form(<WidgetName>) {W Command {Par ""}} {
   \fIupvar Option Option; # if required\fR
   \fIvariable argument_dialogbox; # if required\fR
   switch $Command {
      "create" <CreateCommandSequence>
      "set_choice" <SetChoiceCommandSequence>
      "set" <SetCommandv>
      "get" <GetCommandSequence>
   }
}
.fi
\fBArgument_dialogbox\fR takes care about the \fI-label\fR and \fI-text\fR attributes for all entry widgets. For the entry widget it creates a frame into which the entry widget components can be placed. The path to this frame is provided via the \fIW\fR argument.
The entry widget procedure has to support 3 mandatory and an optional command, defined via the \fICommand\fR argument:
.TP
\fIcreate\fR
The entry widget is called a first time with the command \fIcreate\fR to build the entry widget.
.sp
The frames that are made available by \fBargument_dialogbox\fR for the entry widgets are by default only extendable in the X direction. To make them also extendable in the Y direction, for example for extendable list boxes, the command \fBad_form(make_expandable) $W\fR has to be executed when an entry widget is built.
.TP
\fIset_choice\fR
The entry widget procedure is only called with the \fIset_choice\fR command when the \fI-choices\fR or \fI-choicevariable\fR has been specified. The command is therefore only relevant for list and combo boxes.
.sp
The available selection list, either specified with the \fI-choices\fR or \fI-choicevariable\fR attribute is provided via the \fIPar\fR argument to the entry widget procedure which can initialize the selection list with this data.
.TP
\fIset\fR
If a default value is either defined via the \fI-default\fR attribute or via a preceding call the entry widget procedure is called with the \fIset\fR command. The argument \fIPar\fR contains in this case the value to which the entry widget has to be initialized.
.TP
\fIget\fR
The entry widget procedure's command \fIget\fR has to return the actual value of the entry widget.
.PP
Eventually specified entry widget item attributes are available via the \fBOption\fR array variable of the calling procedure. This variable becomes accessible inside the entry widget procedure via the \fBupvar\fR command.
.PP
There may be a need to store some information in a variable. The array variable \fBargument_dialogbox\fR has to be used for this purpose together with array indexes starting with \fI"$W,"\fR, e.g. \fIargument_dialogbox($W,values)\fR.
.PP
Examples of entry widget procedures are directly provided by the TEPAM package source file that specifies the standard entry widget procedures. The simplest procedure is certainly the one for the basic \fIentry\fR widget:
.nf
proc tepam::ad_form(entry) {W Command {Par ""}} {
   switch $Command {
      "create" {pack [entry \\$W.entry] -fill x \\
                        -expand yes -pady 4 -side left}
      "set" {\\$W.entry insert 0 $Par}
      "get" {return [\\$W.entry get]}
   }
}
.fi
It is also possible to relay on an existing entry widget procedure to create a new, more specific one. The \fIradiobox\fR widget is used for example, to create a new entry widget that allows selecting either the option \fIleft\fR, \fIcenter\fR or \fIright\fR. The original \fIradiobox\fR widget is called with the \fIset_choice\fR command immediately after the \fIcreate\fR command, to define the fixed list of selection options.
.nf
proc tepam::ad_form(rcl) {W Command {Par ""}} {
   set Res [ad_form(radiobox) $W $Command $Par]
   if {$Command=="create"} {
      ad_form(radiobox) $W set_choice {left center right}
   }
   return $Res
}
.fi
Please consult the TEPAM package source file to find additional and more complex examples of entry widget procedures.
.SH VARIABLES
The \fBargument_dialogbox\fR is using two variables inside the \fB::tepam\fR namespace:
.TP
\fBargument_dialogbox\fR
Application specific entry widget procedures can use this array variable to store their own data, using as index the widget path provided to the procedure, e.g. \fIargument_dialogbox($W,<sub_index>)\fR.
.TP
\fBlast_parameters\fR
This array variable is only used by an argument dialog box when its context has been specified via the \fI-context\fR attribute. The argument dialog box' position and size as well as its entered data are stored inside this variable when the data are acknowledged and the form is closed. This allows the form to restore its previous state once it is called another time.
.sp
To reuse the saved parameters not just in the actual application session but also in another one, it is sufficient to store the \fBlast_parameter\fR variable array in a configuration file which is loaded the next time an application is launched.
.PP
.SH "SEE ALSO"
tepam_introduction(n), tepam_procedure(n)
.SH KEYWORDS
entry mask, parameter entry form
.SH CATEGORY
Argument entry form, mega widget
.SH COPYRIGHT
.nf
Copyright (c) 2009/2010, Andreas Drollinger

.fi