'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-112.50.2/tcl_ext/tcllib/tcllib/modules/textutil/textutil.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "textutil" n 0.7.1 textutil "Text and string utilities, macro processing"
.BS
.SH NAME
textutil \- Procedures to manipulate texts and strings.
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBtextutil  ?0.7.1?\fR
.sp
\fB::textutil::adjust\fR \fIstring args\fR
.sp
\fB::textutil::adjust::readPatterns\fR \fIfilename\fR
.sp
\fB::textutil::adjust::listPredefined\fR
.sp
\fB::textutil::adjust::getPredefined\fR \fIfilename\fR
.sp
\fB::textutil::indent\fR \fIstring\fR \fIprefix\fR ?\fIskip\fR?
.sp
\fB::textutil::undent\fR \fIstring\fR
.sp
\fB::textutil::splitn\fR \fIstring\fR ?\fIlen\fR?
.sp
\fB::textutil::splitx\fR \fIstring\fR ?\fIregexp\fR?
.sp
\fB::textutil::tabify\fR \fIstring\fR ?\fInum\fR?
.sp
\fB::textutil::tabify2\fR \fIstring\fR ?\fInum\fR?
.sp
\fB::textutil::trim\fR \fIstring\fR ?\fIregexp\fR?
.sp
\fB::textutil::trimleft\fR \fIstring\fR ?\fIregexp\fR?
.sp
\fB::textutil::trimright\fR \fIstring\fR ?\fIregexp\fR?
.sp
\fB::textutil::trimPrefix\fR \fIstring\fR \fIprefix\fR
.sp
\fB::textutil::trimEmptyHeading\fR \fIstring\fR
.sp
\fB::textutil::untabify\fR \fIstring\fR ?\fInum\fR?
.sp
\fB::textutil::untabify2\fR \fIstring\fR ?\fInum\fR?
.sp
\fB::textutil::strRepeat\fR \fItext num\fR
.sp
\fB::textutil::blank\fR \fInum\fR
.sp
\fB::textutil::chop\fR \fIstring\fR
.sp
\fB::textutil::tail\fR \fIstring\fR
.sp
\fB::textutil::cap\fR \fIstring\fR
.sp
\fB::textutil::uncap\fR \fIstring\fR
.sp
\fB::textutil::longestCommonPrefixList\fR \fIlist\fR
.sp
\fB::textutil::longestCommonPrefix\fR ?\fIstring\fR...?
.sp
.BE
.SH DESCRIPTION
The package \fBtextutil\fR provides commands that manipulate
strings or texts (a.k.a. long strings or string with embedded newlines
or paragraphs).
It is actually a bundle providing the commands of the six packages
.TP
\fBtextutil::adjust\fR
.TP
\fBtextutil::repeat\fR
.TP
\fBtextutil::split\fR
.TP
\fBtextutil::string\fR
.TP
\fBtextutil::tabify\fR
.TP
\fBtextutil::trim\fR
.PP
in the namespace \fBtextutil\fR.
.PP
The bundle is \fIdeprecated\fR, and it will be removed in a future
release of Tcllib, after the next release. It is recommended to use the
relevant sub packages instead for whatever functionality is needed by
the using package or application.
.PP
The complete set of procedures is described below.
.TP
\fB::textutil::adjust\fR \fIstring args\fR
Do a justification on the \fIstring\fR according to \fIargs\fR.  The
string is taken as one big paragraph, ignoring any newlines.  Then the
line is formatted according to the options used, and the command
return a new string with enough lines to contain all the printable
chars in the input string. A line is a set of chars between the
beginning of the string and a newline, or between 2 newlines, or
between a newline and the end of the string. If the input string is
small enough, the returned string won't contain any newlines.
.sp
Together with \fB::textutil::indent\fR it is possible to create
properly wrapped paragraphs with arbitrary indentations.
.sp
By default, any occurrence of spaces characters or tabulation are
replaced by a single space so each word in a line is separated from
the next one by exactly one space char, and this forms a \fIreal\fR
line. Each \fIreal\fR line is placed in a \fIlogical\fR line, which
have exactly a given length (see \fB-length\fR option below). The
\fIreal\fR line may have a lesser length. Again by default, any
trailing spaces are ignored before returning the string (see
\fB-full\fR option below). The following options may be used after the
\fIstring\fR parameter, and change the way the command place a
\fIreal\fR line in a \fIlogical\fR line.
.RS
.TP
-full \fIboolean\fR
If set to \fBfalse\fR, any trailing space chars are deleted before
returning the string. If set to \fBtrue\fR, any trailing space
chars are left in the string. Default to \fBfalse\fR.
.TP
\fB-hyphenate\fR \fIboolean\fR
if set to \fBfalse\fR, no hyphenation will be done. If set to
\fBtrue\fR, the last word of a line is tried to be hyphenated.
Defaults to \fBfalse\fR. Note: hyphenation patterns must be loaded
prior, using the command \fB::textutil::adjust::readPatterns\fR.
.TP
\fB-justify\fR \fBcenter|left|plain|right\fR
Set the justification of the returned string to \fBcenter\fR,
\fBleft\fR, \fBplain\fR or \fBright\fR. By default, it is set to
\fBleft\fR.  The justification means that any line in the returned
string but the last one is build according to the value. If the
justification is set to \fBplain\fR and the number of printable
chars in the last line is less than 90% of the length of a line (see
\fB-length\fR), then this line is justified with the \fBleft\fR
value, avoiding the expansion of this line when it is too small. The
meaning of each value is:
.RS
.TP
\fBcenter\fR
The real line is centered in the logical line. If needed, a set of
space characters are added at the beginning (half of the needed set)
and at the end (half of the needed set) of the line if required (see
the option \fB-full\fR).
.TP
\fBleft\fR
The real line is set on the left of the logical line. It means that
there are no space chars at the beginning of this line. If required,
all needed space chars are added at the end of the line (see the
option \fB-full\fR).
.TP
\fBplain\fR
The real line is exactly set in the logical line. It means that there
are no leading or trailing space chars. All the needed space chars are
added in the \fIreal\fR line, between 2 (or more) words.
.TP
\fBright\fR
The real line is set on the right of the logical line. It means that
there are no space chars at the end of this line, and there may be
some space chars at the beginning, despite of the \fB-full\fR option.
.RE
.TP
\fB-length\fR \fIinteger\fR
Set the length of the \fIlogical\fR line in the string to
\fIinteger\fR.  \fIinteger\fR must be a positive integer
value. Defaults to \fB72\fR.
.TP
\fB-strictlength\fR \fIboolean\fR
If set to \fBfalse\fR, a line can exceed the specified
\fB-length\fR if a single word is longer than \fB-length\fR. If
set to \fBtrue\fR, words that are longer than \fB-length\fR are
split so that no line exceeds the specified \fB-length\fR. Defaults
to \fBfalse\fR.
.RE
.TP
\fB::textutil::adjust::readPatterns\fR \fIfilename\fR
Loads the internal storage for hyphenation patterns with the contents
of the file \fIfilename\fR. This has to be done prior to calling
command \fB::textutil::adjust\fR with
"\fB-hyphenate\fR \fBtrue\fR", or the hyphenation process will
not work correctly.
.sp
The package comes with a number of predefined pattern files, and the
command \fB::textutil::adjust::listPredefined\fR can be used to find
out their names.
.TP
\fB::textutil::adjust::listPredefined\fR
This command returns a list containing the names of the hyphenation
files coming with this package.
.TP
\fB::textutil::adjust::getPredefined\fR \fIfilename\fR
Use this command to query the package for the full path name of the
hyphenation file \fIfilename\fR coming with the package. Only the
filenames found in the list returned by
\fB::textutil::adjust::listPredefined\fR are legal arguments for this
command.
.TP
\fB::textutil::indent\fR \fIstring\fR \fIprefix\fR ?\fIskip\fR?
Each line in the \fIstring\fR indented by adding the string
\fIprefix\fR at its beginning. The modified string is returned
as the result of the command.
.sp
If \fIskip\fR is specified the first \fIskip\fR lines are left
untouched. The default for \fIskip\fR is \fB0\fR, causing the
modification of all lines. Negative values for \fIskip\fR are treated
like \fB0\fR. In other words, \fIskip\fR > \fB0\fR creates a
hanging indentation.
.sp
Together with \fB::textutil::adjust\fR it is possible to create
properly wrapped paragraphs with arbitrary indentations.
.TP
\fB::textutil::undent\fR \fIstring\fR
The command computes the common prefix for all
lines in \fIstring\fR consisting solely out of whitespace,
removes this from each line and returns the modified string.
.sp
Lines containing only whitespace are always reduced to completely
empty lines. They and empty lines are also ignored when computing the
prefix to remove.
.sp
Together with \fB::textutil::adjust\fR it is possible to create
properly wrapped paragraphs with arbitrary indentations.
.TP
\fB::textutil::splitn\fR \fIstring\fR ?\fIlen\fR?
This command splits the given \fIstring\fR into chunks of \fIlen\fR
characters and returns a list containing these chunks. The argument
\fIlen\fR defaults to \fB1\fR if none is specified. A negative
length is not allowed and will cause the command to throw an
error. Providing an empty string as input is allowed, the command will
then return an empty list. If the length of the \fIstring\fR is not an
entire multiple of the chunk length, then the last chunk in the
generated list will be shorter than \fIlen\fR.
.TP
\fB::textutil::splitx\fR \fIstring\fR ?\fIregexp\fR?
Split the \fIstring\fR and return a list. The string is split
according to the regular expression \fIregexp\fR instead of a simple
list of chars. Note that if you add parenthesis into the \fIregexp\fR,
the parentheses part of separator would be added into list as
additional element. If the \fIstring\fR is empty the result is the
empty list, like for \fBsplit\fR. If \fIregexp\fR is empty the
\fIstring\fR is split at every character, like \fBsplit\fR does.
The regular expression \fIregexp\fR defaults to "[\\\\t \\\\r\\\\n]+".
.TP
\fB::textutil::tabify\fR \fIstring\fR ?\fInum\fR?
Tabify the \fIstring\fR by replacing any substring of \fInum\fR space
chars by a tabulation and return the result as a new string. \fInum\fR
defaults to 8.
.TP
\fB::textutil::tabify2\fR \fIstring\fR ?\fInum\fR?
Similar to \fB::textutil::tabify\fR this command tabifies the
\fIstring\fR and returns the result as a new string. A different
algorithm is used however. Instead of replacing any substring of
\fInum\fR spaces this command works more like an editor. \fInum\fR
defaults to 8.
.sp
Each line of the text in \fIstring\fR is treated as if there are
tabstops every \fInum\fR columns. Only sequences of space characters
containing more than one space character and found immediately before
a tabstop are replaced with tabs.
.TP
\fB::textutil::trim\fR \fIstring\fR ?\fIregexp\fR?
Remove in \fIstring\fR any leading and trailing substring according to
the regular expression \fIregexp\fR and return the result as a new
string.  This apply on any \fIline\fR in the string, that is any
substring between 2 newline chars, or between the beginning of the
string and a newline, or between a newline and the end of the string,
or, if the string contain no newline, between the beginning and the
end of the string.
The regular expression \fIregexp\fR defaults to "[ \\\\t]+".
.TP
\fB::textutil::trimleft\fR \fIstring\fR ?\fIregexp\fR?
Remove in \fIstring\fR any leading substring according to the regular
expression \fIregexp\fR and return the result as a new string. This
apply on any \fIline\fR in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.
The regular expression \fIregexp\fR defaults to "[ \\\\t]+".
.TP
\fB::textutil::trimright\fR \fIstring\fR ?\fIregexp\fR?
Remove in \fIstring\fR any trailing substring according to the regular
expression \fIregexp\fR and return the result as a new string. This
apply on any \fIline\fR in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline,
or between a newline and the end of the string, or, if the string
contain no newline, between the beginning and the end of the string.
The regular expression \fIregexp\fR defaults to "[ \\\\t]+".
.TP
\fB::textutil::trimPrefix\fR \fIstring\fR \fIprefix\fR
Removes the \fIprefix\fR from the beginning of \fIstring\fR and
returns the result. The \fIstring\fR is left unchanged if it doesn't
have \fIprefix\fR at its beginning.
.TP
\fB::textutil::trimEmptyHeading\fR \fIstring\fR
Looks for empty lines (including lines consisting of only whitespace)
at the beginning of the \fIstring\fR and removes it. The modified
string is returned as the result of the command.
.TP
\fB::textutil::untabify\fR \fIstring\fR ?\fInum\fR?
Untabify the \fIstring\fR by replacing any tabulation char by a
substring of \fInum\fR space chars and return the result as a new
string. \fInum\fR defaults to 8.
.TP
\fB::textutil::untabify2\fR \fIstring\fR ?\fInum\fR?
Untabify the \fIstring\fR by replacing any tabulation char by a
substring of at most \fInum\fR space chars and return the result as a
new string. Unlike \fBtextutil::untabify\fR each tab is not replaced
by a fixed number of space characters.  The command overlays each line
in the \fIstring\fR with tabstops every \fInum\fR columns instead and
replaces tabs with just enough space characters to reach the next
tabstop. This is the complement of the actions taken by
\fB::textutil::tabify2\fR. \fInum\fR defaults to 8.
.sp
There is one asymmetry though: A tab can be replaced with a single
space, but not the other way around.
.TP
\fB::textutil::strRepeat\fR \fItext num\fR
The implementation depends on the core executing the package. Used
\fBstring repeat\fR if it is present, or a fast tcl implementation
if it is not. Returns a string containing the \fItext\fR repeated
\fInum\fR times. The repetitions are joined without characters between
them. A value of \fInum\fR <= 0 causes the command to return an empty
string.
.TP
\fB::textutil::blank\fR \fInum\fR
A convenience command. Returns a string of \fInum\fR spaces.
.TP
\fB::textutil::chop\fR \fIstring\fR
A convenience command. Removes the last character of \fIstring\fR and
returns the shortened string.
.TP
\fB::textutil::tail\fR \fIstring\fR
A convenience command. Removes the first character of \fIstring\fR and
returns the shortened string.
.TP
\fB::textutil::cap\fR \fIstring\fR
Capitalizes the first character of \fIstring\fR and returns the modified string.
.TP
\fB::textutil::uncap\fR \fIstring\fR
The complementary operation to \fB::textutil::cap\fR. Forces the first
character of \fIstring\fR to lower case and returns the modified
string.
.TP
\fB::textutil::longestCommonPrefixList\fR \fIlist\fR
.TP
\fB::textutil::longestCommonPrefix\fR ?\fIstring\fR...?
Computes the longest common prefix for either the \fIstring\fRs given
to the command, or the strings specified in the single \fIlist\fR, and
returns it as the result of the command.
.sp
If no strings were specified the result is the empty string.  If only
one string was specified, the string itself is returned, as it is its
own longest common prefix.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fItextutil\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
regexp(n), split(n), string(n)
.SH KEYWORDS
TeX, formatting, hyphenation, indenting, paragraph, regular expression, string, trimming
.SH CATEGORY
Text processing