/*
 * Copyright (c) 2000-2017 Apple Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */

/*
 * This file is automatically generated
 * DO NOT EDIT!
 */

/*
 * Reserved Keys
 *
 *   kSCResvLink                                        "__LINK__"                     CFString
 *   kSCResvInactive                                    "__INACTIVE__"
 *
 * Generic Keys
 *
 *   kSCPropInterfaceName                               "InterfaceName"                CFString
 *   kSCPropMACAddress                                  "MACAddress"                   CFString
 *   kSCPropUserDefinedName                             "UserDefinedName"              CFString
 *   kSCPropVersion                                     "Version"                      CFString
 *
 * Preference Keys
 *
 *   kSCPrefCurrentSet                                  "CurrentSet"                   CFString
 *   kSCPrefNetworkServices                             "NetworkServices"              CFDictionary
 *   kSCPrefSets                                        "Sets"                         CFDictionary
 *   kSCPrefSystem                                      "System"                       CFDictionary
 *
 * Component Keys
 *
 *   kSCCompNetwork                                     "Network"
 *   kSCCompService                                     "Service"
 *   kSCCompGlobal                                      "Global"
 *   kSCCompHostNames                                   "HostNames"
 *   kSCCompInterface                                   "Interface"
 *   kSCCompSystem                                      "System"
 *   kSCCompUsers                                       "Users"
 *
 *   --- Regex pattern which matches any component ---
 *   kSCCompAnyRegex                                    "[^/]+"
 *
 * Network Entity Keys
 *
 *   kSCEntNetAirPort                                   "AirPort"                      CFDictionary
 *   kSCEntNetDHCP                                      "DHCP"                         CFDictionary
 *   kSCEntNetDNS                                       "DNS"                          CFDictionary
 *   kSCEntNetEthernet                                  "Ethernet"                     CFDictionary
 *   kSCEntNetFireWire                                  "FireWire"                     CFDictionary
 *   kSCEntNetInterface                                 "Interface"                    CFDictionary
 *   kSCEntNetIPSec                                     "IPSec"                        CFDictionary
 *   kSCEntNetIPv4                                      "IPv4"                         CFDictionary
 *   kSCEntNetIPv6                                      "IPv6"                         CFDictionary
 *   kSCEntNetL2TP                                      "L2TP"                         CFDictionary
 *   kSCEntNetLink                                      "Link"                         CFDictionary
 *   kSCEntNetModem                                     "Modem"                        CFDictionary
 *   kSCEntNetPPP                                       "PPP"                          CFDictionary
 *   kSCEntNetPPPoE                                     "PPPoE"                        CFDictionary
 *   kSCEntNetPPPSerial                                 "PPPSerial"                    CFDictionary
 *   kSCEntNetPPTP                                      "PPTP"                         CFDictionary
 *   kSCEntNetProxies                                   "Proxies"                      CFDictionary
 *   kSCEntNetSMB                                       "SMB"                          CFDictionary
 *   kSCEntNet6to4                                      "6to4"                         CFDictionary
 *
 * kSCCompNetwork Properties
 *
 *   kSCPropNetOverridePrimary                          "OverridePrimary"              CFNumber (0 or 1)
 *   kSCPropNetServiceOrder                             "ServiceOrder"                 CFArray[CFString]
 *   kSCPropNetPPPOverridePrimary                       "PPPOverridePrimary"           CFNumber (0 or 1)
 *
 * kSCCompNetworkInterface Properties
 *
 *   kSCPropNetInterfaces                               "Interfaces"                   CFArray[CFString]
 *
 * kSCCompNetworkHostNames Properties
 *
 *   kSCPropNetLocalHostName                            "LocalHostName"                CFString
 *
 * kSCEntNetDNS Entity Keys
 *
 *   kSCPropNetDNSDomainName                            "DomainName"                   CFString
 *   kSCPropNetDNSOptions                               "Options"                      CFString
 *   kSCPropNetDNSSearchDomains                         "SearchDomains"                CFArray[CFString]
 *   kSCPropNetDNSSearchOrder                           "SearchOrder"                  CFNumber
 *   kSCPropNetDNSServerAddresses                       "ServerAddresses"              CFArray[CFString]
 *   kSCPropNetDNSServerPort                            "ServerPort"                   CFNumber
 *   kSCPropNetDNSServerTimeout                         "ServerTimeout"                CFNumber
 *   kSCPropNetDNSSortList                              "SortList"                     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchDomains              "SupplementalMatchDomains"     CFArray[CFString]
 *   kSCPropNetDNSSupplementalMatchOrders               "SupplementalMatchOrders"      CFArray[CFNumber]
 *
 * kSCEntNetEthernet (Hardware) Entity Keys
 *
 *   kSCPropNetEthernetMediaSubType                     "MediaSubType"                 CFString
 *   kSCPropNetEthernetMediaOptions                     "MediaOptions"                 CFArray[CFString]
 *   kSCPropNetEthernetMTU                              "MTU"                          CFNumber
 *
 * kSCEntNetFireWire (Hardware) Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetInterface Entity Keys
 *
 *   kSCPropNetInterfaceDeviceName                      "DeviceName"                   CFString
 *   kSCPropNetInterfaceHardware                        "Hardware"                     CFString
 *   kSCPropNetInterfaceType                            "Type"                         CFString
 *   kSCPropNetInterfaceSubType                         "SubType"                      CFString
 *
 *   --- kSCPropNetInterfaceType values ---
 *   kSCValNetInterfaceTypeEthernet                     "Ethernet"
 *   kSCValNetInterfaceTypeFireWire                     "FireWire"
 *   kSCValNetInterfaceTypePPP                          "PPP"
 *   kSCValNetInterfaceType6to4                         "6to4"
 *   kSCValNetInterfaceTypeIPSec                        "IPSec"
 *
 *   --- kSCPropNetServiceSubType values (for PPP) ---
 *   kSCValNetInterfaceSubTypePPPoE                     "PPPoE"
 *   kSCValNetInterfaceSubTypePPPSerial                 "PPPSerial"
 *   kSCValNetInterfaceSubTypePPTP                      "PPTP"
 *   kSCValNetInterfaceSubTypeL2TP                      "L2TP"
 *
 * kSCEntNetIPSec Entity Keys
 *
 *   kSCPropNetIPSecAuthenticationMethod                "AuthenticationMethod"         CFString
 *   kSCPropNetIPSecLocalCertificate                    "LocalCertificate"             CFData
 *   kSCPropNetIPSecLocalIdentifier                     "LocalIdentifier"              CFString
 *   kSCPropNetIPSecLocalIdentifierType                 "LocalIdentifierType"          CFString
 *   kSCPropNetIPSecSharedSecret                        "SharedSecret"                 CFString
 *   kSCPropNetIPSecSharedSecretEncryption              "SharedSecretEncryption"       CFString
 *   kSCPropNetIPSecConnectTime                         "ConnectTime"                  CFNumber
 *   kSCPropNetIPSecRemoteAddress                       "RemoteAddress"                CFString
 *   kSCPropNetIPSecStatus                              "Status"                       CFNumber
 *   kSCPropNetIPSecXAuthEnabled                        "XAuthEnabled"                 CFNumber (0 or 1)
 *   kSCPropNetIPSecXAuthName                           "XAuthName"                    CFString
 *   kSCPropNetIPSecXAuthPassword                       "XAuthPassword"                CFString
 *   kSCPropNetIPSecXAuthPasswordEncryption             "XAuthPasswordEncryption"      CFString
 *
 *   --- kSCPropNetIPSecAuthenticationMethod values ---
 *   kSCValNetIPSecAuthenticationMethodSharedSecret     "SharedSecret"
 *   kSCValNetIPSecAuthenticationMethodCertificate      "Certificate"
 *   kSCValNetIPSecAuthenticationMethodHybrid           "Hybrid"
 *
 *   --- kSCPropNetIPSecLocalIdentifierType values ---
 *   kSCValNetIPSecLocalIdentifierTypeKeyID             "KeyID"
 *
 *   --- kSCPropNetIPSecSharedSecretEncryption values ---
 *   kSCValNetIPSecSharedSecretEncryptionKeychain       "Keychain"
 *
 *   --- kSCPropNetIPSecXAuthPasswordEncryption values ---
 *   kSCValNetIPSecXAuthPasswordEncryptionKeychain      "Keychain"
 *   kSCValNetIPSecXAuthPasswordEncryptionPrompt        "Prompt"
 *
 * kSCEntNetIPv4 Entity Keys
 *
 *   kSCPropNetIPv4Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv4ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv4DHCPClientID                         "DHCPClientID"                 CFString
 *   kSCPropNetIPv4Router                               "Router"                       CFString
 *   kSCPropNetIPv4SubnetMasks                          "SubnetMasks"                  CFArray[CFString]
 *   kSCPropNetIPv4DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv4BroadcastAddresses                   "BroadcastAddresses"           CFArray[CFString]
 *
 *   --- kSCPropNetIPv4ConfigMethod values ---
 *   kSCValNetIPv4ConfigMethodAutomatic                 "Automatic"
 *   kSCValNetIPv4ConfigMethodBOOTP                     "BOOTP"
 *   kSCValNetIPv4ConfigMethodDHCP                      "DHCP"
 *   kSCValNetIPv4ConfigMethodINFORM                    "INFORM"
 *   kSCValNetIPv4ConfigMethodLinkLocal                 "LinkLocal"
 *   kSCValNetIPv4ConfigMethodManual                    "Manual"
 *   kSCValNetIPv4ConfigMethodPPP                       "PPP"
 *
 * kSCEntNetIPv6 Entity Keys
 *
 *   kSCPropNetIPv6Addresses                            "Addresses"                    CFArray[CFString]
 *   kSCPropNetIPv6ConfigMethod                         "ConfigMethod"                 CFString
 *   kSCPropNetIPv6DestAddresses                        "DestAddresses"                CFArray[CFString]
 *   kSCPropNetIPv6Flags                                "Flags"                        CFNumber
 *   kSCPropNetIPv6PrefixLength                         "PrefixLength"                 CFArray[CFNumber]
 *   kSCPropNetIPv6Router                               "Router"                       CFString
 *
 *   --- kSCPropNetIPv6ConfigMethod values ---
 *   kSCValNetIPv6ConfigMethodAutomatic                 "Automatic"
 *   kSCValNetIPv6ConfigMethodLinkLocal                 "LinkLocal"
 *   kSCValNetIPv6ConfigMethodManual                    "Manual"
 *   kSCValNetIPv6ConfigMethodRouterAdvertisement       "RouterAdvertisement"
 *   kSCValNetIPv6ConfigMethod6to4                      "6to4"
 *
 * kSCEntNet6to4 Entity Keys
 *
 *   kSCPropNet6to4Relay                                "Relay"                        CFString
 *
 * kSCEntNetLink Entity Keys
 *
 *   kSCPropNetLinkActive                               "Active"                       CFBoolean
 *   kSCPropNetLinkDetaching                            "Detaching"                    CFBoolean
 *
 * kSCEntNetModem (Hardware) Entity Keys
 *
 *   kSCPropNetModemAccessPointName                     "AccessPointName"              CFString
 *   kSCPropNetModemConnectionPersonality               "ConnectionPersonality"        CFString
 *   kSCPropNetModemConnectionScript                    "ConnectionScript"             CFString
 *   kSCPropNetModemConnectSpeed                        "ConnectSpeed"                 CFNumber
 *   kSCPropNetModemDataCompression                     "DataCompression"              CFNumber (0 or 1)
 *   kSCPropNetModemDeviceContextID                     "DeviceContextID"              CFString
 *   kSCPropNetModemDeviceModel                         "DeviceModel"                  CFString
 *   kSCPropNetModemDeviceVendor                        "DeviceVendor"                 CFString
 *   kSCPropNetModemDialMode                            "DialMode"                     CFString
 *   kSCPropNetModemErrorCorrection                     "ErrorCorrection"              CFNumber (0 or 1)
 *   kSCPropNetModemHoldCallWaitingAudibleAlert         "HoldCallWaitingAudibleAlert"  CFNumber (0 or 1)
 *   kSCPropNetModemHoldDisconnectOnAnswer              "HoldDisconnectOnAnswer"       CFNumber (0 or 1)
 *   kSCPropNetModemHoldEnabled                         "HoldEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminder                        "HoldReminder"                 CFNumber (0 or 1)
 *   kSCPropNetModemHoldReminderTime                    "HoldReminderTime"             CFNumber
 *   kSCPropNetModemNote                                "Note"                         CFString
 *   kSCPropNetModemPulseDial                           "PulseDial"                    CFNumber (0 or 1)
 *   kSCPropNetModemSpeaker                             "Speaker"                      CFNumber (0 or 1)
 *   kSCPropNetModemSpeed                               "Speed"                        CFNumber
 *
 *   --- kSCPropNetModemDialMode values ---
 *   kSCValNetModemDialModeIgnoreDialTone               "IgnoreDialTone"
 *   kSCValNetModemDialModeManual                       "Manual"
 *   kSCValNetModemDialModeWaitForDialTone              "WaitForDialTone"
 *
 * kSCEntNetPPP Entity Keys
 *
 *   kSCPropNetPPPACSPEnabled                           "ACSPEnabled"                  CFNumber (0 or 1)
 *   kSCPropNetPPPConnectTime                           "ConnectTime"                  CFNumber
 *   kSCPropNetPPPDeviceLastCause                       "DeviceLastCause"              CFNumber
 *   kSCPropNetPPPDialOnDemand                          "DialOnDemand"                 CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnFastUserSwitch            "DisconnectOnFastUserSwitch"   CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdle                      "DisconnectOnIdle"             CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnIdleTimer                 "DisconnectOnIdleTimer"        CFNumber
 *   kSCPropNetPPPDisconnectOnLogout                    "DisconnectOnLogout"           CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectOnSleep                     "DisconnectOnSleep"            CFNumber (0 or 1)
 *   kSCPropNetPPPDisconnectTime                        "DisconnectTime"               CFNumber
 *   kSCPropNetPPPIdleReminderTimer                     "IdleReminderTimer"            CFNumber
 *   kSCPropNetPPPIdleReminder                          "IdleReminder"                 CFNumber (0 or 1)
 *   kSCPropNetPPPLastCause                             "LastCause"                    CFNumber
 *   kSCPropNetPPPLogfile                               "Logfile"                      CFString
 *   kSCPropNetPPPPlugins                               "Plugins"                      CFArray[CFString]
 *   kSCPropNetPPPRetryConnectTime                      "RetryConnectTime"             CFNumber
 *   kSCPropNetPPPSessionTimer                          "SessionTimer"                 CFNumber
 *   kSCPropNetPPPStatus                                "Status"                       CFNumber
 *   kSCPropNetPPPUseSessionTimer                       "UseSessionTimer"              CFNumber (0 or 1)
 *   kSCPropNetPPPVerboseLogging                        "VerboseLogging"               CFNumber (0 or 1)
 *
 *   --- Auth: ---
 *   kSCPropNetPPPAuthEAPPlugins                        "AuthEAPPlugins"               CFArray[CFString]
 *   kSCPropNetPPPAuthName                              "AuthName"                     CFString
 *   kSCPropNetPPPAuthPassword                          "AuthPassword"                 CFString
 *   kSCPropNetPPPAuthPasswordEncryption                "AuthPasswordEncryption"       CFString
 *   kSCPropNetPPPAuthPrompt                            "AuthPrompt"                   CFString
 *   kSCPropNetPPPAuthProtocol                          "AuthProtocol"                 CFArray[CFString]
 *
 *   --- kSCPropNetPPPAuthPasswordEncryption values ---
 *   kSCValNetPPPAuthPasswordEncryptionKeychain         "Keychain"
 *   kSCValNetPPPAuthPasswordEncryptionToken            "Token"
 *
 *   --- kSCPropNetPPPAuthPrompt values ---
 *   kSCValNetPPPAuthPromptBefore                       "Before"                       CFString
 *   kSCValNetPPPAuthPromptAfter                        "After"                        CFString
 *
 *   --- kSCPropNetPPPAuthProtocol values ---
 *   kSCValNetPPPAuthProtocolCHAP                       "CHAP"                         CFString
 *   kSCValNetPPPAuthProtocolEAP                        "EAP"                          CFString
 *   kSCValNetPPPAuthProtocolMSCHAP1                    "MSCHAP1"                      CFString
 *   kSCValNetPPPAuthProtocolMSCHAP2                    "MSCHAP2"                      CFString
 *   kSCValNetPPPAuthProtocolPAP                        "PAP"                          CFString
 *
 *   --- Comm: ---
 *   kSCPropNetPPPCommAlternateRemoteAddress            "CommAlternateRemoteAddress"   CFString
 *   kSCPropNetPPPCommConnectDelay                      "CommConnectDelay"             CFNumber
 *   kSCPropNetPPPCommDisplayTerminalWindow             "CommDisplayTerminalWindow"    CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialCount                       "CommRedialCount"              CFNumber
 *   kSCPropNetPPPCommRedialEnabled                     "CommRedialEnabled"            CFNumber (0 or 1)
 *   kSCPropNetPPPCommRedialInterval                    "CommRedialInterval"           CFNumber
 *   kSCPropNetPPPCommRemoteAddress                     "CommRemoteAddress"            CFString
 *   kSCPropNetPPPCommTerminalScript                    "CommTerminalScript"           CFString
 *   kSCPropNetPPPCommUseTerminalScript                 "CommUseTerminalScript"        CFNumber (0 or 1)
 *
 *   --- CCP: ---
 *   kSCPropNetPPPCCPEnabled                            "CCPEnabled"                   CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE40Enabled                      "CCPMPPE40Enabled"             CFNumber (0 or 1)
 *   kSCPropNetPPPCCPMPPE128Enabled                     "CCPMPPE128Enabled"            CFNumber (0 or 1)
 *
 *   --- IPCP: ---
 *   kSCPropNetPPPIPCPCompressionVJ                     "IPCPCompressionVJ"            CFNumber (0 or 1)
 *   kSCPropNetPPPIPCPUsePeerDNS                        "IPCPUsePeerDNS"               CFNumber (0 or 1)
 *
 *   --- LCP: ---
 *   kSCPropNetPPPLCPEchoEnabled                        "LCPEchoEnabled"               CFNumber (0 or 1)
 *   kSCPropNetPPPLCPEchoFailure                        "LCPEchoFailure"               CFNumber
 *   kSCPropNetPPPLCPEchoInterval                       "LCPEchoInterval"              CFNumber
 *   kSCPropNetPPPLCPCompressionACField                 "LCPCompressionACField"        CFNumber (0 or 1)
 *   kSCPropNetPPPLCPCompressionPField                  "LCPCompressionPField"         CFNumber (0 or 1)
 *   kSCPropNetPPPLCPMRU                                "LCPMRU"                       CFNumber
 *   kSCPropNetPPPLCPMTU                                "LCPMTU"                       CFNumber
 *   kSCPropNetPPPLCPReceiveACCM                        "LCPReceiveACCM"               CFNumber
 *   kSCPropNetPPPLCPTransmitACCM                       "LCPTransmitACCM"              CFNumber
 *
 * kSCEntNetPPPoE Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetPPPSerial Entity Keys
 *
 *   * RESERVED FOR FUTURE USE *
 *
 * kSCEntNetL2TP Entity Keys
 *
 *   kSCPropNetL2TPIPSecSharedSecret                    "IPSecSharedSecret"            CFString
 *   kSCPropNetL2TPIPSecSharedSecretEncryption          "IPSecSharedSecretEncryption"  CFString
 *   kSCPropNetL2TPTransport                            "Transport"                    CFString
 *
 *   --- kSCPropNetL2TPIPSecSharedSecretEncryption values ---
 *   kSCValNetL2TPIPSecSharedSecretEncryptionKeychain   "Keychain"
 *
 *   --- kSCPropNetL2TPTransport values ---
 *   kSCValNetL2TPTransportIP                           "IP"
 *   kSCValNetL2TPTransportIPSec                        "IPSec"
 *
 * kSCEntNetProxies Entity Keys
 *
 *   kSCPropNetProxiesExceptionsList                    "ExceptionsList"               CFArray[CFString]
 *   kSCPropNetProxiesExcludeSimpleHostnames            "ExcludeSimpleHostnames"       CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPEnable                         "FTPEnable"                    CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPassive                        "FTPPassive"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesFTPPort                           "FTPPort"                      CFNumber
 *   kSCPropNetProxiesFTPProxy                          "FTPProxy"                     CFString
 *   kSCPropNetProxiesGopherEnable                      "GopherEnable"                 CFNumber (0 or 1)
 *   kSCPropNetProxiesGopherPort                        "GopherPort"                   CFNumber
 *   kSCPropNetProxiesGopherProxy                       "GopherProxy"                  CFString
 *   kSCPropNetProxiesHTTPEnable                        "HTTPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPPort                          "HTTPPort"                     CFNumber
 *   kSCPropNetProxiesHTTPProxy                         "HTTPProxy"                    CFString
 *   kSCPropNetProxiesHTTPSEnable                       "HTTPSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesHTTPSPort                         "HTTPSPort"                    CFNumber
 *   kSCPropNetProxiesHTTPSProxy                        "HTTPSProxy"                   CFString
 *   kSCPropNetProxiesRTSPEnable                        "RTSPEnable"                   CFNumber (0 or 1)
 *   kSCPropNetProxiesRTSPPort                          "RTSPPort"                     CFNumber
 *   kSCPropNetProxiesRTSPProxy                         "RTSPProxy"                    CFString
 *   kSCPropNetProxiesSOCKSEnable                       "SOCKSEnable"                  CFNumber (0 or 1)
 *   kSCPropNetProxiesSOCKSPort                         "SOCKSPort"                    CFNumber
 *   kSCPropNetProxiesSOCKSProxy                        "SOCKSProxy"                   CFString
 *   kSCPropNetProxiesProxyAutoConfigEnable             "ProxyAutoConfigEnable"        CFNumber (0 or 1)
 *   kSCPropNetProxiesProxyAutoConfigJavaScript         "ProxyAutoConfigJavaScript"    CFString
 *   kSCPropNetProxiesProxyAutoConfigURLString          "ProxyAutoConfigURLString"     CFString
 *   kSCPropNetProxiesProxyAutoDiscoveryEnable          "ProxyAutoDiscoveryEnable"     CFNumber (0 or 1)
 *
 * kSCEntNetSMB Entity Keys
 *
 *   kSCPropNetSMBNetBIOSName                           "NetBIOSName"                  CFString
 *   kSCPropNetSMBNetBIOSNodeType                       "NetBIOSNodeType"              CFString
 *   kSCPropNetSMBNetBIOSScope                          "NetBIOSScope"                 CFString
 *   kSCPropNetSMBWINSAddresses                         "WINSAddresses"                CFArray[CFString]
 *   kSCPropNetSMBWorkgroup                             "Workgroup"                    CFString
 *
 *   --- kSCPropNetSMBNetBIOSNodeType values ---
 *   kSCValNetSMBNetBIOSNodeTypeBroadcast               "Broadcast"
 *   kSCValNetSMBNetBIOSNodeTypePeer                    "Peer"
 *   kSCValNetSMBNetBIOSNodeTypeMixed                   "Mixed"
 *   kSCValNetSMBNetBIOSNodeTypeHybrid                  "Hybrid"
 *
 * kSCCompUsers Entity Keys
 *
 *   kSCEntUsersConsoleUser                             "ConsoleUser"
 *
 * kSCCompSystem Properties
 *
 *   kSCPropSystemComputerName                          "ComputerName"                 CFString
 *   kSCPropSystemComputerNameEncoding                  "ComputerNameEncoding"         CFNumber
 *
 * SCDynamicStore "domain" prefixes
 *
 *   kSCDynamicStoreDomainFile                          "File:"
 *   kSCDynamicStoreDomainPlugin                        "Plugin:"
 *   kSCDynamicStoreDomainSetup                         "Setup:"
 *   kSCDynamicStoreDomainState                         "State:"
 *   kSCDynamicStoreDomainPrefs                         "Prefs:"
 *
 * Preference ("location") Keys
 *
 *   kSCDynamicStorePropSetupCurrentSet                 "CurrentSet"                   CFString
 *   kSCDynamicStorePropSetupLastUpdated                "LastUpdated"
 *
 * Common/shared Keys
 *
 *   kSCDynamicStorePropNetInterfaces                   "Interfaces"                   CFArray[CFString]
 *   kSCDynamicStorePropNetPrimaryInterface             "PrimaryInterface"             CFString
 *   kSCDynamicStorePropNetPrimaryService               "PrimaryService"               CFString
 *   kSCDynamicStorePropNetServiceIDs                   "ServiceIDs"                   CFArray[CFString]
 */


#ifndef	_SCSCHEMADEFINITIONS_H
#define	_SCSCHEMADEFINITIONS_H

#include <Availability.h>
#include <TargetConditionals.h>
#include <CoreFoundation/CFString.h>

/*!
 *	@header SCSchemaDefinitions
 */


CF_ASSUME_NONNULL_BEGIN

/*!
  @const kSCResvLink
  @discussion Value is a CFString
 */
extern const CFStringRef kSCResvLink                                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCResvLink kSCResvLink

/*!
  @const kSCResvInactive
 */
extern const CFStringRef kSCResvInactive                                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCResvInactive kSCResvInactive

/*!
  @const kSCPropInterfaceName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropInterfaceName                               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropInterfaceName kSCPropInterfaceName

/*!
  @const kSCPropMACAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropMACAddress                                  __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropMACAddress kSCPropMACAddress

/*!
  @const kSCPropUserDefinedName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropUserDefinedName                             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropUserDefinedName kSCPropUserDefinedName

/*!
  @const kSCPropVersion
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropVersion                                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropVersion kSCPropVersion

/*!
  @group Preference Keys
 */

/*!
  @const kSCPrefCurrentSet
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPrefCurrentSet                                  __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPrefCurrentSet kSCPrefCurrentSet

/*!
  @const kSCPrefNetworkServices
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefNetworkServices                             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPrefNetworkServices kSCPrefNetworkServices

/*!
  @const kSCPrefSets
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefSets                                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPrefSets kSCPrefSets

/*!
  @const kSCPrefSystem
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCPrefSystem                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPrefSystem kSCPrefSystem

/*!
  @group Component Keys
 */

/*!
  @const kSCCompNetwork
 */
extern const CFStringRef kSCCompNetwork                                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompNetwork kSCCompNetwork

/*!
  @const kSCCompService
 */
extern const CFStringRef kSCCompService                                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompService kSCCompService

/*!
  @const kSCCompGlobal
 */
extern const CFStringRef kSCCompGlobal                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompGlobal kSCCompGlobal

/*!
  @const kSCCompHostNames
 */
extern const CFStringRef kSCCompHostNames                                   __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCCompHostNames kSCCompHostNames

/*!
  @const kSCCompInterface
 */
extern const CFStringRef kSCCompInterface                                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompInterface kSCCompInterface

/*!
  @const kSCCompSystem
 */
extern const CFStringRef kSCCompSystem                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompSystem kSCCompSystem

/*!
  @const kSCCompUsers
 */
extern const CFStringRef kSCCompUsers                                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompUsers kSCCompUsers

/*!
  @const kSCCompAnyRegex
 */
extern const CFStringRef kSCCompAnyRegex                                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCCompAnyRegex kSCCompAnyRegex

/*!
  @group Network Entity Keys
 */

/*!
  @const kSCEntNetAirPort
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetAirPort                                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetAirPort kSCEntNetAirPort

/*!
  @const kSCEntNetDHCP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetDHCP                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetDHCP kSCEntNetDHCP

/*!
  @const kSCEntNetDNS
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetDNS                                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetDNS kSCEntNetDNS

/*!
  @const kSCEntNetEthernet
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetEthernet                                  __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetEthernet kSCEntNetEthernet

/*!
  @const kSCEntNetFireWire
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetFireWire                                  __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCEntNetFireWire kSCEntNetFireWire

/*!
  @const kSCEntNetInterface
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetInterface                                 __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetInterface kSCEntNetInterface

/*!
  @const kSCEntNetIPSec
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPSec                                     __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCEntNetIPSec kSCEntNetIPSec

/*!
  @const kSCEntNetIPv4
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPv4                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetIPv4 kSCEntNetIPv4

/*!
  @const kSCEntNetIPv6
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetIPv6                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetIPv6 kSCEntNetIPv6

/*!
  @const kSCEntNetL2TP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetL2TP                                      __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCEntNetL2TP kSCEntNetL2TP

/*!
  @const kSCEntNetLink
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetLink                                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetLink kSCEntNetLink

/*!
  @const kSCEntNetModem
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetModem                                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetModem kSCEntNetModem

/*!
  @const kSCEntNetPPP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPP                                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetPPP kSCEntNetPPP

/*!
  @const kSCEntNetPPPoE
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPPoE                                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetPPPoE kSCEntNetPPPoE

/*!
  @const kSCEntNetPPPSerial
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPPSerial                                 __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCEntNetPPPSerial kSCEntNetPPPSerial

/*!
  @const kSCEntNetPPTP
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetPPTP                                      __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_3,__MAC_10_12,__IPHONE_NA,__IPHONE_NA);
#define kSCEntNetPPTP kSCEntNetPPTP

/*!
  @const kSCEntNetProxies
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetProxies                                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntNetProxies kSCEntNetProxies

/*!
  @const kSCEntNetSMB
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNetSMB                                       __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCEntNetSMB kSCEntNetSMB

/*!
  @const kSCEntNet6to4
  @discussion Value is a CFDictionary
 */
extern const CFStringRef kSCEntNet6to4                                      __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCEntNet6to4 kSCEntNet6to4

/*!
  @group kSCCompNetwork Properties
 */

/*!
  @const kSCPropNetOverridePrimary
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetOverridePrimary                          __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetOverridePrimary kSCPropNetOverridePrimary

/*!
  @const kSCPropNetServiceOrder
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetServiceOrder                             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetServiceOrder kSCPropNetServiceOrder

/*!
  @const kSCPropNetPPPOverridePrimary
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPOverridePrimary                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPOverridePrimary kSCPropNetPPPOverridePrimary

/*!
  @group kSCCompNetworkInterface Properties
 */

/*!
  @const kSCPropNetInterfaces
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetInterfaces                               __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetInterfaces kSCPropNetInterfaces

/*!
  @group kSCCompNetworkHostNames Properties
 */

/*!
  @const kSCPropNetLocalHostName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetLocalHostName                            __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetLocalHostName kSCPropNetLocalHostName

/*!
  @group kSCEntNetAirPort (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetAirPortAllowNetCreation
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortAllowNetCreation                  __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortAllowNetCreation kSCPropNetAirPortAllowNetCreation

/*!
  @const kSCPropNetAirPortAuthPassword
  @discussion Value is a CFData
 */
extern const CFStringRef kSCPropNetAirPortAuthPassword                      __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortAuthPassword kSCPropNetAirPortAuthPassword

/*!
  @const kSCPropNetAirPortAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortAuthPasswordEncryption            __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortAuthPasswordEncryption kSCPropNetAirPortAuthPasswordEncryption

/*!
  @const kSCPropNetAirPortJoinMode
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortJoinMode                          __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortJoinMode kSCPropNetAirPortJoinMode

/*!
  @const kSCPropNetAirPortPowerEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortPowerEnabled                      __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortPowerEnabled kSCPropNetAirPortPowerEnabled

/*!
  @const kSCPropNetAirPortPreferredNetwork
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetAirPortPreferredNetwork                  __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortPreferredNetwork kSCPropNetAirPortPreferredNetwork

/*!
  @const kSCPropNetAirPortSavePasswords
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetAirPortSavePasswords                     __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetAirPortSavePasswords kSCPropNetAirPortSavePasswords

/*!
  @const kSCValNetAirPortJoinModeAutomatic
 */
extern const CFStringRef kSCValNetAirPortJoinModeAutomatic                  __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_3,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortJoinModeAutomatic kSCValNetAirPortJoinModeAutomatic

/*!
  @const kSCValNetAirPortJoinModePreferred
 */
extern const CFStringRef kSCValNetAirPortJoinModePreferred                  __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortJoinModePreferred kSCValNetAirPortJoinModePreferred

/*!
  @const kSCValNetAirPortJoinModeRanked
 */
extern const CFStringRef kSCValNetAirPortJoinModeRanked                     __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_4,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortJoinModeRanked kSCValNetAirPortJoinModeRanked

/*!
  @const kSCValNetAirPortJoinModeRecent
 */
extern const CFStringRef kSCValNetAirPortJoinModeRecent                     __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortJoinModeRecent kSCValNetAirPortJoinModeRecent

/*!
  @const kSCValNetAirPortJoinModeStrongest
 */
extern const CFStringRef kSCValNetAirPortJoinModeStrongest                  __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortJoinModeStrongest kSCValNetAirPortJoinModeStrongest

/*!
  @const kSCValNetAirPortAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetAirPortAuthPasswordEncryptionKeychain     __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_3,__MAC_10_9,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetAirPortAuthPasswordEncryptionKeychain kSCValNetAirPortAuthPasswordEncryptionKeychain

/*!
  @group kSCEntNetDNS Entity Keys
 */

/*!
  @const kSCPropNetDNSDomainName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetDNSDomainName                            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetDNSDomainName kSCPropNetDNSDomainName

/*!
  @const kSCPropNetDNSOptions
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetDNSOptions                               __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSOptions kSCPropNetDNSOptions

/*!
  @const kSCPropNetDNSSearchDomains
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSearchDomains                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetDNSSearchDomains kSCPropNetDNSSearchDomains

/*!
  @const kSCPropNetDNSSearchOrder
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSSearchOrder                           __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSSearchOrder kSCPropNetDNSSearchOrder

/*!
  @const kSCPropNetDNSServerAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSServerAddresses                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetDNSServerAddresses kSCPropNetDNSServerAddresses

/*!
  @const kSCPropNetDNSServerPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSServerPort                            __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSServerPort kSCPropNetDNSServerPort

/*!
  @const kSCPropNetDNSServerTimeout
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetDNSServerTimeout                         __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSServerTimeout kSCPropNetDNSServerTimeout

/*!
  @const kSCPropNetDNSSortList
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSortList                              __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetDNSSortList kSCPropNetDNSSortList

/*!
  @const kSCPropNetDNSSupplementalMatchDomains
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchDomains              __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSSupplementalMatchDomains kSCPropNetDNSSupplementalMatchDomains

/*!
  @const kSCPropNetDNSSupplementalMatchOrders
  @discussion Value is a CFArray[CFNumber]
 */
extern const CFStringRef kSCPropNetDNSSupplementalMatchOrders               __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetDNSSupplementalMatchOrders kSCPropNetDNSSupplementalMatchOrders

/*!
  @group kSCEntNetEthernet (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetEthernetMediaSubType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetEthernetMediaSubType                     __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetEthernetMediaSubType kSCPropNetEthernetMediaSubType

/*!
  @const kSCPropNetEthernetMediaOptions
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetEthernetMediaOptions                     __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetEthernetMediaOptions kSCPropNetEthernetMediaOptions

/*!
  @const kSCPropNetEthernetMTU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetEthernetMTU                              __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetEthernetMTU kSCPropNetEthernetMTU

/*!
  @group kSCEntNetFireWire (Hardware) Entity Keys
 */

/*!
  @group kSCEntNetInterface Entity Keys
 */

/*!
  @const kSCPropNetInterfaceDeviceName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceDeviceName                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetInterfaceDeviceName kSCPropNetInterfaceDeviceName

/*!
  @const kSCPropNetInterfaceHardware
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceHardware                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetInterfaceHardware kSCPropNetInterfaceHardware

/*!
  @const kSCPropNetInterfaceType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceType                            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetInterfaceType kSCPropNetInterfaceType

/*!
  @const kSCPropNetInterfaceSubType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetInterfaceSubType                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetInterfaceSubType kSCPropNetInterfaceSubType

/*!
  @const kSCPropNetInterfaceSupportsModemOnHold
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetInterfaceSupportsModemOnHold             __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_13,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetInterfaceSupportsModemOnHold kSCPropNetInterfaceSupportsModemOnHold

/*!
  @const kSCValNetInterfaceTypeEthernet
 */
extern const CFStringRef kSCValNetInterfaceTypeEthernet                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetInterfaceTypeEthernet kSCValNetInterfaceTypeEthernet

/*!
  @const kSCValNetInterfaceTypeFireWire
 */
extern const CFStringRef kSCValNetInterfaceTypeFireWire                     __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetInterfaceTypeFireWire kSCValNetInterfaceTypeFireWire

/*!
  @const kSCValNetInterfaceTypePPP
 */
extern const CFStringRef kSCValNetInterfaceTypePPP                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetInterfaceTypePPP kSCValNetInterfaceTypePPP

/*!
  @const kSCValNetInterfaceType6to4
 */
extern const CFStringRef kSCValNetInterfaceType6to4                         __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetInterfaceType6to4 kSCValNetInterfaceType6to4

/*!
  @const kSCValNetInterfaceTypeIPSec
 */
extern const CFStringRef kSCValNetInterfaceTypeIPSec                        __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCValNetInterfaceTypeIPSec kSCValNetInterfaceTypeIPSec

/*!
  @const kSCValNetInterfaceSubTypePPPoE
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPoE                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetInterfaceSubTypePPPoE kSCValNetInterfaceSubTypePPPoE

/*!
  @const kSCValNetInterfaceSubTypePPPSerial
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPPSerial                 __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetInterfaceSubTypePPPSerial kSCValNetInterfaceSubTypePPPSerial

/*!
  @const kSCValNetInterfaceSubTypePPTP
 */
extern const CFStringRef kSCValNetInterfaceSubTypePPTP                      __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_2,__MAC_10_12,__IPHONE_NA,__IPHONE_NA);
#define kSCValNetInterfaceSubTypePPTP kSCValNetInterfaceSubTypePPTP

/*!
  @const kSCValNetInterfaceSubTypeL2TP
 */
extern const CFStringRef kSCValNetInterfaceSubTypeL2TP                      __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetInterfaceSubTypeL2TP kSCValNetInterfaceSubTypeL2TP

/*!
  @group kSCEntNetIPSec Entity Keys
 */

/*!
  @const kSCPropNetIPSecAuthenticationMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecAuthenticationMethod                __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecAuthenticationMethod kSCPropNetIPSecAuthenticationMethod

/*!
  @const kSCPropNetIPSecLocalCertificate
  @discussion Value is a CFData
 */
extern const CFStringRef kSCPropNetIPSecLocalCertificate                    __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecLocalCertificate kSCPropNetIPSecLocalCertificate

/*!
  @const kSCPropNetIPSecLocalIdentifier
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecLocalIdentifier                     __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecLocalIdentifier kSCPropNetIPSecLocalIdentifier

/*!
  @const kSCPropNetIPSecLocalIdentifierType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecLocalIdentifierType                 __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecLocalIdentifierType kSCPropNetIPSecLocalIdentifierType

/*!
  @const kSCPropNetIPSecSharedSecret
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecSharedSecret                        __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecSharedSecret kSCPropNetIPSecSharedSecret

/*!
  @const kSCPropNetIPSecSharedSecretEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecSharedSecretEncryption              __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetIPSecSharedSecretEncryption kSCPropNetIPSecSharedSecretEncryption

/*!
  @const kSCPropNetIPSecConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetIPSecConnectTime                         __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecConnectTime kSCPropNetIPSecConnectTime

/*!
  @const kSCPropNetIPSecRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecRemoteAddress                       __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecRemoteAddress kSCPropNetIPSecRemoteAddress

/*!
  @const kSCPropNetIPSecStatus
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetIPSecStatus                              __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecStatus kSCPropNetIPSecStatus

/*!
  @const kSCPropNetIPSecXAuthEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetIPSecXAuthEnabled                        __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecXAuthEnabled kSCPropNetIPSecXAuthEnabled

/*!
  @const kSCPropNetIPSecXAuthName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthName                           __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecXAuthName kSCPropNetIPSecXAuthName

/*!
  @const kSCPropNetIPSecXAuthPassword
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthPassword                       __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecXAuthPassword kSCPropNetIPSecXAuthPassword

/*!
  @const kSCPropNetIPSecXAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPSecXAuthPasswordEncryption             __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCPropNetIPSecXAuthPasswordEncryption kSCPropNetIPSecXAuthPasswordEncryption

/*!
  @const kSCValNetIPSecAuthenticationMethodSharedSecret
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodSharedSecret     __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetIPSecAuthenticationMethodSharedSecret kSCValNetIPSecAuthenticationMethodSharedSecret

/*!
  @const kSCValNetIPSecAuthenticationMethodCertificate
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodCertificate      __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetIPSecAuthenticationMethodCertificate kSCValNetIPSecAuthenticationMethodCertificate

/*!
  @const kSCValNetIPSecAuthenticationMethodHybrid
 */
extern const CFStringRef kSCValNetIPSecAuthenticationMethodHybrid           __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetIPSecAuthenticationMethodHybrid kSCValNetIPSecAuthenticationMethodHybrid

/*!
  @const kSCValNetIPSecLocalIdentifierTypeKeyID
 */
extern const CFStringRef kSCValNetIPSecLocalIdentifierTypeKeyID             __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetIPSecLocalIdentifierTypeKeyID kSCValNetIPSecLocalIdentifierTypeKeyID

/*!
  @const kSCValNetIPSecSharedSecretEncryptionKeychain
 */
extern const CFStringRef kSCValNetIPSecSharedSecretEncryptionKeychain       __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetIPSecSharedSecretEncryptionKeychain kSCValNetIPSecSharedSecretEncryptionKeychain

/*!
  @const kSCValNetIPSecXAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetIPSecXAuthPasswordEncryptionKeychain      __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCValNetIPSecXAuthPasswordEncryptionKeychain kSCValNetIPSecXAuthPasswordEncryptionKeychain

/*!
  @const kSCValNetIPSecXAuthPasswordEncryptionPrompt
 */
extern const CFStringRef kSCValNetIPSecXAuthPasswordEncryptionPrompt        __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCValNetIPSecXAuthPasswordEncryptionPrompt kSCValNetIPSecXAuthPasswordEncryptionPrompt

/*!
  @group kSCEntNetIPv4 Entity Keys
 */

/*!
  @const kSCPropNetIPv4Addresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4Addresses                            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4Addresses kSCPropNetIPv4Addresses

/*!
  @const kSCPropNetIPv4ConfigMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4ConfigMethod                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4ConfigMethod kSCPropNetIPv4ConfigMethod

/*!
  @const kSCPropNetIPv4DHCPClientID
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4DHCPClientID                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4DHCPClientID kSCPropNetIPv4DHCPClientID

/*!
  @const kSCPropNetIPv4Router
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv4Router                               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4Router kSCPropNetIPv4Router

/*!
  @const kSCPropNetIPv4SubnetMasks
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4SubnetMasks                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4SubnetMasks kSCPropNetIPv4SubnetMasks

/*!
  @const kSCPropNetIPv4DestAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4DestAddresses                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4DestAddresses kSCPropNetIPv4DestAddresses

/*!
  @const kSCPropNetIPv4BroadcastAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv4BroadcastAddresses                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv4BroadcastAddresses kSCPropNetIPv4BroadcastAddresses

/*!
  @const kSCValNetIPv4ConfigMethodAutomatic
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodAutomatic                 __OSX_AVAILABLE_STARTING(__MAC_10_6,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodAutomatic kSCValNetIPv4ConfigMethodAutomatic

/*!
  @const kSCValNetIPv4ConfigMethodBOOTP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodBOOTP                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodBOOTP kSCValNetIPv4ConfigMethodBOOTP

/*!
  @const kSCValNetIPv4ConfigMethodDHCP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodDHCP                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodDHCP kSCValNetIPv4ConfigMethodDHCP

/*!
  @const kSCValNetIPv4ConfigMethodINFORM
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodINFORM                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodINFORM kSCValNetIPv4ConfigMethodINFORM

/*!
  @const kSCValNetIPv4ConfigMethodLinkLocal
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodLinkLocal                 __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodLinkLocal kSCValNetIPv4ConfigMethodLinkLocal

/*!
  @const kSCValNetIPv4ConfigMethodManual
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodManual                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodManual kSCValNetIPv4ConfigMethodManual

/*!
  @const kSCValNetIPv4ConfigMethodPPP
 */
extern const CFStringRef kSCValNetIPv4ConfigMethodPPP                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetIPv4ConfigMethodPPP kSCValNetIPv4ConfigMethodPPP

/*!
  @group kSCEntNetIPv6 Entity Keys
 */

/*!
  @const kSCPropNetIPv6Addresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv6Addresses                            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv6Addresses kSCPropNetIPv6Addresses

/*!
  @const kSCPropNetIPv6ConfigMethod
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv6ConfigMethod                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetIPv6ConfigMethod kSCPropNetIPv6ConfigMethod

/*!
  @const kSCPropNetIPv6DestAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetIPv6DestAddresses                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetIPv6DestAddresses kSCPropNetIPv6DestAddresses

/*!
  @const kSCPropNetIPv6Flags
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetIPv6Flags                                __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetIPv6Flags kSCPropNetIPv6Flags

/*!
  @const kSCPropNetIPv6PrefixLength
  @discussion Value is a CFArray[CFNumber]
 */
extern const CFStringRef kSCPropNetIPv6PrefixLength                         __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetIPv6PrefixLength kSCPropNetIPv6PrefixLength

/*!
  @const kSCPropNetIPv6Router
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetIPv6Router                               __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetIPv6Router kSCPropNetIPv6Router

/*!
  @const kSCValNetIPv6ConfigMethodAutomatic
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodAutomatic                 __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetIPv6ConfigMethodAutomatic kSCValNetIPv6ConfigMethodAutomatic

/*!
  @const kSCValNetIPv6ConfigMethodLinkLocal
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodLinkLocal                 __OSX_AVAILABLE_STARTING(__MAC_10_7,__IPHONE_NA);
#define kSCValNetIPv6ConfigMethodLinkLocal kSCValNetIPv6ConfigMethodLinkLocal

/*!
  @const kSCValNetIPv6ConfigMethodManual
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodManual                    __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetIPv6ConfigMethodManual kSCValNetIPv6ConfigMethodManual

/*!
  @const kSCValNetIPv6ConfigMethodRouterAdvertisement
 */
extern const CFStringRef kSCValNetIPv6ConfigMethodRouterAdvertisement       __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetIPv6ConfigMethodRouterAdvertisement kSCValNetIPv6ConfigMethodRouterAdvertisement

/*!
  @const kSCValNetIPv6ConfigMethod6to4
 */
extern const CFStringRef kSCValNetIPv6ConfigMethod6to4                      __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetIPv6ConfigMethod6to4 kSCValNetIPv6ConfigMethod6to4

/*!
  @group kSCEntNet6to4 Entity Keys
 */

/*!
  @const kSCPropNet6to4Relay
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNet6to4Relay                                __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNet6to4Relay kSCPropNet6to4Relay

/*!
  @group kSCEntNetLink Entity Keys
 */

/*!
  @const kSCPropNetLinkActive
  @discussion Value is a CFBoolean
 */
extern const CFStringRef kSCPropNetLinkActive                               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetLinkActive kSCPropNetLinkActive

/*!
  @const kSCPropNetLinkDetaching
  @discussion Value is a CFBoolean
 */
extern const CFStringRef kSCPropNetLinkDetaching                            __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetLinkDetaching kSCPropNetLinkDetaching

/*!
  @group kSCEntNetModem (Hardware) Entity Keys
 */

/*!
  @const kSCPropNetModemAccessPointName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemAccessPointName                     __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetModemAccessPointName kSCPropNetModemAccessPointName

/*!
  @const kSCPropNetModemConnectionPersonality
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemConnectionPersonality               __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetModemConnectionPersonality kSCPropNetModemConnectionPersonality

/*!
  @const kSCPropNetModemConnectionScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemConnectionScript                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemConnectionScript kSCPropNetModemConnectionScript

/*!
  @const kSCPropNetModemConnectSpeed
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemConnectSpeed                        __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemConnectSpeed kSCPropNetModemConnectSpeed

/*!
  @const kSCPropNetModemDataCompression
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemDataCompression                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemDataCompression kSCPropNetModemDataCompression

/*!
  @const kSCPropNetModemDeviceContextID
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceContextID                     __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetModemDeviceContextID kSCPropNetModemDeviceContextID

/*!
  @const kSCPropNetModemDeviceModel
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceModel                         __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetModemDeviceModel kSCPropNetModemDeviceModel

/*!
  @const kSCPropNetModemDeviceVendor
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDeviceVendor                        __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetModemDeviceVendor kSCPropNetModemDeviceVendor

/*!
  @const kSCPropNetModemDialMode
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemDialMode                            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemDialMode kSCPropNetModemDialMode

/*!
  @const kSCPropNetModemErrorCorrection
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemErrorCorrection                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemErrorCorrection kSCPropNetModemErrorCorrection

/*!
  @const kSCPropNetModemHoldCallWaitingAudibleAlert
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldCallWaitingAudibleAlert         __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemHoldCallWaitingAudibleAlert kSCPropNetModemHoldCallWaitingAudibleAlert

/*!
  @const kSCPropNetModemHoldDisconnectOnAnswer
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldDisconnectOnAnswer              __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemHoldDisconnectOnAnswer kSCPropNetModemHoldDisconnectOnAnswer

/*!
  @const kSCPropNetModemHoldEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldEnabled                         __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemHoldEnabled kSCPropNetModemHoldEnabled

/*!
  @const kSCPropNetModemHoldReminder
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemHoldReminder                        __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemHoldReminder kSCPropNetModemHoldReminder

/*!
  @const kSCPropNetModemHoldReminderTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemHoldReminderTime                    __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemHoldReminderTime kSCPropNetModemHoldReminderTime

/*!
  @const kSCPropNetModemNote
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetModemNote                                __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetModemNote kSCPropNetModemNote

/*!
  @const kSCPropNetModemPulseDial
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemPulseDial                           __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemPulseDial kSCPropNetModemPulseDial

/*!
  @const kSCPropNetModemSpeaker
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetModemSpeaker                             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemSpeaker kSCPropNetModemSpeaker

/*!
  @const kSCPropNetModemSpeed
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetModemSpeed                               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetModemSpeed kSCPropNetModemSpeed

/*!
  @const kSCValNetModemDialModeIgnoreDialTone
 */
extern const CFStringRef kSCValNetModemDialModeIgnoreDialTone               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetModemDialModeIgnoreDialTone kSCValNetModemDialModeIgnoreDialTone

/*!
  @const kSCValNetModemDialModeManual
 */
extern const CFStringRef kSCValNetModemDialModeManual                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetModemDialModeManual kSCValNetModemDialModeManual

/*!
  @const kSCValNetModemDialModeWaitForDialTone
 */
extern const CFStringRef kSCValNetModemDialModeWaitForDialTone              __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetModemDialModeWaitForDialTone kSCValNetModemDialModeWaitForDialTone

/*!
  @group kSCEntNetPPP Entity Keys
 */

/*!
  @const kSCPropNetPPPACSPEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPACSPEnabled                           __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetPPPACSPEnabled kSCPropNetPPPACSPEnabled

/*!
  @const kSCPropNetPPPConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPConnectTime                           __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPConnectTime kSCPropNetPPPConnectTime

/*!
  @const kSCPropNetPPPDeviceLastCause
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDeviceLastCause                       __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPDeviceLastCause kSCPropNetPPPDeviceLastCause

/*!
  @const kSCPropNetPPPDialOnDemand
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDialOnDemand                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPDialOnDemand kSCPropNetPPPDialOnDemand

/*!
  @const kSCPropNetPPPDisconnectOnFastUserSwitch
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnFastUserSwitch            __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetPPPDisconnectOnFastUserSwitch kSCPropNetPPPDisconnectOnFastUserSwitch

/*!
  @const kSCPropNetPPPDisconnectOnIdle
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdle                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPDisconnectOnIdle kSCPropNetPPPDisconnectOnIdle

/*!
  @const kSCPropNetPPPDisconnectOnIdleTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnIdleTimer                 __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPDisconnectOnIdleTimer kSCPropNetPPPDisconnectOnIdleTimer

/*!
  @const kSCPropNetPPPDisconnectOnLogout
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnLogout                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPDisconnectOnLogout kSCPropNetPPPDisconnectOnLogout

/*!
  @const kSCPropNetPPPDisconnectOnSleep
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPDisconnectOnSleep                     __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPDisconnectOnSleep kSCPropNetPPPDisconnectOnSleep

/*!
  @const kSCPropNetPPPDisconnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPDisconnectTime                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetPPPDisconnectTime kSCPropNetPPPDisconnectTime

/*!
  @const kSCPropNetPPPIdleReminderTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPIdleReminderTimer                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPIdleReminderTimer kSCPropNetPPPIdleReminderTimer

/*!
  @const kSCPropNetPPPIdleReminder
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIdleReminder                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPIdleReminder kSCPropNetPPPIdleReminder

/*!
  @const kSCPropNetPPPLastCause
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLastCause                             __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPLastCause kSCPropNetPPPLastCause

/*!
  @const kSCPropNetPPPLogfile
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPLogfile                               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLogfile kSCPropNetPPPLogfile

/*!
  @const kSCPropNetPPPPlugins
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPPlugins                               __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPPlugins kSCPropNetPPPPlugins

/*!
  @const kSCPropNetPPPRetryConnectTime
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPRetryConnectTime                      __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetPPPRetryConnectTime kSCPropNetPPPRetryConnectTime

/*!
  @const kSCPropNetPPPSessionTimer
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPSessionTimer                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPSessionTimer kSCPropNetPPPSessionTimer

/*!
  @const kSCPropNetPPPStatus
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPStatus                                __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPStatus kSCPropNetPPPStatus

/*!
  @const kSCPropNetPPPUseSessionTimer
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPUseSessionTimer                       __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPUseSessionTimer kSCPropNetPPPUseSessionTimer

/*!
  @const kSCPropNetPPPVerboseLogging
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPVerboseLogging                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPVerboseLogging kSCPropNetPPPVerboseLogging

/*!
  @const kSCPropNetPPPAuthEAPPlugins
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPAuthEAPPlugins                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetPPPAuthEAPPlugins kSCPropNetPPPAuthEAPPlugins

/*!
  @const kSCPropNetPPPAuthName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthName                              __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPAuthName kSCPropNetPPPAuthName

/*!
  @const kSCPropNetPPPAuthPassword
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPassword                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPAuthPassword kSCPropNetPPPAuthPassword

/*!
  @const kSCPropNetPPPAuthPasswordEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPasswordEncryption                __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPAuthPasswordEncryption kSCPropNetPPPAuthPasswordEncryption

/*!
  @const kSCPropNetPPPAuthPrompt
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPAuthPrompt                            __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetPPPAuthPrompt kSCPropNetPPPAuthPrompt

/*!
  @const kSCPropNetPPPAuthProtocol
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetPPPAuthProtocol                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPAuthProtocol kSCPropNetPPPAuthProtocol

/*!
  @const kSCValNetPPPAuthPasswordEncryptionKeychain
 */
extern const CFStringRef kSCValNetPPPAuthPasswordEncryptionKeychain         __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthPasswordEncryptionKeychain kSCValNetPPPAuthPasswordEncryptionKeychain

/*!
  @const kSCValNetPPPAuthPasswordEncryptionToken
 */
extern const CFStringRef kSCValNetPPPAuthPasswordEncryptionToken            __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetPPPAuthPasswordEncryptionToken kSCValNetPPPAuthPasswordEncryptionToken

/*!
  @const kSCValNetPPPAuthPromptBefore
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthPromptBefore                       __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthPromptBefore kSCValNetPPPAuthPromptBefore

/*!
  @const kSCValNetPPPAuthPromptAfter
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthPromptAfter                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthPromptAfter kSCValNetPPPAuthPromptAfter

/*!
  @const kSCValNetPPPAuthProtocolCHAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolCHAP                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetPPPAuthProtocolCHAP kSCValNetPPPAuthProtocolCHAP

/*!
  @const kSCValNetPPPAuthProtocolEAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolEAP                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthProtocolEAP kSCValNetPPPAuthProtocolEAP

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP1
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP1                    __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthProtocolMSCHAP1 kSCValNetPPPAuthProtocolMSCHAP1

/*!
  @const kSCValNetPPPAuthProtocolMSCHAP2
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolMSCHAP2                    __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetPPPAuthProtocolMSCHAP2 kSCValNetPPPAuthProtocolMSCHAP2

/*!
  @const kSCValNetPPPAuthProtocolPAP
  @discussion Value is a CFString
 */
extern const CFStringRef kSCValNetPPPAuthProtocolPAP                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCValNetPPPAuthProtocolPAP kSCValNetPPPAuthProtocolPAP

/*!
  @const kSCPropNetPPPCommAlternateRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommAlternateRemoteAddress            __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommAlternateRemoteAddress kSCPropNetPPPCommAlternateRemoteAddress

/*!
  @const kSCPropNetPPPCommConnectDelay
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommConnectDelay                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommConnectDelay kSCPropNetPPPCommConnectDelay

/*!
  @const kSCPropNetPPPCommDisplayTerminalWindow
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommDisplayTerminalWindow             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommDisplayTerminalWindow kSCPropNetPPPCommDisplayTerminalWindow

/*!
  @const kSCPropNetPPPCommRedialCount
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommRedialCount                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommRedialCount kSCPropNetPPPCommRedialCount

/*!
  @const kSCPropNetPPPCommRedialEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommRedialEnabled                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommRedialEnabled kSCPropNetPPPCommRedialEnabled

/*!
  @const kSCPropNetPPPCommRedialInterval
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPCommRedialInterval                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommRedialInterval kSCPropNetPPPCommRedialInterval

/*!
  @const kSCPropNetPPPCommRemoteAddress
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommRemoteAddress                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommRemoteAddress kSCPropNetPPPCommRemoteAddress

/*!
  @const kSCPropNetPPPCommTerminalScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetPPPCommTerminalScript                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPCommTerminalScript kSCPropNetPPPCommTerminalScript

/*!
  @const kSCPropNetPPPCommUseTerminalScript
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCommUseTerminalScript                 __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPCommUseTerminalScript kSCPropNetPPPCommUseTerminalScript

/*!
  @const kSCPropNetPPPCCPEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPEnabled                            __OSX_AVAILABLE_STARTING(__MAC_10_2,__IPHONE_NA);
#define kSCPropNetPPPCCPEnabled kSCPropNetPPPCCPEnabled

/*!
  @const kSCPropNetPPPCCPMPPE40Enabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE40Enabled                      __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetPPPCCPMPPE40Enabled kSCPropNetPPPCCPMPPE40Enabled

/*!
  @const kSCPropNetPPPCCPMPPE128Enabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPCCPMPPE128Enabled                     __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetPPPCCPMPPE128Enabled kSCPropNetPPPCCPMPPE128Enabled

/*!
  @const kSCPropNetPPPIPCPCompressionVJ
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIPCPCompressionVJ                     __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPIPCPCompressionVJ kSCPropNetPPPIPCPCompressionVJ

/*!
  @const kSCPropNetPPPIPCPUsePeerDNS
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPIPCPUsePeerDNS                        __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetPPPIPCPUsePeerDNS kSCPropNetPPPIPCPUsePeerDNS

/*!
  @const kSCPropNetPPPLCPEchoEnabled
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPEchoEnabled                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPEchoEnabled kSCPropNetPPPLCPEchoEnabled

/*!
  @const kSCPropNetPPPLCPEchoFailure
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPEchoFailure                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPEchoFailure kSCPropNetPPPLCPEchoFailure

/*!
  @const kSCPropNetPPPLCPEchoInterval
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPEchoInterval                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPEchoInterval kSCPropNetPPPLCPEchoInterval

/*!
  @const kSCPropNetPPPLCPCompressionACField
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionACField                 __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPCompressionACField kSCPropNetPPPLCPCompressionACField

/*!
  @const kSCPropNetPPPLCPCompressionPField
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetPPPLCPCompressionPField                  __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPCompressionPField kSCPropNetPPPLCPCompressionPField

/*!
  @const kSCPropNetPPPLCPMRU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPMRU                                __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPMRU kSCPropNetPPPLCPMRU

/*!
  @const kSCPropNetPPPLCPMTU
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPMTU                                __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPMTU kSCPropNetPPPLCPMTU

/*!
  @const kSCPropNetPPPLCPReceiveACCM
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPReceiveACCM                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPReceiveACCM kSCPropNetPPPLCPReceiveACCM

/*!
  @const kSCPropNetPPPLCPTransmitACCM
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetPPPLCPTransmitACCM                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetPPPLCPTransmitACCM kSCPropNetPPPLCPTransmitACCM

/*!
  @group kSCEntNetPPPoE Entity Keys
 */

/*!
  @group kSCEntNetPPPSerial Entity Keys
 */

/*!
  @group kSCEntNetL2TP Entity Keys
 */

/*!
  @const kSCPropNetL2TPIPSecSharedSecret
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecret                    __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetL2TPIPSecSharedSecret kSCPropNetL2TPIPSecSharedSecret

/*!
  @const kSCPropNetL2TPIPSecSharedSecretEncryption
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPIPSecSharedSecretEncryption          __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetL2TPIPSecSharedSecretEncryption kSCPropNetL2TPIPSecSharedSecretEncryption

/*!
  @const kSCPropNetL2TPTransport
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetL2TPTransport                            __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCPropNetL2TPTransport kSCPropNetL2TPTransport

/*!
  @const kSCValNetL2TPIPSecSharedSecretEncryptionKeychain
 */
extern const CFStringRef kSCValNetL2TPIPSecSharedSecretEncryptionKeychain   __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetL2TPIPSecSharedSecretEncryptionKeychain kSCValNetL2TPIPSecSharedSecretEncryptionKeychain

/*!
  @const kSCValNetL2TPTransportIP
 */
extern const CFStringRef kSCValNetL2TPTransportIP                           __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetL2TPTransportIP kSCValNetL2TPTransportIP

/*!
  @const kSCValNetL2TPTransportIPSec
 */
extern const CFStringRef kSCValNetL2TPTransportIPSec                        __OSX_AVAILABLE_STARTING(__MAC_10_3,__IPHONE_NA);
#define kSCValNetL2TPTransportIPSec kSCValNetL2TPTransportIPSec

/*!
  @group kSCEntNetProxies Entity Keys
 */

/*!
  @const kSCPropNetProxiesExceptionsList
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetProxiesExceptionsList                    __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesExceptionsList kSCPropNetProxiesExceptionsList

/*!
  @const kSCPropNetProxiesExcludeSimpleHostnames
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesExcludeSimpleHostnames            __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetProxiesExcludeSimpleHostnames kSCPropNetProxiesExcludeSimpleHostnames

/*!
  @const kSCPropNetProxiesFTPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesFTPEnable                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesFTPEnable kSCPropNetProxiesFTPEnable

/*!
  @const kSCPropNetProxiesFTPPassive
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesFTPPassive                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesFTPPassive kSCPropNetProxiesFTPPassive

/*!
  @const kSCPropNetProxiesFTPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesFTPPort                           __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesFTPPort kSCPropNetProxiesFTPPort

/*!
  @const kSCPropNetProxiesFTPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesFTPProxy                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesFTPProxy kSCPropNetProxiesFTPProxy

/*!
  @const kSCPropNetProxiesGopherEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesGopherEnable                      __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesGopherEnable kSCPropNetProxiesGopherEnable

/*!
  @const kSCPropNetProxiesGopherPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesGopherPort                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesGopherPort kSCPropNetProxiesGopherPort

/*!
  @const kSCPropNetProxiesGopherProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesGopherProxy                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesGopherProxy kSCPropNetProxiesGopherProxy

/*!
  @const kSCPropNetProxiesHTTPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesHTTPEnable                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPEnable kSCPropNetProxiesHTTPEnable

/*!
  @const kSCPropNetProxiesHTTPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesHTTPPort                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPPort kSCPropNetProxiesHTTPPort

/*!
  @const kSCPropNetProxiesHTTPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPProxy                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPProxy kSCPropNetProxiesHTTPProxy

/*!
  @const kSCPropNetProxiesHTTPSEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesHTTPSEnable                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPSEnable kSCPropNetProxiesHTTPSEnable

/*!
  @const kSCPropNetProxiesHTTPSPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesHTTPSPort                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPSPort kSCPropNetProxiesHTTPSPort

/*!
  @const kSCPropNetProxiesHTTPSProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesHTTPSProxy                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesHTTPSProxy kSCPropNetProxiesHTTPSProxy

/*!
  @const kSCPropNetProxiesRTSPEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesRTSPEnable                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesRTSPEnable kSCPropNetProxiesRTSPEnable

/*!
  @const kSCPropNetProxiesRTSPPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesRTSPPort                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesRTSPPort kSCPropNetProxiesRTSPPort

/*!
  @const kSCPropNetProxiesRTSPProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesRTSPProxy                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesRTSPProxy kSCPropNetProxiesRTSPProxy

/*!
  @const kSCPropNetProxiesSOCKSEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesSOCKSEnable                       __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesSOCKSEnable kSCPropNetProxiesSOCKSEnable

/*!
  @const kSCPropNetProxiesSOCKSPort
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropNetProxiesSOCKSPort                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesSOCKSPort kSCPropNetProxiesSOCKSPort

/*!
  @const kSCPropNetProxiesSOCKSProxy
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesSOCKSProxy                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropNetProxiesSOCKSProxy kSCPropNetProxiesSOCKSProxy

/*!
  @const kSCPropNetProxiesProxyAutoConfigEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigEnable             __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetProxiesProxyAutoConfigEnable kSCPropNetProxiesProxyAutoConfigEnable

/*!
  @const kSCPropNetProxiesProxyAutoConfigJavaScript
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigJavaScript         __OSX_AVAILABLE_STARTING(__MAC_10_7,__IPHONE_NA);
#define kSCPropNetProxiesProxyAutoConfigJavaScript kSCPropNetProxiesProxyAutoConfigJavaScript

/*!
  @const kSCPropNetProxiesProxyAutoConfigURLString
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoConfigURLString          __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetProxiesProxyAutoConfigURLString kSCPropNetProxiesProxyAutoConfigURLString

/*!
  @const kSCPropNetProxiesProxyAutoDiscoveryEnable
  @discussion Value is a CFNumber (0 or 1)
 */
extern const CFStringRef kSCPropNetProxiesProxyAutoDiscoveryEnable          __OSX_AVAILABLE_STARTING(__MAC_10_4,__IPHONE_NA);
#define kSCPropNetProxiesProxyAutoDiscoveryEnable kSCPropNetProxiesProxyAutoDiscoveryEnable

/*!
  @group kSCEntNetSMB Entity Keys
 */

/*!
  @const kSCPropNetSMBNetBIOSName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSName                           __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetSMBNetBIOSName kSCPropNetSMBNetBIOSName

/*!
  @const kSCPropNetSMBNetBIOSNodeType
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSNodeType                       __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetSMBNetBIOSNodeType kSCPropNetSMBNetBIOSNodeType

/*!
  @const kSCPropNetSMBNetBIOSScope
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBNetBIOSScope                          __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_5,__MAC_10_7,__IPHONE_NA,__IPHONE_NA);
#define kSCPropNetSMBNetBIOSScope kSCPropNetSMBNetBIOSScope

/*!
  @const kSCPropNetSMBWINSAddresses
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCPropNetSMBWINSAddresses                         __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetSMBWINSAddresses kSCPropNetSMBWINSAddresses

/*!
  @const kSCPropNetSMBWorkgroup
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropNetSMBWorkgroup                             __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCPropNetSMBWorkgroup kSCPropNetSMBWorkgroup

/*!
  @const kSCValNetSMBNetBIOSNodeTypeBroadcast
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeBroadcast               __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetSMBNetBIOSNodeTypeBroadcast kSCValNetSMBNetBIOSNodeTypeBroadcast

/*!
  @const kSCValNetSMBNetBIOSNodeTypePeer
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypePeer                    __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetSMBNetBIOSNodeTypePeer kSCValNetSMBNetBIOSNodeTypePeer

/*!
  @const kSCValNetSMBNetBIOSNodeTypeMixed
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeMixed                   __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetSMBNetBIOSNodeTypeMixed kSCValNetSMBNetBIOSNodeTypeMixed

/*!
  @const kSCValNetSMBNetBIOSNodeTypeHybrid
 */
extern const CFStringRef kSCValNetSMBNetBIOSNodeTypeHybrid                  __OSX_AVAILABLE_STARTING(__MAC_10_5,__IPHONE_NA);
#define kSCValNetSMBNetBIOSNodeTypeHybrid kSCValNetSMBNetBIOSNodeTypeHybrid

/*!
  @group kSCCompUsers Entity Keys
 */

/*!
  @const kSCEntUsersConsoleUser
 */
extern const CFStringRef kSCEntUsersConsoleUser                             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCEntUsersConsoleUser kSCEntUsersConsoleUser

/*!
  @group kSCCompSystem Properties
 */

/*!
  @const kSCPropSystemComputerName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropSystemComputerName                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropSystemComputerName kSCPropSystemComputerName

/*!
  @const kSCPropSystemComputerNameEncoding
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropSystemComputerNameEncoding                  __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCPropSystemComputerNameEncoding kSCPropSystemComputerNameEncoding

/*!
  @group SCDynamicStore "domain" prefixes
 */

/*!
  @const kSCDynamicStoreDomainFile
 */
extern const CFStringRef kSCDynamicStoreDomainFile                          __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStoreDomainFile kSCDynamicStoreDomainFile

/*!
  @const kSCDynamicStoreDomainPlugin
 */
extern const CFStringRef kSCDynamicStoreDomainPlugin                        __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStoreDomainPlugin kSCDynamicStoreDomainPlugin

/*!
  @const kSCDynamicStoreDomainSetup
 */
extern const CFStringRef kSCDynamicStoreDomainSetup                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStoreDomainSetup kSCDynamicStoreDomainSetup

/*!
  @const kSCDynamicStoreDomainState
 */
extern const CFStringRef kSCDynamicStoreDomainState                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStoreDomainState kSCDynamicStoreDomainState

/*!
  @const kSCDynamicStoreDomainPrefs
 */
extern const CFStringRef kSCDynamicStoreDomainPrefs                         __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStoreDomainPrefs kSCDynamicStoreDomainPrefs

/*!
  @group Preference ("location") Keys
 */

/*!
  @const kSCDynamicStorePropSetupCurrentSet
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropSetupCurrentSet                 __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropSetupCurrentSet kSCDynamicStorePropSetupCurrentSet

/*!
  @const kSCDynamicStorePropSetupLastUpdated
 */
extern const CFStringRef kSCDynamicStorePropSetupLastUpdated                __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropSetupLastUpdated kSCDynamicStorePropSetupLastUpdated

/*!
  @group Common/shared Keys
 */

/*!
  @const kSCDynamicStorePropNetInterfaces
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCDynamicStorePropNetInterfaces                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropNetInterfaces kSCDynamicStorePropNetInterfaces

/*!
  @const kSCDynamicStorePropNetPrimaryInterface
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryInterface             __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropNetPrimaryInterface kSCDynamicStorePropNetPrimaryInterface

/*!
  @const kSCDynamicStorePropNetPrimaryService
  @discussion Value is a CFString
 */
extern const CFStringRef kSCDynamicStorePropNetPrimaryService               __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropNetPrimaryService kSCDynamicStorePropNetPrimaryService

/*!
  @const kSCDynamicStorePropNetServiceIDs
  @discussion Value is a CFArray[CFString]
 */
extern const CFStringRef kSCDynamicStorePropNetServiceIDs                   __OSX_AVAILABLE_STARTING(__MAC_10_1,__IPHONE_NA);
#define kSCDynamicStorePropNetServiceIDs kSCDynamicStorePropNetServiceIDs

/*!
  @const kSCPropUsersConsoleUserName
  @discussion Value is a CFString
 */
extern const CFStringRef kSCPropUsersConsoleUserName                        __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_4,__IPHONE_NA,__IPHONE_NA);
#define kSCPropUsersConsoleUserName kSCPropUsersConsoleUserName

/*!
  @const kSCPropUsersConsoleUserUID
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropUsersConsoleUserUID                         __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_4,__IPHONE_NA,__IPHONE_NA);
#define kSCPropUsersConsoleUserUID kSCPropUsersConsoleUserUID

/*!
  @const kSCPropUsersConsoleUserGID
  @discussion Value is a CFNumber
 */
extern const CFStringRef kSCPropUsersConsoleUserGID                         __OSX_AVAILABLE_BUT_DEPRECATED(__MAC_10_1,__MAC_10_4,__IPHONE_NA,__IPHONE_NA);
#define kSCPropUsersConsoleUserGID kSCPropUsersConsoleUserGID

CF_ASSUME_NONNULL_END

#endif	/* _SCSCHEMADEFINITIONS_H */
