/*
 * Copyright (c) 2008-2012 Apple Inc. All rights reserved.
 *
 * @APPLE_APACHE_LICENSE_HEADER_START@
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @APPLE_APACHE_LICENSE_HEADER_END@
 */

#ifndef __DISPATCH_BASE__
#define __DISPATCH_BASE__

#ifndef __DISPATCH_INDIRECT__
#error "Please #include <dispatch/dispatch.h> instead of this file directly."
#endif

#ifndef __has_builtin
#define __has_builtin(x) 0
#endif
#ifndef __has_include
#define __has_include(x) 0
#endif
#ifndef __has_feature
#define __has_feature(x) 0
#endif
#ifndef __has_attribute
#define __has_attribute(x) 0
#endif
#ifndef __has_extension
#define __has_extension(x) 0
#endif

#if __GNUC__
#define DISPATCH_NORETURN __attribute__((__noreturn__))
#define DISPATCH_NOTHROW __attribute__((__nothrow__))
#define DISPATCH_NONNULL1 __attribute__((__nonnull__(1)))
#define DISPATCH_NONNULL2 __attribute__((__nonnull__(2)))
#define DISPATCH_NONNULL3 __attribute__((__nonnull__(3)))
#define DISPATCH_NONNULL4 __attribute__((__nonnull__(4)))
#define DISPATCH_NONNULL5 __attribute__((__nonnull__(5)))
#define DISPATCH_NONNULL6 __attribute__((__nonnull__(6)))
#define DISPATCH_NONNULL7 __attribute__((__nonnull__(7)))
#if __clang__ && __clang_major__ < 3
// rdar://problem/6857843
#define DISPATCH_NONNULL_ALL
#else
#define DISPATCH_NONNULL_ALL __attribute__((__nonnull__))
#endif
#define DISPATCH_SENTINEL __attribute__((__sentinel__))
#define DISPATCH_PURE __attribute__((__pure__))
#define DISPATCH_CONST __attribute__((__const__))
#define DISPATCH_WARN_RESULT __attribute__((__warn_unused_result__))
#define DISPATCH_MALLOC __attribute__((__malloc__))
#define DISPATCH_ALWAYS_INLINE __attribute__((__always_inline__))
#define DISPATCH_UNAVAILABLE __attribute__((__unavailable__))
#define DISPATCH_UNAVAILABLE_MSG(msg) __attribute__((__unavailable__(msg)))
#else
/*! @parseOnly */
#define DISPATCH_NORETURN
/*! @parseOnly */
#define DISPATCH_NOTHROW
/*! @parseOnly */
#define DISPATCH_NONNULL1
/*! @parseOnly */
#define DISPATCH_NONNULL2
/*! @parseOnly */
#define DISPATCH_NONNULL3
/*! @parseOnly */
#define DISPATCH_NONNULL4
/*! @parseOnly */
#define DISPATCH_NONNULL5
/*! @parseOnly */
#define DISPATCH_NONNULL6
/*! @parseOnly */
#define DISPATCH_NONNULL7
/*! @parseOnly */
#define DISPATCH_NONNULL_ALL
/*! @parseOnly */
#define DISPATCH_SENTINEL
/*! @parseOnly */
#define DISPATCH_PURE
/*! @parseOnly */
#define DISPATCH_CONST
/*! @parseOnly */
#define DISPATCH_WARN_RESULT
/*! @parseOnly */
#define DISPATCH_MALLOC
/*! @parseOnly */
#define DISPATCH_ALWAYS_INLINE
/*! @parseOnly */
#define DISPATCH_UNAVAILABLE
/*! @parseOnly */
#define DISPATCH_UNAVAILABLE_MSG(msg)
#endif

#ifdef __linux__
#define DISPATCH_LINUX_UNAVAILABLE() \
		DISPATCH_UNAVAILABLE_MSG( \
		"This interface is unavailable on linux systems")
#else
#define DISPATCH_LINUX_UNAVAILABLE()
#endif

#ifndef DISPATCH_ALIAS_V2
#if TARGET_OS_MAC
#define DISPATCH_ALIAS_V2(sym)	 __asm__("_" #sym "$V2")
#else
#define DISPATCH_ALIAS_V2(sym)
#endif
#endif

#if TARGET_OS_WIN32 && defined(__DISPATCH_BUILDING_DISPATCH__) && \
		defined(__cplusplus)
#define DISPATCH_EXPORT extern "C" extern __declspec(dllexport)
#elif TARGET_OS_WIN32 && defined(__DISPATCH_BUILDING_DISPATCH__)
#define DISPATCH_EXPORT extern __declspec(dllexport)
#elif TARGET_OS_WIN32 && defined(__cplusplus)
#define DISPATCH_EXPORT extern "C" extern __declspec(dllimport)
#elif TARGET_OS_WIN32
#define DISPATCH_EXPORT extern __declspec(dllimport)
#elif __GNUC__
#define DISPATCH_EXPORT extern __attribute__((visibility("default")))
#else
#define DISPATCH_EXPORT extern
#endif

#if __GNUC__
#define DISPATCH_INLINE static __inline__
#else
#define DISPATCH_INLINE static inline
#endif

#if __GNUC__
#define DISPATCH_EXPECT(x, v) __builtin_expect((x), (v))
#define dispatch_compiler_barrier()  __asm__ __volatile__("" ::: "memory")
#else
#define DISPATCH_EXPECT(x, v) (x)
#define dispatch_compiler_barrier()  do { } while (0)
#endif

#if __has_attribute(not_tail_called)
#define DISPATCH_NOT_TAIL_CALLED __attribute__((__not_tail_called__))
#else
#define DISPATCH_NOT_TAIL_CALLED
#endif

#if __has_builtin(__builtin_assume)
#define DISPATCH_COMPILER_CAN_ASSUME(expr) __builtin_assume(expr)
#else
#define DISPATCH_COMPILER_CAN_ASSUME(expr) ((void)(expr))
#endif

#if __has_attribute(noescape)
#define DISPATCH_NOESCAPE __attribute__((__noescape__))
#else
#define DISPATCH_NOESCAPE
#endif

#if __has_feature(assume_nonnull)
#define DISPATCH_ASSUME_NONNULL_BEGIN _Pragma("clang assume_nonnull begin")
#define DISPATCH_ASSUME_NONNULL_END   _Pragma("clang assume_nonnull end")
#else
#define DISPATCH_ASSUME_NONNULL_BEGIN
#define DISPATCH_ASSUME_NONNULL_END
#endif

#if !__has_feature(nullability)
#ifndef _Nullable
#define _Nullable
#endif
#ifndef _Nonnull
#define _Nonnull
#endif
#ifndef _Null_unspecified
#define _Null_unspecified
#endif
#endif

#ifndef DISPATCH_RETURNS_RETAINED_BLOCK
#if __has_attribute(ns_returns_retained)
#define DISPATCH_RETURNS_RETAINED_BLOCK __attribute__((__ns_returns_retained__))
#else
#define DISPATCH_RETURNS_RETAINED_BLOCK
#endif
#endif

#if __has_feature(objc_fixed_enum) || __has_extension(cxx_strong_enums)
#define DISPATCH_ENUM(name, type, ...) \
		typedef enum : type { __VA_ARGS__ } name##_t
#else
#define DISPATCH_ENUM(name, type, ...) \
		enum { __VA_ARGS__ }; typedef type name##_t
#endif

#if __has_feature(enumerator_attributes)
#define DISPATCH_ENUM_API_AVAILABLE(...) API_AVAILABLE(__VA_ARGS__)
#define DISPATCH_ENUM_API_DEPRECATED(...) API_DEPRECATED(__VA_ARGS__)
#define DISPATCH_ENUM_API_DEPRECATED_WITH_REPLACEMENT(...) \
		API_DEPRECATED_WITH_REPLACEMENT(__VA_ARGS__)
#else
#define DISPATCH_ENUM_API_AVAILABLE(...)
#define DISPATCH_ENUM_API_DEPRECATED(...)
#define DISPATCH_ENUM_API_DEPRECATED_WITH_REPLACEMENT(...)
#endif

#if defined(SWIFT_SDK_OVERLAY_DISPATCH_EPOCH) && \
		SWIFT_SDK_OVERLAY_DISPATCH_EPOCH >= 2
#define DISPATCH_SWIFT3_OVERLAY 1
#else
#define DISPATCH_SWIFT3_OVERLAY 0
#endif // SWIFT_SDK_OVERLAY_DISPATCH_EPOCH >= 2

#if __has_feature(attribute_availability_swift)
#define DISPATCH_SWIFT_UNAVAILABLE(_msg) \
		__attribute__((__availability__(swift, unavailable, message=_msg)))
#else
#define DISPATCH_SWIFT_UNAVAILABLE(_msg)
#endif

#if DISPATCH_SWIFT3_OVERLAY
#define DISPATCH_SWIFT3_UNAVAILABLE(_msg) DISPATCH_SWIFT_UNAVAILABLE(_msg)
#else
#define DISPATCH_SWIFT3_UNAVAILABLE(_msg)
#endif

#if __has_attribute(swift_private)
#define DISPATCH_REFINED_FOR_SWIFT __attribute__((__swift_private__))
#else
#define DISPATCH_REFINED_FOR_SWIFT
#endif

#if __has_attribute(swift_name)
#define DISPATCH_SWIFT_NAME(_name) __attribute__((__swift_name__(#_name)))
#else
#define DISPATCH_SWIFT_NAME(_name)
#endif

#ifndef __cplusplus
#define DISPATCH_TRANSPARENT_UNION __attribute__((__transparent_union__))
#else
#define DISPATCH_TRANSPARENT_UNION
#endif

typedef void (*dispatch_function_t)(void *_Nullable);

#endif
