'\"
'\" Generated from file '/BuildRoot/Library/Caches/com.apple.xbs/Sources/tcl/tcl-118.50.1/tcl_ext/tcllib/tcllib/modules/term/term_bind.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "term::receive::bind" n 0.1 term "Terminal control"
.BS
.SH NAME
term::receive::bind \- Keyboard dispatch from terminals
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBterm::receive::bind  ?0.1?\fR
.sp
\fBterm::receive::bind\fR \fIobject\fR ?\fImap\fR?
.sp
\fIobject\fR \fBmap\fR \fIstr\fR \fIcmd\fR
.sp
\fIobject\fR \fBdefault\fR \fIcmd\fR
.sp
\fIobject\fR \fBlisten\fR ?\fIchan\fR?
.sp
\fIobject\fR \fBunlisten\fR ?\fIchan\fR?
.sp
\fIobject\fR \fBreset\fR
.sp
\fIobject\fR \fBnext\fR \fIchar\fR
.sp
\fIobject\fR \fBprocess\fR \fIstr\fR
.sp
\fIobject\fR \fBeof\fR
.sp
.BE
.SH DESCRIPTION
This package provides a class for the creation of simple dispatchers
from character sequences to actions. Internally each dispatcher is in
essence a deterministic finite automaton with tree structure.
.SH "CLASS API"
The package exports a single command, the
class command, enabling the creation of
dispatcher instances. Its API
is:
.TP
\fBterm::receive::bind\fR \fIobject\fR ?\fImap\fR?
This command creates a new dispatcher object with the name
\fIobject\fR, initializes it, and returns the fully qualified name of
the object command as its result.
.sp
The argument is a dictionary mapping from strings, i.e. character
sequences to the command prefices to invoke when the sequence is found
in the input stream.
.PP
.SH "OBJECT API"
The objects created by the class command provide the methods listed
below:
.TP
\fIobject\fR \fBmap\fR \fIstr\fR \fIcmd\fR
This method adds an additional mapping from the string \fIstr\fR to
the action \fIcmd\fR. The mapping will take effect immediately
should the processor be in a prefix of \fIstr\fR, or at the next
reset operation. The action is a command prefix and will be invoked
with one argument appended to it, the character sequence causing
the invokation. It is executed in the global namespace.
.TP
\fIobject\fR \fBdefault\fR \fIcmd\fR
This method defines a default action \fIcmd\fR which will be invoked
whenever an unknown character sequence is encountered. The command
prefix is handled in the same as the regular action defined via
method \fBmap\fR.
.TP
\fIobject\fR \fBlisten\fR ?\fIchan\fR?
This methods sets up a filevent listener for the channel with handle
\fIchan\fR and invokes the dispatcher object whenever characters have
been received, or EOF was reached.
.sp
If not specified \fIchan\fR defaults to \fBstdin\fR.
.TP
\fIobject\fR \fBunlisten\fR ?\fIchan\fR?
This methods removes the filevent listener for the channel with handle
\fIchan\fR.
.sp
If not specified \fIchan\fR defaults to \fBstdin\fR.
.TP
\fIobject\fR \fBreset\fR
This method resets the character processor
to the beginning of the tree.
.TP
\fIobject\fR \fBnext\fR \fIchar\fR
This method causes the character processor to process the character
\fIc\fR. This may simply advance the internal state, or invoke an
associated action for a recognized sequence.
.TP
\fIobject\fR \fBprocess\fR \fIstr\fR
This method causes the character processor to process the character
sequence \fIstr\fR, advancing the internal state and invoking action
as necessary. This is a callback for \fBlisten\fR.
.TP
\fIobject\fR \fBeof\fR
This method causes the character processor to handle EOF on the
input. This is currently no-op.
This is a callback for \fBlisten\fR.
.PP
.SH NOTES
The simplicity of the DFA means that it is not possible to recognize a
character sequence with has a another recognized character sequence as
its prefix.
.PP
In other words, the set of recognized strings has to form a
\fIprefix code\fR.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIterm\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
character input, control, dispatcher, listener, receiver, terminal
.SH CATEGORY
Terminal control
.SH COPYRIGHT
.nf
Copyright (c) 2006 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi