/*
 * Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009 Apple Inc. All rights reserved.
 * Copyright (C) 2006 Samuel Weinig <sam.weinig@gmail.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#import <WebKit/DOMStyleSheet.h>

@class DOMCSSRule;
@class DOMCSSRuleList;
@class NSString;

NS_CLASS_AVAILABLE_MAC(10_4)
@interface DOMCSSStyleSheet : DOMStyleSheet
@property (readonly, strong) DOMCSSRule *ownerRule;
@property (readonly, strong) DOMCSSRuleList *cssRules;
@property (readonly, strong) DOMCSSRuleList *rules NS_AVAILABLE_MAC(10_6);

- (unsigned)insertRule:(NSString *)rule index:(unsigned)index NS_AVAILABLE_MAC(10_5);
- (void)deleteRule:(unsigned)index;
- (int)addRule:(NSString *)selector style:(NSString *)style index:(unsigned)index NS_AVAILABLE_MAC(10_6);
- (void)removeRule:(unsigned)index NS_AVAILABLE_MAC(10_6);
@end

@interface DOMCSSStyleSheet (DOMCSSStyleSheetDeprecated)
- (unsigned)insertRule:(NSString *)rule :(unsigned)index NS_DEPRECATED_MAC(10_4, 10_5);
@end
