'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/grammar_fa/dexec.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\" Copyright (c) 2007 Bogdan <rftghost@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "grammar::fa::dexec" n 0.2 grammar_fa "Finite automaton operations and usage"
.BS
.SH NAME
grammar::fa::dexec \- Execute deterministic finite automatons
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBsnit \fR
.sp
package require \fBgrammar::fa::dexec  ?0.2?\fR
.sp
\fB::grammar::fa::dexec\fR \fIdaName\fR \fIfa\fR ?\fB-any\fR \fIany\fR? ?\fB-command\fR \fIcmdprefix\fR?
.sp
\fBdaName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIdaName\fR \fBdestroy\fR
.sp
\fIdaName\fR \fBput\fR \fIsymbol\fR
.sp
\fIdaName\fR \fBreset\fR
.sp
\fIdaName\fR \fBstate\fR
.sp
\fIcmdprefix\fR \fBerror\fR \fIcode\fR \fImessage\fR
.sp
\fIcmdprefix\fR \fBfinal\fR \fIstateid\fR
.sp
\fIcmdprefix\fR \fBreset\fR
.sp
\fIcmdprefix\fR \fBstate\fR \fIstateid\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a class for executors constructed from
deterministic \fIfinite automatons\fR (DFA). Executors are objects
which are given a string of symbols in a piecemal fashion, perform
state transitions and report back when they enter a final state, or
find an error in the input.
For the actual creation of the DFAs the executors are based on we have
the packages \fBgrammar::fa\fR and \fBgrammar::fa::op\fR.
.PP
The objects follow a push model. Symbols are pushed into the executor,
and when something important happens, i.e. error occurs, a state transition,
or a final state is entered this will be reported via the callback
specified via the option \fB-command\fR. Note that conversion of
this into a pull model where the environment retrieves messages from
the object and the object uses a callback to ask for more symbols is
a trivial thing.
.PP
\fISide note\fR:
The acceptor objects provided by \fBgrammar::fa::dacceptor\fR
could have been implemented on top of the executors provided here, but
were not, to get a bit more performance (we avoid a number of method
calls and the time required for their dispatch).
.PP
.SH API
The package exports the API described here.
.TP
\fB::grammar::fa::dexec\fR \fIdaName\fR \fIfa\fR ?\fB-any\fR \fIany\fR? ?\fB-command\fR \fIcmdprefix\fR?
Creates a new deterministic executor with an associated global Tcl
command whose name is \fIdaName\fR. This command may be used to invoke
various operations on the executor. It has the following general form:
.RS
.TP
\fBdaName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command. See section \fBEXECUTOR METHODS\fR for more
explanations.
.sp
The executor will be based on the deterministic finite automaton
stored in the object \fIfa\fR. It will keep a copy of the relevant
data of the FA in its own storage, in a form easy to use for its
purposes. This also means that changes made to the \fIfa\fR after the
construction of the executor \fIwill not\fR influence the executor.
.sp
If \fIany\fR has been specified, then the executor will convert all
symbols in the input which are unknown to the base FA to that symbol
before proceeding with the processing.
.RE
.PP
.SH "EXECUTOR METHODS"
.PP
All executors provide the following methods for their manipulation:
.TP
\fIdaName\fR \fBdestroy\fR
Destroys the automaton, including its storage space and associated
command.
.TP
\fIdaName\fR \fBput\fR \fIsymbol\fR
Takes the current state of the executor and the \fIsymbol\fR and
performs the appropriate state transition. Reports any errors
encountered via the command callback, as well as entering a final
state of the underlying FA.
.sp
When an error is reported all further invokations of \fBput\fR will
do nothing, until the error condition has been cleared via an
invokation of method \fBreset\fR.
.TP
\fIdaName\fR \fBreset\fR
Unconditionally sets the executor into the start state of the
underlying FA. This also clears any error condition  \fBput\fR may
have encountered.
.TP
\fIdaName\fR \fBstate\fR
Returns the current state of the underlying FA. This allow for
introspection without the need to pass data from the callback command.
.PP
.SH "EXECUTOR CALLBACK"
The callback command \fIcmdprefix\fR given to an executor via the
option \fB-command\fR will be executed by the object at the global
level, using the syntax described below. Note that \fIcmdprefix\fR is
not simply the name of a command, but a full command prefix. In other
words it may contain additional fixed argument words beyond the
command word.
.TP
\fIcmdprefix\fR \fBerror\fR \fIcode\fR \fImessage\fR
The executor has encountered an error, and \fImessage\fR contains a
human-readable text explaining the nature of the problem.
The \fIcode\fR on the other hand is a fixed machine-readable text.
The following error codes can be generated by executor objects.
.RS
.TP
\fBBADSYM\fR
An unknown symbol was found in the input. This can happen if and only
if no \fB-any\fR symbol was specified.
.TP
\fBBADTRANS\fR
The underlying FA has no transition for the current combination of
input symbol and state. In other words, the executor was not able to
compute a new state for this combination.
.RE
.TP
\fIcmdprefix\fR \fBfinal\fR \fIstateid\fR
The executor has entered the final state \fIstateid\fR.
.TP
\fIcmdprefix\fR \fBreset\fR
The executor was reset.
.TP
\fIcmdprefix\fR \fBstate\fR \fIstateid\fR
The FA changed state due to a transition. \fIstateid\fR is the new state.
.PP
.PP
.SH EXAMPLES
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIgrammar_fa\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
automaton, execution, finite automaton, grammar, parsing, regular expression, regular grammar, regular languages, running, state, transducer
.SH CATEGORY
Grammars and finite automata
.SH COPYRIGHT
.nf
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
Copyright (c) 2007 Bogdan <rftghost@users.sourceforge.net>

.fi