'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tklib/tklib/modules/diagrams/diagram.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "diagram" n 0.3 diagrams "Documentation toolbox"
.BS
.SH NAME
diagram \- Diagram drawing
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBTk  8.5\fR
.sp
package require \fBdiagram  1\fR
.sp
\fB::diagram\fR \fIobjectName\fR \fIcanvas\fR ?\fIscript\fR?
.sp
\fIdiagramObject\fR \fBnew direction\fR \fIname\fR ?\fIkey\fR \fIvalue\fR...?
.sp
\fIdiagramObject\fR \fBnew element\fR \fIname\fR \fIattributes\fR \fIcmdprefix\fR
.sp
\fIdiagramObject\fR \fBnew alias\fR \fIname\fR \fIcmdprefix\fR
.sp
\fIdiagramObject\fR \fBnew command\fR \fIname\fR \fIarguments\fR \fIbody\fR
.sp
\fIdiagramObject\fR \fBnew attribute\fR \fIname\fR ?\fIkey\fR \fIvalue\fR...?
.sp
\fIdiagramObject\fR \fBunknown attribute\fR \fIcmdprefix\fR
.sp
\fIdiagramObject\fR \fBdraw\fR \fIscript\fR
.sp
\fBarc\fR \fIattr\fR...
.sp
\fBarrow\fR \fIattr\fR...
.sp
\fB-->\fR \fIattr\fR...
.sp
\fB<-->\fR \fIattr\fR...
.sp
\fB<-->\fR \fIattr\fR...
.sp
\fBblock\fR \fIscript\fR \fIattr\fR...
.sp
\fBbox\fR \fIattr\fR...
.sp
\fBcircle\fR \fIattr\fR...
.sp
\fBO\fR \fIattr\fR...
.sp
\fBdiamond\fR \fIattr\fR...
.sp
\fB<>\fR \fIattr\fR...
.sp
\fBdrum\fR \fIattr\fR...
.sp
\fBellipse\fR \fIattr\fR...
.sp
\fBline\fR \fIattr\fR...
.sp
\fB--\fR \fIattr\fR...
.sp
\fBmove\fR \fIattr\fR
.sp
\fBspline\fR \fIattr\fR...
.sp
\fBtext\fR \fIattr\fR...
.sp
\fBwest\fR
.sp
\fBw\fR
.sp
\fBleft\fR
.sp
\fBl\fR
.sp
\fBsouth\fR
.sp
\fBs\fR
.sp
\fBdown\fR
.sp
\fBbottom\fR
.sp
\fBbot\fR
.sp
\fBb\fR
.sp
\fBeast\fR
.sp
\fBe\fR
.sp
\fBright\fR
.sp
\fBr\fR
.sp
\fBnorth\fR
.sp
\fBn\fR
.sp
\fBup\fR
.sp
\fBtop\fR
.sp
\fBt\fR
.sp
\fBnorthwest\fR
.sp
\fBnw\fR
.sp
\fBup-left\fR
.sp
\fBupleft\fR
.sp
\fBleftup\fR
.sp
\fBnortheast\fR
.sp
\fBne\fR
.sp
\fBup-right\fR
.sp
\fBupright\fR
.sp
\fBrightup\fR
.sp
\fBsouthwest\fR
.sp
\fBsw\fR
.sp
\fBdown-left\fR
.sp
\fBdownleft\fR
.sp
\fBleftdown\fR
.sp
\fBsoutheast\fR
.sp
\fBse\fR
.sp
\fBdown-right\fR
.sp
\fBdownright\fR
.sp
\fBrightdown\fR
.sp
\fInumber\fR \fBcm\fR
.sp
\fInumber\fR \fBmm\fR
.sp
\fInumber\fR \fBinch\fR
.sp
\fInumber\fR \fBpt\fR
.sp
\fInumber\fR \fInumber\fR
.sp
\fBby\fR \fIdistance\fR \fIdirection\fR
.sp
\fIpoint1\fR \fB+\fR \fIpoint2\fR
.sp
\fIpoint1\fR \fB-\fR \fIpoint2\fR
.sp
\fIpoint\fR \fBby\fR \fIdistance\fR \fIdirection\fR
.sp
\fIpoint1\fR \fB|\fR \fIpoint2\fR
.sp
\fIn\fR \fBbetween\fR \fIpoin1\fR \fIpoint2\fR
.sp
\fBintersect\fR \fIelem1\fR \fIelem2\fR
.sp
\fIelement\fR \fBnames\fR ?\fIpattern\fR?
.sp
\fIelement\fR \fIcorner\fR
.sp
\fIelement\fR \fIcorner1\fR \fIcorner2\fR...
.sp
\fIelement\fR ?\fIcorner1\fR... ?\fBnames\fR ?\fIpattern\fR??]?
.sp
\fB\fBn\fRth\fR ?\fIcorner\fR?
.sp
\fB\fBn\fRth\fR \fBlast\fR ?\fIcorner\fR?
.sp
\fB\fBn\fRth\fR \fIshape\fR ?\fIcorner\fR?
.sp
\fB\fBn\fRth\fR \fBlast\fR \fIshape\fR ?\fIcorner\fR?
.sp
\fBlast\fR ?\fIcorner\fR?
.sp
\fBlast\fR \fIshape\fR ?\fIcorner\fR?
.sp
\fB1st\fR
.sp
\fB2nd\fR
.sp
\fB3rd\fR
.sp
.BE
.SH DESCRIPTION
Welcome to \fBdiagram\fR, a package for the easy construction of
diagrams (sic), i.e. 2D vector graphics, sometimes also called \fIpictures\fR.
Note that this package is not a replacement for \fBTk\fR's canvas,
but rather a layer sitting on top of it, to make it easier to use.
In other words, using the canvas as the core graphics engine \fBdiagram\fR abstracts away from the minutiae of handling coordinates to
position and size the drawn elements, allowing the user to concentrate
on the content of the diagram instead.
.PP
This is similar to Brian Kernighan's PIC language for troff, which is
the spiritual ancestor of this package.
.PP
This document contains the reference to the API and drawing (language)
commands. Its intended audience are users of the package wishing to
refresh their memory.
Newcomers should read the \fIDiagram Language Tutorial\fR first.
Developers wishing to work on the internals of the package and its
supporting packages should look at section
\fBDiagram Classes\fR
first, and then the comments in the sources of the packages itself.
.PP
In the remainder of the document we first describe the APIs of the
diagram class and its instances, followed by the language reference
for the drawing language itself.
.SH API
.SS "CLASS API"
The package exports the API described here.
.TP
\fB::diagram\fR \fIobjectName\fR \fIcanvas\fR ?\fIscript\fR?
The command creates a new instance of a diagram
controller and returns the fully qualified name of the
object command as its result.
The new instance is connected to the specified
\fIcanvas\fR object, which is used as the diagrams
graphics engine. This is usually an instance of Tk's
canvas, however any object which is API compatible to
Tk's canvas can be used here.
.sp
The API of this object command is described in the
following section, \fBObject API\fR. It may be
used to invoke various operations on the object.
.sp
If the \fIscript\fR argument is specified then method
\fBdraw\fR will be invoked on it.
.PP
.SS "OBJECT API"
Instances of the diagram class support the following
methods:
.TP
\fIdiagramObject\fR \fBnew direction\fR \fIname\fR ?\fIkey\fR \fIvalue\fR...?
This method defines a new named direction and its
attributes. The latter is given through the
\fIkey\fR/\fIvalue\fR pairs coming after the \fIname\fR.
.sp
Users are mostly free to specify arbitrary attributes
with whatever meaning they desire. The exception are
the names \fIangle\fR and \fIopposite\fR. They are
special to the diagram package and have a fixed meaning.
.RS
.TP
angle
This attribute specifies the angle of the direction in
degrees, where 0 points east (to the right) and 90 points
north (up).
.TP
opposite
This attribute specifies the name of the direction
which should be considered as complementary to the
named one.
.RE
.TP
\fIdiagramObject\fR \fBnew element\fR \fIname\fR \fIattributes\fR \fIcmdprefix\fR
This method defines a new graphics element for the
drawing language. I.e. \fIname\fR will become a new
command in the language, and the specified command
prefix (\fIcmdprefix\fR) will be called to perform
the actual drawing.
.sp
\fIattributes\fR specifies the set of attributes for which
data has to be available. I.e. the system will run the
...-callbacks for these attributes.
See the method \fBnew attribute\fR for more information
on attribute definitions.
.sp
The command prefix is expected to conform to the
following signature:
.RS
.TP
\fBcmdprefix\fR \fIcanvas\fR \fIattributes\fR
Where \fIcanvas\fR is the handle of the canvas widget
to draw to, and \fIattributes\fR is a dictionary
holding the attributes for the element, be they
user-specified, or defaults.
.sp
The results of the command has to be a list containing
at least two and at most four items. These are, in order:
.RS
.IP [1]
The list of canvas items the drawn element consists of.
.IP [2]
The dictionary of named locations in the element, its
\fIcorners\fR.
.IP [3]
An optional mode, either "relative" or "absolute".
When not returned "relative" is assumed. In the
case of a relative element position the attributes
"with" and "at" are used to determine the final
position of the new element.
.IP [4]
An optional name of a direction. If not the
empty string this is handed to the automatic
layouter as the new direction to follow.
.RE
.RE
.TP
\fIdiagramObject\fR \fBnew alias\fR \fIname\fR \fIcmdprefix\fR
This method defines a new command for the drawing
language. I.e. \fIname\fR will become a new command in
the language, and the specified command prefix
(\fIcmdprefix\fR) will be called on use of this new
command. Any arguments given to the command are
simply passed to the prefix. There is no fixed siganture.
.sp
Note that the prefix is run in the context of the
drawing language, allowing the direct use of any
existing commands.
.TP
\fIdiagramObject\fR \fBnew command\fR \fIname\fR \fIarguments\fR \fIbody\fR
This is like \fBnew alias\fR except that the new
command is defined as a procedure in the language's
context, with regular argument list and body.
.TP
\fIdiagramObject\fR \fBnew attribute\fR \fIname\fR ?\fIkey\fR \fIvalue\fR...?
This method defines a new named attribute which can be
used by graphical elements. The handling of the
attribute by the processor is declared through the
\fIkey\fR/\fIvalue\fR pairs coming after the \fIname\fR.
.sp
The accepted keys and their meanings are:
.RS
.TP
\fBkey\fR
The value of this key is the name of the key
under which the attribute's value shall be
stored in the attribute dictionary given to
the drawing command after attribute processing
is complete.
.sp
This key is optional. If it is not specified it
defaults to the name of the attribute.
.TP
\fBget\fR
The value of this key is a command prefix
which will be invoked to retrieve the
attribute's argument(s) from the command
line.
.sp
This key is optional. If it is not specified a
default is used which takes the single word
after the attribute name as the attribute's
value.
.sp
The signature of the command prefix is
.RS
.TP
\fBcmdprefix\fR \fIwordqueue\fR
Where \fIwordqueue\fR is the handle of
a queue object conforming to the API
of the queues provided by package
\fBstruct::queue\fR. This queue
contains the not-yet-processed part of
the attribute definitions, with one
entry per word, with the first entry
the word \fIafter\fR name of the
attribute. In other words, the
attribute's name has already been
removed from the queue.
.sp
The result of the command is the value
of the attribute, which may have been
taken from the queue, or not.
.RE
.TP
\fBtransform\fR
The value of this key is a command prefix
which will be invoked to transform the
retrieved value (See \fBget\fR) into their
final form.
.sp
This key is optional. If it is not specified
no transformation is done.
The signature of the command prefix is
.RS
.TP
\fBcmdprefix\fR \fIvalue\fR
Where \fIvalue\fR is the value to transform.
.sp
The result of the command is the final
value of the attribute.
.RE
.TP
\fBtype\fR
The value of this key is a command prefix
which will be invoked to validate the
attribute's argument(s).
.sp
This key is optional. If it is not specified
no validation is done.
.sp
The signature of the command prefix is that of
snit validation types. See the documentation
of the \fBsnit\fR package.
.TP
\fBmerge\fR
The value of this key is a command prefix
which will be invoked to insert the
transformed and validated attribute value into
the dictionary of collected attributes.
.sp
This key is optional. If it is not specified
a default merge is chosen, based on the data
for key \fBaggregate\fR, see below.
The signature of the command prefix is
.RS
.TP
\fBcmdprefix\fR \fIvalue\fR \fIdict\fR
Where \fIvalue\fR is the value to
insert, and \fIdict\fR the dictionary
of attributes and values collected so
far.
.sp
The result of the command is the new
dictionary of attributes.
.RE
.TP
\fBaggregate\fR
The value of this key is a boolean flag. It
has an effect if and only if the key \fBmerge\fR was not specified. This key is
optional. If it is not specified it defaults
to \fBFalse\fR.
.sp
If the key is effective, the value of \fBFalse\fR means that the attribute's value is
\fIset\fR into the dictionary using the value
of key \fIkey\fR (see above) as index,
\fIoverwriting\fR any previously specified value.
.sp
If the key is effective, the value of \fBTrue\fR means that the attribute's value is
\fIadded\fR to the dictionary using the value
of key \fIkey\fR (see above) as index,
\fIextending\fR any previously specified value.
This means that the final value of the
attribute as seen after processing will be a
list of the collected values.
.TP
\fBdefault\fR
The value of this key is a command prefix
which will be invoked after collection of
attributes has been completed and this
attribute is in the list of required
attributes for the drawing element (See
argument \fIattributes\fR of method
\fBnew element\fR).
.sp
Note that the connection is made through the
value of key \fIkey\fR, not through the
attribute name per se.
.sp
Further note that this command prefix is
invoked even if a user specified attribute
value is present. This allows the command
to go beyond simply setting defaults, it
can calculate and store derived values as
well.
.sp
This key is optional. If an element requires
this attribute, but \fIdefault\fR is not
specified then nothing will be done.
.sp
The signature of the command prefix is
.RS
.TP
\fBcmdprefix\fR \fBinit\fR
This method is run when the attribute
is defined, its responsibility is to
initialize anything in the language
namespace for the attribute and
default processing.
.sp
The result of this method is ignored.
.TP
\fBcmdprefix\fR \fBfill\fR \fIvarname\fR
This method is run to put defaults, or
derived values into the attribute dictionary
named by \fIvarname\fR. This variable will
be found in the calling context.
.sp
The result of this method is ignored.
.TP
\fBcmdprefix\fR \fBset\fR \fIname\fR \fIvalue\fR
This method is run to push current a
attribute value into the language
namespace, to make it the new default.
.sp
The result of this method is ignored.
.RE
.TP
\fBlinked\fR
This key is effective if and only if key
\fBdefault\fR is not specified. In that
case is supplies a default handling for
\fBdefault\fR, linking the attribute to a
variable in the language context.
.sp
The value for this key is a 2-element list
containing the name of the variable to link
to, and its initial value, in this order.
.RE
.TP
\fIdiagramObject\fR \fBunknown attribute\fR \fIcmdprefix\fR
This method registers the command prefix with the
subsystem processing the attributes for element
commands, telling it to call it when it encounters an
attribute it is unable to handle on its on.
.sp
It is allowed to register more than callback, these
will be called in order of registration (i.e. first to
last), until one of the callbacks accepts the current
input.
The command prefix is expected to conform to the
following signature:
.RS
.TP
\fBcmdprefix\fR \fIwordqueue\fR
Where \fIwordqueue\fR is the handle of a queue
object conforming to the API of the queues
provided by package \fBstruct::queue\fR.
This queue contains the not-yet-processed part
of the attribute definitions, with one entry
per word, with the first entry the name of the
attribute which could not be processed.
.sp
The results of the command has to be a boolean
value where \fBTrue\fR signals that this
callback has accepted the attribute, processed
it, and the new state of the \fIwordqueue\fR
is where the general processing shall continue.
.sp
Given the signature the command has basically
two ways of handling (rewriting) the attributes
it recognizes:
.RS
.IP [1]
Replace the attribute (and arguments)
with a different attribute and arguments.
.IP [2]
Push additional words in front to get
the general processing unstuck.
.RE
.RE
.TP
\fIdiagramObject\fR \fBdraw\fR \fIscript\fR
This method runs the given \fIscript\fR in the
context of the drawing language definitions.
See section \fBLanguage Reference\fR for
details on the available commands.
.sp
\fINote\fR that \fIscript\fR is \fItrusted\fR.
It is executed in the current interpreter with
access to its full abilities.
For the execution of untrusted diagram scripts this
interpreter should be a safe one.
.PP
.SH "LANGUAGE REFERENCE"
.SS ELEMENTS
This section lists the commands for the predefined drawing elements,
aka shapes. These commands are all defined in the language's context.
All commands of this section return the handle of the newly created
element as their result. This handle also exists as a command which
can be used to query the element for its corners (names, values).
See section \fBMiscellaneous Commands\fR.
IMAGE: figure-02-basic-shapes
.TP
\fBarc\fR \fIattr\fR...
IMAGE: figure-02-arc
An open element with the corresponding corners, i.e. "start", "end",
and "center".
Note however that it also has the compass rose of closed elements as
its corners, with the center of the arc's circle as the center of the
compass and the other points on the circle the arc is part of.
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBclockwise\fR
.TP
\fBcw\fR
Specifies the direction of the \fBarc\fR element, here going
clockwise.
The complementary attribute is \fBcounterclockwise\fR.
If not specified the system falls back to the value taken from the
language variable \fBclockwise\fR, which itself defaults to
\fBfalse\fR, for counter-clockwise direction.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBcounterclockwise\fR
.TP
\fBccw\fR
Specifies the direction of the \fBarc\fR element, here
counter-clockwise.
The complementary attribute is \fBclockwise\fR.
If not specified the system falls back to the value taken from the
language variable \fBclockwise\fR, which itself defaults to
\fBfalse\fR, for counter-clockwise direction.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBfrom\fR \fIlocation\fR
Specifies the location where the \fBarc\fR element begins.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBradius\fR \fIlength\fR
Specifies the radius of the \fBarc\fR element, or rather, the radius
of the circle the shown arc is a part of.
If not specified the system falls back to the value taken from the
language variable \fBarcradius\fR, which itself defaults to the pixel
equivalent of \fB1 cm\fR.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBto\fR \fIlocation\fR
Specifies the location where the \fBarc\fR element ends.
Defaults to a location such that a 90-degree arc is drawn in the
chosen direction, starting at \fBfrom\fR.
.RE
.TP
\fBarrow\fR \fIattr\fR...
.TP
\fB-->\fR \fIattr\fR...
.TP
\fB<-->\fR \fIattr\fR...
.TP
\fB<-->\fR \fIattr\fR...
IMAGE: figure-02-arrow
An alias for the \fBline\fR element (see below), with the attribute
\fBarrowhead\fR preset to \fB->\fR, \fB<->\fR, or \fB<-\fR.  The
\fBarrow\fR is equivalent to \fB-->\fR.
.TP
\fBblock\fR \fIscript\fR \fIattr\fR...
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
The main effect is the aggregration of all elements created by the
\fIscript\fR into one element.
This also means that while the elements created by the script are
visible in the element history while the script is executing,
afterward the history contains only the block itself, and not the
elements it is composed of.
.sp
The script has access to the current state of all variables in the
language context.
Any changes to the variables will be reverted after execution of the
block.
However, also, any variables set in the script will be exported as
corners of the element, allowing users to define their own named
locations in the block.
.sp
Regarding the layout mechanism any changes made by the script are
reverted after the element is done.
In other words, a block is an implicit \fBgroup\fR.
.sp
Blocks handle all attributes, propgating their settings into the
script as the default values active during script execution.
.TP
\fBbox\fR \fIattr\fR...
IMAGE: figure-02-box
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBheight\fR \fIlength\fR
.TP
\fBht\fR \fIlength\fR
Specifies the height of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxheight\fR, which itself defaults to the
pixel equivalent of \fB2 cm\fR.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBslant\fR \fIangle\fR
Specifies the angle by which the \fBbox\fR element is slanted, in
degrees.
If not specified the system falls back to the value taken from the
language variable \fBslant\fR, which itself defaults to \fB90\fR,
i.e. vertical, no slant.
0 degrees is slanting straight east, pointing to the right.
90 degrees is slanting to the north, pointing straight up.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwidth\fR \fIlength\fR
.TP
\fBwid\fR \fIlength\fR
Specifies the width of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxwidth\fR, which itself defaults to the pixel
equivalent of \fB2 cm\fR.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.TP
\fBcircle\fR \fIattr\fR...
.TP
\fBO\fR \fIattr\fR...
IMAGE: figure-02-circle
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBdiameter\fR \fIlength\fR
.TP
\fBdiam\fR \fIlength\fR
Specifies the diameter of the \fBcircle\fR element, as an alternative
way to specify its \fBradius\fR.
Effective if and only if the radius was not specified. I.e. if both
diameter and radius are specified then the radius infomration has
precendence.
This attribute has no default, because the defaults are taken from the
radius.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBradius\fR \fIlength\fR
.TP
\fBrad\fR \fIlength\fR
Specifies the radius of the \fBcircle\fR element.
If not specified the system falls back to the value taken from the
language variable \fBcircleradius\fR, which itself defaults to the
pixel equivalent of \fB1 cm\fR.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.TP
\fBdiamond\fR \fIattr\fR...
.TP
\fB<>\fR \fIattr\fR...
IMAGE: figure-02-diamond
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBaspect\fR \fInumber\fR
Specifies the aspect ratio, i.e ratio of width to height, of the
\fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBwidth\fR and
\fBheight\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBheight\fR \fIlength\fR
Specifies the height of the \fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBaspect\fR and
\fBwidth\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwidth\fR \fIlength\fR
Specifies the width of the \fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBaspect\fR and
\fBheight\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.TP
\fBdrum\fR \fIattr\fR...
IMAGE: figure-02-drum
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBaspect\fR \fInumber\fR
Specifies the aspect ratio, i.e ratio of width to height, of the
ellipses which are used to draw the top and bottom of the \fBdrum\fR
element.
If not specified the system falls back to the value taken from the
language variable \fBdrumaspect\fR, which itself defaults to
\fB0.35\fR.
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBheight\fR \fIlength\fR
.TP
\fBht\fR \fIlength\fR
Specifies the height of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxheight\fR, which itself defaults to the
pixel equivalent of \fB2 cm\fR.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwidth\fR \fIlength\fR
.TP
\fBwid\fR \fIlength\fR
Specifies the width of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxwidth\fR, which itself defaults to the pixel
equivalent of \fB2 cm\fR.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.TP
\fBellipse\fR \fIattr\fR...
IMAGE: figure-02-ellipse
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBheight\fR \fIlength\fR
.TP
\fBht\fR \fIlength\fR
Specifies the height of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxheight\fR, which itself defaults to the
pixel equivalent of \fB2 cm\fR.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwidth\fR \fIlength\fR
.TP
\fBwid\fR \fIlength\fR
Specifies the width of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxwidth\fR, which itself defaults to the pixel
equivalent of \fB2 cm\fR.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.TP
\fBline\fR \fIattr\fR...
.TP
\fB--\fR \fIattr\fR...
IMAGE: figure-02-line
An open element with the corresponding corners, i.e. "start", "end",
and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBarrowhead\fR \fIspec\fR
IMAGE: figure-19-style-arrowheads
Specifies where to draw arrowheads on the \fBline\fR element, at the
beginning or end, at both ends, or none.
If not specified the system falls back to the value taken from the
language variable \fBarrowhead\fR, which itself defaults to
\fBnone\fR.
The legal values are
.RS
.TP
\fBnone\fR, \fB-\fR
Draw no arrowheads, at neither end of the line.
.TP
\fBstart\fR, \fBfirst\fR, \fB<-\fR
Draw an arrowhead at the beginning of the line, but not at its end.
.TP
\fBend\fR, \fBlast\fR, \fB->\fR
Draw an arrowhead at the end of the line, but not at its beginning.
.TP
\fBboth\fR, \fB<->\fR
Draw arrowheads at both ends of the line.
.RE
Note that the values "start", "end", "-", "->", "<-", and "<->" are
all accepted as shorthands for the \fBarrowhead\fR command using them
as argument.
.TP
\fBat\fR \fIlocation\fR
\fBLine\fR elements are normally positioned absolutely, using the
locations specified through the attributes \fBfrom\fR, \fBthen\fR, and
\fBto\fR.
If \fBat\fR is specified however then these positions are translated a
last time, moving the line's corner named by the attribute \fBwith\fR
to the location given by this attribute.
.TP
\fBchop\fR ?\fIlength\fR?
Specifies the length of the \fBline\fR element to remove from the
beginning and/or end.
Defaults to nothing.
If specified once the chopping applies to both beginning and end of
the line.
If specified twice or more the last two specifications are used, and
applied to beginning and end of the line, in this order.
Whenever the attribute is specified without an explicit length, the
system falls back to the value taken from the language variable
\fBcircleradius\fR, which itself defaults to the pixel equivalent of
\fB1 cm\fR
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBfrom\fR \fIlocation\fR
Specifies the location where the \fBline\fR element begins.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBnoturn\fR
Specifies that the direction of \fBline\fR element at its end is not
propagated to the layout management.
If not specified the direction of the line becomes the new direction
the layout.
.TP
\fBsmooth\fR
Specifies the use of bezier splines for the \fBline\fR element.
If not specified lines are drawn exactly through the specified
waypoints, without any smooth curves.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBthen\fR \fIlocation\fR
.TP
\fBthen\fR (<direction> ?\fIlength\fR?)...
.TP
(<direction> ?\fIlength\fR?)...
This attribute specifies an intermediate location the \fBline\fR
element has to go through.
It can be specified multiple times, with each use adding one
additional location to the series which the line will go
through. These location will be traversed in the order they were
specified.
.sp
The location can be given explicitly, or as a series of directions
with distances. In the latter case the names of all known directions
are accepted for the direction part.
If no distance is specified for a direction the system falls back to
the value taken from the language variable \fBmovelength\fR, which
itself defaults to the pixel equivalent of \fB2 cm\fR.
The whole set of direction,distance pairs is treated as a series of
translations which are added up to provide the final translation
specifying the intermediate point (relative to the preceding point).
.sp
The last named direction is propagated to the layout system as the
direction to follow. The use of \fBnoturn\fR is not able to overide
this behaviour.
.sp
At last, the names of the registered directions also serve as
attribute commands, with an implicit attribute \fBthen\fR in front of
them.
.sp
If no intermediate or last location is specified for the line the
system falls back to a point \fBmovelength\fR pixels away from the
starting location, in the current direction as maintained by the
layouting system
.TP
\fBto\fR \fIlocation\fR
Specifies the location where the \fBline\fR element ends.
This attribute has no default. The default is handled by the attribute
\fBthen\fR, which makes it appear as if \fBto\fR has a default when
not specified.
.TP
\fBwith\fR \fIcorner\fR
\fBLine\fR elements are normally positioned absolutely, using the
locations specified through the attributes \fBfrom\fR, \fBthen\fR, and
\fBto\fR.
If \fBat\fR is specified however then these positions are translated a
last time, moving the line's corner named by the attribute \fBwith\fR
to the location given by this attribute.
This means that \fIwith\fR is effective if and only if the attribute
\fBat\fR was specified as well for the line.
.RE
.TP
\fBmove\fR \fIattr\fR
An open element with the corresponding corners, i.e. "start", "end",
and "center".
A \fBmove\fR element is in essence an invisible \fBline\fR.
While the main effect we are interested in is the change it makes to
the layout system, it is an actual element, i.e. it has the same
corners as an ordinary line, and shows up in the history as well,
allowing future references to all the places it touched.
It handles the same attibutes as \fBline\fR elements.
.TP
\fBspline\fR \fIattr\fR...
IMAGE: figure-02-spline
An alias for the \fBline\fR element (see above), with the attribute
\fBsmooth\fR preset.
.TP
\fBtext\fR \fIattr\fR...
IMAGE: figure-02-text
A closed element with the corresponding corners, i.e. the eight
directions of the compass rose, and "center".
It handles the attributes
.RS
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBheight\fR \fIlength\fR
Specifies the height of the \fBtext\fR element.
Defaults to the natural height of its text.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBwidth\fR \fIlength\fR
Specifies the width of the \fBtext\fR element.
Defaults to the natural width of its text.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.RE
.PP
.SS ATTRIBUTES
The set of all attributes supported by all the element commands is
shown below.
While we speak of them as commands, and provide a syntax, they are not
truly available as actual commands, but only as part of the arguments
for an element command.
.PP
Note that some of the attribute names are overloaded, i.e. have
multiple, different, definitions. During processing of attributes for
an element the actual definition used is chosen based on the type of
the element the processing is for.
.PP
Further, as a catch-all clause, any attribute which could not be
processed according to the definitions below will be treated as the
argument of an implicit \fBtext\fR attribute.
.TP
\fBanchor\fR \fIname\fR
.TP
\fBljust\fR
.TP
\fBrjust\fR
.TP
\fBabove\fR
.TP
\fBbelow\fR
IMAGE: figure-22-text-anchoring-3
Specifies the anchor of the text which is to be placed at the
element's center, by name. I.e. this attribute defines the text's
position relative to the element's center.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBanchor\fR, which itself defaults to
\fBcenter\fR.
The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].
The commands without arguments are all shorthands with the anchor
implied. Note that they do not combine, only the last is used. For
comined directions the main attribute command, \fBanchor\fR has to be
used.
.RS
.TP
\fBljust\fR
"anchor west"
.TP
\fBrjust\fR
"anchor east"
.TP
\fBabove\fR
"anchor south"
.TP
\fBbelow\fR
"anchor north"
.RE
.TP
\fBarrowhead\fR \fIspec\fR
IMAGE: figure-19-style-arrowheads
Specifies where to draw arrowheads on the \fBline\fR element, at the
beginning or end, at both ends, or none.
If not specified the system falls back to the value taken from the
language variable \fBarrowhead\fR, which itself defaults to
\fBnone\fR.
The legal values are
.RS
.TP
\fBnone\fR, \fB-\fR
Draw no arrowheads, at neither end of the line.
.TP
\fBstart\fR, \fBfirst\fR, \fB<-\fR
Draw an arrowhead at the beginning of the line, but not at its end.
.TP
\fBend\fR, \fBlast\fR, \fB->\fR
Draw an arrowhead at the end of the line, but not at its beginning.
.TP
\fBboth\fR, \fB<->\fR
Draw arrowheads at both ends of the line.
.RE
Note that the values "start", "end", "-", "->", "<-", and "<->" are
all accepted as shorthands for the \fBarrowhead\fR command using them
as argument.
.TP
\fBaspect\fR \fInumber\fR
Specifies the aspect ratio, i.e ratio of width to height, of the
\fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBwidth\fR and
\fBheight\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBaspect\fR \fInumber\fR
Specifies the aspect ratio, i.e ratio of width to height, of the
ellipses which are used to draw the top and bottom of the \fBdrum\fR
element.
If not specified the system falls back to the value taken from the
language variable \fBdrumaspect\fR, which itself defaults to
\fB0.35\fR.
.TP
\fBat\fR \fIlocation\fR
Specifies the location of the element's corner named by the attribute
\fBwith\fR.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBat\fR \fIlocation\fR
\fBLine\fR elements are normally positioned absolutely, using the
locations specified through the attributes \fBfrom\fR, \fBthen\fR, and
\fBto\fR.
If \fBat\fR is specified however then these positions are translated a
last time, moving the line's corner named by the attribute \fBwith\fR
to the location given by this attribute.
.TP
\fBchop\fR ?\fIlength\fR?
Specifies the length of the \fBline\fR element to remove from the
beginning and/or end.
Defaults to nothing.
If specified once the chopping applies to both beginning and end of
the line.
If specified twice or more the last two specifications are used, and
applied to beginning and end of the line, in this order.
Whenever the attribute is specified without an explicit length, the
system falls back to the value taken from the language variable
\fBcircleradius\fR, which itself defaults to the pixel equivalent of
\fB1 cm\fR
.TP
\fBclockwise\fR
.TP
\fBcw\fR
Specifies the direction of the \fBarc\fR element, here going
clockwise.
The complementary attribute is \fBcounterclockwise\fR.
If not specified the system falls back to the value taken from the
language variable \fBclockwise\fR, which itself defaults to
\fBfalse\fR, for counter-clockwise direction.
.TP
\fBcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinecolor\fR, which itself defaults to \fBblack\fR.
.TP
\fBcounterclockwise\fR
.TP
\fBccw\fR
Specifies the direction of the \fBarc\fR element, here
counter-clockwise.
The complementary attribute is \fBclockwise\fR.
If not specified the system falls back to the value taken from the
language variable \fBclockwise\fR, which itself defaults to
\fBfalse\fR, for counter-clockwise direction.
.TP
\fBdiameter\fR \fIlength\fR
.TP
\fBdiam\fR \fIlength\fR
Specifies the diameter of the \fBcircle\fR element, as an alternative
way to specify its \fBradius\fR.
Effective if and only if the radius was not specified. I.e. if both
diameter and radius are specified then the radius infomration has
precendence.
This attribute has no default, because the defaults are taken from the
radius.
.TP
\fBfillcolor\fR \fIspec\fR
IMAGE: figure-21-style-colors
Specifies the color used to draw the inside of the element.
If not specified the system falls back to the value taken from the
language variable \fBfillcolor\fR, which itself defaults to the empty
string, signaling "no filling".
.TP
\fBfrom\fR \fIlocation\fR
Specifies the location where the \fBline\fR element begins.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBfrom\fR \fIlocation\fR
Specifies the location where the \fBarc\fR element begins.
Defaults to the current location as maintained by the layouting
system.
.TP
\fBheight\fR \fIlength\fR
.TP
\fBht\fR \fIlength\fR
Specifies the height of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxheight\fR, which itself defaults to the
pixel equivalent of \fB2 cm\fR.
.TP
\fBheight\fR \fIlength\fR
Specifies the height of the \fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBaspect\fR and
\fBwidth\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBheight\fR \fIlength\fR
Specifies the height of the \fBtext\fR element.
Defaults to the natural height of its text.
.TP
\fBjustify\fR \fBleft\fR|\fBcenter\fR|\fBright\fR
Specifies how multi-line text associated with the element is
positioned within its box.
The value is ignored if no text was specified for the element.
If not specified the system falls back to the value taken from the
language variable \fBjustify\fR, which itself defaults to
\fBleft\fR.
The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.
.TP
\fBnoturn\fR
Specifies that the direction of \fBline\fR element at its end is not
propagated to the layout management.
If not specified the direction of the line becomes the new direction
the layout.
.TP
\fBradius\fR \fIlength\fR
.TP
\fBrad\fR \fIlength\fR
Specifies the radius of the \fBcircle\fR element.
If not specified the system falls back to the value taken from the
language variable \fBcircleradius\fR, which itself defaults to the
pixel equivalent of \fB1 cm\fR.
.TP
\fBradius\fR \fIlength\fR
Specifies the radius of the \fBarc\fR element, or rather, the radius
of the circle the shown arc is a part of.
If not specified the system falls back to the value taken from the
language variable \fBarcradius\fR, which itself defaults to the pixel
equivalent of \fB1 cm\fR.
.TP
\fBslant\fR \fIangle\fR
Specifies the angle by which the \fBbox\fR element is slanted, in
degrees.
If not specified the system falls back to the value taken from the
language variable \fBslant\fR, which itself defaults to \fB90\fR,
i.e. vertical, no slant.
0 degrees is slanting straight east, pointing to the right.
90 degrees is slanting to the north, pointing straight up.
.TP
\fBsmooth\fR
Specifies the use of bezier splines for the \fBline\fR element.
If not specified lines are drawn exactly through the specified
waypoints, without any smooth curves.
.TP
\fBstroke\fR \fIwidth\fR
IMAGE: figure-20-style-stroke
Specifies the width of the lines drawn for the the element, in pixels.
If not specified the system falls back to the value taken from the
language variable \fBlinewidth\fR, which itself defaults to \fB1\fR.
.TP
\fBstyle\fR \fIspec\fR
IMAGE: figure-18-style-dash
Specifies the style used to draw the lines of the element.
If not specified the system falls back to the value taken from the
language variable \fBlinestyle\fR, which itself defaults to
\fBsolid\fR lines.
The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],
and additionally all which are listed below:
.RS
.TP
\fBsolid\fR, empty string
Draw solid line.
.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
Draw a dashed line.
.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
Draw a dotted line.
.TP
\fBdash-dot\fR, \fB-.\fR
Draw a dash-dotted line
.TP
\fBdash-dot-dot\fR, \fB-..\fR
Draw a dash-dot-dotted line.
.RE
Note that the values "solid", "dot(ted)", "dash(ed)", "dash-dot", and
"dash-dot-dot" are all accepted as shorthands for the \fBstyle\fR
command using them as argument.
.TP
\fBtext\fR \fIstring\fR
Specifies the text to associate with the element.
Defaults to nothing.
When specified multiple times the actually shown text is the
concatenation of the individual strings, vertically stacked, with the
first string specified being the topmost element.
.TP
\fBtextcolor\fR \fIspec\fR
Specifies the color used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextcolor\fR, which itself defaults to
\fBblack\fR.
.TP
\fBtextfont\fR \fIspec\fR
Specifies the font used to draw the text of an element with.
Ignored if there is no text.
If not specified the system falls back to the value taken from the
language variable \fBtextfont\fR, which itself defaults to
\fBHelvetica 12pt\fR.
.TP
\fBthen\fR \fIlocation\fR
.TP
\fBthen\fR (<direction> ?\fIlength\fR?)...
.TP
(<direction> ?\fIlength\fR?)...
This attribute specifies an intermediate location the \fBline\fR
element has to go through.
It can be specified multiple times, with each use adding one
additional location to the series which the line will go
through. These location will be traversed in the order they were
specified.
.sp
The location can be given explicitly, or as a series of directions
with distances. In the latter case the names of all known directions
are accepted for the direction part.
If no distance is specified for a direction the system falls back to
the value taken from the language variable \fBmovelength\fR, which
itself defaults to the pixel equivalent of \fB2 cm\fR.
The whole set of direction,distance pairs is treated as a series of
translations which are added up to provide the final translation
specifying the intermediate point (relative to the preceding point).
.sp
The last named direction is propagated to the layout system as the
direction to follow. The use of \fBnoturn\fR is not able to overide
this behaviour.
.sp
At last, the names of the registered directions also serve as
attribute commands, with an implicit attribute \fBthen\fR in front of
them.
.sp
If no intermediate or last location is specified for the line the
system falls back to a point \fBmovelength\fR pixels away from the
starting location, in the current direction as maintained by the
layouting system
.TP
\fBto\fR \fIlocation\fR
Specifies the location where the \fBline\fR element ends.
This attribute has no default. The default is handled by the attribute
\fBthen\fR, which makes it appear as if \fBto\fR has a default when
not specified.
.TP
\fBto\fR \fIlocation\fR
Specifies the location where the \fBarc\fR element ends.
Defaults to a location such that a 90-degree arc is drawn in the
chosen direction, starting at \fBfrom\fR.
.TP
\fBwidth\fR \fIlength\fR
.TP
\fBwid\fR \fIlength\fR
Specifies the width of the element.
If not specified the system falls back to the value taken from the
language variable \fBboxwidth\fR, which itself defaults to the pixel
equivalent of \fB2 cm\fR.
.TP
\fBwidth\fR \fIlength\fR
Specifies the width of the \fBdiamond\fR element.
The manner in which a default is calculated when not specified also
depends on the specifications of the attributes \fBaspect\fR and
\fBheight\fR, if any.
.sp
If both \fBwidth\fR, and \fBheight\fR are specified then any
specification of \fBaspect\fR is ignored, as it is implicitly defined
in the width and height as well, and this takes precedence. A missing
specification is ignored in that case well, i.e. no defaults are
required.
.sp
If the \fBaspect\fR is specified, and one of the attributes
\fBwidth\fR or \fBheight\fR, then the missing attribute is calculated
from the two which are specified. No defaults are required for these
cases either.
.sp
If only one of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBaspect\fR, the value taken
from the language variable \fBdiamondaspect\fR, which itselfs defaults
to \fB2\fR.
.sp
If none of of the attributes \fBwidth\fR or \fBheight\fR is specified
then the system uses a fallback for the \fBwidth\fR, the value taken
from the language variable \fBboxwidth\fR, which itselfs defaults to
the pixel equivalent of \fB2 cm\fR. For the aspect it uses either
the user-specified value or the default taken as described in the
previous paragraph.
.TP
\fBwidth\fR \fIlength\fR
Specifies the width of the \fBtext\fR element.
Defaults to the natural width of its text.
.TP
\fBwith\fR \fIcorner\fR
Specifies the corner of the element to place at the location given by
the attribute \fBat\fR.
Defaults to the current corner as maintained by the layouting system,
except if the value for \fBat\fR was specified by the user. In that
case it defaults to \fBcenter\fR.
.TP
\fBwith\fR \fIcorner\fR
\fBLine\fR elements are normally positioned absolutely, using the
locations specified through the attributes \fBfrom\fR, \fBthen\fR, and
\fBto\fR.
If \fBat\fR is specified however then these positions are translated a
last time, moving the line's corner named by the attribute \fBwith\fR
to the location given by this attribute.
This means that \fIwith\fR is effective if and only if the attribute
\fBat\fR was specified as well for the line.
.PP
.SS CORNERS
Corners are named values for in elements, usually locations.
.IP \(bu
The \fIclosed\fR elements define corners for the compass rose,
including the "center", and their "width" and "height".
.sp
IMAGE: figure-27-corners-closed
.sp
.IP \(bu
\fBblock\fR elements additionally export all variables which were set
during their definition as corners.
.IP \(bu
The \fIopen\fR elements on the other hand define "start", "end", and
"center". The first two map to the locations originally provided
through the attributes \fBfrom\fR and \fBto\fR of the element.
.sp
IMAGE: figure-28-corners-open
.sp
.IP \(bu
The center of \fBline\fR and \fBmove\fR elements is the location
halfway between "start" and "end" corners, this is regardless of any
intermediate locations the element may have.
.IP \(bu
The \fBline\fR and \fBmove\fR elements additionally name all their
locations as corners using numbers as names, starting from \fB1\fR
(equivalent to "start"), in order of traversal.
.sp
IMAGE: figure-15-spline-1
.sp
.IP \(bu
The center of \fBarc\fR elements is the center of the circle the arc
is part off.
.IP \(bu
The \fBarc\fR elements additionally define the compass rose of
closed elements as well.
.PP
.SS "NAMED DIRECTIONS"
The named directions are commands which tell the layout system in
which direction to go when placing the next element without an
explicit position specification.
They can also be used as arguments to the attribute \fBthen\fR, and
the command \fBby\fR for relative points, see there for the relevant
syntax.
.PP
The diagram core defines the directions of the compass rose, plus a
number of aliases. See below for the full list.
.PP
IMAGE: figure-27-corners-closed
.PP
This overlaps with the pre-defined corners for closed elements. This
is used by the layout system, when are going in direction X the name
of the opposite direction is the name of the corner at which the new
element will be attached to the current position, and if this corner
does not exist the nearest actual corner by angle is used.
.PP
.TP
\fBwest\fR
.TP
\fBw\fR
.TP
\fBleft\fR
.TP
\fBl\fR
.TP
\fBsouth\fR
.TP
\fBs\fR
.TP
\fBdown\fR
.TP
\fBbottom\fR
.TP
\fBbot\fR
.TP
\fBb\fR
.TP
\fBeast\fR
.TP
\fBe\fR
.TP
\fBright\fR
.TP
\fBr\fR
.TP
\fBnorth\fR
.TP
\fBn\fR
.TP
\fBup\fR
.TP
\fBtop\fR
.TP
\fBt\fR
.TP
\fBnorthwest\fR
.TP
\fBnw\fR
.TP
\fBup-left\fR
.TP
\fBupleft\fR
.TP
\fBleftup\fR
.TP
\fBnortheast\fR
.TP
\fBne\fR
.TP
\fBup-right\fR
.TP
\fBupright\fR
.TP
\fBrightup\fR
.TP
\fBsouthwest\fR
.TP
\fBsw\fR
.TP
\fBdown-left\fR
.TP
\fBdownleft\fR
.TP
\fBleftdown\fR
.TP
\fBsoutheast\fR
.TP
\fBse\fR
.TP
\fBdown-right\fR
.TP
\fBdownright\fR
.TP
\fBrightdown\fR
.PP
.SS "MISCELLANEOUS COMMANDS"
.TP
\fInumber\fR \fBcm\fR
.TP
\fInumber\fR \fBmm\fR
.TP
\fInumber\fR \fBinch\fR
.TP
\fInumber\fR \fBpt\fR
These commands allow the specification of distances and coordinates in
metric and imperial units, returning the equivalent distance or
coordinate in pixels, which is the unit used internally for all
calculations.
.sp
The conversion factors are based on the result of \fBtk scaling\fR
and are computed once, at the time the package is sourced, future
changes of the \fBtk scaling\fR factor have no effect.
.TP
\fInumber\fR \fInumber\fR
.sp
IMAGE: figure-50-point-cons-absolute
.sp
This command takes the x and y coordinates of a location and returns
the \fIabsolute\fR point for it.
.TP
\fBby\fR \fIdistance\fR \fIdirection\fR
.sp
IMAGE: figure-51-point-cons-relative
.sp
This command takes a \fIdistance\fR and \fIdirection\fR (angle in
degress, or registered direction name) and returns the \fIrelative\fR
point for it, i.e. the \fIdelta\fR or \fItranslation\fR it
represents.
.sp
Note also the (dis)similarities to the directional specifications for
the attribute \fBthen\fR of \fBline\fR and \fBmove\fR elements.
Where we say here
.nf
by 50 east
.fi
for the attribute we say
.nf
... then east 50 ...
.fi
or just
.nf
... then east ...
.fi
.TP
\fIpoint1\fR \fB+\fR \fIpoint2\fR
.sp
IMAGE: figure-48-point-vectoradd
.sp
This command interprets two points as vectors and adds them together.
If at least one of the points is \fIabsolute\fR the result is
absolute as well.
The result is a \fIrelative\fR point if and only if both points are
\fIrelative\fR.
.TP
\fIpoint1\fR \fB-\fR \fIpoint2\fR
.sp
IMAGE: figure-49-point-vectorsub
.sp
This command interprets two points as vectors and subtracts the second
from the first.
If at least one of the points is \fIabsolute\fR the result is
absolute as well.
The result is a \fIrelative\fR point if and only if both points are
\fIrelative\fR.
.TP
\fIpoint\fR \fBby\fR \fIdistance\fR \fIdirection\fR
This command is a more convenient, or at least shorter, form of
.nf

    [$point + [by $distance $direction]]

.fi
.TP
\fIpoint1\fR \fB|\fR \fIpoint2\fR
.sp
IMAGE: figure-31-point-projection
.sp
This command calculates the \fIprojection\fR of two points, i.e. the
result is the point having the x-coordinate of \fIpoint1\fR and the
y-coordinate of \fIpoint2\fR.
.TP
\fIn\fR \fBbetween\fR \fIpoin1\fR \fIpoint2\fR
.sp
IMAGE: figure-29-point-interpolation-1
.sp
This command computes the point which is \fIn\fR*100 percent of the
way between \fIpoint1\fR and \fIpoint2\fR, and returns it as its
result.
This means that for
.RS
.TP
\fIn\fR == 0
The result is \fIpoint1\fR.
.TP
\fIn\fR == 1
The result is \fIpoint2\fR.
.TP
\fIn\fR == 0.5
The result is half way between the two points.
.RE
etc.
\fINote\fR that it is allowed to use values < 0 and > 1 for \fIn\fR
.TP
\fBintersect\fR \fIelem1\fR \fIelem2\fR
.sp
IMAGE: figure-32-point-intersection
.sp
This command takes two \fIopen\fR elements, computes the lines going
through their "start"- and "end"-corners, and returns the point where
these two lines intersect.
The command throws an error if the lines do not intersect, or are
coincident.
.TP
\fIelement\fR \fBnames\fR ?\fIpattern\fR?
This command returns a list containing the names of all corners for
the \fIelement\fR. If a pattern is specified then only the names
matching it (via \fBstring match\fR are returned. Otherwise all
names are returned (equivalent to a default pattern of \fB*\fR).
.TP
\fIelement\fR \fIcorner\fR
This command returns the value for the \fIcorner\fR of the
\fIelement\fR.
This can be anything, including points and elements.
.TP
\fIelement\fR \fIcorner1\fR \fIcorner2\fR...
This is a convenience shorthand for
.nf

[[[$elem $corner1] $corner2] ...]

.fi
assuming that the value for
.nf
 [$elem $corner1]
.fi, etc. is
again an element.


.TP
\fIelement\fR ?\fIcorner1\fR... ?\fBnames\fR ?\fIpattern\fR??]?


This is a convenience shorthand for



.nf

[[[$elem $corner1] ...] names ?pattern?]

.fi
assuming that the value for
.nf
 [$elem $corner1]
.fi, etc. is
again an element.


.TP
\fB\fBn\fRth\fR ?\fIcorner\fR?


This command asks the diagram history for the \fBn\fRth element
created, searching from the beginning of the history (counting from 1)
and returns it as its result.

If the \fIcorner\fR is specified then the value for this corner is
returned instead.



.TP
\fB\fBn\fRth\fR \fBlast\fR ?\fIcorner\fR?


This command asks the diagram history for the \fBn\fRth element
created, searching from the end of the history and returns it as its
result.

If the \fIcorner\fR is specified then the value for this corner is
returned instead.



.TP
\fB\fBn\fRth\fR \fIshape\fR ?\fIcorner\fR?


This command asks the diagram history for the \fBn\fRth element
created, of the given \fIshape\fR, searching from the beginning of the
history (counting from 1) and returns it as its result.

If the \fIcorner\fR is specified then the value for this corner is
returned instead.



.TP
\fB\fBn\fRth\fR \fBlast\fR \fIshape\fR ?\fIcorner\fR?


This command asks the diagram history for the \fBn\fRth element
created, of the given \fIshape\fR, searching from the end of the
history and returns it as its result.

If the \fIcorner\fR is specified then the value for this corner is
returned instead.



.TP
\fBlast\fR ?\fIcorner\fR?


.TP
\fBlast\fR \fIshape\fR ?\fIcorner\fR?


Convenience commands mapping to "\fB1st last\fR"
and "\fB1st last\fR \fIshape\fR".



.TP
\fB1st\fR


.TP
\fB2nd\fR


.TP
\fB3rd\fR


Aliases for \fB1th\fR, \fB2th\fR, and \fB3th\fR, for readability,
usable whereever \fB\fBn\fRth\fR can ocur.


.PP



.SS VARIABLES

The language context contains a number of predefined variables which
hold the default values for various attributes. These variables, their
uses, and values are:



.TP
\fBanchor\fR


The default value for the attribute \fBanchor\fR.

Initialized to \fBcenter\fR.


The legal values are all those accepted by
\fITk_GetAnchor\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetAnchor.htm].



.TP
\fBarcradius\fR


The default value for the attribute \fBradius\fR of \fBarc\fR
elements.

Initialized to the pixel equivalent of \fB1 cm\fR.


.TP
\fBarrowhead\fR


The default value for the attribute \fBarrowhead\fR.

Initialized to \fBnone\fR.

The legal values are

.RS

.TP
\fBnone\fR, \fB-\fR

Draw no arrowheads, at neither end of the line.


.TP
\fBstart\fR, \fBfirst\fR, \fB<-\fR

Draw an arrowhead at the beginning of the line, but not at its end.


.TP
\fBend\fR, \fBlast\fR, \fB->\fR

Draw an arrowhead at the end of the line, but not at its beginning.


.TP
\fBboth\fR, \fB<->\fR

Draw arrowheads at both ends of the line.

.RE



.TP
\fBboxheight\fR


The default value for the attribute \fBheight\fR of \fBbox\fR,
\fBdiamond\fR and \fBellipse\fR elements.

Initialized to the pixel equivalent of \fB2 cm\fR.


.TP
\fBboxwidth\fR


The default value for the attribute \fBwidth\fR of \fBbox\fR,
\fBdiamond\fR and \fBellipse\fR elements.

Initialized to the pixel equivalent of \fB2 cm\fR.


.TP
\fBclockwise\fR


The default value for the attributes \fBclockwise\fR and
\fBcounterclockwise\fR of \fBarc\fR elements.

Initialized to \fBFalse\fR, for counter-clockwise direction.


.TP
\fBcircleradius\fR


The default value for the attribute \fBradius\fR of \fBcircle\fR
elements, and also the default for the attribute \fBchop\fR, when
specified without an explicit length.

Initialized to the pixel equivalent of \fB1 cm\fR.


.TP
\fBdrumaspect\fR


The default value for the attribute \fBaspect\fR of \fBdrum\fR
elements.

Initialized to \fB0.35\fR.


.TP
\fBfillcolor\fR


The default value for the attribute \fBfillcolor\fR of all elements
which can be filled.

Initialized to the empty string, signaling that the element is not
filled.


.TP
\fBjustify\fR


The default value for the attribute \fBjustify\fR.

Initialized to \fBleft\fR.


The legal values are \fBleft\fR, \fBright\fR, and \fBcenter\fR.



.TP
\fBlinecolor\fR


The default value for the attribute \fBcolor\fR of all elements having
to draw lines (all but \fBtext\fR).

Initialized to \fBblack\fR.


.TP
\fBlinestyle\fR


The default value for the attribute \fBstyle\fR of all elements
having to draw some line.

Initialized to \fBsolid\fR.


The legal values are all those accepted by
\fITk_GetDash\fR [http://www.tcl.tk/man/tcl8.5/TkLib/GetDash.htm],

and additionally all which are listed below:


.RS

.TP
\fBsolid\fR, empty string
		Draw solid line.

.TP
\fBdash\fR, \fBdashed\fR, \fB-\fR
	Draw a dashed line.

.TP
\fBdot\fR, \fBdotted\fR, \fB.\fR
	Draw a dotted line.

.TP
\fBdash-dot\fR, \fB-.\fR
	  	Draw a dash-dotted line

.TP
\fBdash-dot-dot\fR, \fB-..\fR
	Draw a dash-dot-dotted line.

.RE



.TP
\fBlinewidth\fR


The default value for the attribute \fBstroke\fR of all elements
having to draw some line.

Initialized to \fB1\fR (pixels).


.TP
\fBmovelength\fR


The default value for the directional specification of intermediate
locations by the attribute \fBthen\fR of \fBline\fR and \fBmove\fR
elements.

Initialized to the pixel equivalent of \fB2 cm\fR.


.TP
\fBslant\fR


The default value for the attribute \fBslant\fR of \fBbox\fR elements.

Initialized to 90 degrees, i.e. slant straight up.


.TP
\fBtextcolor\fR


The default value for the attribute \fBtextcolor\fR of all elements
having to draw some text.

Initialized to \fBblack\fR.


.TP
\fBtextfont\fR


The default value for the attribute \fBtextfont\fR of all elements
having to draw some text.

Initialized to \fBHelvetica 12pt\fR.


.PP



.SH "DIAGRAM CLASSES"     The intended audience of this section are developers wishing to work
on the internals of the diagram package.

Regular users of \fBdiagram\fR can skip this section without
missing anything.


.PP


The main information seen here is the figure below, showing the
hierarchy of the classes implementing diagram.


.PP
IMAGE: figure-00-dependencies
.PP


At the bottom, all at the same level are the supporting packages like
\fBsnit\fR, etc. These can all be found in Tcllib.


.PP


Above them is the set of diagram classes implementing the various
aspects of the system, i.e.:




.TP
\fBdiagram\fR

The main class, that which is seen by the user.


.TP
\fBdiagram::core\fR

The core engine, itself distributed over four helper classes.


.TP
\fBdiagram::basic\fR

The implementation of the standard shapes, like box, circle, etc.,
based on the extension features of the core.


.TP
\fBdiagram::element\fR

Core support class, the database of created elements. It also keeps
the history, i.e. the order in which elements were created.


.TP
\fBdiagram::attribute\fR

Core support class, the generic handling of definition and processing
of attributes.


.TP
\fBdiagram::direction\fR

Core support class, the database of named directions.


.TP
\fBdiagram::navigation\fR

Core support class, the state of layout engine, i.e. current position
and directin, and operations on it.


.TP
\fBdiagram::point\fR

General support class handling various vector operations.


.PP



.SH REFERENCES



.SH KEYWORDS
2D geometry, arc, arrow, box, canvas, circle, diagram, diamond, drawing, drum, ellipse, image, interpolation, intersection, line, move, picture, plane geometry, plotting, point, raster image, spline, text, vector

.SH CATEGORY
Documentation tools

