'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tklib/tklib/modules/menubar/menubar.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Tom Krehbiel <krehbiel.tom@gmail.com> All rights reserved.
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "menubar" n 0.5 menubar "Create and manipulate menubars"
.BS
.SH NAME
menubar \- Creates an instance of the \fImenubar\fR Class.
.SH SYNOPSIS
package require \fBTcl  8.6\fR
.sp
package require \fBTk  8.6\fR
.sp
package require \fBmenubar  ?0.5?\fR
.sp
\fBmenubar new\fR ?options?
.sp
\fImBarInst\fR \fBdefine\fR \fIbody\fR
.sp
\fImBarInst\fR \fBinstall\fR \fIpathName body\fR
.sp
\fImBarInst\fR \fBmenu.configure\fR \fIoption tag-settings ?option tag-settings ...?\fR
.sp
\fImBarInst\fR \fBmenu.namespace\fR \fItag namespace\fR
.sp
\fImBarInst\fR \fBmenu.hide\fR \fItag\fR
.sp
\fImBarInst\fR \fBmenu.show\fR \fItag\fR
.sp
\fImBarInst\fR \fBtag.add\fR \fItag value\fR
.sp
\fImBarInst\fR \fBtag.configure\fR \fIpathName tag ?option value ...option value?\fR
.sp
\fImBarInst\fR \fBtag.cget\fR \fIpathName tag ?option?\fR
.sp
\fImBarInst\fR \fBgroup.add\fR \fItag label ?cmd? ?accel? ?sequence? ?state?\fR
.sp
\fImBarInst\fR \fBgroup.delete\fR \fItag label\fR
.sp
\fImBarInst\fR \fBgroup.move\fR \fIdirection tag label\fR
.sp
\fImBarInst\fR \fBgroup.configure\fR \fItag label ?option value ...option value?\fR
.sp
\fImBarInst\fR \fBgroup.serialize\fR \fItag\fR
.sp
\fImBarInst\fR \fBgroup.deserialize\fR \fItag stream\fR
.sp
\fImBarInst\fR \fBnotebook.addTabStore\fR \fIpathname\fR
.sp
\fImBarInst\fR \fBnotebook.deleteTabStore\fR \fIpathname\fR
.sp
\fImBarInst\fR \fBnotebook.setTabValue\fR \fIpathname tag\fR
.sp
\fImBarInst\fR \fBnotebook.restoreTabValues\fR \fIpathname\fR
.sp
.BE
.SH DESCRIPTION
.TP
\fBmenubar new\fR ?options?
.PP
.PP
Create and return a new instance of the menubar class. The
menubar class encapsulates the definition, installation and
dynamic behavior of a menubar. The class doesn't depend on a
widget framework and therefore can be used with or without a
framework (e.g. Bwidget, IWidget, Snit, etc.). Unlike other Tk
widget commands, the menubar command doesn't have a \fIpathName\fR
argument because menubars are handled by the window manager (i.e. wm)
and not the application.
.SH OPTIONS
The following options can be passed to the \fImenubar new\fR command.
.PP
These options are inherited from the Tk menu command, their effect is
platform specific.
.TP
\fB\fI-activebackground\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-activebackground]\fR
.TP
\fB\fI-activeborderwidth\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-activeborderwidth]\fR
.TP
\fB\fI-activeforeground\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-activeforeground]\fR
.TP
\fB\fI-background\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-background]\fR
.TP
\fB\fI-borderwidth\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-borderwidth]\fR
.TP
\fB\fI-cursor\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-cursor]\fR
.TP
\fB\fI-disabledforeground\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-disabledforeground]\fR
.TP
\fB\fI-font\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-font]\fR
.TP
\fB\fI-foreground\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-foreground]\fR
.TP
\fB\fI-relief\fR [http://docs.activestate.com/activetcl/8.5/tcl/TkCmd/options.htm#M-relief]\fR
.PP
.SH INTRODUCTION
.PP
An instance of the menubar class provides methods for compiling a
description of the menubar, configuring menu items and
installing the menubar in toplevel windows.
.PP
A menubar can be thought of as a tree of cascading menus. Users define
a menubar using a language that results in a human readable description
of a menubar. The description of the menubar is then compiled by an
instance of the menubar class after which it can be installed in one or more
toplevel windows.
.PP
The menubar class provides many unique capabilities that are not
found in other tcl/tk menubar implementation. Some of these are:
.IP \(bu
A tagging system that simplifies access to menu entries in the menu tree.
.IP \(bu
Support for user defined tags that depend on the toplevel window context.
.IP \(bu
A simplified and uniform interface for all callback commands.
.IP \(bu
Namespace support for all callback commands so callback commands can be easily grouped into namespaces.
.IP \(bu
Support for hiding and exposing menus on the menubar.
.IP \(bu
A simplified method for creating radiobutton groups.
.IP \(bu
Automatic management of state variables for checkbuttons and radiobuttons.
.IP \(bu
Scope control for the state variables of checkbuttons and radiobuttons.
.IP \(bu
Tear-off menu management that ensures only one tearoff menu is created.
.IP \(bu
Support for dynamic menu extension to simplify the creation of recent document menus.
.IP \(bu
Support for saving and restoring dynamic menu extensions.
.PP
.SH TERMINOLOGY
.TP
MENUBAR
The visible rendering of a menubar in a toplevel window is a horizontally
group of cascading Tk menus.
.TP
MENU
A menu is an ordered list of items that is rendered
vertically. Menus are not visible until a user
preforms some action (normally a <ButtonPress-1> event). A menu
may contain any number of child menus that are rendered as
cascading menus. Cascading menus are rendered next to the parent menu
when they are activated.
.TP
MENU ENTRY
A menu contains an ordered list of items called entries.
Menu entries have a type and the menubar class supports the
following 6 entry types:
\fICommand\fR, \fICheckbutton\fR, \fIRadiobutton\fR, \fISeparator\fR, \fIGroup\fR and \fIMenu\fR.
.TP
ENTRY LABEL
Each menu entry has a visible string that is called the entry label.
.TP
TAG
A tag is name that is normally used to referr to an item in a menu
tree. A tag name is an alphanumeric character string
that may include the underscore character. Menu tree tags are
defined for all nodes and leafs in a menu tree. This provides a
flat abstraction of the tree and simplifies item referencing in
menubar methods. Without this abstraction it would be
necessary to reference menu elements using a tree path which
could change at run-time. The menubar class also has a method that
can create a user defined tag. User
defined tags store values that change based on the currently
active toplevel window. User defined tags can be used to store widget
pathnames use by callback code so that output can be routed to the
appropriate toplevel window.
.PP
.SH METHODS
.TP
\fImBarInst\fR \fBdefine\fR \fIbody\fR
Compiles \fIbody\fR into a tree of menu entries which define the
visual layout of the menubar. The \fIbody\fR argument
describes the layout using the following syntax, where the
elements of the syntax are described below.
.sp
\fIbody == definitions\fR
.nf

definitions    ::= { <ignore> | <definition> | <definition> <definitions> }
ignore         ::= { <nl> | <white-space> <nl> | # <comment> <nl> }
definition     ::= { <command> | <checkbutton> | <radiobutton> | <separator> | <group> | <menu> }
command        ::= <label> C <tag> <nl>
checkbutton    ::= <label> X<scope> { <tag> | <tag>+ } <nl>
radiobutton    ::= <label> R<scope> { <tag> | <tag>+ } <nl>
separator      ::= <stext> S <tag> <nl>
group          ::= <dummy> G <tag> <nl>
menu           ::= <label> { M:<tag> | M:<tag>+ } <nl> <definitions>
stext          ::= '--' | <label>
scope          ::= '' | '@' | '='

.fi
\fI \fR
.RS
.TP
C - Command
The C type entry is the most common type of entry. This entry executes
a command when it is invoked.
.TP
X - Checkbutton
A X type entry behaves much like a Tk checkbutton
widget. When it is invoked it toggles back and forth between
a selected and deselected states. The value of a checkbutton
is a boolean (i.e. 1 or 0). By default all checkbuttons are
deselected. If you want the checkbutton to be initially selected
then include a trailing plus (+) with the tag name. See SCOPE CONTROL
below for a description of the scope indicator.
.TP
R - Radiobutton
A R type menu entry behaves much like a Tk radiobutton widget. Each
radiobutton entry is a member of a radiobutton group that
controls the behavior of the radiobuttons in the group. All
radiobuttons in a group are given the same tag name. In the
example below Red, Green and Blue all have the same tag and are
therefore all in the same radiobutton group. A trailing plus
(+) on the tag name of a radiobutton entry will cause the entry to be
the initially selected entry. See SCOPE CONTROL
below for a description of the scope indicator.
.TP
S - Separator
A S type menu entry is an entry that is displayed either as a horizontal
dividing line or a label. Separators are not active elements of a menu and
have no associated behavior if they are invoked. If <stext> is two dashes
(i.e. '--') then the separator will be displayed as a horizontal line
otherwise <stext> will be displayed as a bold label surrounded by double
dashes (e.g. "-- <stext> --") with a lightgray background.
.TP
G - Command Group
The G type menu entry marks a location in the menu tree where
entries can be dynamically added and removed. Menu extension can only
occur at the end of a menu so G type entries must be the last item on a menu.
A G	type entry is rendered as a separator line. The \fIgroup.<xxx>\fR
sub-commands are used to manipulate command group entries.
.TP
M - Menu
An M type entry is used to define both menubar menus and cascading
menus. Menu entries are the most complicated of the 6 menu types.
A menu entry is composed of three list elements. The first element
of the list is its label. The second element of the list is a
composite string consisting of a type identifier (M) followed by
an optional tag (beginning with a ':' separator) and finally an
optional plus (+) which indicates that the menu is a tear-off
menu. The final element of the list is a LIST VALUE.
.RE
.PP
.TP
\fImBarInst\fR \fBinstall\fR \fIpathName body\fR
The \fIinstall\fR method installs the menubar created with the
\fIdefine\fR method into toplevel window \fIpathName\fR. The
\fIbody\fR argument of the command contains a tcl script which
is used to initialize the installed menubar. Normally the tcl
script will contain calls to various menubar methods to perform
the initialization. The initialization code is only run once
when the menubar is installed. The namespace in which the \fIinstall\fR
method is executed becomes the default namespace for callback commands
(see \fImenu.namespace\fR below for more details).
.PP
.SH "METHODS - MENU.XXX"
.TP
\fImBarInst\fR \fBmenu.configure\fR \fIoption tag-settings ?option tag-settings ...?\fR
Configures the tags of a menubar and returns an empty string. This method provides a convenient
way to configure a larger number of tags without the verbosity of using the \fItag.configure\fR method.
.RS
.TP
\fIoption\fR
\fIOption\fR may have any of the values accepted by the \fItag.configure\fR method.
.TP
\fItag-settings\fR
The \fItag-settings\fR argument is a string that is converted to a list of tag-value pairs
using the following syntax.
.sp
Syntax for \fItag-settings\fR.
.nf

tag-settings ::= { <ignore> | <value> | <value> <tag-settings> }
ignore       ::= { <nl> | <white-space> <nl> | # <comment> <nl> }
value        ::= <tag> <option-value> <nl>

.fi
.RE
.PP
.TP
\fImBarInst\fR \fBmenu.namespace\fR \fItag namespace\fR
Change the namespace for a sub-tree of the menubar
starting at entry \fItag\fR. The new value will be \fInamespace\fR.
Each entry in the menubar tree has an
associated namespace which will be used for its callback
procedure. The default namespace is the namespace where
the \fIinstall\fR  method was executed. The \fInamespace\fR
method can be used to change the namespace
that will be used for callbacks in a sub-tree of the
menubar. This method can only be used in the context of
an \fIinstall\fR script.
.PP
.TP
\fImBarInst\fR \fBmenu.hide\fR \fItag\fR
Remove (hide) a menubar entry. When a
menubar tree is defined all entries are visible by default.
This method can be used to hide a menubar entry.
The \fIhide\fR methods can be used in the
context of an \fIinstall\fR script so that a menu will be
initially hidden at application start up. The \fItag\fR argument
is the tag name of the menu to be hidden.
.TP
\fImBarInst\fR \fBmenu.show\fR \fItag\fR
Exposes (shows) a hidden menubar entry. When a
menubar tree is defined all entries are visible by default.
If a entry is hidden from the user (using the menu.hide method)
then it can be exposed again using the show method. The \fItag\fR
argument is the tag name of the menu to be shown.
.PP
.SH "METHODS - TAG.XXX"
.TP
\fImBarInst\fR \fBtag.add\fR \fItag value\fR
Add a user defined \fItag\fR value. The \fItag.add\fR method
adds a new tag-value pair to the the tags defined for a
menubar. User defined tags are different from the tags
created by the \fIdefine\fR method. The \fItag.add\fR
method can only be used in an \fIinstall\fR script and its
value is associated with the toplevel where the menubar is
installed. This makes the tag context sensitive so callback
code that queries the tag value will receive a value that
is associated with the window that performed the callback.
.PP
.TP
\fImBarInst\fR \fBtag.configure\fR \fIpathName tag ?option value ...option value?\fR
Given the \fIpathName\fR of a toplevel window and a \fItag\fR this method configures the
menu entry associated with the tag and return an empty string.
.RS
.TP
\fIStandard Options\fR
These option are the same as those described for menu entries in the Tk \fImenu\fR documentation.
.RS
.TP
\fB-activebackground\fR
.TP
\fB-activeforeground\fR
.TP
\fB-background\fR
.TP
\fB-bitmap\fR
.TP
\fB-columnbreak\fR
.TP
\fB-compound\fR
.TP
\fB-font\fR
.TP
\fB-foreground\fR
.TP
\fB-hidemargin\fR
.TP
\fB-image\fR
.TP
\fB-indicatoron\fR
.TP
\fB-label\fR
.TP
\fB-selectcolor\fR
.TP
\fB-selectimage\fR
.TP
\fB-state\fR
.RE
\fI \fR
.TP
Class Specific Options
.RS
.TP
\fB-bind\fR {uline accel sequence}
The value of the \fI-bind\fR option is three element list where the values are as follows.
.RS
.TP
uline
An integer index of a character to underline in the entry.
This value performs the same function as the Tk \fImenu\fR -underline option.
If this value is an empty string then no underlining is performed.
.TP
accel
A string to display at the right side of the menu
entry. The string normally describes an accelerator keystroke sequence that
may be typed to invoke the same function as the menu entry.
This value performs the same function as the Tk \fImenu\fR -accelerator option.
If this value is an empty string then no accelerator is displayed.
.TP
sequence
A bind sequence that will cause the entries associated command to fire.
.RE
.TP
\fB-command\fR cmdprefix
The value of the \fI-command\fR option a command
prefix that is evaluated when the menu entry is invoked.
By default the callback is evaluate in the
namespace where the \fIinstall\fR method was executed. Additional values
are appended to the \fIcmdprefix\fR and are thus passed to the
callback command as argument. These additional arguments are described
in the list below.
.RS
.TP
command entry
1) The pathname of the toplevel window that invoked the callback.
.TP
checkbutton entry
1) The pathname of the toplevel window that invoked the callback.
.sp
2) The checkbutton's tag name
.sp
3) The new value for the checkbutton
.TP
radiobutton entry
1) The pathname of the toplevel window that invoked the callback.
.sp
2) The radiobutton's tag name
.sp
3) The label of the button that was selected
.TP
group entry
1) The pathname of the toplevel window that invoked the callback.
.RE
.RE
.RE
.PP
.TP
\fImBarInst\fR \fBtag.cget\fR \fIpathName tag ?option?\fR
Returns the value of the configuration option given by \fIoption\fR
or the value of a user defined tag. The option argument may be any
of the options accepted by the \fItag.configure\fR method for the
\fItag\fR type. User defined tags are queried without an \fIoption\fR
value.
.PP
.SH "METHODS - GROUP.XXX"
.TP
\fImBarInst\fR \fBgroup.add\fR \fItag label ?cmd? ?accel? ?sequence? ?state?\fR
Add a command to the group with tag name \fItag\fR. This method
appends a new command entry to the end of a command group. The order of the
arguments is fixed but arguments to the right can be ignored. Arguments to
this method have the following meaning.
.RS
.TP
tag \fI(string)\fR
The tag name of the command group.
.TP
label \fI(string)\fR
The displayed label for the menu entry.
.TP
cmd \fI(string)\fR
A command prefix that will be used for callback command.
.TP
accel \fI(string)\fR
An accelerator string that will be displayed next to the entry label.
.TP
sequence \fI(string)\fR
A bind sequence that will be bound to the callback command.
.TP
state \fI(enum)\fR
Sets the active state of the command. One of:  normal, disabled, active
.RE
.PP
.TP
\fImBarInst\fR \fBgroup.delete\fR \fItag label\fR
Delete a command from a group with tag name \fItag\fR. This method
deletes command \fIlabel\fR from a command group.
.PP
.TP
\fImBarInst\fR \fBgroup.move\fR \fIdirection tag label\fR
Change the position of an entry in a group with tag name \fItag\fR.
The \fIdirection\fR argument is the direction ('up' or 'down') the
entry will be moved. The entry that is moved has the name \fIlabel\fR.
.PP
.TP
\fImBarInst\fR \fBgroup.configure\fR \fItag label ?option value ...option value?\fR
Configure the options of an entry in the command group with
tag name \fItag\fR. This method is similar to the \fItag.configure\fR
method except that it works on entries in a command group. Set documentation
for the \fItag.configure\fR method (above) for more details on command
entry options.
.PP
.TP
\fImBarInst\fR \fBgroup.serialize\fR \fItag\fR
Return a string serialization of the entries in a command group. The
argument \fItag\fR is the tag name for the group that is to be serialized.
The resulting serialization is a list containing three
element  (1) the tag name of the group  (2) a dictionary
containing group level options (3) a list of zero or more similar three
element lists that describe the entries in the group.
.PP
.TP
\fImBarInst\fR \fBgroup.deserialize\fR \fItag stream\fR
Replace the contents of group tag \fItag\fR with the commands
defined in the serialization \fIstream\fR. The original contents of
the group are lost.
.PP
.SH "METHODS - NOTEBOOK.XXX"
.TP
\fImBarInst\fR \fBnotebook.addTabStore\fR \fIpathname\fR
This method should be used in code that creates a new notebook tab.
Execution of this method will cause state storage to be allocated
for the new notebook tab. The pathname for the notebook tab is passed
as an argument to the method.
.PP
.TP
\fImBarInst\fR \fBnotebook.deleteTabStore\fR \fIpathname\fR
This command deallocates the state store for a notebook tab. The
pathname for the notebook tab is passed as an argument to the method.
.PP
.TP
\fImBarInst\fR \fBnotebook.setTabValue\fR \fIpathname tag\fR
This method should be used in the callback for menubar checkbuttons or
radiobuttons that have notebook tab scope control. When this method is
executed it will move the value associated with tag into the tab store
for the tab identified by pathname.
.PP
.TP
\fImBarInst\fR \fBnotebook.restoreTabValues\fR \fIpathname\fR
This method should be place in a bind script that is triggered by
a notebooks <<NotebookTabChanged>> event.
.PP
.SH "SCOPE CONTROL"
.PP
By default a menubar instance looks the same in all installed toplevel
windows. As changes are made to one instance of a menubar all the other
instances are immediately updated. This means the internal state of all
the menu entries for the instances are synchronized. This behavior is
called global scope control of the menubar state.
.PP
The menubar class allows finer scope control on check and radio buttons.
The scope of these entry types can be modified by adding a
modifier character to their type character. Two
modifier characters are supported as show in the table below.
.nf

''  ::= global scope (no character)
'@' ::= local scope modifier
'=' ::= notebook tab scope modifier

.fi
.PP
When the local scope character (@) is added to the definition of a button,
the button is given a new variable for each installed toplevel window. This
has the effect of making the button's state local to the window (i.e. local scope).
An example use case for this behavior might be a status bar that can be
toggled on an off by a checkbutton. The developer may want to allow the
user to control the visibility of the status bar on a per window basis. In this
case a local modifier would be added to the status bar selector so the callback
code would receive an appropriate value based on the current toplevel window.
.PP
The notebook tab scope character (=) is similar in effect to the local scope
character but it allows a notebook tab selection to also manage the state of
of a button. Adding the notebook tab scope modifier enables notebook tab
scope control but the developer must then make use of the notebook.xxxx sub-commands
to actively manage state values as tabs are added, deleted and selected.
.SH EXAMPLE
.nf

package require Tcl
package require Tk
package require menubar

set tout [text .t -width 25 -height 12]
pack ${tout} -expand 1 -fill both
set mbar [menubar new \\
    -borderwidth 4 \\
    -relief groove  \\
    -foreground black \\
    -background tan \\
    ]
${mbar} define {
    File M:file {
        Exit                 C      exit
    }
    Edit M:items+ {
    #   Label               Type    Tag Name(s)
    #   -----------------   ----    ---------
        "Cut"               C       cut
        "Copy"              C       copy
        "Paste"             C       paste
        --                  S       s2
        "Options" M:opts {
            "CheckList" M:chx+ {
                Coffee      X       coffee+
                Donut       X       donut
                Eggs        X       eggs
                }
            "RadioButtons" M:btn+ {
                "Red"       R       color
                "Green"     R       color+
                "Blue"      R       color
                }
        }
    }
    Help M:help {
        About               C       about
    }
}
${mbar} install . {
    ${mbar} tag.add tout ${tout}
    ${mbar} menu.configure -command {
        # file menu
        exit            {Exit}
        # Item menu
        cut             {CB Edit cut}
        copy            {CB Edit copy}
        paste           {CB Edit paste}
        # boolean menu
        coffee          {CB CheckButton}
        donut           {CB CheckButton}
        eggs            {CB CheckButton}
        # radio menu
        color           {CB RadioButton}
        # Help menu
        about           {CB About}
    } -bind {
        exit        {1 Cntl+Q  Control-Key-q}
        cut         {2 Cntl+X  Control-Key-x}
        copy        {0 Cntl+C  Control-Key-c}
        paste       {0 Cntl+V  Control-Key-v}
        coffee      {0 Cntl+A  Control-Key-a}
        donut       {0 Cntl+B  Control-Key-b}
        eggs        {0 Cntl+C  Control-Key-c}
        about       0
    } -background {
        exit red
    } -foreground {
        exit white
    }
}
proc pout { txt } {
    global mbar
    set tout [${mbar} tag.cget . tout]
    ${tout} insert end "${txt}\\n"
}
proc Exit { args } {
    puts "Goodbye"
    exit
}
proc CB { args } {
    set alist [lassign ${args} cmd]
    pout "${cmd}: [join ${alist} {, }]"
}
wm minsize . 300 300
wm geometry . +4+4
wm protocol . WM_DELETE_WINDOW exit
wm title . "Example"
wm focusmodel . active
pout "Example started ..."

.fi
.SH CAVEATS
.PP
This implementation uses TclOO so it requires 8.6. The code has been
tested on Windows (Vista), Linux and OSX (10.4).
.SH "SEE ALSO"
\fIA command that creates menubar objects\fR [http://wiki.tcl.tk/25231], \fImenu\fR [http://www.tcl.tk/man/tcl8.6/TkCmd/menu.htm]
.SH COPYRIGHT
.nf
Copyright (c) 2009 Tom Krehbiel <krehbiel.tom@gmail.com> All rights reserved.

.fi