'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tklib/tklib/modules/ntext/ntextBindings.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ntextBindings" n 0.81 ntext "Alternative Bindings for the Text Widget"
.BS
.SH NAME
ntextBindings \- Alternative Bindings for the Text Widget
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBTk  8.5\fR
.sp
package require \fBntext  ?0.81?\fR
.sp
.BE
.SH DESCRIPTION
The \fBntext\fR package provides a binding tag named \fINtext\fR for use by text widgets in place of the default \fIText\fR binding tag.
.PP
The \fIText\fR binding tag provides around one hundred bindings to the text widget (the exact number is platform-dependent).  A few of these behave in a way that is different from most contemporary text-editing applications.  \fINtext\fR aims to provide more familiar behaviour.
.PP
Features of the \fINtext\fR bindings that differ from the default \fIText\fR bindings:
.IP \(bu
Clicking near the end of a (logical) line moves the cursor to the end of that line \fI(not the start of the next line)\fR.  If the widget is in \fI-wrap\fR \fIword\fR mode, the same rule applies to display lines.
.IP \(bu
Double-clicking or dragging near the end of a (logical) line will highlight/select characters from the end of that line \fI(not the next line, or the region at the end of the line where there are no characters)\fR.  If the widget is in \fI-wrap\fR \fIword\fR mode, the same rule applies to display lines.
.IP \(bu
The \fIEnd\fR key implements "Smart End" (successive keypresses move the cursor to the end of the display line, then to the end of the logical line); the \fIHome\fR key implements "Smart Home" (which is similar to "Smart End", but also toggles between the beginning and end of leading whitespace).
.IP \(bu
When a selection exists, a <<Paste>> operation (e.g. <Control-v>) overwrites the selection (as most editors do), and does so on all platforms.
.IP \(bu
The <Insert> key toggles between "Insert" and "Overwrite" modes for keyboard input.  \fI(In contrast, the Text binding tag uses <Insert> as a method to paste the "primary selection", a task that can be accomplished instead by mouse middle-click.)\fR
.IP \(bu
The <Escape> key clears the selection.
.IP \(bu
Selecting with <Shift-Button1> selects from the previous position of the insertion cursor. \fI(In the Text binding tag, the selection anchor may be the position of the previous mouse click.)\fR
.IP \(bu
<Shift-Button1> operations do not alter the selection anchor. \fI(In the Text binding tag, they do.)\fR
.IP \(bu
By default, the \fINtext\fR binding tag does not provide several of the Control-key bindings supplied by the \fIText\fR binding tag.  Modern keyboards offer alternatives, such as cursor keys for navigation; modern applications often use the Control-key bindings for other purposes (e.g. <Control-p> for "print").
.PP
The last three cases, the behavior of \fIText\fR is often useful, so \fINtext\fR gives you the option of retaining it, by setting variables defined in the ::ntext namespace to 1 (instead of their default 0).  Explaining these features in more detail:
.IP \(bu
If the mouse is clicked at position A, then the keyboard is used to move the cursor to B, then shift is held down, and the mouse is clicked at C: the \fIText\fR binding tag gives a selection from A to C; the \fINtext\fR gives a selection from B to C.  If you want \fINtext\fR to behave like \fIText\fR in this respect, set \fB::ntext::classicMouseSelect\fR to 1.
.IP \(bu
The \fIText\fR binding tag allows successive <Shift-Button-1> events to change both ends of the selection, by moving the selection anchor to the end of the selection furthest from the mouse click.  Instead, the \fINtext\fR binding tag fixes the anchor, and multiple Shift-Button-1 events can only move the non-anchored end of the selection.  If you want \fINtext\fR to behave like \fIText\fR in this respect, set \fB::ntext::classicAnchor\fR to 1.  In both \fIText\fR and \fINtext\fR, keyboard navigation with the Shift key held down alters the selection and keeps the selection anchor fixed.
.IP \(bu
The following "extra" \fIText\fR bindings are switched off by default, but can be activated in \fINtext\fR by setting \fB::ntext::classicExtras\fR to 1: <Control-a>, <Control-b>, <Control-d>, <Control-e>, <Control-f>, <Control-h>, <Control-i>, <Control-k>, <Control-n>, <Control-o>, <Control-p>, <Control-t>, <Control-space>, <Control-Shift-space>.
.PP
.SH "CONFIGURATION OPTIONS"
\fINtext\fR provides alternatives to a number of behaviours of the classic \fIText\fR binding tag.  Where there is an option, the \fINtext\fR behaviour is switched on by default, except for display-line indentation which is discussed on a separate page at \fIntextIndent\fR.
.PP
The behaviour of \fINtext\fR may be configured application-wide by setting the values of a number of namespace variables:
.PP
\fB::ntext::classicAnchor\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i.e. the anchor point is fixed
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i.e. the anchor point is variable
.PP
.PP
\fB::ntext::classicExtras\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i.e. several "extra" \fIText\fR bindings are de-activated
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i.e. the "extra" \fIText\fR bindings are activated
.PP
.PP
\fB::ntext::classicMouseSelect\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i.e. the anchor point for mouse selection operations is moved by keyboard navigation
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour
.PP
.PP
\fB::ntext::overwrite\fR
.IP \(bu
\fB0\fR - (initial value) text typed at the keyboard is inserted into the widget
.IP \(bu
\fB1\fR - text typed at the keyboard overwrites text already in the widget
.IP \(bu
The value is toggled by the \fIInsert\fR key.
.PP
.SH EXAMPLE
To use \fINtext\fR but keep classic \fIText\fR 's variable-anchor feature:
.nf

package require ntext
text .t
set ::ntext::classicAnchor 1
bindtags .t {.t Ntext . all}

.fi
.SH "SEE ALSO"
bindtags, ntext, ntextIndent, text
.SH KEYWORDS
bindtags, text