'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/ntp/ntp_time.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002, Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ntp_time" n 1.2.1 ntp "Network Time Facilities"
.BS
.SH NAME
ntp_time \- Tcl Time Service Client
.SH SYNOPSIS
package require \fBTcl  8.0\fR
.sp
package require \fBtime  ?1.2.1?\fR
.sp
\fB::time::gettime\fR ?\fIoptions\fR? \fItimeserver\fR ?\fIport\fR?
.sp
\fB::time::getsntp\fR ?\fIoptions\fR? \fItimeserver\fR ?\fIport\fR?
.sp
\fB::time::configure\fR ?\fIoptions\fR?
.sp
\fB::time::cget\fR \fIname\fR
.sp
\fB::time::unixtime\fR \fItoken\fR
.sp
\fB::time::status\fR \fItoken\fR
.sp
\fB::time::error\fR \fItoken\fR
.sp
\fB::time::reset\fR \fItoken\fR \fI?reason?\fR
.sp
\fB::time::wait\fR \fItoken\fR
.sp
\fB::time::cleanup\fR \fItoken\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package implements a client for the RFC 868 TIME protocol
(\fIhttp://www.rfc-editor.org/rfc/rfc868.txt\fR) and also a minimal
client for the RFC 2030 Simple Network Time Protocol
(\fIhttp://www.rfc-editor.org/rfc/rfc2030.txt\fR).
RFC 868 returns the time in seconds since 1 January 1900
to either tcp or udp clients. RFC 2030 also gives this time but also
provides a fractional part which is not used in this client.
.SH COMMANDS
.TP
\fB::time::gettime\fR ?\fIoptions\fR? \fItimeserver\fR ?\fIport\fR?
Get the time from \fItimeserver\fR. You may specify any of the options
listed for the \fBconfigure\fR command here. This command returns a
token which must then be used with the remaining commands in this
package. Once you have finished, you should use \fBcleanup\fR to
release all resources. The default port is \fB37\fR.
.TP
\fB::time::getsntp\fR ?\fIoptions\fR? \fItimeserver\fR ?\fIport\fR?
Get the time from an SNTP server. This accepts exactly the same
arguments as \fB::time::gettime\fR except that the default port is
\fB123\fR. The result is a token as per \fB::time::gettime\fR and
should be handled in the same way.
.sp
Note that it is unlikely that any SNTP server will reply using tcp so
you will require the \fBtcludp\fR or the \fBceptcl\fR
package. If a suitable package can be loaded then the udp protocol
will be used by default.
.TP
\fB::time::configure\fR ?\fIoptions\fR?
Called with no arguments this command returns all the current
configuration options and values. Otherwise it should be called with
pairs of option name and value.
.RS
.TP
\fB-protocol\fR \fInumber\fR
Set the default network protocol. This defaults to udp if the tcludp
package is available. Otherwise it will use tcp.
.TP
\fB-port\fR \fInumber\fR
Set the default port to use. RFC 868 uses port \fB37\fR, RFC 2030 uses
port \fB123\fR.
.TP
\fB-timeout\fR \fInumber\fR
Set the default timeout value in milliseconds. The default is 10 seconds.
.TP
\fB-command\fR \fInumber\fR
Set a command procedure to be run when a reply is received. The
procedure is called with the time token appended to the argument list.
.TP
\fB-loglevel\fR \fInumber\fR
Set the logging level. The default is 'warning'.
.RE
.TP
\fB::time::cget\fR \fIname\fR
Get the current value for the named configuration option.
.TP
\fB::time::unixtime\fR \fItoken\fR
Format the returned time for the unix epoch. RFC 868 time defines
time 0 as 1 Jan 1900, while unix time defines time 0 as 1 Jan
1970. This command converts the reply to unix time.
.TP
\fB::time::status\fR \fItoken\fR
Returns the status flag. For a successfully completed query this will be
\fIok\fR. May be \fIerror\fR or \fItimeout\fR or \fIeof\fR.
See also \fB::time::error\fR
.TP
\fB::time::error\fR \fItoken\fR
Returns the error message provided for requests whose status is \fIerror\fR.
If there is no error message then an empty string is returned.
.TP
\fB::time::reset\fR \fItoken\fR \fI?reason?\fR
Reset or cancel the query optionally specfying the reason to record
for the \fBerror\fR command.
.TP
\fB::time::wait\fR \fItoken\fR
Wait for a query to complete and return the status upon completion.
.TP
\fB::time::cleanup\fR \fItoken\fR
Remove all state variables associated with the request.
.PP
.nf

% set tok [::time::gettime ntp2a.mcc.ac.uk]
% set t [::time::unixtime $tok]
% ::time::cleanup $tok

.fi
.nf

% set tok [::time::getsntp pool.ntp.org]
% set t [::time::unixtime $tok]
% ::time::cleanup $tok

.fi
.nf

proc on_time {token} {
   if {[time::status $token] eq "ok"} {
      puts [clock format [time::unixtime $token]]
   } else {
      puts [time::error $token]
   }
   time::cleanup $token
}
time::getsntp -command on_time pool.ntp.org

.fi
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIntp\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
ntp
.SH KEYWORDS
NTP, SNTP, rfc 2030, rfc 868, time
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2002, Pat Thoyts <patthoyts@users.sourceforge.net>

.fi