'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/stringprep/stringprep.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007-2009, Sergei Golovan <sgolovan@nes.ru>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "stringprep" n 1.0.1 stringprep "Preparation of Internationalized Strings"
.BS
.SH NAME
stringprep \- Implementation of stringprep
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBstringprep  1.0.1\fR
.sp
\fB::stringprep::register\fR \fIprofile\fR ?\fI-mapping list\fR? ?\fI-normalization form\fR? ?\fI-prohibited list\fR? ?\fI-prohibitedList list\fR? ?\fI-prohibitedCommand command\fR? ?\fI-prohibitedBidi boolean\fR?
.sp
\fB::stringprep::stringprep\fR \fIprofile\fR \fIstring\fR
.sp
\fB::stringprep::compare\fR \fIprofile\fR \fIstring1\fR \fIstring2\fR
.sp
.BE
.SH DESCRIPTION
.PP
This is an implementation in Tcl of the Preparation of Internationalized
Strings ("stringprep"). It allows to define stringprep profiles and use
them to prepare Unicode strings for comparison as defined in RFC-3454.
.SH COMMANDS
.TP
\fB::stringprep::register\fR \fIprofile\fR ?\fI-mapping list\fR? ?\fI-normalization form\fR? ?\fI-prohibited list\fR? ?\fI-prohibitedList list\fR? ?\fI-prohibitedCommand command\fR? ?\fI-prohibitedBidi boolean\fR?
Register the \fBstringprep\fR profile named \fIprofile\fR. Options
are the following.
.sp
Option \fI-mapping\fR specifies \fBstringprep\fR mapping tables.
This parameter takes list of tables from appendix B of RFC-3454. The usual
list values are {B.1 B.2} or {B.1 B.3} where B.1 contains characters which
commonly map to nothing, B.3 specifies case folding, and B.2 is used in
profiles with unicode normalization form KC. Defult value is {} which means
no mapping.
.sp
Option \fI-normalization\fR takes a string and if it is nonempty then it
uses as a name of Unicode normalization form. Any value of "D", "C", "KD"
or "KC" may be used, though RFC-3454 defines only two options: no
normalization or normalization using form KC.
.sp
Option \fI-prohibited\fR takes a list of RFC-3454 tables with prohibited
characters. Current version does allow to prohibit either all tables from
C.3 to C.9 or neither of them. An example of this list for RFC-3491 is
{A.1 C.1.2 C.2.2 C.3 C.4 C.5 C.6 C.7 C.8 C.9}.
.sp
Option \fI-prohibitedList\fR specifies a list of additional prohibited
characters. The list contains not characters themselves but their Unicode
numbers. For example, Nodeprep specification from RFC-3920 forbids the
following codes: {0x22 0x26 0x27 0x2f 0x3a 0x3c 0x3e 0x40} (\\" \\& \\' / : < > @).
.sp
Option \fI-prohibitedCommand\fR specifies a command which is called for
every character code in mapped and normalized string. If the command returns
true then the character is considered prohibited. This option is useful when
a list for \fI-prohibitedList\fR is too large.
.sp
Option \fI-prohibitedBidi\fR takes boolean value and if it is true then the
bidirectional character processing rules defined in section 6 of RFC-3454 are
used.
.TP
\fB::stringprep::stringprep\fR \fIprofile\fR \fIstring\fR
Performs \fBstringprep\fR operations defined in profile \fIprofile\fR
to string \fIstring\fR. Result is a prepared string or one of the following
errors: \fIinvalid_profile\fR (profile \fIprofile\fR is not defined),
\fIprohibited_character\fR (string \fIstring\fR contains a prohibited character)
or \fIprohibited_bidi\fR (string \fIstring\fR contains a prohibited bidirectional
sequence).
.TP
\fB::stringprep::compare\fR \fIprofile\fR \fIstring1\fR \fIstring2\fR
Compares two unicode strings prepared accordingly to \fBstringprep\fR
profile \fIprofile\fR. The command returns 0 if prepared strings are equal,
-1 if \fIstring1\fR is lexicographically less than \fIstring2\fR, or
1 if \fIstring1\fR is lexicographically greater than \fIstring2\fR.
.PP
.SH EXAMPLES
Nameprep profile definition (see RFC-3491):
.nf

::stringprep::register nameprep  -mapping {B.1 B.2}  -normalization KC  -prohibited {A.1 C.1.2 C.2.2 C.3 C.4 C.5 C.6 C.7 C.8 C.9}  -prohibitedBidi 1

.fi
Nodeprep and resourceprep profile definitions (see RFC-3920):
.nf

::stringprep::register nodeprep  -mapping {B.1 B.2}  -normalization KC  -prohibited {A.1 C.1.1 C.1.2 C.2.1 C.2.2 C.3 C.4 C.5 C.6 C.7 C.8 C.9}  -prohibitedList {0x22 0x26 0x27 0x2f 0x3a 0x3c 0x3e 0x40}  -prohibitedBidi 1

::stringprep::register resourceprep  -mapping {B.1}  -normalization KC  -prohibited {A.1 C.1.2 C.2.1 C.2.2 C.3 C.4 C.5 C.6 C.7 C.8 C.9}  -prohibitedBidi 1

.fi
.SH REFERENCES
.IP [1]
"Preparation of Internationalized Strings ('stringprep')",
(\fIhttp://www.ietf.org/rfc/rfc3454.txt\fR)
.IP [2]
"Nameprep: A Stringprep Profile for Internationalized Domain Names (IDN)",
(\fIhttp://www.ietf.org/rfc/rfc3491.txt\fR)
.IP [3]
"Extensible Messaging and Presence Protocol (XMPP): Core",
(\fIhttp://www.ietf.org/rfc/rfc3920.txt\fR)
.PP
.SH AUTHORS
Sergei Golovan
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIstringprep\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
unicode(n)
.SH KEYWORDS
stringprep, unicode
.SH COPYRIGHT
.nf
Copyright (c) 2007-2009, Sergei Golovan <sgolovan@nes.ru>

.fi