'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tcllib/tcllib/modules/tepam/tepam_introduction.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009/2010, Andreas Drollinger
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tepam" n 0.1 tepam "Tcl's Enhanced Procedure and Argument Manager"
.BS
.SH NAME
tepam \- An introduction into TEPAM, Tcl's Enhanced Procedure and Argument Manager
.SH DESCRIPTION
.PP
This document is an informal introduction into version 0.1 of TEPAM, the Tcl's Enhanced Procedure and Argument Manager. Detailed information to the TEPAM package is provided in the \fItepam::procedure\fR and \fItepam::argument_dialogbox\fR reference manuals.
.SH OVERVIEW
This package provides a new Tcl procedure declaration syntax that simplifies the implementation of procedure subcommands and the handling of the different types of procedure arguments like flags or switches, options, unnamed arguments, optional and mandatory options and arguments, default values, etc. Procedure declarations can be enriched with detailed information about the procedure and its arguments. This information is used later for the following purposes:
.PP
First of all, an argument manager that is automatically added to a procedure implemented with TEPAM checks the argument types and values before the procedure body is executed. Then, the information is used to generate help and usage texts if requested, or to generate clear error message in case an argument validation fails. The information also allows generating automatically graphical forms that allows an interactive definition of all arguments, in case a procedure is called interactively. And finally, the additional information helps self-commenting in a clean way the declaration of a procedure and of all its arguments.
.PP
The graphical form generator that creates the necessary argument specification forms for the interactive procedure calls is also available for other purposes than for procedure argument specifications. It allows creating code efficiently complex parameter entry forms that are usable independently from TEPAM's new procedure definition feature.
.PP
Here is a short overview about all major TEPAM features:
.IP \(bu
New self-documenting procedure declaration syntax: The additional information to declare properly a procedure has not to be provided with additional statements, but can be added in a natural syntax directly into the procedure header.
.IP \(bu
Easy way to specify subcommands: A subcommand is declared like a procedure, simply with a procedure name composed by a base name followed by a subcommand name. Sub-subcommands are created identically using simply procedure names composed by 3 words.
.IP \(bu
Flexible usage of flags (switches), options (named arguments) and unnamed arguments. Option names are optionally automatically completed.
.IP \(bu
Support for default values, mandatory/optional options and arguments, choice lists, valid value ranges, multiple usable options/arguments.
.IP \(bu
Choice of a \fInamed arguments first, unnamed arguments later\fR procedure calling style (typical for Tcl commands) or of an \fIunnamed arguments first, named arguments later\fR procedure calling style (typical for Tk commands).
.IP \(bu
In case the \fInamed arguments first, unnamed arguments later\fR style (Tcl) is selected:  Clear separation between options and arguments via the "--" flag. The unnamed arguments can optionally be accessed as options (named arguments).
.IP \(bu
Automatic type and value check before the procedure body is executed, taking into account validation ranges, choice lists and custom validation commands. Generation of clear error message if necessary.
.IP \(bu
Many predefined types exist (integer, boolean, double, color, file, font, ...). Other application specific types can easily be added.
.IP \(bu
Automatic help and usage text generation when a procedure is called with the \fI-help\fR flag.
.IP \(bu
Automatic generation of an interactive argument definition form, in case a procedure is called with the \fI-interactive\fR flag.
.IP \(bu
Powerful and code efficient generation of complex parameter definition forms.
.PP
.SH "PROCEDURE DECLARATION"
TEPAM's procedure declaration syntax is simple and self-explaining. Instead of declaring a procedure with the Tcl key word \fBproc\fR, a procedure is declared with the TEPAM command \fBprocedure\fR which takes as \fBproc\fR also 3 arguments: The procedure name, the procedure header and the procedure body.
.PP
The following example declares the subcommand \fBmessage\fR of the procedure \fBdisplay\fR. This command has several named and unnamed arguments:
.nf
\fBtepam::procedure\fR {display message} {
   -return            -
   -short_description "Displays a simple message box"
   -description       "This procedure allows displaying a configurable message box.
   -args {
      {-mtype -default Warning -choices {Info Warning Error} -description "Message type"}
      {-font -type font -default {Arial 10 italic} -description "Message text font"}
      {-level -type integer -optional -range {1 10} -description "Message level"}
      {-fg -type color -default black -description "Message color"}
      {-bg -type color -optional -description "Background color"}
      {-no_border -type none -description "Use a splash window style (no border)"}
      {-log_file -type file -optional -description "Optional message log file"}
      {text -type string -multiple -description "Multiple text lines to display"}
   }
} {\fI
   puts "display message:"
   foreach var {mtype font level fg bg no_border log_file text} {
      if {[info exists $var]} {
         puts  "  $var=[set $var]"
      }
   }
\fR}
.fi
When a procedure that has been declared in this way is called, the TEPAM argument manager is automatically invoked before the procedure body is executed. The argument manager parses the provided arguments, validates them, completes them eventually with some default values, and makes them finally available to the procedure body as local variables. In case an argument is missing or has a wrong type, the argument manager generates an error message that explains the reason for the error.
.PP
As the example above shows, the TEPAM command \fBprocedure\fR accepts subcommand definitions as procedure name and allows defining much more information than just the argument list inside the procedure header. The procedure body on the other hand is identical between a command declared with \fBproc\fR or with \fBprocedure\fR.
.PP
The procedure header allows defining in addition to the arguments some procedure attributes, like a description, information concerning the return value, etc. This information is basically used for the automatic generation of comprehensive help and usage texts.
.PP
A list of argument definition statements assigned to the \fI-args\fR argument is defining the procedure arguments. Each argument definition statement starts with the argument name, optionally followed by some argument attributes.
.PP
Three types of arguments can be defined: Unnamed arguments, named arguments and flags. The distinction between the named and unnamed arguments is made by the first argument name character which is simply "-" for named arguments. Flags are defined as named argument that has a type set to \fInone\fR.
.PP
Named and unnamed arguments are mandatory, unless they are declared with the \fI-optional\fR flag and unless they have a default value specified with the \fI-default\fR option. Named arguments and the last unnamed argument can have the attribute \fI-multiple\fR, which means that they can be defined multiple times. The expected argument data type is specified with the \fI-type\fR option. TEPAM defines a large set of standard data types which can easily be completed with application specific data types.
.PP
The argument declaration order has only an importance for unnamed arguments that are by default parsed after the named arguments (Tcl style). A variable allows changing this behavior in a way that unnamed arguments are parsed first, before the named arguments (Tk style).
.SH "PROCEDURE HELP"
The declared procedure can simply be called with the \fI-help\fR option to get the information about the usage of the procedure and its arguments:
.nf
\fBdisplay message\fR -help
\fI  ->
NAME
      display message - Displays a simple message box
SYNOPSYS
      display message
            [-mtype <mtype>] :
               Message type, default: "Warning", choices: {Info Warning Error}
            [-font <font>] :
               Message text font, type: font, default: Arial 10 italic
            [-level <level>] :
               Message level, type: integer, range: 1..10
            [-fg <fg>] :
               Message color, type: color, default: black
            [-bg <bg>] :
               Background color, type: color
            [-no_border ] :
               Use a splash window style (no border)
            [-log_file <log_file>] :
               Optional message log file, type: file
            <text> :
               Multiple text lines to display, type: string
DESCRIPTION
      This procedure allows displaying a configurable message box.\fR
.fi
.SH "PROCEDURE CALL"
The specified procedure can be called in many ways. The following listing shows some valid procedure calls:
.nf
\fBdisplay message\fR "The document hasn't yet been saved!"
\fI-> display message:
     mtype=Warning
     font=Arial 10 italic
     fg=black
     no_border=0
     text={The document hasn't yet been saved!}\fR

\fBdisplay message\fR -fg red -bg black "Please save first the document"
\fI-> display message:
     mtype=Warning
     font=Arial 10 italic
     fg=red
     bg=black
     no_border=0
     text={Please save first the document}\fR

\fBdisplay message\fR -mtype Error -no_border "Why is here no border?"
\fI-> display message:
     mtype=Error
     font=Arial 10 italic
     fg=black
     no_border=1
     text={Why is here no border?}\fR

\fBdisplay message\fR -font {Courier 12} -level 10 \\
   "Is there enough space?" "Reduce otherwise the font size!"
\fI-> display message:
     mtype=Warning
     font=Courier 12
     level=10
     fg=black
     no_border=0
     text={Is there enough space?} {Reduce otherwise the font size!}\fR
.fi
The next lines show how wrong arguments are recognized. The \fItext\fR argument that is mandatory is missing in the first procedure call:
.nf
\fBdisplay message\fR -font {Courier 12}
\fI  -> display message: Required argument is missing: text\fR
.fi
Only valid arguments are accepted:
.nf
\fBdisplay message\fR -category warning Hello
\fI  -> display message: Argument '-category' not known\fR
.fi
Argument types are automatically checked and an error message is generated in case the argument type is not satisfied.
.nf
\fBdisplay message\fR -fg MyColor "Hello"
\fI  -> display message: Argument 'fg' requires type 'color'. \\
            Provided value: 'MyColor'\fR
.fi
Selection choices have to be respected...
.nf
\fBdisplay message\fR -mtype Fatal Hello
\fI  -> display message: Argument (mtype) has to be one of the \\
            following elements: Info, Warning, Error\fR
.fi
... as well as valid value ranges:
.nf
\fBdisplay message\fR -level 12 Hello
\fI  -> display message: Argument (level) has to be between 1 and 10\fR
.fi
.SH "INTERACTIVE ARGUMENT DEFINITION"
The most intuitive way to call the procedure is using an interactive form that allows specifying all arguments. This form will automatically be generated when the declared procedure is called with the \fI-interactive\fR flag.
.nf
\fBdisplay message\fR -interactive
.fi
The generated form contains for each argument a data entry widget that is adapted to the argument type. Check buttons are used to specify flags, radio boxes for tiny choice lists, disjoint list boxes for larger choice lists and files, directories, fonts and colors can be selected with dedicated browsers.
.PP
After acknowledging the specified argument data via an OK button, the entered data are first validated, before the provided arguments are transformed into local variables and the procedure body is executed. In case the entered data are invalid, a message appears and the user can correct them until they are valid.
.SH "FLEXIBLE ARGUMENT DIALOG BOX"
The form generator that creates in the previous example the argument dialog box for the interactive procedure call is also available for other purposes than for the definition of procedure arguments. Even if Tk is well known for its code efficient way to build GUIs, the presented argument dialog box allows crating complex parameter definition forms in a still much more efficient way.
.PP
The following example tries to illustrate the simplicity to create complex data entry forms. It creates an input mask that allows specifying a file to copy, a destination folder as well as a checkbox that allows specifying if an eventual existing file can be overwritten. Comfortable browsers can be used to select files and directories. And finally, the form offers also the possibility to accept and decline the selection. Here is the code snippet that is doing all this:
.nf
\fBtepam::argument_dialogbox\fR \\
   \fB-existingfile\fR {-label "Source file" -variable SourceFile} \\
   \fB-existingdirectory\fR {-label "Destination folder" -variable DestDir} \\
   \fB-checkbutton\fR {-label "Overwrite existing file" -variable Overwrite}
.fi
The \fBargument_dialogbox\fR returns \fBok\fR when the entered data are validated and \fBcancel\fR when the data entry has been canceled. After the validation of the entered data, the \fBargument_dialogbox\fR defines all the specified variables with the entered data inside the calling context.
.PP
A pair of arguments has to be provided to \fBargument_dialogbox\fR for each variable that has to be specified by this last one. The first argument defines the entry widget type to use to select the variable's data and the second one is a lists of attributes related to the variable and the entry widget.
.PP
Many entry widget types are available: Beside the simple generic entries, there are different kinds of list and combo boxes available, browsers for existing and new files and directories, check and radio boxes and buttons, as well as color and font pickers. If necessary, additional entry widget types can be defined.
.PP
The attribute list contains pairs of attribute names and attribute data. The primary attribute is \fI-variable\fR used to specify the variable in the calling context into which the entered data has to be stored. Another often used attribute is \fI-label\fR that allows adding a label to the data entry widget. Other attributes are available that allows specifying default values, the expected data types, valid data ranges, etc.
.PP
The next example of a more complex argument dialog box provides a good overview about the different available entry widget types and parameter attributes. The example contains also some formatting instructions like \fI-frame\fR and \fI-sep\fR which allows organizing the different entry widgets in frames and sections:
.nf
set ChoiceList {"Choice 1" "Choice 2" "Choice 3" "Choice 4" "Choice 5" "Choice 6"}

set Result [\fBtepam::argument_dialogbox\fR \\
   \fB-title\fR "System configuration" \\
   \fB-context\fR test_1 \\
   \fB-frame\fR {-label "Entries"} \\
      \fB-entry\fR {-label Entry1 -variable Entry1} \\
      \fB-entry\fR {-label Entry2 -variable Entry2 -default "my default"} \\
   \fB-frame\fR {-label "Listbox & combobox"} \\
      \fB-listbox\fR {-label "Listbox, single selection" -variable Listbox1 \\
                -choices {1 2 3 4 5 6 7 8} -default 1 -height 3} \\
      \fB-listbox\fR {-label "Listbox, multiple selection" -variable Listbox2
                -choicevariable ChoiceList -default {"Choice 2" "Choice 3"}
                -multiple_selection 1 -height 3} \\
      \fB-disjointlistbox\fR {-label "Disjoined listbox" -variable DisJntListbox
                        -choicevariable ChoiceList \\
                        -default {"Choice 3" "Choice 5"} -height 3} \\
      \fB-combobox\fR {-label "Combobox" -variable Combobox \\
                 -choices {1 2 3 4 5 6 7 8} -default 3} \\
   \fB-frame\fR {-label "Checkbox, radiobox and checkbutton"} \\
      \fB-checkbox\fR {-label Checkbox -variable Checkbox
                 -choices {bold italic underline} -choicelabels {Bold Italic Underline} \\
                 -default italic} \\
      \fB-radiobox\fR {-label Radiobox -variable Radiobox
                 -choices {bold italic underline} -choicelabels {Bold Italic Underline} \\
                 -default underline} \\
      \fB-checkbutton\fR {-label CheckButton -variable Checkbutton -default 1} \\
   \fB-frame\fR {-label "Files & directories"} \\
      \fB-existingfile\fR {-label "Input file" -variable InputFile} \\
      \fB-file\fR {-label "Output file" -variable OutputFile} \\
      \fB-sep\fR {} \\
      \fB-existingdirectory\fR {-label "Input directory" -variable InputDirectory} \\
      \fB-directory\fR {-label "Output irectory" -variable OutputDirectory} \\
   \fB-frame\fR {-label "Colors and fonts"} \\
      \fB-color\fR {-label "Background color" -variable Color -default red} \\
      \fB-sep\fR {} \\
      \fB-font\fR {-label "Font" -variable Font -default {Courier 12 italic}}]
.fi
The validation status is in this case stored inside the \fBResult\fR variable. If the entered data are validated, \fBResult\fR will contain \fB0\fR and the calling program can read the entered data via the variables that have been specified:
.nf
if {$Result=="cancel"} {
   puts "Canceled"
} else {
   puts "Arguments: "
   foreach Var {
      Entry1 Entry2
      Listbox1 Listbox2 DisJntListbox
      Combobox Checkbox Radiobox Checkbutton
      InputFile OutputFile InputDirectory OutputDirectory
      Color Font
   } {
      puts "  $Var: '[set $Var]'"
   }
}
\fI-> Arguments:
   Entry1: 'Hello, this is a trial'
   Entry2: 'my default'
   Listbox1: '1'
   Listbox2: '{Choice 2} {Choice 3}'
   DisJntListbox: '{Choice 3} {Choice 5}'
   Combobox: '3'
   Checkbox: 'italic'
   Radiobox: 'underline'
   Checkbutton: '1'
   InputFile: 'c:\\tepam\\in.txt'
   OutputFile: 'c:\\tepam\\out.txt'
   InputDirectory: 'c:\\tepam\\input'
   OutputDirectory: 'c:\\tepam\\output'
   Color: 'red'
   Font: 'Courier 12 italic'\fR
.fi
.SH "SEE ALSO"
tepam_argument_dialogbox(n), tepam_procedure(n)
.SH KEYWORDS
argument integrity, argument validation, arguments, entry mask, parameter entry form, procedure, subcommand
.SH CATEGORY
Procedures, arguments, parameters, options
.SH COPYRIGHT
.nf
Copyright (c) 2009/2010, Andreas Drollinger

.fi