'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-107.40.1/tcl_ext/tclvfs/tclvfs/doc/vfs.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2001-2003 Vince Darley <vincentdarley@users.sourceforge.net>
'\" Copyright (c) 2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "vfs" n 1.0  "Tcl-level Virtual Filesystems"
.BS
.SH NAME
vfs \- Filesystem management in Tcl
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBvfs  ?1.2.1?\fR
.sp
\fBvfs::filesystem\fR \fBmount\fR ?\fB-volume\fR? \fIpath\fR \fIcommand\fR
.sp
\fBvfs::filesystem\fR \fBunmount\fR \fIpath\fR
.sp
\fBvfs::filesystem\fR \fBinfo\fR ?\fIpath\fR?
.sp
\fBvfs::filesystem\fR \fBfullynormalize\fR \fIpath\fR
.sp
\fBvfs::filesystem\fR \fBposixerror\fR \fIint\fR
.sp
\fBvfs::filesystem\fR \fBinternalerror\fR \fIcommand\fR
.sp
.BE
.SH DESCRIPTION
The package \fBvfs\fR provides commands to query, mount and
unmount virtual filesystems implemented in Tcl. This is further
facilitated through the provison of helper commands in a tcl script
library. See section "HANDLER ENVIRONMENT" of \fBvfs-fsapi\fR for
more information.
.PP
Once a virtual filesystem is in place, the standard Tcl commands, like
\fBfile\fR, \fBglob\fR, \fBcd\fR, \fBpwd\fR, \fBopen\fR, including all
their C APIs in the Tcl library (e.g.
\fBTcl_FSOpenFileChannel\fR, \fBTcl_FSMatchInDirectory\fR,
...), can be used within the filesystem (and indeed, properly written
extensions such as \fBTk\fR which may open or read files will also
transparently access the virtual filesystem).
.PP
Because all of Tcl's filesystem activity passes through a single
layer, every operation can be intercepted. This package does just
that.
This is also quite different from simply overloading the \fBfile\fR
command in Tcl.  We are actually providing replacements for C commands
like \fBaccess\fR, \fBstat\fR, etc.
By implementing a small number of low-level commands we ensure that
all commands at higher levels will function irrespective of what is
going on inside the filesystem layer.
.PP
Tcl's filesystem hooks operate on a per-process basis.  This means
every Tcl interpreter in the same process/application will see the
same filesystem, including any virtual filesystems.
.PP
To access this package use the command \fBpackage require vfs\fR.
This automatically registers the vfs hooks into Tcl's filesystem and
provides the command \fBvfs::filesystem\fR. The latter allows the
registration of actual virtual filesystems. More in the upcoming
section \fBAPI\fR.
The hooks will not be removed until Tcl exits. If desired, control
over this could be exposed to Tcl in the future.
By and in itself the command above will have no further effect. Only
after filesystem implementations have been registered and filesystems
using them been mounted filesystem commands will actually be
intercepted, and handled by the Tcl code of the mounted virtual
filesystem.
.SH API
.TP
\fBvfs::filesystem\fR \fBmount\fR ?\fB-volume\fR? \fIpath\fR \fIcommand\fR
\fIMount\fRs a virtual filesystem at \fIpath\fR, making it
useable. After completion of the call any access to a subdirectory of
\fIpath\fR will be handled by that filesystem. The filesystem is
represented here by the \fIcommand\fR prefix which will be executed
whenever an operation on a file or directory within \fIpath\fR has to
be performed.
.sp
Whether the \fIcommand\fR is implemented in C or Tcl is of no
relevance as long as it adheres to the API specified in
\fBvfs-fsapi\fR and is present in the interpreter where the mount
operation is executed.
.sp
If the option \fB-volume\fR is specified the new mount point is
also registered with Tcl as a new volume and will therefore from then
on appear in the output of the command \fBfile volumes\fR. This is
useful (and required for reasonable operation) for mounts like
\fBftp://\fR. It should not be used for paths mounted inside the
native filesystem.
.sp
The new filesystem mounts will be observed immediately in all
interpreters in the current process.  If the interpreter is later
deleted, all mounts which are intercepted by it will be automatically
removed (and will therefore affect the view of the filesystem seen by
all interpreters).
.TP
\fBvfs::filesystem\fR \fBunmount\fR \fIpath\fR
This unmounts the virtual filesystem which was mounted at
\fIpath\fR. An error is thrown if no filesystem was mounted there.
After the completion of the operation the filesystem is not visible
anymore, and any previous filesystem accessible through this path
becomes accessible again.
.TP
\fBvfs::filesystem\fR \fBinfo\fR ?\fIpath\fR?
A list of all filesystems mounted in all interpreters is returned, if
no \fIpath\fR argument was specified.
Else the filesystem responsible for that \fIpath\fR is examined and
the command prefix used to handle all filesystem operations returned.
An error is thrown if no filesystem is mounted for that \fIpath\fR.
.sp
There is currently no facility for examining in which interpreter each
command will be evaluated.
.TP
\fBvfs::filesystem\fR \fBfullynormalize\fR \fIpath\fR
Performs a full expansion of \fIpath\fR, (as per \fBfile
normalize\fR). This includes the following of any links in the last
element of \fIpath\fR.
.TP
\fBvfs::filesystem\fR \fBposixerror\fR \fIint\fR
This command can be called by filesystem implementations during the
execution of a filesystem operation to signal the posix error code of
a failure. See also \fBvfs-fsapi\fR.
.TP
\fBvfs::filesystem\fR \fBinternalerror\fR \fIcommand\fR
When used the specified \fIcommand\fR is registerd as the command to
trap and report any internal errors thrown by filesystem
implementations.
.PP
.SH LIMITATIONS
The code of the package \fBvfs\fR has only a few limitations.
.PP
.IP [1]
One subtlety one has to be aware of is that mixing case-(in)sensitive
filesystems and application code may yield unexpected results.
.sp
For example mounting a case-sensitive virtual filesystem into a
case-insensitive system (like the standard Windows or MacOS
filesystems) and then using this with code relying on
case-insensitivity problems will appear when accessing the virtual
filesystem.
.sp
Note that application code relying on case-insensitivity will not
under Unix either, i.e. is inherently non-portable, and should be
fixed.
.IP [2]
The C-API's for \fBlink\fR and \fBlstat\fR are currently not
exposed to the Tcl level. This may be done in the future to allow
virtual filesystems implemented in Tcl to support the reading and
writing of links.
.IP [3]
The public C-API filesystem function \fBTcl_FSMatchInDirectory\fR is
given a variety of type information in a \fITcl_GlobTypeData\fR
structure.  Currently only the \fItype\fR field of said strcuture is
exposed to the tcl-level. Fields like \fIpermissions\fR and MacOS
\fItype/creator\fR are ignored.
.PP
.SH "SEE ALSO"
vfs-filesystems, vfs-fsapi
.SH KEYWORDS
file, filesystem, vfs
.SH COPYRIGHT
.nf
Copyright (c) 2001-2003 Vince Darley <vincentdarley@users.sourceforge.net>
Copyright (c) 2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi