/*
    File:		AVMetadataIdentifiers.h

    Framework:  AVFoundation
 
    Copyright 2014-2017 Apple Inc. All rights reserved.

*/

#import <AVFoundation/AVBase.h>
#import <Foundation/Foundation.h>

typedef NSString * AVMetadataIdentifier NS_EXTENSIBLE_STRING_ENUM;

// CommonMetadata
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierTitle                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierCreator                                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierSubject                                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierDescription                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierPublisher                                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierContributor                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierCreationDate                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierLastModifiedDate                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierType                                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierFormat                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierAssetIdentifier                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierSource                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierLanguage                                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierRelation                                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierLocation                                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierCopyrights                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierAlbumName                                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierAuthor                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierArtist                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierArtwork                                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierMake                                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierModel                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataCommonIdentifierSoftware                                   NS_AVAILABLE(10_10, 8_0);

// QuickTimeUserData
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataAlbum                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataArranger                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataArtist                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataAuthor                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataChapter                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataComment                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataComposer                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataCopyright                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataCreationDate                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataDescription                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataDirector                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataDisclaimer                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataEncodedBy                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataFullName                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataGenre                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataHostComputer                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataInformation                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataKeywords                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataMake                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataModel                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataOriginalArtist                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataOriginalFormat                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataOriginalSource                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataPerformers                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataProducer                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataPublisher                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataProduct                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataSoftware                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataSpecialPlaybackRequirements     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataTrack                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataWarning                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataWriter                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataURLLink                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataLocationISO6709                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataTrackName                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataCredits                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataPhonogramRights                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeUserDataTaggedCharacteristic            NS_AVAILABLE(10_10, 8_0);

// ISO UserData (includes 3GPP)
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierISOUserDataCopyright                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierISOUserDataDate                                  NS_AVAILABLE(10_12, 10_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierISOUserDataTaggedCharacteristic                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataCopyright                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataAuthor                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataPerformer                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataGenre                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataRecordingYear                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataLocation                              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataTitle                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataDescription                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataCollection                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataUserRating                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataThumbnail                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataAlbumAndTrack                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataKeywordList                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataMediaClassification                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifier3GPUserDataMediaRating                           NS_AVAILABLE(10_10, 8_0);

// QuickTimeMetadata. For more information, see the QuickTime File Format Specification, available as part of the Mac OS X Reference Library at http://developer.apple.com/library/mac/navigation/
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataAuthor                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataComment                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCopyright                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCreationDate                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDirector                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDisplayName                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataInformation                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataKeywords                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataProducer                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataPublisher                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataAlbum                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataArtist                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataArtwork                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDescription                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataSoftware                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataYear                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataGenre                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataiXML                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationISO6709                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataMake                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataModel                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataArranger                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataEncodedBy                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataOriginalArtist                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataPerformer                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataComposer                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCredits                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataPhonogramRights                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCameraIdentifier                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCameraFrameReadoutTime          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataTitle		                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataCollectionUser                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataRatingUser                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationName                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationBody                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationNote                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationRole                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataLocationDate                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDirectionFacing                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDirectionMotion                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataPreferredAffineTransform        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataDetectedFace                    NS_AVAILABLE(10_11, 9_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataVideoOrientation                NS_AVAILABLE(10_11, 9_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierQuickTimeMetadataContentIdentifier               NS_AVAILABLE(10_11, 9_0);

// iTunesMetadata
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAlbum                              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataArtist                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataUserComment                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataCoverArt                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataCopyright                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataReleaseDate                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataEncodedBy                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataPredefinedGenre                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataUserGenre                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataSongName                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataTrackSubTitle                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataEncodingTool                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataComposer                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAlbumArtist                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAccountKind                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAppleID                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataArtistID                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataSongID                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataDiscCompilation                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataDiscNumber                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataGenreID                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataGrouping                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataPlaylistID                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataContentRating                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataBeatsPerMin                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataTrackNumber                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataArtDirector                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataArranger                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAuthor                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataLyrics                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataAcknowledgement                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataConductor                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataDescription                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataDirector                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataEQ                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataLinerNotes                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataRecordCompany                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataOriginalArtist                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataPhonogramRights                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataProducer                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataPerformer                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataPublisher                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataSoundEngineer                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataSoloist                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataCredits                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataThanks                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataOnlineExtras                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifieriTunesMetadataExecProducer                       NS_AVAILABLE(10_10, 8_0);

// ID3Metadata
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataAudioEncryption                       /* AENC Audio encryption */                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataAttachedPicture                       /* APIC Attached picture */                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataAudioSeekPointIndex                   /* ASPI Audio seek point index */                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataComments                              /* COMM Comments */                                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataCommercial                            /* COMR Commercial frame */                                     NS_AVAILABLE(10_11, 9_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataCommerical                            /* COMR Commercial frame */                                     NS_DEPRECATED(10_10, 10_11, 8_0, 9_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEncryption                            /* ENCR Encryption method registration */                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEqualization                          /* EQUA Equalization */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEqualization2                         /* EQU2 Equalisation (2) */                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEventTimingCodes                      /* ETCO Event timing codes */                                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataGeneralEncapsulatedObject             /* GEOB General encapsulated object */                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataGroupIdentifier                       /* GRID Group identification registration */                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInvolvedPeopleList_v23                /* IPLS Involved people list */                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataLink                                  /* LINK Linked information */                                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataMusicCDIdentifier                     /* MCDI Music CD identifier */                                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataMPEGLocationLookupTable               /* MLLT MPEG location lookup table */                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOwnership                             /* OWNE Ownership frame */                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPrivate                               /* PRIV Private frame */                                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPlayCounter                           /* PCNT Play counter */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPopularimeter                         /* POPM Popularimeter */                                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPositionSynchronization               /* POSS Position synchronisation frame */                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataRecommendedBufferSize                 /* RBUF Recommended buffer size */                              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataRelativeVolumeAdjustment              /* RVAD Relative volume adjustment */                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataRelativeVolumeAdjustment2             /* RVA2 Relative volume adjustment (2) */                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataReverb                                /* RVRB Reverb */                                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSeek                                  /* SEEK Seek frame */                                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSignature                             /* SIGN Signature frame */                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSynchronizedLyric                     /* SYLT Synchronized lyric/text */                              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSynchronizedTempoCodes                /* SYTC Synchronized tempo codes */                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataAlbumTitle                            /* TALB Album/Movie/Show title */                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataBeatsPerMinute                        /* TBPM BPM (beats per minute) */                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataComposer                              /* TCOM Composer */                                             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataContentType                           /* TCON Content type */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataCopyright                             /* TCOP Copyright message */                                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataDate                                  /* TDAT Date */                                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEncodingTime                          /* TDEN Encoding time */                                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPlaylistDelay                         /* TDLY Playlist delay */                                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalReleaseTime                   /* TDOR Original release time */                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataRecordingTime                         /* TDRC Recording time */                                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataReleaseTime                           /* TDRL Release time */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTaggingTime                           /* TDTG Tagging time */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEncodedBy                             /* TENC Encoded by */                                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataLyricist                              /* TEXT Lyricist/Text writer */                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataFileType                              /* TFLT File type */                                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTime                                  /* TIME Time */                                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInvolvedPeopleList_v24                /* TIPL Involved people list */                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataContentGroupDescription               /* TIT1 Content group description */                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTitleDescription                      /* TIT2 Title/songname/content description */                   NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSubTitle                              /* TIT3 Subtitle/Description refinement */                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInitialKey                            /* TKEY Initial key */                                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataLanguage                              /* TLAN Language(s) */                                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataLength                                /* TLEN Length */                                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataMusicianCreditsList                   /* TMCL Musician credits list */                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataMediaType                             /* TMED Media type */                                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataMood                                  /* TMOO Mood */                                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalAlbumTitle                    /* TOAL Original album/movie/show title */                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalFilename                      /* TOFN Original filename */                                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalLyricist                      /* TOLY Original lyricist(s)/text writer(s) */                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalArtist                        /* TOPE Original artist(s)/performer(s) */                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOriginalReleaseYear                   /* TORY Original release year */                                NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataFileOwner                             /* TOWN File owner/licensee */                                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataLeadPerformer                         /* TPE1 Lead performer(s)/Soloist(s) */                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataBand                                  /* TPE2 Band/orchestra/accompaniment */                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataConductor                             /* TPE3 Conductor/performer refinement */                       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataModifiedBy                            /* TPE4 Interpreted, remixed, or otherwise modified by */       NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPartOfASet                            /* TPOS Part of a set */                                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataProducedNotice                        /* TPRO Produced notice */                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPublisher                             /* TPUB Publisher */                                            NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTrackNumber                           /* TRCK Track number/Position in set */                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataRecordingDates                        /* TRDA Recording dates */                                      NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInternetRadioStationName              /* TRSN Internet radio station name */                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInternetRadioStationOwner             /* TRSO Internet radio station owner */                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSize                                  /* TSIZ Size */                                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataAlbumSortOrder                        /* TSOA Album sort order */                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPerformerSortOrder                    /* TSOP Performer sort order */                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTitleSortOrder                        /* TSOT Title sort order */                                     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataInternationalStandardRecordingCode    /* TSRC ISRC (international standard recording code) */         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataEncodedWith                           /* TSSE Software/Hardware and settings used for encoding */     NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataSetSubtitle                           /* TSST Set subtitle */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataYear                                  /* TYER Year */                                                 NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataUserText                              /* TXXX User defined text information frame */                  NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataUniqueFileIdentifier                  /* UFID Unique file identifier */                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataTermsOfUse                            /* USER Terms of use */                                         NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataUnsynchronizedLyric                   /* USLT Unsynchronized lyric/text transcription */              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataCommercialInformation                 /* WCOM Commercial information */                               NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataCopyrightInformation                  /* WCOP Copyright/Legal information */                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOfficialAudioFileWebpage              /* WOAF Official audio file webpage */                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOfficialArtistWebpage                 /* WOAR Official artist/performer webpage */                    NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOfficialAudioSourceWebpage            /* WOAS Official audio source webpage */                        NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOfficialInternetRadioStationHomepage  /* WORS Official Internet radio station homepage */             NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataPayment                               /* WPAY Payment */                                              NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataOfficialPublisherWebpage              /* WPUB Publishers official webpage */                          NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierID3MetadataUserURL                               /* WXXX User defined URL link frame */                          NS_AVAILABLE(10_10, 8_0);

AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierIcyMetadataStreamTitle                           NS_AVAILABLE(10_10, 8_0);
AVF_EXPORT AVMetadataIdentifier const AVMetadataIdentifierIcyMetadataStreamURL                             NS_AVAILABLE(10_10, 8_0);

