'\"
'\" Generated from file '/BuildRoot/Library/Caches/com.apple.xbs/Sources/tcl/tcl-118.50.1/tcl_ext/tcllib/tcllib/modules/aes/aes.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005, Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "aes" n 1.0.2 aes "Advanced Encryption Standard (AES)"
.BS
.SH NAME
aes \- Implementation of the AES block cipher
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBaes  ?1.0.2?\fR
.sp
\fB::aes::aes\fR ?\fI-mode [ecb|cbc]\fR? ?\fI-dir [encrypt|decrypt]\fR? \fI-key keydata\fR ?\fI-iv vector\fR? ?\fI-hex\fR? ?\fI-out channel\fR? ?\fI-chunksize size\fR? [ \fI-in channel\fR | \fIdata\fR ]
.sp
\fB::aes::Init\fR \fImode\fR \fIkeydata\fR \fIiv\fR
.sp
\fB::aes::Encrypt\fR \fIKey\fR \fIdata\fR
.sp
\fB::aes::Decrypt\fR \fIKey\fR \fIdata\fR
.sp
\fB::aes::Reset\fR \fIKey\fR \fIiv\fR
.sp
\fB::aes::Final\fR \fIKey\fR
.sp
.BE
.SH DESCRIPTION
.PP
This is an implementation in Tcl of the Advanced Encryption Standard
(AES) as published by the U.S. National Institute of Standards and
Technology [1]. AES is a 128-bit block cipher with a variable
key size of 128, 192 or 256 bits. This implementation supports ECB and
CBC modes.
.SH COMMANDS
.TP
\fB::aes::aes\fR ?\fI-mode [ecb|cbc]\fR? ?\fI-dir [encrypt|decrypt]\fR? \fI-key keydata\fR ?\fI-iv vector\fR? ?\fI-hex\fR? ?\fI-out channel\fR? ?\fI-chunksize size\fR? [ \fI-in channel\fR | \fIdata\fR ]
Perform the \fBaes\fR algorithm on either the data provided
by the argument or on the data read from the \fI-in\fR channel. If
an \fI-out\fR channel is given then the result will be written to
this channel.
.sp
The \fI-key\fR option must be given. This parameter takes a binary
string of either 16, 24 or 32 bytes in length and is used to generate the
key schedule.
.sp
The \fI-mode\fR and \fI-dir\fR options are optional and default to cbc
mode and encrypt respectively. The initialization vector \fI-iv\fR
takes a 16 byte binary argument which defaults to all zeros.
See \fBMODES OF OPERATION\fR for more about available modes and
their uses.
.sp
AES is a 128-bit block cipher. This means that the data must be
provided in units that are a multiple of 16 bytes.
.PP
.SH "PROGRAMMING INTERFACE"
Internal state is maintained in an opaque structure that is returned
from the \fBInit\fR function. In ECB mode the state is not affected by
the input but for CBC mode some input dependent state is maintained
and may be reset by calling the \fBReset\fR function with a new
initialization vector value.
.TP
\fB::aes::Init\fR \fImode\fR \fIkeydata\fR \fIiv\fR
Construct a new AES key schedule using the specified key data and the
given initialization vector. The initialization vector is not used
with ECB mode but is important for CBC mode.
See \fBMODES OF OPERATION\fR for details about cipher modes.
.TP
\fB::aes::Encrypt\fR \fIKey\fR \fIdata\fR
Use a prepared key acquired by calling \fBInit\fR to encrypt the
provided data. The data argument should be a binary array that is a
multiple of the AES block size of 16 bytes. The result is a binary
array the same size as the input of encrypted data.
.TP
\fB::aes::Decrypt\fR \fIKey\fR \fIdata\fR
Decipher data using the key. Note that the same key may be used to
encrypt and decrypt data provided that the initialization vector is
reset appropriately for CBC mode.
.TP
\fB::aes::Reset\fR \fIKey\fR \fIiv\fR
Reset the initialization vector. This permits the programmer to re-use
a key and avoid the cost of re-generating the key schedule where the
same key data is being used multiple times.
.TP
\fB::aes::Final\fR \fIKey\fR
This should be called to clean up resources associated with \fIKey\fR.
Once this function has been called the key may not be used again.
.PP
.SH "MODES OF OPERATION"
.TP
Electronic Code Book (ECB)
ECB is the basic mode of all block ciphers. Each block is encrypted
independently and so identical plain text will produce identical
output when encrypted with the same key. Any encryption errors will
only affect a single block however this is vulnerable to known
plaintext attacks.
.TP
Cipher Block Chaining (CBC)
CBC mode uses the output of the last block encryption to affect the
current block. An initialization vector of the same size as the cipher
block size is used to handle the first block. The initialization
vector should be chosen randomly and transmitted as the first block of
the output. Errors in encryption affect the current block and the next
block after which the cipher will correct itself. CBC is the most
commonly used mode in software encryption. This is the default mode
of operation for this module.
.PP
.SH EXAMPLES
.nf

% set nil_block [string repeat \\\\0 16]
% aes::aes -hex -mode cbc -dir encrypt -key $nil_block $nil_block
66e94bd4ef8a2c3b884cfa59ca342b2e

.fi
.nf

set Key [aes::Init cbc $sixteen_bytes_key_data $sixteen_byte_iv]
append ciphertext [aes::Encrypt $Key $plaintext]
append ciphertext [aes::Encrypt $Key $additional_plaintext]
aes::Final $Key

.fi
.SH REFERENCES
.IP [1]
"Advanced Encryption Standard",
Federal Information Processing Standards Publication 197, 2001
(\fIhttp://csrc.nist.gov/publications/fips/fips197/fips-197.pdf\fR)
.PP
.SH AUTHORS
Thorsten Schloermann, Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIaes\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
blowfish(n), des(n), md5(n), sha1(n)
.SH KEYWORDS
aes, block cipher, data integrity, encryption, security
.SH CATEGORY
Hashes, checksums, and encryption
.SH COPYRIGHT
.nf
Copyright (c) 2005, Pat Thoyts <patthoyts@users.sourceforge.net>

.fi