'\"
'\" Generated from file '/BuildRoot/Library/Caches/com.apple.xbs/Sources/tcl/tcl-118.50.1/tcl_ext/tcllib/tcllib/modules/math/bigfloat.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004-2008, by Stephane Arnold <stephanearnold at yahoo dot fr>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::bigfloat" n 2.0.1 math "Tcl Math Library"
.BS
.SH NAME
math::bigfloat \- Arbitrary precision floating-point numbers
.SH SYNOPSIS
package require \fBTcl  8.5\fR
.sp
package require \fBmath::bigfloat  ?2.0.1?\fR
.sp
\fBfromstr\fR \fInumber\fR ?\fItrailingZeros\fR?
.sp
\fBtostr\fR ?\fB-nosci\fR? \fInumber\fR
.sp
\fBfromdouble\fR \fIdouble\fR ?\fIdecimals\fR?
.sp
\fBtodouble\fR \fInumber\fR
.sp
\fBisInt\fR \fInumber\fR
.sp
\fBisFloat\fR \fInumber\fR
.sp
\fBint2float\fR \fIinteger\fR ?\fIdecimals\fR?
.sp
\fBadd\fR \fIx\fR \fIy\fR
.sp
\fBsub\fR \fIx\fR \fIy\fR
.sp
\fBmul\fR \fIx\fR \fIy\fR
.sp
\fBdiv\fR \fIx\fR \fIy\fR
.sp
\fBmod\fR \fIx\fR \fIy\fR
.sp
\fBabs\fR \fIx\fR
.sp
\fBopp\fR \fIx\fR
.sp
\fBpow\fR \fIx\fR \fIn\fR
.sp
\fBiszero\fR \fIx\fR
.sp
\fBequal\fR \fIx\fR \fIy\fR
.sp
\fBcompare\fR \fIx\fR \fIy\fR
.sp
\fBsqrt\fR \fIx\fR
.sp
\fBlog\fR \fIx\fR
.sp
\fBexp\fR \fIx\fR
.sp
\fBcos\fR \fIx\fR
.sp
\fBsin\fR \fIx\fR
.sp
\fBtan\fR \fIx\fR
.sp
\fBcotan\fR \fIx\fR
.sp
\fBacos\fR \fIx\fR
.sp
\fBasin\fR \fIx\fR
.sp
\fBatan\fR \fIx\fR
.sp
\fBcosh\fR \fIx\fR
.sp
\fBsinh\fR \fIx\fR
.sp
\fBtanh\fR \fIx\fR
.sp
\fBpi\fR \fIn\fR
.sp
\fBrad2deg\fR \fIradians\fR
.sp
\fBdeg2rad\fR \fIdegrees\fR
.sp
\fBround\fR \fIx\fR
.sp
\fBceil\fR \fIx\fR
.sp
\fBfloor\fR \fIx\fR
.sp
.BE
.SH DESCRIPTION
The bigfloat package provides arbitrary precision floating-point math
capabilities to the Tcl language. It is designed to work with Tcl 8.5,
but for Tcl 8.4 is provided an earlier version of this package.
See \fBWHAT ABOUT TCL 8.4 ?\fR for more explanations.
By convention, we will talk about the numbers treated in this library as :
.IP \(bu
BigFloat for floating-point numbers of arbitrary length.
.IP \(bu
integers for arbitrary length signed integers, just as basic integers since Tcl 8.5.
.PP
Each BigFloat is an interval, namely [\fIm-d, m+d\fR],
where \fIm\fR is the mantissa and \fId\fR the uncertainty, representing the
limitation of that number's precision.
This is why we call such mathematics \fIinterval computations\fR.
Just take an example in physics : when you measure a temperature, not all
digits you read are \fIsignificant\fR. Sometimes you just cannot trust all digits - not to mention if doubles (f.p. numbers) can handle all these digits.
BigFloat can handle this problem - trusting the digits you get - plus the ability to store numbers with an arbitrary precision.
BigFloats are internally represented at Tcl lists: this
package provides a set of procedures operating against
the internal representation in order to :
.IP \(bu
perform math operations on BigFloats and (optionnaly) with integers.
.IP \(bu
convert BigFloats from their internal representations to strings, and vice versa.
.PP
.SH INTRODUCTION
.TP
\fBfromstr\fR \fInumber\fR ?\fItrailingZeros\fR?
Converts \fInumber\fR into a BigFloat. Its precision
is at least the number of digits provided by \fInumber\fR.
If the \fInumber\fR contains only digits and eventually a minus sign, it is considered as
an integer. Subsequently, no conversion is done at all.
.sp
\fItrailingZeros\fR - the number of zeros to append at the end of the floating-point number
to get more precision. It cannot be applied to an integer.
.nf

# x and y are BigFloats : the first string contained a dot, and the second an e sign
set x [fromstr -1.000000]
set y [fromstr 2000e30]
# let's see how we get integers
set t 20000000000000
# the old way (package 1.2) is still supported for backwards compatibility :
set m [fromstr 10000000000]
# but we do not need fromstr for integers anymore
set n -39
# t, m and n are integers

.fi
.sp
The \fInumber\fR's last digit is considered by the procedure to be true at +/-1,
For example, 1.00 is the interval [0.99, 1.01],
and 0.43 the interval [0.42, 0.44].
The Pi constant may be approximated by the number "3.1415".
This string could be considered as the interval [3.1414 , 3.1416] by \fBfromstr\fR.
So, when you mean 1.0 as a double, you may have to write 1.000000 to get enough precision.
To learn more about this subject, see \fBPRECISION\fR.
.sp
For example :
.nf

set x [fromstr 1.0000000000]
# the next line does the same, but smarter
set y [fromstr 1. 10]

.fi
.TP
\fBtostr\fR ?\fB-nosci\fR? \fInumber\fR
Returns a string form of a BigFloat, in which all digits are exacts.
\fIAll exact digits\fR means a rounding may occur, for example to zero,
if the uncertainty interval does not clearly show the true digits.
\fInumber\fR may be an integer, causing the command to return exactly the input argument.
With the \fB-nosci\fR option, the number returned is never shown in scientific
notation, i.e. not like '3.4523e+5' but like '345230.'.
.nf

puts [tostr [fromstr 0.99999]] ;# 1.0000
puts [tostr [fromstr 1.00001]] ;# 1.0000
puts [tostr [fromstr 0.002]] ;# 0.e-2

.fi
See \fBPRECISION\fR for that matter.
See also \fBiszero\fR for how to detect zeros, which is useful when performing a division.
.TP
\fBfromdouble\fR \fIdouble\fR ?\fIdecimals\fR?
Converts a double (a simple floating-point value) to a BigFloat, with
exactly \fIdecimals\fR digits.  Without the \fIdecimals\fR argument,
it behaves like \fBfromstr\fR.
Here, the only important feature you might care of is the ability
to create BigFloats with a fixed number of \fIdecimals\fR.
.nf

tostr [fromstr 1.111 4]
# returns : 1.111000 (3 zeros)
tostr [fromdouble 1.111 4]
# returns : 1.111

.fi
.TP
\fBtodouble\fR \fInumber\fR
Returns a double, that may be used in \fIexpr\fR,
from a BigFloat.
.TP
\fBisInt\fR \fInumber\fR
Returns 1 if \fInumber\fR is an integer, 0 otherwise.
.TP
\fBisFloat\fR \fInumber\fR
Returns 1 if \fInumber\fR is a BigFloat, 0 otherwise.
.TP
\fBint2float\fR \fIinteger\fR ?\fIdecimals\fR?
Converts an integer to a BigFloat with \fIdecimals\fR trailing zeros.
The default, and minimal, number of \fIdecimals\fR is 1.
When converting back to string, one decimal is lost:
.nf

set n 10
set x [int2float $n]; # like fromstr 10.0
puts [tostr $x]; # prints "10."
set x [int2float $n 3]; # like fromstr 10.000
puts [tostr $x]; # prints "10.00"

.fi
.PP
.SH ARITHMETICS
.TP
\fBadd\fR \fIx\fR \fIy\fR
.TP
\fBsub\fR \fIx\fR \fIy\fR
.TP
\fBmul\fR \fIx\fR \fIy\fR
Return the sum, difference and product of \fIx\fR by \fIy\fR.
\fIx\fR - may be either a BigFloat or an integer
\fIy\fR - may be either a BigFloat or an integer
When both are integers, these commands behave like \fBexpr\fR.
.TP
\fBdiv\fR \fIx\fR \fIy\fR
.TP
\fBmod\fR \fIx\fR \fIy\fR
Return the quotient and the rest of \fIx\fR divided by \fIy\fR.
Each argument (\fIx\fR and \fIy\fR) can be either a BigFloat or an integer,
but you cannot divide an integer by a BigFloat
Divide by zero throws an error.
.TP
\fBabs\fR \fIx\fR
Returns the absolute value of \fIx\fR
.TP
\fBopp\fR \fIx\fR
Returns the opposite of \fIx\fR
.TP
\fBpow\fR \fIx\fR \fIn\fR
Returns \fIx\fR taken to the \fIn\fRth power.
It only works if \fIn\fR is an integer.
\fIx\fR might be a BigFloat or an integer.
.PP
.SH COMPARISONS
.TP
\fBiszero\fR \fIx\fR
Returns 1 if \fIx\fR is :
.RS
.IP \(bu
a BigFloat close enough to zero to raise "divide by zero".
.IP \(bu
the integer 0.
.RE
See here how numbers that are close to zero are converted to strings:
.nf

tostr [fromstr 0.001] ; # -> 0.e-2
tostr [fromstr 0.000000] ; # -> 0.e-5
tostr [fromstr -0.000001] ; # -> 0.e-5
tostr [fromstr 0.0] ; # -> 0.
tostr [fromstr 0.002] ; # -> 0.e-2

set a [fromstr 0.002] ; # uncertainty interval : 0.001, 0.003
tostr  $a ; # 0.e-2
iszero $a ; # false

set a [fromstr 0.001] ; # uncertainty interval : 0.000, 0.002
tostr  $a ; # 0.e-2
iszero $a ; # true

.fi
.TP
\fBequal\fR \fIx\fR \fIy\fR
Returns 1 if \fIx\fR and \fIy\fR are equal, 0 elsewhere.
.TP
\fBcompare\fR \fIx\fR \fIy\fR
Returns 0 if both BigFloat arguments are equal,
1 if \fIx\fR is greater than \fIy\fR,
and -1 if \fIx\fR is lower than \fIy\fR.
You would not be able to compare an integer to a BigFloat :
the operands should be both BigFloats, or both integers.
.PP
.SH ANALYSIS
.TP
\fBsqrt\fR \fIx\fR
.TP
\fBlog\fR \fIx\fR
.TP
\fBexp\fR \fIx\fR
.TP
\fBcos\fR \fIx\fR
.TP
\fBsin\fR \fIx\fR
.TP
\fBtan\fR \fIx\fR
.TP
\fBcotan\fR \fIx\fR
.TP
\fBacos\fR \fIx\fR
.TP
\fBasin\fR \fIx\fR
.TP
\fBatan\fR \fIx\fR
.TP
\fBcosh\fR \fIx\fR
.TP
\fBsinh\fR \fIx\fR
.TP
\fBtanh\fR \fIx\fR
The above functions return, respectively, the following :
square root, logarithm, exponential, cosine, sine,
tangent, cotangent, arc cosine, arc sine, arc tangent, hyperbolic
cosine, hyperbolic sine, hyperbolic tangent, of a BigFloat named \fIx\fR.
.TP
\fBpi\fR \fIn\fR
Returns a BigFloat representing the Pi constant with \fIn\fR digits after the dot.
\fIn\fR is a positive integer.
.TP
\fBrad2deg\fR \fIradians\fR
.TP
\fBdeg2rad\fR \fIdegrees\fR
\fIradians\fR - angle expressed in radians (BigFloat)
.sp
\fIdegrees\fR - angle expressed in degrees (BigFloat)
.sp
Convert an angle from radians to degrees, and \fIvice versa\fR.
.PP
.SH ROUNDING
.TP
\fBround\fR \fIx\fR
.TP
\fBceil\fR \fIx\fR
.TP
\fBfloor\fR \fIx\fR
The above functions return the \fIx\fR BigFloat,
rounded like with the same mathematical function in \fIexpr\fR,
and returns it as an integer.
.PP
.SH PRECISION
How do conversions work with precision ?
.IP \(bu
When a BigFloat is converted from string, the internal representation
holds its uncertainty as 1 at the level of the last digit.
.IP \(bu
During computations, the uncertainty of each result
is internally computed the closest to the reality, thus saving the memory used.
.IP \(bu
When converting back to string, the digits that are printed
are not subject to uncertainty. However, some rounding is done, as not doing so
causes severe problems.
.PP
Uncertainties are kept in the internal representation of the number ;
it is recommended to use \fBtostr\fR only for outputting data (on the screen or in a file),
and NEVER call \fBfromstr\fR with the result of \fBtostr\fR.
It is better to always keep operands in their internal representation.
Due to the internals of this library, the uncertainty interval may be slightly
wider than expected, but this should not cause false digits.
.PP
Now you may ask this question : What precision am I going to get
after calling add, sub, mul or div?
First you set a number from the string representation and,
by the way, its uncertainty is set:
.nf

set a [fromstr 1.230]
# $a belongs to [1.229, 1.231]
set a [fromstr 1.000]
# $a belongs to [0.999, 1.001]
# $a has a relative uncertainty of 0.1% : 0.001(the uncertainty)/1.000(the medium value)

.fi
The uncertainty of the sum, or the difference, of two numbers, is the sum
of their respective uncertainties.
.nf

set a [fromstr 1.230]
set b [fromstr 2.340]
set sum [add $a $b]]
# the result is : [3.568, 3.572] (the last digit is known with an uncertainty of 2)
tostr $sum ; # 3.57

.fi
But when, for example, we add or substract an integer to a BigFloat,
the relative uncertainty of the result is unchanged. So it is desirable
not to convert integers to BigFloats:
.nf

set a [fromstr 0.999999999]
# now something dangerous
set b [fromstr 2.000]
# the result has only 3 digits
tostr [add $a $b]

# how to keep precision at its maximum
puts [tostr [add $a 2]]

.fi
.PP
For multiplication and division, the relative uncertainties of the product
or the quotient, is the sum of the relative uncertainties of the operands.
Take care of division by zero : check each divider with \fBiszero\fR.
.nf

set num [fromstr 4.00]
set denom [fromstr 0.01]

puts [iszero $denom];# true
set quotient [div $num $denom];# error : divide by zero

# opposites of our operands
puts [compare $num [opp $num]]; # 1
puts [compare $denom [opp $denom]]; # 0 !!!
# No suprise ! 0 and its opposite are the same...

.fi
Effects of the precision of a number considered equal to zero
to the cos function:
.nf

puts [tostr [cos [fromstr 0. 10]]]; # -> 1.000000000
puts [tostr [cos [fromstr 0. 5]]]; # -> 1.0000
puts [tostr [cos [fromstr 0e-10]]]; # -> 1.000000000
puts [tostr [cos [fromstr 1e-10]]]; # -> 1.000000000

.fi
BigFloats with different internal representations may be converted
to the same string.
.PP
For most analysis functions (cosine, square root, logarithm, etc.), determining the precision
of the result is difficult.
It seems however that in many cases, the loss of precision in the result
is of one or two digits.
There are some exceptions : for example,
.nf

tostr [exp [fromstr 100.0 10]]
# returns : 2.688117142e+43 which has only 10 digits of precision, although the entry
# has 14 digits of precision.

.fi
.SH "WHAT ABOUT TCL 8.4 ?"
If your setup do not provide Tcl 8.5 but supports 8.4, the package can still be loaded,
switching back to \fImath::bigfloat\fR 1.2. Indeed, an important function introduced in Tcl 8.5
is required - the ability to handle bignums, that we can do with \fBexpr\fR.
Before 8.5, this ability was provided by several packages,
including the pure-Tcl \fImath::bignum\fR package provided by \fItcllib\fR.
In this case, all you need to know, is that arguments to the commands explained here,
are expected to be in their internal representation.
So even with integers, you will need to call \fBfromstr\fR
and \fBtostr\fR in order to convert them between string and internal representations.
.nf

#
# with Tcl 8.5
# ============
set a [pi 20]
# round returns an integer and 'everything is a string' applies to integers
# whatever big they are
puts [round [mul $a 10000000000]]
#
# the same with Tcl 8.4
# =====================
set a [pi 20]
# bignums (arbitrary length integers) need a conversion hook
set b [fromstr 10000000000]
# round returns a bignum:
# before printing it, we need to convert it with 'tostr'
puts [tostr [round [mul $a $b]]]

.fi
.SH "NAMESPACES AND OTHER PACKAGES"
We have not yet discussed about namespaces
because we assumed that you had imported public commands into the global namespace,
like this:
.nf

namespace import ::math::bigfloat::*

.fi
If you matter much about avoiding names conflicts,
I considere it should be resolved by the following :
.nf

package require math::bigfloat
# beware: namespace ensembles are not available in Tcl 8.4
namespace eval ::math::bigfloat {namespace ensemble create -command ::bigfloat}
# from now, the bigfloat command takes as subcommands all original math::bigfloat::* commands
set a [bigfloat sub [bigfloat fromstr 2.000] [bigfloat fromstr 0.530]]
puts [bigfloat tostr $a]

.fi
.SH EXAMPLES
Guess what happens when you are doing some astronomy. Here is an example :
.nf

# convert acurrate angles with a millisecond-rated accuracy
proc degree-angle {degrees minutes seconds milliseconds} {
    set result 0
    set div 1
    foreach factor {1 1000 60 60} var [list $milliseconds $seconds $minutes $degrees] {
        # we convert each entry var into milliseconds
        set div [expr {$div*$factor}]
        incr result [expr {$var*$div}]
    }
    return [div [int2float $result] $div]
}
# load the package
package require math::bigfloat
namespace import ::math::bigfloat::*
# work with angles : a standard formula for navigation (taking bearings)
set angle1 [deg2rad [degree-angle 20 30 40   0]]
set angle2 [deg2rad [degree-angle 21  0 50 500]]
set opposite3 [deg2rad [degree-angle 51  0 50 500]]
set sinProduct [mul [sin $angle1] [sin $angle2]]
set cosProduct [mul [cos $angle1] [cos $angle2]]
set angle3 [asin [add [mul $sinProduct [cos $opposite3]] $cosProduct]]
puts "angle3 : [tostr [rad2deg $angle3]]"

.fi
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: bignum :: float\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
computations, floating-point, interval, math, multiprecision, tcl
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2004-2008, by Stephane Arnold <stephanearnold at yahoo dot fr>

.fi