'\"
'\" Generated from file '/BuildRoot/Library/Caches/com.apple.xbs/Sources/tcl/tcl-118.50.1/tcl_ext/tcllib/tcllib/modules/mapproj/mapproj.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2007 Kevin B. Kenny <kennykb@acm.org>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "mapproj" n 0.1 mapproj "Tcl Library"
.BS
.SH NAME
mapproj \- Map projection routines
.SH SYNOPSIS
package require \fBTcl  ?8.4?\fR
.sp
package require \fBmath::interpolate  ?1.0?\fR
.sp
package require \fBmath::special  ?0.2.1?\fR
.sp
package require \fBmapproj  ?1.0?\fR
.sp
\fB::mapproj::toPlateCarree\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromPlateCarree\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toMercator\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromMercator\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toMillerCylindrical\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromMillerCylindrical\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toSinusoidal\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromSinusoidal\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toMollweide\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromMollweide\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toEckertIV\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromEckertIV\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toEckertVI\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromEckertVI\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toRobinson\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromRobinson\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toCassini\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromCassini\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toPeirceQuincuncial\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromPeirceQuincuncial\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toOrthographic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromOrthographic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toStereographic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromStereographic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toGnomonic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromGnomonic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toAzimuthalEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromAzimuthalEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toLambertAzimuthalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromLambertAzimuthalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toHammer\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromHammer\fR \fIlambda_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toConicEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromConicEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toAlbersEqualAreaConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromAlbersEqualAreaConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toLambertConformalConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromLambertConformalConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toLambertCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromLambertCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toBehrmann\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromBehrmann\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toTrystanEdwards\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromTrystanEdwards\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toHoboDyer\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromHoboDyer\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toGallPeters\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromGallPeters\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
\fB::mapproj::toBalthasart\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
.sp
\fB::mapproj::fromBalthasart\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
.sp
.BE
.SH DESCRIPTION
The \fBmapproj\fR package provides a set of procedures for
converting between world co-ordinates (latitude and longitude) and map
co-ordinates on a number of different map projections.
.SH COMMANDS
The following commands convert between world co-ordinates and
map co-ordinates:
.TP
\fB::mapproj::toPlateCarree\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the \fIplate carrée\fR (cylindrical equidistant)
projection.
.TP
\fB::mapproj::fromPlateCarree\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the \fIplate carrée\fR (cylindrical equidistant)
projection.
.TP
\fB::mapproj::toCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the cylindrical equal-area projection.
.TP
\fB::mapproj::fromCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the cylindrical equal-area projection.
.TP
\fB::mapproj::toMercator\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Mercator (cylindrical conformal) projection.
.TP
\fB::mapproj::fromMercator\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Mercator (cylindrical conformal) projection.
.TP
\fB::mapproj::toMillerCylindrical\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Miller Cylindrical projection.
.TP
\fB::mapproj::fromMillerCylindrical\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Miller Cylindrical projection.
.TP
\fB::mapproj::toSinusoidal\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the sinusoidal (Sanson-Flamsteed) projection.
projection.
.TP
\fB::mapproj::fromSinusoidal\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the sinusoidal (Sanson-Flamsteed) projection.
projection.
.TP
\fB::mapproj::toMollweide\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Mollweide projection.
.TP
\fB::mapproj::fromMollweide\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Mollweide projection.
.TP
\fB::mapproj::toEckertIV\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Eckert IV projection.
.TP
\fB::mapproj::fromEckertIV\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Eckert IV projection.
.TP
\fB::mapproj::toEckertVI\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Eckert VI projection.
.TP
\fB::mapproj::fromEckertVI\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Eckert VI projection.
.TP
\fB::mapproj::toRobinson\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Robinson projection.
.TP
\fB::mapproj::fromRobinson\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Robinson projection.
.TP
\fB::mapproj::toCassini\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Cassini (transverse cylindrical equidistant)
projection.
.TP
\fB::mapproj::fromCassini\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Cassini (transverse cylindrical equidistant)
projection.
.TP
\fB::mapproj::toPeirceQuincuncial\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Peirce Quincuncial Projection.
.TP
\fB::mapproj::fromPeirceQuincuncial\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Peirce Quincuncial Projection.
.TP
\fB::mapproj::toOrthographic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the orthographic projection.
.TP
\fB::mapproj::fromOrthographic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the orthographic projection.
.TP
\fB::mapproj::toStereographic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the stereographic (azimuthal conformal) projection.
.TP
\fB::mapproj::fromStereographic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the stereographic (azimuthal conformal) projection.
.TP
\fB::mapproj::toGnomonic\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the gnomonic projection.
.TP
\fB::mapproj::fromGnomonic\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the gnomonic projection.
.TP
\fB::mapproj::toAzimuthalEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the azimuthal equidistant projection.
.TP
\fB::mapproj::fromAzimuthalEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the azimuthal equidistant projection.
.TP
\fB::mapproj::toLambertAzimuthalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Lambert azimuthal equal-area projection.
.TP
\fB::mapproj::fromLambertAzimuthalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Lambert azimuthal equal-area projection.
.TP
\fB::mapproj::toHammer\fR \fIlambda_0\fR \fIlambda\fR \fIphi\fR
Converts to the Hammer projection.
.TP
\fB::mapproj::fromHammer\fR \fIlambda_0\fR \fIx\fR \fIy\fR
Converts from the Hammer projection.
.TP
\fB::mapproj::toConicEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
Converts to the conic equidistant projection.
.TP
\fB::mapproj::fromConicEquidistant\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
Converts from the conic equidistant projection.
.TP
\fB::mapproj::toAlbersEqualAreaConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
Converts to the Albers equal-area conic projection.
.TP
\fB::mapproj::fromAlbersEqualAreaConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
Converts from the Albers equal-area conic projection.
.TP
\fB::mapproj::toLambertConformalConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIlambda\fR \fIphi\fR
Converts to the Lambert conformal conic projection.
.TP
\fB::mapproj::fromLambertConformalConic\fR \fIlambda_0\fR \fIphi_0\fR \fIphi_1\fR \fIphi_2\fR \fIx\fR \fIy\fR
Converts from the Lambert conformal conic projection.
.PP
Among the cylindrical equal-area projections, there are a number of
choices of standard parallels that have names:
.TP
\fB::mapproj::toLambertCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Lambert cylindrical equal area projection. (standard parallel
is the Equator.)
.TP
\fB::mapproj::fromLambertCylindricalEqualArea\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Lambert cylindrical equal area projection. (standard parallel
is the Equator.)
.TP
\fB::mapproj::toBehrmann\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Behrmann cylindrical equal area projection. (standard parallels
are 30 degrees North and South)
.TP
\fB::mapproj::fromBehrmann\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Behrmann cylindrical equal area projection. (standard parallels
are 30 degrees North and South.)
.TP
\fB::mapproj::toTrystanEdwards\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Trystan Edwards cylindrical equal area projection. (standard parallels
are 37.4 degrees North and South)
.TP
\fB::mapproj::fromTrystanEdwards\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Trystan Edwards cylindrical equal area projection. (standard parallels
are 37.4 degrees North and South.)
.TP
\fB::mapproj::toHoboDyer\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Hobo-Dyer cylindrical equal area projection. (standard parallels
are 37.5 degrees North and South)
.TP
\fB::mapproj::fromHoboDyer\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Hobo-Dyer cylindrical equal area projection. (standard parallels
are 37.5 degrees North and South.)
.TP
\fB::mapproj::toGallPeters\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Gall-Peters cylindrical equal area projection. (standard parallels
are 45 degrees North and South)
.TP
\fB::mapproj::fromGallPeters\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Gall-Peters cylindrical equal area projection. (standard parallels
are 45 degrees North and South.)
.TP
\fB::mapproj::toBalthasart\fR \fIlambda_0\fR \fIphi_0\fR \fIlambda\fR \fIphi\fR
Converts to the Balthasart cylindrical equal area projection. (standard parallels
are 50 degrees North and South)
.TP
\fB::mapproj::fromBalthasart\fR \fIlambda_0\fR \fIphi_0\fR \fIx\fR \fIy\fR
Converts from the Balthasart cylindrical equal area projection. (standard parallels
are 50 degrees North and South.)
.PP
.SH ARGUMENTS
The following arguments are accepted by the projection commands:
.TP
\fIlambda\fR
Longitude of the point to be projected, in degrees.
.TP
\fIphi\fR
Latitude of the point to be projected, in degrees.
.TP
\fIlambda_0\fR
Longitude of the center of the sheet, in degrees.  For many projections,
this figure is also the reference meridian of the projection.
.TP
\fIphi_0\fR
Latitude of the center of the sheet, in degrees.  For the azimuthal
projections, this figure is also the latitude of the center of the projection.
.TP
\fIphi_1\fR
Latitude of the first reference parallel, for projections that use reference
parallels.
.TP
\fIphi_2\fR
Latitude of the second reference parallel, for projections that use reference
parallels.
.TP
\fIx\fR
X co-ordinate of a point on the map, in units of Earth radii.
.TP
\fIy\fR
Y co-ordinate of a point on the map, in units of Earth radii.
.PP
.SH RESULTS
For all of the procedures whose names begin with 'to', the return value
is a list comprising an \fIx\fR co-ordinate and a \fIy\fR co-ordinate.
The co-ordinates are relative to the center of the map sheet to be drawn,
measured in Earth radii at the reference location on the map.
For all of the functions whose names begin with 'from', the return value
is a list comprising the longitude and latitude, in degrees.
.SH "CHOOSING A PROJECTION"
This package offers a great many projections, because no single projection
is appropriate to all maps.  This section attempts to provide guidance
on how to choose a projection.
.PP
First, consider the type of data that you intend to display on the map.
If the data are \fIdirectional\fR (\fIe.g.,\fR winds, ocean currents, or
magnetic fields) then you need to use a projection that preserves
angles; these are known as \fIconformal\fR projections.  Conformal
projections include the Mercator, the Albers azimuthal equal-area,
the stereographic, and the Peirce Quincuncial projection.  If the
data are \fIthematic\fR, describing properties of land or water, such
as temperature, population density, land use, or demographics; then
you need a projection that will show these data with the areas on the map
proportional to the areas in real life.  These so-called \fIequal area\fR
projections include the various cylindrical equal area projections,
the sinusoidal projection, the Lambert azimuthal equal-area projection,
the Albers equal-area conic projection, and several of the world-map
projections (Miller Cylindrical, Mollweide, Eckert IV, Eckert VI, Robinson,
and Hammer). If the significant factor in your data is distance from a
central point or line (such as air routes), then you will do best with
an \fIequidistant\fR projection such as \fIplate carrée\fR,
Cassini, azimuthal equidistant, or conic equidistant.  If direction from
a central point is a critical factor in your data (for instance,
air routes, radio antenna pointing), then you will almost surely want to
use one of the azimuthal projections. Appropriate choices are azimuthal
equidistant, azimuthal equal-area, stereographic, and perhaps orthographic.
.PP
Next, consider how much of the Earth your map will cover, and the general
shape of the area of interest.  For maps of the entire Earth,
the cylindrical equal area, Eckert IV and VI, Mollweide, Robinson, and Hammer
projections are good overall choices.  The Mercator projection is traditional,
but the extreme distortions of area at high latitudes make it
a poor choice unless a conformal projection is required. The Peirce
projection is a better choice of conformal projection, having less distortion
of landforms.  The Miller Cylindrical is a compromise designed to give
shapes similar to the traditional Mercator, but with less polar stretching.
The Peirce Quincuncial projection shows all the continents with acceptable
distortion if a reference meridian close to +20 degrees is chosen.
The Robinson projection yields attractive maps for things like political
divisions, but should be avoided in presenting scientific data, since other
projections have moe useful geometric properties.
.PP
If the map will cover a hemisphere, then choose stereographic,
azimuthal-equidistant, Hammer, or Mollweide projections; these all project
the hemisphere into a circle.
.PP
If the map will cover a large area (at least a few hundred km on a side),
but less than
a hemisphere, then you have several choices.  Azimuthal projections
are usually good (choose stereographic, azimuthal equidistant, or
Lambert azimuthal equal-area according to whether shapes, distances from
a central point, or areas are important).  Azimuthal projections (and possibly
the Cassini projection) are the only
really good choices for mapping the polar regions.
.PP
If the large area is in one of the temperate zones and is round or has
a primarily east-west extent, then the conic projections are good choices.
Choose the Lambert conformal conic, the conic equidistant, or the Albers
equal-area conic according to whether shape, distance, or area are the
most important parameters.  For any of these, the reference parallels
should be chosen at approximately 1/6 and 5/6 of the range of latitudes
to be displayed.  For instance, maps of the 48 coterminous United States
are attractive with reference parallels of 28.5 and 45.5 degrees.
.PP
If the large area is equatorial and is round or has a primarily east-west
extent, then the Mercator projection is a good choice for a conformal
projection; Lambert cylindrical equal-area and sinusoidal projections are
good equal-area projections; and the \fIplate carrée\fR is a
good equidistant projection.
.PP
Large areas having a primarily North-South aspect, particularly those
spanning the Equator, need some other choices.  The Cassini projection
is a good choice for an equidistant projection (for instance, a Cassini
projection with a central meridian of 80 degrees West produces an
attractive map of the Americas). The cylindrical equal-area, Albers
equal-area conic, sinusoidal, Mollweide and Hammer
projections are possible choices for equal-area projections.
A good conformal projection in this situation is the Transverse
Mercator, which alas, is not yet implemented.
.PP
Small areas begin to get into a realm where the ellipticity of the
Earth affects the map scale.  This package does not attempt to
handle accurate mapping for large-scale topographic maps.  If
slight scale errors are acceptable in your application, then any
of the projections appropriate to large areas should work for
small ones as well.
.PP
There are a few projections that are included for their special
properties.  The orthographic projection produces views of the
Earth as seen from space.  The gnomonic projection produces a
map on which all great circles (the shortest distance between
two points on the Earth's surface) are rendered as straight lines.
While this projection is useful for navigational planning, it
has extreme distortions of shape and area, and can display
only a limited area of the Earth (substantially less than a hemisphere).
.SH KEYWORDS
geodesy, map, projection
.SH COPYRIGHT
.nf
Copyright (c) 2007 Kevin B. Kenny <kennykb@acm.org>

.fi