'\"
'\" Generated from file '/BuildRoot/Library/Caches/com.apple.xbs/Sources/tcl/tcl-118.50.1/tcl_ext/tcllib/tcllib/modules/tepam/tepam_procedure.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009/2010, Andreas Drollinger
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "tepam::procedure" n 0.1.0 tepam "Tcl's Enhanced Procedure and Argument Manager"
.BS
.SH NAME
tepam::procedure \- TEPAM procedure, reference manual
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBtepam  ?0.1?\fR
.sp
\fBtepam::procedure\fR \fIname\fR \fIattributes\fR \fIbody\fR
.sp
.BE
.SH DESCRIPTION
This package provides an alternative way to declare Tcl procedures and to manage its arguments. There is a lot of benefit to declare a procedure with TEPAM rather than with the Tcl standard command \fBproc\fR: TEPAM allows specifying inside the procedure declaration in a natural syntax all information that is required to generate comprehensive documentations and help support.  The information is also used by an automatically invoked argument checker that is validating the provided procedure arguments before the procedure body is executed. Finally, a procedure can be called interactively which will open a form into which the arguments can be entered interactively.
.PP
TEPAM simplifies also the handling of the different types of argument, like the \fInamed arguments\fR (often also called \fIoptions\fR) and the \fIunnamed arguments\fR. TEPAM supports the \fInamed first, unnamed later\fR style (used by many Tcl commands) as well as also the \fIunnamed first, named later\fR style (used by many Tk commands). TEPAM reduces the effort to use default values, optional arguments, multiple applicable arguments, etc. to a simply definition of an argument attributes.
.PP
An informal overview of all the TEPAM procedure declaration and calling features as well as an informal introduction into TEPAM is provided by \fItepam(n)\fR.
.SH TERMINOLOGY
The exact meaning of several terms that are used in this document will be shortly explained to avoid any ambiguities and misunderstandings.
.TP
\fISubcommand\fR
The usage of subcommands is heavily used in the Tcl language. Several commands are incorporated into a single main command and are selectable via the first argument.
.sp
The \fBstring\fR command is an example of such a command that implements for example subcommands to check a character string's length, to compare strings, to extract substrings, etc:
.nf
\fBstring length\fR \fIstring\fR
\fBstring compare\fR \fIstring\fR \fIstring\fR
\fBstring range\fR \fIstring\fR \fIfirst\fR \fIlast\fR
...
.fi
.sp
TEPAM provides a framework that allows implementing easily such subcommands in form of Tcl procedures. It allows not only defining a first level of subcommands, but also a higher level of subcommands. The \fBstring\fR command's class check could be implemented as independent sub-sub-commands of the \fBstring\fR command:
.nf
\fBstring is alnum\fR \fIstring\fR
\fBstring is integer\fR \fIstring\fR
\fBstring is double\fR \fIstring\fR
...
.fi
.TP
\fIProcedure attribute\fR
TEPAM allows attaching to a declared procedure many kind of attributes. Some of these attributes are \fIjust\fR used for documentation purposes, but other attributes specify the way how the procedure has to be called. Also the procedure arguments are defined in form of a procedure attribute.
.TP
\fIArgument\fR
TEPAM uses the term \fIargument\fR for the parameters of a procedure.
.sp
The following example calls the subcommand \fBstring compare\fR with several arguments:
.nf
\fBstring compare\fR \fI-nocase -length 3 "emphasized" "emphasised"\fR
.fi
The following paragraphs discuss these different argument types.
.TP
\fINamed argument\fR
Some parameters, as \fI-length 3\fR of the subcommand \fBstring compare\fR have to be provided as pairs of argument names and argument values. This parameter type is often also called \fIoption\fR.
.sp
TEPAM uses the term \fInamed argument\fR for such options as well as for the flags (see next item).
.TP
\fIFlag, switch\fR
Another parameter type is the \fIflag\fR or the \fIswitch\fR. Flags are provided simply by naming the flag leading with the '-' character. The \fI-nocase\fR of the previous \fBstring compare\fR example is such a flag.
.sp
\fIFlags\fR are considered by TEPAM like a special form of \fInamed arguments\fR.
.TP
\fIUnnamed argument\fR
For the other parameters, e.g. the ones for which the argument name has not to be mentioned, TEPAM uses the term \fIunnamed argument\fR. The previous \fBstring compare\fR example uses for the two provided character strings two \fIunnamed arguments\fR.
.TP
\fIArgument attribute\fR
TEPAM allows describing the purpose of each procedure argument with \fIargument attributes\fR. While some of them are just documenting the attributes, most attributes are used by an argument manager to control and validate the arguments that are provided during a procedure call. Argument attributes are used to specify default values, parameter classes (integer, xdigit, font, ...), valid choices, value ranges, etc.
.TP
\fINamed arguments first, unnamed arguments later\fR
The \fBstring compare\fR command of the previous example requires that the \fInamed arguments\fR (options, flags) are provided first. The two mandatory (unnamed) arguments have to be provided as last argument.
.sp
This is the usual Tcl style (exceptions exist) which is referred in the TEPAM documentation as \fInamed arguments first, unnamed arguments later style\fR.
.TP
\fIUnnamed arguments first, named arguments later\fR
In contrast to most Tcl commands, Tk uses generally (exceptions exist also here) a different calling style where the \fIunnamed arguments\fR have to be provided first, before the \fInamed arguments\fR have to be provided:
.nf
\fBpack\fR \fI.ent1 .ent2 -fill x -expand yes -side left\fR
.fi
This style is referred in the TEPAM documentation as \fIunnamed arguments first, named arguments later style\fR.
.PP
.SH "PROCEDURE DECLARATION"
TEPAM allows declaring new Tcl procedures with the command \fBtepam::procedure\fR that similar to the standard Tcl command \fBproc\fR also 3 arguments:
.TP
\fBtepam::procedure\fR \fIname\fR \fIattributes\fR \fIbody\fR
.PP
The TEPAM procedure declaration syntax is demonstrated by the following example:
.nf
\fBtepam::procedure\fR {display message} {
   -short_description
      "Displays a simple message box"
   -description
      "This procedure allows displaying a configurable\\
       message box. The default message type that is\\
       created is a warning, but also errors and info can\\
       be generated.
       The procedure accepts multiple text lines."
   -example
      {display message -mtype Warning "Save first your job"}
   -args {
      {-mtype -choices {Info Warning Error} \\
              -default Warning -description "Message type"}
      {text   -type string -multiple \\
              -description "Multiple text lines to display"}
   }
} {
   puts "Message type: $mtype"
   puts "Message: $text"
}
.fi
The 3 arguments of \fBprocedure\fR are:
.TP
\fIname\fR
The procedure name can be used in very flexible ways. Not only that namespaces are fully supported. By providing a two element name list as procedure name, a subcommand of a procedure will be declared. It is even possible to declare sub-sub-commands of a procedure by providing name lists with three elements.
.sp
Here are some valid procedure declarations using different procedure names (the attribute and body arguments are empty for simplicity):
.nf
\fI# Simple procedure name:\fR
tepam::procedure \fBdisplay_message\fR {} {}
\fI\fR
\fI# Procedure declared in the main namespace:\fR
tepam::procedure \fB::display_message\fR {} {}
\fI\fR
\fI# Procedure in the namespace\fR \fB::ns\fR\fI:\fR
tepam::procedure \fB::ns::display_message\fR {} {}
\fI\fR
\fI# Declaration of the subcommand\fR \fBmessage\fR \fIof the procedure\fR \fBdisplay\fR\fI:\fR
tepam::procedure \fB{display message}\fR {} {}
.fi
.TP
\fIattributes\fR
All procedure attributes are provided in form of an option list that contains pairs of option names and option data. The example above has as procedure attribute a short and a normal description, but also the procedure arguments are defined in form of a procedure attribute.
.sp
Most procedure attributes are providing information for documentation purposes. But some of them affect also the way how the procedure can be called. The section \fBProcedure Attributes\fR discuses in detail the available procedure attributes.
.sp
The procedure arguments are defined in form of a special procedure attribute. Most of the information provided in the argument definition is not just used for documentation purposes. This information is in fact used by the TEPAM argument manager to handle and validate the various forms of arguments that are provided during the procedure calls. The section \fBArgument Declaration\fR discusses in detail all the argument definition attributes.
.TP
\fIbody\fR
This is the normal procedure body. The declared arguments will be available to the procedure body in form of variables.
.sp
The procedure body will only be executed if the provided set of arguments could be validated by the TEPAM argument manager.
.nf
tepam::procedure {display_message} {
   -args {
      {-\fBmtype\fR -default Warning -choices {Warning Error}}
      {\fBtext\fR -type string}
   }
} {
   puts "Message type: \fB$mtype\fR"
   puts "Message: \fB$text\fR"
}
.fi
.PP
The commands \fBprocedure\fR as well as \fBargument_dialogbox\fR are exported from the namespace \fBtepam\fR. To use these commands without the \fBtepam::\fR namespace prefix, it is sufficient to import them into the main namespace:
.nf
\fBnamespace import tepam::*\fR

\fBprocedure\fR {display_message} {
   -args {
      ...
.fi
.SS "PROCEDURE ATTRIBUTES"
The first group of procedure attributes is not affecting the behavior of the declared procedure. These attributes are just used for the purpose of documentation and help text generation:
.TP
-category \fIstring\fR
A category can be assigned to a procedure for documentation purposes. Any string is accepted as category.
.TP
-short_description \fIstring\fR
The short description of a procedure is used in the documentation summary of a generated procedure list as well as
in the NAME section of a generated procedure manual page.
.TP
-description \fIstring\fR
The (full) description assigned to a procedure is used to create user manual and help pages.
.TP
-return \fIstring\fR
The \fI-return\fR attribute allows defining the expected return value of a procedure (user for documentation purposes).
.TP
-example \fIstring\fR
A help text or manual page of a procedure can be enriched with eventual examples, using the \fI-example\fR attribute.
.PP
The following attributes are not relevant for the documentation and help text generation, but they affect the behavior of the declared procedure:
.TP
-named_arguments_first \fB0\fR|\fB1\fR
This attribute defines the calling style of a procedure. TEPAM uses by default the \fInamed arguments first, unnamed arguments later\fR style (Tcl). This default behavior can globally be changed by setting the variable \fBtepam::named_arguments_first\fR to \fB0\fR. This global calling style can be changed individually for a procedure with the \fI-named_arguments_first\fR attribute.
.TP
-auto_argument_name_completion \fB0\fR|\fB1\fR
The declared procedures will by default automatically try to match eventually abbreviated argument names to the defined arguments names. This default behavior can globally be changed by setting the variable \fBtepam::auto_argument_name_completion\fR to \fB0\fR. This global setting of the automatic argument name completion can be changed individually for a procedure with the \fI-auto_argument_name_completion\fR attribute.
.TP
-interactive_display_format \fBextended\fR|\fBshort\fR
A procedure declared with the TEPAM \fBprocedure\fR command can always be called with the \fB-interactive\fR option. By doing so, a graphical form will be generated that allows entering interactively all procedure arguments. There are two display modes for these interactive forms. While the \fIextended\fR mode is more adapted for small procedure argument sets, the \fBshort\fR form is more adequate for huge procedure argument sets.
.sp
The choice to use short or extended forms can globally be configured via the variable \fBtepam::interactive_display_format\fR. This global setting can then be changed individually for a procedure with the \fI-interactive_display_format\fR attribute.
.TP
-args \fIlist\fR
The procedure's arguments are declared via the \fI-args\fR attribute. An argument is defined via a list having as first element the argument name, followed by eventual argument attributes. All these argument definition lists are packaged themselves into a global list that is assigned to the procedure's \fI-args\fR attribute.
.sp
The next sub section describes in detail the argument definition syntax.
.PP
.SS "ARGUMENT DECLARATION"
The following example highlights the structure that is used for the argument definitions in the context of a procedure declaration:
.nf
tepam::procedure {display_message} {
   -args \fB{
      {-mtype -default Warning -choices {Info Warning Error} -description "Message type"}
      {-font -type font -default {Arial 10 italic} -description "Message text font"}
      {-level -type integer -optional -range {1 10} -description "Message level"}
      {-fg -type color -optional -description "Message color"}
      {-log_file -type file -optional -description "Optional message log file"}
      {text -type string -multiple -description "Multiple text lines to display"}
   }\fR
} {
}
.fi
So, each of the procedure arguments is declared with a list that has as first element the argument name, followed by eventual attributes. The argument definition syntax can be formalized in the following way:
.nf
tepam::procedure <name> {
   -args \fB{
      {<argument_name_1> <arg_attr_name_1a> <arg_attr_data_1a> \\
                         <arg_attr_name_1b> <arg_attr_data_1b> ...}
      {<argument_name_2> <arg_attr_name_2a> <arg_attr_data_2a> \\
                         <arg_attr_name_2b> <arg_attr_data_2b> ...}
      ...
   }\fR
} <body>
.fi
The argument names and attributes have to be used in the following way:
.TP
Argument name (\fI<argument_name_<n>>\fR)
The provided argument name specifies if the argument is an \fIunnamed argument\fR or a \fInamed argument/option\fR. In addition to this, an argument name can also be blank to indicate an argument comment, or it can start with # to indicate a section comment.
.RS
.TP
\fI"<Name>"\fR
This is the simplest form of an argument name: An argument whose name is not starting with '-' is an unnamed argument. The parameter provided during a procedure call will be assigned to a variable with the name \fI<Name>\fR.
.nf
tepam::procedure {print_string} {
   -args {
      {\fBtext\fR -type string -description "This is an unnamed argument"}
   }
} {
   puts \fB$text\fR
}

print_string \fB"Hello"\fR
\fI -> Hello\fR
.fi
.TP
\fI"-<Name>"\fR
An argument whose name starts with '-' is a named argument (also called \fIoption\fR). The parameter provided during a procedure call will be assigned to a variable with the name \fI<Name>\fR (not \fI-<Name>\fR).
.nf
tepam::procedure {print_string} {
   -args {
      {\fB-text\fR -type string -description "This is a named argument"}
   }
} {
   puts \fB$text\fR
}

print_string \fB-text "Hello"\fR
\fI -> Hello\fR
.fi
.TP
\fI"--"\fR
This flag allows clearly specifying the end of the named arguments and the begin of the unnamed arguments, in case the \fInamed arguments first, unnamed arguments later style (Tcl)\fR has been selected.
.sp
If the \fIunnamed arguments first, named arguments later style (Tk)\fR style is selected, this flag is ignored when the unnamed arguments have already been parsed. Otherwise it will be assigned to the corresponding unnamed argument.
.TP
\fI"-"\fR or \fI""\fR
A blank argument name (either '-' or \fI''\fR) indicates an argument comment. All remaining characters of the argument definition list will be considered as a comment that will be attributed to the following attribute.
.nf
tepam::procedure {print_time} {
   -args {
      {hours -type integer -description "Hour"}
      {minutes -type integer -description "Minute"}

      \fB{- The following arguments are optional:}\fR
      {seconds -type integer -default 0 -description "Seconds"}
      {milliseconds -type integer -default 0 -description "Milliseconds"}
   }
} {
   puts "${hour}h${minutes}:[expr $seconds+0.001*$milliseconds]"
}
.fi
Argument comments are basically used in the interactive argument definition forms, when a procedure is called interactively.
.TP
\fI"#*"\fR
An argument definition list that starts with '#' is considered as a section comment. The argument definition list will be trimmed from the '#' characters and the remaining string will be used as section comment.
.sp
Section comments can be used to structure visually the argument definition code. Section comments are also used to structure the generated help texts and the interactive argument definition forms.
.nf
tepam::procedure {complex_multiply} {
   -description "This function perform a complex multiplication"
   -args {
      \fB{#### First complex number ####}\fR
      {-r0 -type double -description "First number's real part"}
      {-i0 -type double -description "First number's imaginary part"}

      \fB{#### Second complex number ####}\fR
      {-r1 -type double -description "Second number's real part"}
      {-i1 -type double -description "Second number's imaginary part"}
   }
} {
   return [expr $r0*$r1 - $i0*$i1]
}
.fi
.RE
.TP
Argument attributes (\fI<arg_attr_name_<mn>> <arg_attr_data_<mn>>\fR)
The following argument attributes are supported:
.RS
.TP
-description \fIstring\fR
The description argument attribute is used for documentation purpose. Interactive argument definition forms use this attribute to provide comprehensible explanations for an argument.
.TP
-type \fItype\fR
The type argument attribute allows assigning the argument either to a predefined data type, or to a application specific data type. The argument data that are provided during a procedure call are automatically checked for consistency with the defined argument type.
.sp
Section \fBARGUMENT TYPES\fR provides a list of predefined data types and explains how application specific types can be specified.
.sp
The argument type \fInone\fR has a special meaning. An argument that has the type \fInone\fR is handled as a \fIflag\fR. A flag is always optional and its related variable contains the logical value \fB0\fR if the flag has been used during the procedure call, or otherwise \fB1\fR.
.TP
-default \fIvalue\fR
Eventual default values can be defined with the -default argument attribute. Arguments with default values are automatically optional arguments.
.TP
-optional|-mandatory
Arguments are by default mandatory, unless a default value is defined. The flag \fI-optional\fR transforms an argument into an optional argument.
.sp
In case an optional argument is not defined during a procedure call, the corresponding variable will not be defined.
The flag \fI-mandatory\fR is the opposite to \fI-optional\fR. This flag exists only for completion reason, since an argument is anyway mandatory by default.
.TP
-multiple
Arguments that have the \fI-multiple\fR attribute can be defined multiple times during a procedure call. The data that are provided during a procedure call for such an argument are stored in a list. This is even the case if such an argument is only defined once during a procedure call.
.sp
The \fI-multiple\fR attribute can be attributed to unnamed arguments and to named arguments. The pair of argument name/argument data has to be repeated for each provided data value in case of a named argument.
In case the argument with the \fI-multiple\fR attribute is an unnamed argument, this one has to be the absolute last one of all unnamed arguments.
.TP
-choices \fIlist\fR
A possible set of valid argument values can be attributed to an argument via the \fI-choices\fR attribute. The argument data provided during a procedure call will be checked against the provided choice values.
.TP
-choicelabels \fIlist\fR
An evanutal short description can be attributed to each choice option with the \fI-choicelabels\fR attribute. These descriptions will be used in the generated help texts and as radio and check box labels for the interactive calls.
.sp
The \fI-choicelabels\fR attribute is optional, but if it is defined, its list needs to have the identical size as the \fI-choices\fR argument list.
.TP
-range \fI{double double}\fR
Another argument constraint can be defined with the \fI-range\fR attribute. The valid range is defined with a list containing the minimum valid value and a maximum valid value. The \fI-range\fR attribute has to be used only for numerical arguments, like integers and doubles.
.TP
-validatecommand \fIscript\fR
Eventual more complex argument data validations can be performed via specific validation commands that are assigned to the \fIvalidatecommand\fR attribute. The provided validation command can be a complete script in which the pattern \fI%P\fR is replaced by the argument data that has to be validated.
An example of a validation command declaration is:
.nf
tepam::procedure {display_message} {
   -args {
      {text -type string -description "Message text" \\
            \fB-validatecommand "IllegalWordDetector %P"\fR}
} {
}
.fi
.TP
-auxargs \fIlist\fR
In case a procedure is called interactively, additional argument attributes can be provided to the interactive argument definition form via the \fI-auxargs\fR attribute that is itself a list of attribute name/attribute data pairs:
.nf
-auxargs {-<arg_attr_name_1a> <arg_attr_data_1a> \\
          -<arg_attr_name_1b> <arg_attr_data_1b>
          ...
}
.fi
For example, if a procedure takes as argument a file name it may be beneficial to specify the required file type for the interactive argument definition form. This information can be provided via the \fI-auxargs\fR attribute to the argument definition form:
.nf
tepam::procedure LoadPicture {
   -args {
      {FileName -type existingfile -description "Picture file" \\
                 \fB-auxargs {-filetypes {{"GIF" {*.gif}} {"JPG" {*.jpg}} }}\fR}
   }
} {
}
.fi
.TP
-auxargs_commands \fIscript\fR
If the auxiliary argument attributes are not static but have to be dynamically adaptable, the \fI-auxargs_commands\fR allows defining them via commands that are executed during a procedure call. A list of pairs of auxiliary attribute names and commands have to be provided to the \fI-auxargs_commands\fR attribute. The provided commands are executed in the context of the calling procedure.
.nf
-auxargs_commands {-<arg_attr_name_1a> <arg_attr_command_1a> \\
                   -<arg_attr_name_1b> <arg_attr_command_1b>
                   ...
}
.fi
.RE
.PP
.SH VARIABLES
Several variables defined inside the \fB::tepam\fR namespace are impacting the procedures and the way how they have to be called.
.TP
\fBnamed_arguments_first\fR
This variable defines the general calling style of the procedures. It is by default set to \fB1\fR which selects the \fInamed arguments first, unnamed arguments later\fR style (Tcl).
.sp
By setting this variable to \fB0\fR, the \fInamed arguments first, unnamed arguments later\fR style (Tk) is globally selected:
.nf
set tepam::named_arguments_first 0
.fi
.sp
While this variable defines globally the calling style, the procedure attribute \fI-named_arguments_first\fR can adapt this style individually for each procedure.
.TP
\fBauto_argument_name_completion\fR
This variable controls globally the automatic argument name matching mode. By default it is set to \fB1\fR, meaning that the called procedures are trying to match eventually abbreviated argument names with the declared argument names.
.sp
By setting this variable to \fB0\fR the automatic argument name matching mode is disabled:
.nf
set tepam::auto_argument_name_completion 0
.fi
.sp
While this variable defines globally the matching mode, the procedure attribute \fI-auto_argument_name_completion\fR can adapt this mode individually for each procedure.
.TP
\fBinteractive_display_format\fR
A procedure declared via the TEPAM \fBprocedure\fR command can always be called with the \fB-interactive\fR switch. By doing so, a graphical form will be generated that allows entering interactively all procedure arguments.
.sp
There are two display modes for these interactive forms. The \fIextended\fR mode which is the default mode is more adapted for small procedure argument sets, while the \fBshort\fR form is more adequate for huge procedure argument sets:
.nf
set tepam::interactive_display_format "short"
.fi
.sp
The choice to use short or extended forms can globally be configured via this variable \fBinteractive_display_format\fR.
This global setting can be changed individually for a procedure with the procedure attribute \fI-interactive_display_format\fR.
.TP
\fBhelp_line_length\fR
The maximum line length used by the procedure help text generator can be specified with this variable. The default length which is set to 80 (characters) can easily be adapted to the need of an application:
.nf
set tepam::help_line_length 120
.fi
Since this variable is applied directly during the help text generation, its value can continuously be adapted to the current need.
.PP
.SH "ARGUMENT TYPES"
Many argument types are predefined by TEPAM that can be used in the procedure argument definition section as argument type. In case a special application specific type is missing, it is easy to add the necessary support for such a type.
.SS "PREDEFINED ARGUMENT TYPES"
To remember, a type can be assigned to each specified procedure argument:
.nf
tepam::procedure {warning} {
   -args {
      {-font \fB-type font\fR -default {Arial 10 italic}}
      {-severity_level \fB-type integer\fR -optional -range {1 10}}
      {-fg \fB-type color\fR -optional -description "Message color"}
      {text \fB-type string\fR -multiple -description "Multiple text lines to display"}
   }
} {
   ...
}
.fi
There are some \fIspecial purpose types\fR that are building the first category of predefined argument types:
.IP \(bu
\fBnone\fR
.sp
\fIFlags\fR, also called \fIswitches\fR, are defined by specifying a named argument with the type \fBnone\fR. Flags are always optional and the default value of the assigned variable is set to \fB0\fR. In contrast to the (normal) named arguments no argument data has to be provided to a flag.
.nf
tepam::procedure flag_test {
   -args {
      \fB{-flag -type none -description "This is a flag"}\fR
   }
} {
   puts \fB$flag\fR
}

flag_test
\fI-> 0\fR

flag_test -flag
\fI-> 1\fR
.fi
.sp
Since no argument data has to be provided to a flag, also no data checks are performed for this argument type.
.IP \(bu
\fBstring\fR
.sp
\fBString\fR is a generic argument data type. Any data string can be provided to a string type argument and no data type checks are therefore performed.
.IP \(bu
\fB{}\fR
.sp
A \fBblank\fR argument type signifies an undefined argument type. This is the default argument type that is used when no type has been explicitly specified. An argument that has a \fBblank\fR type behaves identically than an argument that has a \fBstring\fR type, e.g. no argument data checks are performed. The only difference is that the data type \fBstring\fR is mentioned in the generated help documentation, while this is not the case for \fBblank\fR type.
.PP
.PP
Several \fInumerical types\fR are defined by TEPAM. The type validation procedures are not using only the \fBstring is <type>\fR commands to check the validity of the provided arguments, but they assure also that no empty strings are provided as argument data (the \fBstring is <type>\fR commands are considering an empty string as a valid numerical parameter). The common type validation expression is therefore:
.nf
expr [string length \fI<argument_data>\fR]>0 && [string is \fB<type_to_check>\fR \fI<argument_data>\fR]
.fi
.IP \(bu
\fIboolean\fR
.sp
.IP \(bu
\fIinteger\fR
.sp
.IP \(bu
\fIdouble\fR
.sp
.PP
The verification of all \fIalpha numeric types\fR is directly performed with the standard Tcl string type verification command:
.nf
string is \fI<type_to_check>\fR \fI<argument_data>\fR
.fi
The following types are verified in this way:
.IP \(bu
\fIalnum\fR
.sp
.IP \(bu
\fIalpha\fR
.sp
.IP \(bu
\fIascii\fR
.sp
.IP \(bu
\fIcontrol\fR
.sp
.IP \(bu
\fIdigit\fR
.sp
.IP \(bu
\fIgraph\fR
.sp
.IP \(bu
\fIlower\fR
.sp
.IP \(bu
\fIprint\fR
.sp
.IP \(bu
\fIpunct\fR
.sp
.IP \(bu
\fIspace\fR
.sp
.IP \(bu
\fIupper\fR
.sp
.IP \(bu
\fIwordchar\fR
.sp
.IP \(bu
\fIxdigit\fR
.sp
.PP
.PP
In addition to the data types checked with the \fBstring is <type>\fR commands, TEPAM specifies some other useful data types:
.IP \(bu
\fIchar\fR
.sp
Each string that has a length of 1 character meets the \fIcharacter\fR type. The type check is made with the following expression:
.nf
expr [string length \fI<argument_data>\fR]==1
.fi
.IP \(bu
\fIcolor\fR
.sp
Any character strings that are accepted by Tk as a color are considered as valid color argument. Please note that the Tk package has to be loaded to use the \fIcolor\fR type. TEPAM is using the following command to validate the color type:
.nf
expr ![catch {winfo rgb . \fI<argument_data>\fR}]
.fi
.IP \(bu
\fIfont\fR
.sp
Any character strings that are accepted by Tk as a font are considered as valid font argument. Please note that the Tk package uas to be loaded to use the \fIfont\fR type. TEPAM is using the following command to validate the color type:
.nf
expr ![catch {font measure <argument_data> ""}]
.fi
.IP \(bu
\fIfile\fR
.sp
Any strings that are not containing one of the following characters are considered as valid file name: * ? " < >. It is not necessary that the file or its containing directory is existing. Zero-length strings are not considered as valid file names.
.sp
The following expression is used to validate the file names:
.nf
expr [string length <argument_data>]>0 && ![regexp {[\\"*?<>:]} <argument_data>]
.fi
.IP \(bu
\fIexistingfile\fR
.sp
The argument is valid if it matches with an existing file. The following check is performed to validate the arguments of this type:
.nf
file exists <argument_data>
.fi
.IP \(bu
\fIdirectory\fR
.sp
The directory argument is validated exactly in the same way as the file arguments.
.IP \(bu
\fIexistingdirectory\fR
.sp
The argument is valid if it matches with an existing directory. The following check is performed to validate the arguments of this type:
.nf
file isdirectory <argument_data>
.fi
.PP
.SS "DEFINING APPLICATION SPECIFIC ARGUMENT TYPES"
Nothing is easier than adding support for a new application specific argument type. It is just necessary to add into the namespace \fBtepam\fR a validation function \fBValidation(<type>)\fR that has one argument and that returns \fB1\fR if the provided argument matches with the relevant data type. The function has to return otherwise \fB0\fR.
.PP
The validation command section of the "\fItepam.tcl\fR" package provides sufficient examples of validation functions, since it implements the ones for the standard TEPAM types.
.PP
The following additional code snippet shows the validation function for a custom argument type that has to correspond to a character string with a length of 2:
.nf
proc tepam::Validate(two_char) {v} {expr [string length $v]==2}
.fi
.SH "PROCEDURE CALLS"
.SS HELP
Each procedure can be called with the \fI-help\fR flag. The procedure will then print a generated help text to \fIstdout\fR and will then return without performing any additional actions.
.PP
Taking the first procedure declared in \fBPROCEDURE CALLS\fR, the help request and the printed help text would be:
.nf
\fBdisplay message -help\fR
\fI->
NAME
      display message - Displays a simple message box
SYNOPSIS
      display message
            [-mtype <mtype>]
               Message type, default: "Warning", choices: {Info, Warning, Error}
            <text>
               Multiple text lines to display, type: string
DESCRIPTION
      This procedure allows displaying a configurable message box. The default
      message type that is created is a warning, but also errors and info can
      be generated.
      The procedure accepts multiple text lines.
EXAMPLE
      display message -mtype Warning "Save first your job"\fR
.fi
The argument manager is checking if the last provided argument is \fI-help\fR and generates the requested help message if this is the case. So, also the following example will print the help message:
.nf
\fBdisplay message -mtype Info "It is 7:00" -help\fR
.fi
On the other hand, the following call will result in an error:
.nf
\fBdisplay message -help -mtype Info "It is 7:00"\fR
\fI->
display message: Argument '-help' not known\fR
.fi
.SS "INTERACTIVE PROCEDURE CALL"
Calling a procedure with the \fI-interactive\fR flag will open a graphical form that allows specifying interactively all procedure arguments. The Tk library has to be loaded to use the interactive call. The following example assures that the Tk library is loaded and shows the command line to call interactively the procedure declared in \fBPROCEDURE CALLS\fR:
.nf
package require Tk
\fBdisplay message -interactive\fR
.fi
Also the \fI-interactive\fR flag has to be placed at the last argument position as this is also required for the \fI-help\fR flag. Arguments defined before the \fI-interactive\fR flag will be ignored. The following example is therefore also a valid interactive procedure call:
.nf
\fBdisplay message\fR -mtype Info "It is 7:00" \fB-interactive\fR
.fi
.SS "UNNAMED ARGUMENTS"
Unnamed arguments are typically provided to the called procedure as simple parameters. This procedure calling form requires that the provided arguments are strictly following the order of the specified arguments. Several parameters can be assigned to the last argument if this one has the \fI-multiple\fR attribute. So, the following declared procedure ...
.nf
tepam::procedure {display_message} {
   -args {
      {mtype -choices {Info Warning Error}}
      {text -type string -multiple}
   }
} {
   puts "$mtype: [join $text]"
}
.fi
... can for example be called in the following ways:
.nf
\fBdisplay_message Info "It is PM 7:00."\fR
\fI-> Info: It is PM 7:00.\fR

\fBdisplay_message Info "It is PM 7:00." "You should go home."\fR
\fI-> Info: It is PM 7:00. You should go home.\fR
.fi
The nice thing is that unnamed arguments can also be called as named arguments, which can be handy, for example if the exact specified argument order is not known to a user:
.nf
\fBdisplay_message -mtype Info -text "It is PM 7:00."\fR
\fI-> Info: It is PM 7:00.\fR

\fBdisplay_message -text "It is PM 7:00." -mtype Info\fR
\fI-> Info: It is PM 7:00.\fR

\fBdisplay_message -mtype Info -text "It is PM 7:00." -text "You should go home."\fR
\fI-> Info: It is PM 7:00. You should go home.\fR

\fBdisplay_message -text "It is PM 7:00." -text "You should go home." -mtype Info\fR
\fI-> Info: It is PM 7:00. You should go home.\fR
.fi
.SS "NAMED ARGUMENTS"
Named arguments have to be provided to a procedure in form of a parameter pairs composed by the argument names and the argument data. The order how they are provided during a procedure call is irrelevant and has not to match with the argument specification order.
.PP
The following declared procedure ...
.nf
tepam::procedure {display_message} {
   -args {
      {-mtype -choices {Info Warning Error}}
      {-text -type string -multiple}
   }
} {
   puts "$mtype: [join $text]"
}
.fi
... can be called in the following ways:
.nf
\fBdisplay_message -mtype Info -text "It is PM 7:00."\fR
\fI-> Info: It is PM 7:00.\fR

\fBdisplay_message -text "It is PM 7:00." -mtype Info\fR
\fI-> Info: It is PM 7:00.\fR

\fBdisplay_message -mtype Info -text "It is PM 7:00." -text "You should go home."\fR
\fI-> Info: It is PM 7:00. You should go home.\fR

\fBdisplay_message -text "It is PM 7:00." -text "You should go home." -mtype Info\fR
\fI-> Info: It is PM 7:00. You should go home.\fR
.fi
Also named arguments that have not the \fI-multiple\fR attribute can be provided multiple times. Only the last provided argument will be retained in such a case:
.nf
\fBdisplay_message -mtype Info -text "It is PM 7:00." -mtype Warning\fR
\fI-> Warning: It is PM 7:00.\fR
.fi
.SS "UNNAMED ARGUMENTS FIRST, NAMED ARGUMENTS LATER (TK STYLE)"
A procedure that has been defined while the variable \fBtepam::named_arguments_first\fR was set to 1, or with the procedure attribute \fI-named_arguments_first\fR set to 1 has to be called in the Tcl style. The following procedure declaration will be used in this section to illustrate the meaning of this calling style:
.nf
\fBset tepam::named_arguments_first 1\fR
tepam::procedure my_proc {
   -args {
      {-n1 -default ""}
      {-n2 -default ""}
      {u1 -default ""}
      {u2 -default ""}
   }
} {
   puts "n1:'$n1', n2:'$n2', u1:'$u1', u2:'$u2'"
}
.fi
The unnamed arguments are placed at the end of procedure call, after the named arguments:
.nf
my_proc \fB-n1 N1 -n2 N2 U1 U2\fR
\fI-> n1:'N1', n2:'N2', u1:'U1', u2:'U2'\fR
.fi
The argument parser considers the first argument that doesn't start with the '-' character as well as all following arguments as unnamed argument:
.nf
my_proc \fBU1 U2\fR
\fI-> n1:'', n2:'', u1:'U1', u2:'U2'\fR
.fi
Named arguments can be defined multiple times. If the named argument has the \fI-multiply\fR attribute, all argument data will be collected in a list. Otherwise, only the last provided attribute data will be retained:
.nf
my_proc \fB-n1 N1 -n2 N2 -n1 M1 U1 U2\fR
\fI-> n1:'M1', n2:'N2', u1:'U1', u2:'U2'\fR
.fi
The name of the first unnamed argument has therefore not to start with the '-' character. The unnamed argument is otherwise considered as name of another named argument. This is especially important if the first unnamed argument is given by a variable that can contain any character strings:
.nf
my_proc \fB-n1 N1 -n2 N2 "->" "<-"\fR
\fI-> my_proc: Argument '->' not known\fR

set U1 "->"
my_proc -n1 N1 -n2 N2 $U1 U2}]
my_proc: Argument '->' not known
.fi
The '--' flag allows separating unambiguously the unnamed arguments from the named arguments. All data after the '--' flag will be considered as unnamed argument:
.nf
my_proc \fB-n1 N1 -n2 N2 -- "->" "<-"\fR
\fI-> n1:'N1', n2:'N2', u1:'->', u2:'<-'\fR

set U1 "->"
my_proc \fB-n1 N1 -n2 N2 -- $U1 U2\fR
\fI-> n1:'N1', n2:'N2', u1:'->', u2:'<-'\fR
.fi
.SS "NAMED ARGUMENTS FIRST, UNNAMED ARGUMENTS LATER (TCL STYLE)"
The Tk calling style is selected when a procedure is defined while the variable \fBtepam::named_arguments_first\fR is set to 0, or when the procedure attribute \fI-named_arguments_first\fR has been set to 0. The following procedure will be used in this section to illustrate this calling style:
.nf
\fBset tepam::named_arguments_first 0\fR
tepam::procedure my_proc {
   -args {
      {-n1 -default ""}
      {-n2 -default ""}
      {u1}
      {u2 -default "" -multiple}
   }
} {
   puts "n1:'$n1', n2:'$n2', u1:'$u1', u2:'$u2'"
}
.fi
The unnamed arguments have to be provided first in this case. The named arguments are provided afterwards:
.nf
my_proc \fBU1 U2 -n1 N1 -n2 N2\fR
\fI-> n1:'N1', n1:'N1', u1:'U1', u2:'U2'\fR
.fi
The argument parser will assign to each defined unnamed argument an argument data before it switches to read the named arguments. This default behavior changes a bit if there are unnamed arguments that are optional or that can take multiple values.
.PP
An argument data will only be assigned to an unnamed argument that is optional (that has either the \fI-optional\fR attribute or that has a default value), when the data is not beginning with the '-' character or when no named arguments are defined. The data that starts with '-' is otherwise considered as the name of a named argument.
.PP
Argument data are assigned to an argument that has the \fI-multiple\fR attribute as long as the parameter value doesn't starts with the '-' character.
.PP
This constraint that parameter values that start with the '-' character cannot be assigned to optional unnamed arguments makes the Tcl procedure calling style not suitable for all situations. The Tk style may be preferable in some cases, since it allows separating unambiguously the named arguments from the unnamed ones with the '--' flag.
.PP
Let's explore in a bit less theoretically the ways how the previously defined procedure can be called: The first example calls the procedure without any parameters, which leads to an error since \fIu1\fR is a mandatory argument:
.nf
my_proc
\fI-> my_proc: Required argument is missing: u1\fR
.fi
The procedure call is valid if one parameter is provided for \fIu1\fR:
.nf
my_proc \fBU1\fR
\fI-> n1:'', n2:'', u1:'U1', u2:''\fR
.fi
When more parameters are provided that are not starting with the '-' character, then they will be attributed to the unnamed arguments. \fIU2\fR will receive 3 of these parameters, since it accepts multiple values:
.nf
my_proc \fBU1 U2 U3 U4\fR
\fI-> n1:'', n2:'', u1:'U1', u2:'U2 U3 U4'\fR
.fi
As soon as one parameter starts with '-' and all unnamed arguments have been served, the argument manager tries to interpret the parameter as name of a named argument. The procedure call will fail if the intend was to attribute the parameter beginning with '-' to an unnamed argument:
.nf
my_proc \fBU1 U2 U3 U4 -U5\fR
\fI-> my_proc: Argument '-U5' not known\fR
.fi
The attribution of a parameter to a named argument will fail if there are undefined unnamed (non optional) arguments. The name specification will in this case simply be considered as a parameter value that is attributed to the \fInext\fR unnamed argument. This was certainly not the intention in the following example:
.nf
my_proc \fB-n1 N1\fR
\fI-> n1:'', n2:'', u1:'-n1', u2:'N1'\fR
.fi
The situation is completely different if values have already been attributed to all mandatory unnamed arguments. A parameter beginning with the '-' character will in this case be considered as a name identifier for a named argument:
.nf
my_proc \fBU1 -n1 N1\fR
\fI-> n1:'N1', n2:'', u1:'U1', u2:''\fR
.fi
No unnamed arguments are allowed behind the named arguments:
.nf
my_proc \fBU1 -n1 N1 U2\fR
\fI-> my_proc: Argument 'U2' is not an option\fR
.fi
The '--' flag has no special meaning if not all mandatory arguments have got assigned a value. This flag will simply be attributed to one of the unnamed arguments:
.nf
my_proc \fB-- -n1 N1\fR
\fI-> n1:'N1', n2:'', u1:'--', u2:''\fR
.fi
But the '--' flag is simply ignored if the argument parser has started to handle the named arguments:
.nf
my_proc \fBU1 -- -n1 N1\fR
\fI-> n1:'N1', n2:'', u1:'U1', u2:''\fR

my_proc \fBU1 -n1 N1 -- -n2 N2\fR
\fI-> n1:'N1', n2:'N2', u1:'U1', u2:''\fR
.fi
.SS "RAW ARGUMENT LIST"
It may be necessary sometimes that the procedure body is able to access the entire list of arguments provided during a procedure call. This can happen via the \fBargs\fR variable that contains always to unprocessed argument list:
.nf
tepam::procedure {display_message} {
   -args {
      {-mtype -choices {Warning Error} -default Warning}
      {text -type string -multiple}

   }
} {
   puts "args: \fB$args\fR"
}
display_message -mtype Warning "It is 7:00"
\fI-> args: -mtype Warning {It is 7:00}\fR
.fi
.SH "SEE ALSO"
tepam_introduction(n), tepam_procedure(n)
.SH KEYWORDS
argument integrity, argument validation, arguments, procedure, subcommand
.SH CATEGORY
Procedures, arguments, parameters, options
.SH COPYRIGHT
.nf
Copyright (c) 2009/2010, Andreas Drollinger

.fi